

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobStatusForLegalHoldJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   10/31/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetJobStatusForLegalHoldJobs.sp,v $ $Id: JMGetJobStatusForLegalHoldJobs.sp,v 1.8.276.1 2018/03/22 03:01:14 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetJobStatusForLegalHoldJobs <<<'

IF EXISTS (select * from sysobjects where name='JMGetJobStatusForLegalHoldJobs')
	drop procedure JMGetJobStatusForLegalHoldJobs
IF EXISTS (select * from GxQscripts where name='JMGetJobStatusForLegalHoldJobs')
	delete from GxQscripts where name = 'JMGetJobStatusForLegalHoldJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobStatusForLegalHoldJobs')
	delete from GXDBVersions where aliasname = 'JMGetJobStatusForLegalHoldJobs'
GO
print '... Creating Procedure: JMGetJobStatusForLegalHoldJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetJobStatusForLegalHoldJobs
  @xmlText XML
AS
	--------------------------------------------------------------------
	--	TABLE #tempJobStatusList will be used to create a list of job --
	--  status for a given list of jobs                               --
	--------------------------------------------------------------------
	IF object_id('tempdb.dbo.#tempJobStatusList') IS NOT null
		DROP TABLE #tempJobStatusList
	IF object_id('tempdb.dbo.#tempJobInfoToStats') IS NOT null
		DROP TABLE #tempJobInfoToStats
	IF object_id('tempdb.dbo.#tempJobInfoJobs') IS NOT null
		DROP TABLE #tempJobInfoJobs
	IF object_id('tempdb.dbo.#tempLegalHoldTable') IS NOT null
		DROP TABLE #tempLegalHoldTable
	CREATE TABLE #tempJobStatusList
	(
		jobId			int NOT null,
		status			int NOT null,
		percentcomplete	int NOT null,
		totCompBytes	bigint NOT null,
		totUnCompBytes	bigint NOT null,
		pendingReason	int NOT null,
		jobStartTime	int NOT null,
		jobEndTime		int NOT null,
		clientId		int NOT null,
		taskId			int NOT null,
		appId			int NOT null,
	)
	CREATE TABLE #tempJobInfoToStats
	(
		id			int NOT null,
		status		int NOT null,
	)
	CREATE TABLE #tempJobInfoJobs
	(
		jobId			int NOT null,
		taskId			int NOT null,
	)
	CREATE TABLE #tempLegalHoldTable
	(
		CompPolicyID	CHAR(50),
		CompPolicyName	NVARCHAR(256),
		CompPolicyDesc	NVARCHAR(MAX),
		RetainUntil		DATETIME null,
		BackupsetId		INT,
		Attribute		INT,
		UserGUID		CHAR(50),
		CreateTime		DATETIME,
		ModifiedTime	DATETIME,
		ArchGroupName	NVARCHAR(1024),
		RetentionDays	INT,
		emailIds		NVARCHAR(MAX),
	)
	INSERT INTO #tempJobInfoToStats VALUES('1', '4')
	INSERT INTO #tempJobInfoToStats VALUES('2', '10')
	INSERT INTO #tempJobInfoToStats VALUES('3', '12')
	INSERT INTO #tempJobInfoToStats VALUES('4', '11')
	IF object_id('dbo.SchedLHGetLegalHoldFromBackuSet') IS NOT null
	BEGIN
	INSERT INTO #tempLegalHoldTable
		EXEC [dbo].[SchedLHGetLegalHoldFromBackuSet] @xmlText
	END
	INSERT INTO #tempJobStatusList
	SELECT JMJobInfo.jobId, JMJobInfo.state, JMJobInfo.percentcomplete, JMBkpJobInfo.CompBytes, JMBkpJobInfo.UnCompBytes, JMJobInfo.pendingCause, JMJobInfo.jobStartTime, JMJobInfo.serverEndTime, 2, 0, JMBkpJobInfo.applicationId FROM JMJobInfo, JMBkpJobInfo WHERE JMJobInfo.jobId = JMBkpJobInfo.jobId and JMJobInfo.CommCellId = JMBkpJobInfo.CommCellId AND (JMBkpJobInfo.bkpattributes & 0x10000000) = 0x10000000
	UNION
	SELECT jobId, #tempJobInfoToStats.status, 100, totalCompBytes, totalUncompBytes, 0, servStartDate, servEndDate, 2, 0, JMBkpStats.appId FROM JMBkpStats, #tempJobInfoToStats WHERE  #tempJobInfoToStats.id = JMBkpStats.status AND (JMBkpStats.bkpattributes & 0x10000000) = 0x10000000
	--SELECT jobId, #tempJobInfoToStats.status, 100, totalCompBytes, totalUncompBytes, 0, servStartDate, servEndDate, (SELECT clientId FROM APP_Application WHERE APP_Application.id = appId), 0 FROM JMBkpStats, #tempJobInfoToStats WHERE  #tempJobInfoToStats.id = JMBkpStats.status AND (JMBkpStats.bkpattributes & 0x10000000) = 0x10000000
	SELECT
		a.jobId,
		a.status,
		a.percentcomplete,
		a.totCompBytes,
		a.totUnCompBytes,
		a.pendingReason,
		a.jobStartTime as jobStartTime,
		a.jobEndTime as jobEndTime,
		1 as destClientId,
		'' as name
	FROM #tempJobStatusList a, app_client b, #tempLegalHoldTable c
	WHERE a.clientid = b.id AND jobStartTime > dbo.getUnixTime(DATEADD(day, -7, GETDATE()))
	AND a.appId = (SELECT id FROM APP_Application WHERE backupSet = c.BackupsetId)
	DROP TABLE #tempJobStatusList
	DROP TABLE #tempJobInfoToStats
	DROP TABLE #tempJobInfoJobs
	DROP TABLE #tempLegalHoldTable
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'JMGetJobStatusForLegalHoldJobs')
	delete from GxQscripts where name = 'JMGetJobStatusForLegalHoldJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobStatusForLegalHoldJobs')
	delete from GXDBVersions where aliasname = 'JMGetJobStatusForLegalHoldJobs'
GO

insert into GXDBVersions values(2, 'JMGetJobStatusForLegalHoldJobs',  '00010008027600010000', 'JMGetJobStatusForLegalHoldJobs', '00010008027600010000')
GO

