

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobStatusForJobIdList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   10/31/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetJobStatusForJobIdList.sp,v $ $Id: JMGetJobStatusForJobIdList.sp,v 1.20.36.1 2018/03/22 03:02:38 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetJobStatusForJobIdList <<<'

IF EXISTS (select * from sysobjects where name='JMGetJobStatusForJobIdList')
	drop procedure JMGetJobStatusForJobIdList
IF EXISTS (select * from GxQscripts where name='JMGetJobStatusForJobIdList')
	delete from GxQscripts where name = 'JMGetJobStatusForJobIdList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobStatusForJobIdList')
	delete from GXDBVersions where aliasname = 'JMGetJobStatusForJobIdList'
GO
print '... Creating Procedure: JMGetJobStatusForJobIdList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetJobStatusForJobIdList
  @i_JobIds char(2048)
--:PARAM	i_TaskIds	char(2048)
AS
	DECLARE @s_JobsInfo char(2048)
	DECLARE @s_JobsStats char(2048)
	DECLARE @s_JobsTasks char(2048)
	DECLARE @s_JobsFound char(2048)
	DECLARE @s_JobsInfo1 char(2048)
	DECLARE @s_JobsStats1 char(2048)
 	--SET @s_JobsInfo = 'SELECT JMJobInfo.jobId, JMJobInfo.state, JMJobInfo.percentcomplete, JMJobInfo.pendingCause, JMJobInfo.jobStartTime, JMRstJobInfo.totCompBytes, JMRstJobInfo.totUnCompBytes, JMJobInfo.serverEndTime, JMRstJobInfo.destClientId FROM JMJobInfo, JMRstJobInfo WHERE JMJobInfo.jobId = JMRstJobInfo.jobId and JMJobInfo.CommCellId = JMRstJobInfo.CommCellId and JMJobInfo.jobId IN '
 	--SET @s_JobsStats = 'SELECT jobId, status, 100, totUncompBytes_l, totCompBytes_l, 0, servStartTime, servEndTime, destClientId FROM JMRestoreStats WHERE jobId IN '
	--SET @s_JobsInfo = 'SELECT JMJobInfo.jobId, JMJobInfo.state, JMJobInfo.percentcomplete, JMJobInfo.pendingCause, JMJobInfo.jobStartTime, JMRstJobInfo.totCompBytes, JMRstJobInfo.totUnCompBytes, JMJobInfo.serverEndTime, JMRstJobInfo.destClientId FROM JMJobInfo, JMRstJobInfo WHERE JMJobInfo.jobId = JMRstJobInfo.jobId and JMJobInfo.CommCellId = JMRstJobInfo.CommCellId and JMJobInfo.jobId IN '
	--SET @s_JobsStats = 'SELECT jobId, #tempJobInfoToStats.status, 100, totUncompBytes_l, totCompBytes_l, 0, servStartTime, servEndTime, destClientId FROM JMRestoreStats, #tempJobInfoToStats WHERE #tempJobInfoToStats.id = JMRestoreStats.status and jobId IN '
	SET @s_JobsTasks = 'SELECT ID, rstTaskID FROM JMJobTaskLink WHERE rstTaskID IN '
	SET @s_JobsFound = '(SELECT jobId FROM #tempJobInfoJobs)'
	--------------------------------------------------------------------
	--	TABLE #tempJobStatusList will be used to create a list of job --
	--  status for a given list of jobs                               --
	--------------------------------------------------------------------
	IF object_id('tempdb.dbo.#tempJobStatusList') IS NOT null
		DROP TABLE #tempJobStatusList
	IF object_id('tempdb.dbo.#tempJobInfoToStats') IS NOT null
		DROP TABLE #tempJobInfoToStats
	IF object_id('tempdb.dbo.#tempJobInfoJobs') IS NOT null
		DROP TABLE #tempJobInfoJobs
	CREATE TABLE #tempJobStatusList
	(
		jobId			int NOT null,
		status			int NOT null,
		percentcomplete	int NOT null,
		totCompBytes	bigint NOT null,
		totUnCompBytes	bigint NOT null,
		pendingReason	int NOT null,
		jobStartTime	int NOT null,
		jobEndTime		int NOT null,
		destClientId	int NOT null,
		taskId			int NOT null,
	)
	CREATE TABLE #tempJobInfoToStats
	(
		id			int NOT null,
		status		int NOT null,
	)
	CREATE TABLE #tempJobInfoJobs
	(
		jobId			int NOT null,
		taskId			int NOT null,
	)
	INSERT INTO #tempJobInfoToStats VALUES('1', '4')
	INSERT INTO #tempJobInfoToStats VALUES('2', '10')
	INSERT INTO #tempJobInfoToStats VALUES('3', '12')
	INSERT INTO #tempJobInfoToStats VALUES('4', '11')
	INSERT INTO #tempJobInfoToStats VALUES('9', '10') --if dropped, then return failed status.
	--IF (@i_TaskIds != '')
	--BEGIN
	--	SET @s_JobsInfo = 'SELECT JMJobInfo.jobId, JMJobInfo.state, JMJobInfo.percentcomplete, JMRstJobInfo.totCompBytes, JMRstJobInfo.totUnCompBytes, JMJobInfo.pendingCause, JMJobInfo.jobStartTime, JMJobInfo.serverEndTime, JMRstJobInfo.destClientId, #tempJobInfoJobs.taskId FROM JMJobInfo, JMRstJobInfo, #tempJobInfoJobs WHERE JMJobInfo.jobId = JMRstJobInfo.jobId and JMJobInfo.CommCellId = JMRstJobInfo.CommCellId and JMJobInfo.jobId IN '
	--	SET @s_JobsStats = 'SELECT JMRestoreStats.jobId, #tempJobInfoToStats.status, 100, totCompBytes_l, totUncompBytes_l, 0, servStartTime, servEndTime, destClientId, #tempJobInfoJobs.taskId FROM JMRestoreStats, #tempJobInfoToStats, #tempJobInfoJobs WHERE  #tempJobInfoToStats.id = JMRestoreStats.status and JMRestoreStats.jobId IN '
	--	INSERT INTO #tempJobInfoJobs
	--		EXEC(@s_JobsTasks + @i_TaskIds)
	--	INSERT INTO #tempJobStatusList
	--	EXEC(@s_JobsInfo + @s_JobsFound + ' UNION ' + @s_JobsStats + @s_JobsFound)
	--END
	--ELSE
	--BEGIN
		IF (@i_JobIds != '')
		BEGIN
			SET @s_JobsInfo = 'SELECT JMJobInfo.jobId, JMJobInfo.state, JMJobInfo.percentcomplete, JMRstJobInfo.totCompBytes, JMRstJobInfo.totUnCompBytes, JMJobInfo.pendingCause, JMJobInfo.jobStartTime, JMJobInfo.serverEndTime, JMRstJobInfo.destClientId, 0 FROM JMJobInfo, JMRstJobInfo WHERE JMJobInfo.jobId = JMRstJobInfo.jobId and JMJobInfo.CommCellId = JMRstJobInfo.CommCellId and JMJobInfo.jobId IN '
			SET @s_JobsStats = 'SELECT jobId, #tempJobInfoToStats.status, 100, totCompBytes_l, totUncompBytes_l, 0, servStartTime, servEndTime, destClientId, 0 FROM JMRestoreStats, #tempJobInfoToStats WHERE  #tempJobInfoToStats.id = JMRestoreStats.status and jobId IN '
			-- Selecting from adminjob table too as information management jobs are admin jobs
			SET @s_JobsInfo1 = 'SELECT JMJobInfo.jobId, JMJobInfo.state, JMJobInfo.percentcomplete, JMAdminJobInfoTable.uncompBytes, JMAdminJobInfoTable.uncompBytes, JMJobInfo.pendingCause, JMJobInfo.jobStartTime, JMJobInfo.serverEndTime, 1, 0 FROM JMJobInfo, JMAdminJobInfoTable WHERE JMJobInfo.jobId = JMAdminJobInfoTable.jobId and JMJobInfo.CommCellId = JMAdminJobInfoTable.commCellId and JMJobInfo.jobId IN '
			SET @s_JobsStats1 = 'SELECT jobId, #tempJobInfoToStats.status, 100, 0, 0, 0, JMAdminJobStatsTable.servStart,JMAdminJobStatsTable.servEnd, 1, 0 FROM JMAdminJobStatsTable, #tempJobInfoToStats WHERE  #tempJobInfoToStats.id = JMAdminJobStatsTable.status and jobId IN '
			INSERT INTO #tempJobStatusList
			EXEC(@s_JobsInfo + @i_JobIds + ' UNION ' + @s_JobsStats + @i_JobIds + ' UNION '+  @s_JobsInfo1 + @i_JobIds + ' UNION ' + @s_JobsStats1 + @i_JobIds)
			---Now get the jobs whose jobs are unpicked by schedular
			--remove the paranthesis
			select @i_JobIds =REPLACE(REPLACE(@i_JobIds,'(',''),')','')
			select @i_JobIds =LTRIM(RTRIM(@i_JobIds))
			CREATE table #unknownJobIds (jobId BIGINT);
			INSERT INTO #unknownJobIds
			SELECT T.jobId FROM
			(
				SELECT S._ID AS jobId FROM dbo.SplitIDString(@i_JobIds) AS S
					EXCEPT
				SELECT jobId FROM #tempJobStatusList
			)AS T
			IF EXISTS (SELECT TOP 1 * FROM #unknownJobIds)
			BEGIN
				DECLARE @unknownJobs varchar(max) = ''
				SET @unknownJobs = ' ('+ STUFF(
						(SELECT  ', ' "text()", jobId "text()"
						FROM #unknownJobIds
						FOR XML PATH('')),1,1,'') + ') '
				delete #unknownJobIds
				--when joining wiht JMJobs, consider only not processses/processing status
				EXEC ('	SET QUOTED_IDENTIFIER ON;
					INSERT INTO #unknownJobIds
					SELECT T.jobId FROM
					(
						SELECT (
								SELECT T.col.value(''@powerSearchId[1]'',''BIGINT'')
								FROM xmlValue.nodes(''TMMsg_CreateTaskReq/taskInfo/subTasks/options/restoreOptions/searchOption'')
								AS T(col)
							) AS jobId
						FROM TM_CreateTaskRequest WITH (READUNCOMMITTED) WHERE processed = 0
						AND EXISTS
						(
						SELECT T.col.value(''@powerSearchId[1]'',''BIGINT'')
						FROM xmlValue.nodes(''TMMsg_CreateTaskReq/taskInfo/subTasks/options/restoreOptions/searchOption'') AS T(col)
						WHERE T.col.value(''@powerSearchId[1]'',''BIGINT'')
							IN ' + @unknownJobs + '
						)
						UNION
						SELECT jobId FROM TM_Jobs WITH (READUNCOMMITTED)
						WHERE jobId IN ' + @unknownJobs + ' AND STATUS IN (0,1)
					) AS T
				')
				/*
				@karthiks
					Jobs that are returned status = 99 should be ignored by subsystem other than DM2..
					This status is just to continue the polling for the jobs that are unpicked by JM and NO update should happen based on this.
					The change is just to make sure that job is submitted at the DM2 end, and waiting for CS to process..
					if the output of this sp doesnt return any of the input jobId, it can assumed that Job is not submitted at the dm2 end
				***/
				INSERT INTO #tempJobStatusList
						(jobId,status,percentcomplete,
						totCompBytes,totUnCompBytes	,pendingReason,
						jobStartTime,jobEndTime	,destClientId,	taskId)
				SELECT
					jobId,99 ,0 AS percentcomplete	,
					0 AS totCompBytes	,0 AS totUnCompBytes	,0 AS pendingReason	,
					0 AS jobStartTime	,0 AS jobEndTime	,1 AS destClientId,	0 AS taskId
				FROM #unknownJobIds
			END
		END
	--END
	SELECT
		a.jobId,
		a.status,
		a.percentcomplete,
		a.totCompBytes,
		a.totUnCompBytes,
		a.pendingReason,
		a.jobStartTime as jobStartTime,
		a.jobEndTime as jobEndTime,
		a.destClientId,
		name as destClientName,
		a.taskId
	FROM #tempJobStatusList a, app_client b
	WHERE a.destClientid = b.id
	DROP TABLE #tempJobStatusList
	DROP TABLE #tempJobInfoToStats
	DROP TABLE #tempJobInfoJobs
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'JMGetJobStatusForJobIdList')
	delete from GxQscripts where name = 'JMGetJobStatusForJobIdList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobStatusForJobIdList')
	delete from GXDBVersions where aliasname = 'JMGetJobStatusForJobIdList'
GO

insert into GXDBVersions values(2, 'JMGetJobStatusForJobIdList',  '00010020003600010000', 'JMGetJobStatusForJobIdList', '00010020003600010000')
GO

