

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobStatusForComplianceJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   10/31/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetJobStatusForComplianceJobs.sp,v $ $Id: JMGetJobStatusForComplianceJobs.sp,v 1.4.206.1 2018/03/22 03:05:11 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetJobStatusForComplianceJobs <<<'

IF EXISTS (select * from sysobjects where name='JMGetJobStatusForComplianceJobs')
	drop procedure JMGetJobStatusForComplianceJobs
IF EXISTS (select * from GxQscripts where name='JMGetJobStatusForComplianceJobs')
	delete from GxQscripts where name = 'JMGetJobStatusForComplianceJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobStatusForComplianceJobs')
	delete from GXDBVersions where aliasname = 'JMGetJobStatusForComplianceJobs'
GO
print '... Creating Procedure: JMGetJobStatusForComplianceJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetJobStatusForComplianceJobs
  @userguid VARCHAR(36) = ''
AS
	--------------------------------------------------------------------
	--	TABLE #tempJobStatusList will be used to create a list of job --
	--  status for a given list of jobs                               --
	--------------------------------------------------------------------
	IF object_id('tempdb.dbo.#tempJobStatusList') IS NOT null
		DROP TABLE #tempJobStatusList
	IF object_id('tempdb.dbo.#tempJobInfoToStats') IS NOT null
		DROP TABLE #tempJobInfoToStats
	--Declare userInfo variables
	DECLARE @userName NVARCHAR(255) = ''
	DECLARE @userId INTEGER = 0
	IF(@userguid is not null AND LEN(@userguid) > 0)
	BEGIN
		SELECT @userName = U.login, @userId = U.id FROM UMUsers AS U
		WHERE U.userGuid = @userguid
	END
	CREATE TABLE #tempJobStatusList
	(
		jobId			int NOT null,
		status			int NOT null,
		percentcomplete	int NOT null,
		totCompBytes	bigint NOT null,
		totUnCompBytes	bigint NOT null,
		pendingReason	int NOT null,
		jobStartTime	int NOT null,
		jobEndTime		int NOT null,
		clientId		int NOT null,
		taskId			int NOT null,
		appId			int NOT null,
	)
	CREATE TABLE #tempJobInfoToStats
	(
		id			int NOT null,
		status		int NOT null,
	)
	INSERT INTO #tempJobInfoToStats VALUES('1', '4')
	INSERT INTO #tempJobInfoToStats VALUES('2', '10')
	INSERT INTO #tempJobInfoToStats VALUES('3', '12')
	INSERT INTO #tempJobInfoToStats VALUES('4', '11')
	INSERT INTO #tempJobStatusList
	SELECT JMJobInfo.jobId, JMJobInfo.state, JMJobInfo.percentcomplete, 0, JMAdminJobInfoTable.UnCompBytes, JMJobInfo.pendingCause, JMJobInfo.jobStartTime, JMJobInfo.serverEndTime, 2, 0, 0 FROM JMJobInfo, JMAdminJobInfoTable WHERE JMJobInfo.jobId = JMAdminJobInfoTable.jobId AND JMJobInfo.commCellId = JMAdminJobInfoTable.commCellId AND JMAdminJobInfoTable.opType = 64 AND JMJobInfo.opType = 64
		AND ( @userId = 0 OR JMJobInfo.userId = @userId )
	UNION
	SELECT jobId, #tempJobInfoToStats.status, 100, 0, uncompBytes, 0, servStart, servEnd, 2, 0, 0 FROM JMAdminJobStatsTable, #tempJobInfoToStats WHERE  #tempJobInfoToStats.id = JMAdminJobStatsTable.status AND JMAdminJobStatsTable.opType = 64 AND
	(@userName = '' OR JMAdminJobStatsTable.username = @userName)
	SELECT
		a.jobId,
		a.status,
		a.percentcomplete,
		a.totCompBytes,
		a.totUnCompBytes,
		a.pendingReason,
		a.jobStartTime as jobStartTime,
		a.jobEndTime as jobEndTime,
		1 as destClientId
	FROM #tempJobStatusList a, app_client b
	WHERE a.clientid = b.id
	DROP TABLE #tempJobStatusList
	DROP TABLE #tempJobInfoToStats
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'JMGetJobStatusForComplianceJobs')
	delete from GxQscripts where name = 'JMGetJobStatusForComplianceJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobStatusForComplianceJobs')
	delete from GXDBVersions where aliasname = 'JMGetJobStatusForComplianceJobs'
GO

insert into GXDBVersions values(2, 'JMGetJobStatusForComplianceJobs',  '00010004020600010000', 'JMGetJobStatusForComplianceJobs', '00010004020600010000')
GO

