

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobStaggerTimeForReSubmit.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetJobStaggerTimeForReSubmit.sp,v $ $Id: JMGetJobStaggerTimeForReSubmit.sp,v 1.1.2.4 2018/03/27 09:11:28 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMGetJobOption()
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Divakar R   		Sp to get job stagger time while resubmitting
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetJobStaggerTimeForReSubmit <<<'

IF EXISTS (select * from sysobjects where name='JMGetJobStaggerTimeForReSubmit')
	drop procedure JMGetJobStaggerTimeForReSubmit
IF EXISTS (select * from GxQscripts where name='JMGetJobStaggerTimeForReSubmit')
	delete from GxQscripts where name = 'JMGetJobStaggerTimeForReSubmit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobStaggerTimeForReSubmit')
	delete from GXDBVersions where aliasname = 'JMGetJobStaggerTimeForReSubmit'
GO
print '... Creating Procedure: JMGetJobStaggerTimeForReSubmit'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetJobStaggerTimeForReSubmit
  @inJobID INT
AS
  DECLARE @jobStaggerTime INTEGER
SET @jobStaggerTime = 30 * 60 --default
SET NOCOUNT ON
IF NOT EXISTS (SELECT 1 FROM JMJobOptions WITH(NOLOCK) WHERE attributeId = 62 AND attributeName = 'Resubmitted Job ID' AND attributeValueInt = @inJobID)
BEGIN
	--This job is the start point for resubmit
	SET @jobStaggerTime = 30 * 60
END
ELSE
BEGIN
	--This is not First ReSubmit so stagger time can be 6 hours or 12 hours. That is initial retry count was 2 or 3
DECLARE @cJobRetryCount INTEGER = (SELECT attributeValueInt FROM JMJobOptions WITH(NOLOCK) WHERE attributeId = 58 AND attributeName = 'Job Auto Re-Submit Count' AND jobId = @inJobID)
DECLARE @parentJobID INTEGER = (SELECT jobId FROM JMJobOptions WITH(NOLOCK) WHERE attributeId = 62 AND attributeName = 'Resubmitted Job ID' AND attributeValueInt = @inJobID)
	DECLARE @FirstJID INTEGER = @parentJobID
	WHILE @parentJobID IS NOT NULL
	BEGIN
SET @parentJobID = (SELECT jobId FROM JMJobOptions WITH(NOLOCK) WHERE attributeId = 62 AND attributeName = 'Resubmitted Job ID' AND attributeValueInt = @parentJobID)
		IF @parentJobID IS NOT NULL
			SET @FirstJID = @parentJobID
	END
DECLARE @TotalRetryCount INTEGER = (SELECT attributeValueInt FROM JMJobOptions WITH(NOLOCK) WHERE attributeId = 58 AND attributeName = 'Job Auto Re-Submit Count' AND jobId = @FirstJID)
	IF (@TotalRetryCount-@cJobRetryCount) = 2
		SET @jobStaggerTime = 60 * 60 * 12 --12 hours
	ELSE IF (@TotalRetryCount-@cJobRetryCount) = 1
		SET @jobStaggerTime = 60 * 60 * 6 --6 hours
END
SELECT @jobStaggerTime
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetJobStaggerTimeForReSubmit')
	delete from GxQscripts where name = 'JMGetJobStaggerTimeForReSubmit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobStaggerTimeForReSubmit')
	delete from GXDBVersions where aliasname = 'JMGetJobStaggerTimeForReSubmit'
GO

insert into GXDBVersions values(2, 'JMGetJobStaggerTimeForReSubmit',  '00010001000200040000', 'JMGetJobStaggerTimeForReSubmit', '00010001000200040000')
GO

