

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetJobOptions.sp,v $ $Id: JMGetJobOptions.sp,v 1.4.48.1 2016/12/09 17:27:03 shashankgupta Exp $";
---- =============================================
---- Author:		Jaya Rama Raju Inavolu
---- Description:	Get the job options
---- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetJobOptions <<<'

IF EXISTS (select * from sysobjects where name='JMGetJobOptions')
	drop procedure JMGetJobOptions
IF EXISTS (select * from GxQscripts where name='JMGetJobOptions')
	delete from GxQscripts where name = 'JMGetJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobOptions')
	delete from GXDBVersions where aliasname = 'JMGetJobOptions'
GO
print '... Creating Procedure: JMGetJobOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetJobOptions
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inputXml XML
AS
BEGIN
  DECLARE @outputXml XML 
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @jmjoboptions TABLE
	(
		jobId				int,
		commcellId			int,
		attributeId			int,
		attributeName  		varchar(1024),
		attributeValueInt	bigint,
		attributeValue		text
	)
	INSERT INTO @jmjoboptions
	SELECT
	ISNULL(i.col.value('@jobId', 'int'), 0),
	ISNULL(i.col.value('@commcellId', 'int'), 2),
	ISNULL(i.col.value('@attributeId', 'int'), 0),
	ISNULL(i.col.value('@attributeName', 'varchar(1024)'), ''),
	0,
	''
	FROM
	@inputXml.nodes('JobManager_GetJmJobOptionsReq/jobOptions') i(col)
	UPDATE t1
	SET
	t1.attributeValueInt = t2.attributeValueInt,
	t1.attributeValue = t2.attributeValue
	FROM @jmjoboptions t1
	Inner join JmJobOptions t2
	ON t1.jobId = t2.JobId AND t1.commcellId = t2.commcellId AND t1.attributeId = t2.attributeId AND t1.attributeName = t2.attributeName
	SET @outputXml =
	(
		SELECT
		jobId '@jobId',
		commcellId '@commcellId',
		attributeId '@attributeId',
		attributeName '@attributeName',
		attributeValueInt '@attributeValueInt',
		dbo.EncodeInvalidXMLChar(attributeValue) '@attributeValue'
		FROM @jmjoboptions
		FOR XML PATH('jobOptions'), ROOT('JobManager_GetJmJobOptionsResp')
	)
	IF @outputXml IS NULL
		SET @outputXml = '<JobManager_GetJmJobOptionsResp/>'
	SELECT @outputXml
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetJobOptions')
	delete from GxQscripts where name = 'JMGetJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobOptions')
	delete from GXDBVersions where aliasname = 'JMGetJobOptions'
GO

insert into GXDBVersions values(2, 'JMGetJobOptions',  '00010004004800010000', 'JMGetJobOptions', '00010004004800010000')
GO

