

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobOption.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetJobOption.sp,v $ $Id: JMGetJobOption.sp,v 1.2.208.2 2018/03/22 21:07:22 njudge Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMGetJobOption()
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Ashish Gupta   		Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetJobOption <<<'

IF EXISTS (select * from sysobjects where name='JMGetJobOption')
	drop procedure JMGetJobOption
IF EXISTS (select * from GxQscripts where name='JMGetJobOption')
	delete from GxQscripts where name = 'JMGetJobOption'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobOption')
	delete from GXDBVersions where aliasname = 'JMGetJobOption'
GO
print '... Creating Procedure: JMGetJobOption'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetJobOption
  @inXmlReq XML,
  @outXmlResp XML	OUTPUT
AS
SET NOCOUNT ON
BEGIN
	SET @outXmlResp = (
			SELECT J.jobId '@jobId',
				( CASE WHEN op.exist('adminOpts/vmProvisioningOption/*') = 1
					THEN
						(SELECT op.value('adminOpts[1]/vmProvisioningOption[1]/@operationType', 'int') '@operationType',
							op.query('adminOpts/vmProvisioningOption/*')
						FOR XML PATH('vmProvOption'), TYPE)
					END),
				(SELECT op.query('restoreOptions/virtualServerRstOption/*')
				FOR XML PATH(''), TYPE),
			(SELECT op.value('adminOpts[1]/sendLogFilesOption[1]', 'nvarchar(255)'),
					op.query('adminOpts/sendLogFilesOption')
						FOR XML PATH(''), TYPE)
			FROM (	SELECT ref.value('@val', 'integer') AS jobId
					FROM  @inXmlReq.nodes ('TMMsg_GetJobOptionReq/jobIds') R(ref)
			) AS J
			INNER JOIN TM_JobXMLOptions TJ ON TJ.jobId=J.jobId
			CROSS APPLY TJ.xmlValue.nodes ('TMMsg_JobOption') M(op)
			FOR XML PATH('jobOptions'), ROOT('TMMsg_GetJobOptionResp')
		)
	IF ( @outXmlResp IS null )
		SET @outXmlResp = '<TMMsg_GetJobOptionResp />'
	SELECT @outXmlResp
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetJobOption')
	delete from GxQscripts where name = 'JMGetJobOption'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobOption')
	delete from GXDBVersions where aliasname = 'JMGetJobOption'
GO

insert into GXDBVersions values(2, 'JMGetJobOption',  '00010002020800020000', 'JMGetJobOption', '00010002020800020000')
GO

