

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobIndexInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--  +========================================================================+
--  |      Name	 :  JMGetJobIndexInfo
--  |
--  | Description:  It queries JM and TM tables based on query criteria and returns the output XML.
--	|				Currently it is handling backup jobs. It can be extended for any kind of jobs later.
--	|				It returns one row for each request irrespective of whether it gets the valid data or not.
--	|
--  +========================================================================+
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetJobIndexInfo.sp,v $ $Id: JMGetJobIndexInfo.sp,v 1.1.2.5.4.2 2021/02/17 04:31:05 sbonilla Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMGetJobIndexInfo')
BEGIN
	print '>>> Drop Stored Procedure: JMGetJobIndexInfo <<<'
	drop procedure JMGetJobIndexInfo
END
IF EXISTS (select * from GxQscripts where name='JMGetJobIndexInfo')
	delete from GxQscripts where name = 'JMGetJobIndexInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobIndexInfo')
	delete from GXDBVersions where aliasname = 'JMGetJobIndexInfo'
GO
print '... Creating Procedure: JMGetJobIndexInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMGetJobIndexInfo
  @i_xml XML
AS
  DECLARE @o_XML XML;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @jobId INT = 0
	DECLARE @vmClientId INT = 0
	DECLARE @vmsubClientId INT = 0
	DECLARE @vmBackupSetId INT = 0
	DECLARE @vmInstanceId INT = 0
	DECLARE @parentClientId INT = 0
	DECLARE @parentSubclientId INT = 0
	DECLARE @archFileId INT = 0
	DECLARE @commCellId INT = 2
	DECLARE @toTime INT = 0
	DECLARE @fromTime INT = 0
	DECLARE @appId INT = 0
	DECLARE @getBackupCopyInfo INT = 0
	DECLARE @userId INT = 0
	DECLARE @localeId INT = 0
	DECLARE @errorCode	INTEGER = 0
	DECLARE @errorString NVARCHAR(MAX) = ''
	DECLARE @vsaV2ParentJobAttr BIGINT = (CAST(0x40000000 AS BIGINT) | CAST(0x100000000000000 AS BIGINT)) -- JMBKP_EX_PSEUDO_PARENT_JOB | JMBKP_EX_VSA_PARENT_SYNTHFULL
	DECLARE @vsaV2Job BIGINT = (CAST(0x40000000 AS BIGINT) | CAST(0x4000000 AS BIGINT) | CAST(0x20000000000 AS BIGINT)) -- JMBKP_EX_PSEUDO_PARENT_JOB | JMBKP_EX_PSEUDO_CHILD_JOB | JMBKP_EX_VM_LEVEL_SYNTHFULL
	SELECT @commCellId = ISNULL(ref.value('commcell[1]/@commCellId', 'int'), @commCellId),
			@vmClientId = ISNULL(ref.value('vmClient[1]/@clientId', 'int'), 0),
			@vmsubClientId = ISNULL(ref.value('vmClient[1]/@subclientId', 'int'), 0),
			@vmBackupSetId = ISNULL(ref.value('vmClient[1]/@backupsetId', 'int'), 0),
			@vmInstanceId = ISNULL(ref.value('vmClient[1]/@instanceId', 'int'), 0),
			@archFileId = ISNULL(ref.value('@archFileId', 'int'), 0),
			@parentClientId = ISNULL(ref.value('vmSourceClient[1]/@clientId', 'int'), 0),
			@jobId = ISNULL(ref.value('@jobId', 'int'), 0),
			@toTime = ISNULL(ref.value('jobTimeRange[1]/@toTime', 'int'), dbo.GetUnixTime(GETUTCDATE())),  -- default to time to current time if not passed
			@fromTime = ISNULL(ref.value('jobTimeRange[1]/@fromTime', 'int'), 0),
			@parentSubclientId = ISNULL(ref.value('vmSourceClient[1]/@subclientId', 'int'), 0),
			@getBackupCopyInfo = ISNULL(ref.value('@getBackupCopyInfo', 'int'), 0),
			@userId = ISNULL(ref.value('processinginstructioninfo[1]/user[1]/@userId', 'int'), 0),
			@localeId = ISNULL(ref.value('processinginstructioninfo[1]/locale[1]/@localeId', 'int'), 0)
	FROM @i_xml.nodes('JobManager_JobGetIndexInfoReq') R ( ref )
	IF object_id('tempdb.dbo.#tblIndexJobInfo') IS NOT NULL DROP TABLE #tblIndexJobInfo
	IF object_id('tempdb.dbo.#tblJobInfo') IS NOT NULL DROP TABLE #tblJobInfo
	IF object_id('tempdb.dbo.#tblAppId') IS NOT NULL DROP TABLE #tblAppId
	CREATE TABLE #tblIndexJobInfo(jobId bigint, commcellId int, clientId int, subClientId int, jobSubStatus int DEFAULT NULL, jobStartTime int DEFAULT NULL, jobEndTime int DEFAULT NULL, dataArchGroupId INT DEFAULT NULL, backupLevel INT DEFAULT NULL, isIndexingV2 INT DEFAULT NULL, opType INT, isIntelliSnap INT DEFAULT NULL, isBackupCopyDone INT DEFAULT 0)
	CREATE TABLE #tblJobInfo(jobId bigint, commcellId int, clientId int, subClientId int, jobSubStatus int DEFAULT NULL, jobStartTime int DEFAULT NULL, jobEndTime int DEFAULT NULL, dataArchGroupId INT DEFAULT NULL, backupLevel INT DEFAULT NULL, bkpAttributesEx BIGINT DEFAULT NULL, isParent INT, opType INT)
	CREATE TABLE #tblAppId(appId INT, backupSetId INT, clientId INT, isParent INT)
	CREATE CLUSTERED INDEX tblAppId_appId_Index1 ON #tblAppId ([appId])
	CREATE CLUSTERED INDEX tblJobInfo_jobId_Index1 ON #tblJobInfo ([jobId])
	IF @vmClientId = 0 AND @vmsubClientId = 0 AND @vmBackupSetId = 0 AND @parentClientId = 0 AND @jobId = 0 AND @archFileId = 0 AND @parentSubclientId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid input in request'
		GOTO ALL_DONE
	END
	-- Do security check if user Id is passed
	IF @userId > 0
	BEGIN
		DECLARE @isVisible INT = 0
		IF @jobId > 0
		BEGIN
			SELECT @isVisible = dbo.isVisible(@userId, @jobId, @commCellId, 0, 0, 0, 0, 0, 0)
		END
		ELSE
		BEGIN
			IF OBJECT_ID(N'tempdb.dbo.#secObjects') IS NOT NULL
				DROP TABLE #secObjects
create table  #secObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
			IF @vmClientId > 0
			BEGIN
				exec sec_getUserObjects @userId, 2009 /*CLIENT_ITEM*/, 0, '#secObjects'
				SELECT TOP 1 @isVisible = 1
				FROM #secObjects sec WHERE sec.clientId = @vmClientId
			END
			ELSE IF @parentClientId > 0
			BEGIN
				exec sec_getUserObjects @userId, 2009 /*CLIENT_ITEM*/, 0, '#secObjects'
				SELECT TOP 1 @isVisible = 1
				FROM #secObjects sec WHERE sec.clientId = @parentClientId
			END
			ELSE IF @parentSubclientId > 0
			BEGIN
				exec sec_getUserObjects @userId, 2013 /*SUB_CLIENT_ITEM*/, 0, '#secObjects'
				SELECT TOP 1 @isVisible = 1
				FROM #secObjects sec WHERE sec.subClientId = @parentSubclientId
			END
			-- Check for CS level rights
			IF @isVisible = 0
			BEGIN
				SELECT TOP 1 @isVisible = 1
				FROM #secObjects sec
WHERE sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
			END
			IF OBJECT_ID(N'tempdb.dbo.#secObjects') IS NOT NULL
				DROP TABLE #secObjects
		END
		IF @isVisible = 0
		BEGIN
			SET @errorCode = 2
			SET @errorString = 'User does not have rights on the provided objects.'
			GOTO ALL_DONE
		END
	END
	IF @jobId > 0
	BEGIN
		INSERT INTO #tblIndexJobInfo
		(jobId, commcellId, clientId, subClientId, jobSubStatus, jobStartTime, jobEndTime, dataArchGroupId, backupLevel, isIndexingV2, opType, isIntelliSnap)
		SELECT B.jobId, B.commCellId, A.clientId, B.appId, B.status, B.servStartDate, B.servEndDate, B.dataArchGrpId, B.bkpLevel,
			CASE WHEN B.bkpAttributesEx & @vsaV2Job <> 0 OR B.bkpAttributesEx & @vsaV2ParentJobAttr <> 0 THEN 1 ELSE 0 END isIndexingV2,
			CASE WHEN C.subOptype > 0 THEN C.subOpType ELSE B.opType END opType,
			CASE WHEN B.opType = 59 THEN 1 ELSE 0 END isIntelliSnap -- SNAPBACKUP
		FROM APP_Application A (NOLOCK)
		JOIN JMBkpStats (NOLOCK) B ON B.jobId = @jobId AND B.appId = A.id AND B.commcellId = @commCellId
		JOIN JMJobStats (NOLOCK) C ON B.jobId = C.jobId and B.commcellId = C.commcellId
		AND B.opType <> 60 -- SNAPTOTAPE - Exclude backup copy
		AND (C.subOptype IN (144, 145, 147 /*BACKUP_ADMIN , SNAP_BACKUP_ADMIN, SYNTH_FULL_ADMIN*/) OR dataStatus = 0) -- DATA_STATUS_VALID - Include unaged jobs only except when dummy parent
	END
	ELSE IF @archFileId > 0
	BEGIN
		INSERT INTO #tblIndexJobInfo
		(jobId, commcellId, clientId, subClientId, jobSubStatus, jobStartTime, jobEndTime, dataArchGroupId, backupLevel, isIndexingV2, opType, isIntelliSnap)
		SELECT B.jobId, B.commCellId, A.clientId, B.appId, B.status, B.servStartDate, B.servEndDate, B.dataArchGrpId, B.bkpLevel,
			CASE WHEN B.bkpAttributesEx&@vsaV2Job <> 0 OR B.bkpAttributesEx & @vsaV2ParentJobAttr <> 0 THEN 1 ELSE 0 END isIndexingV2,
			CASE WHEN C.subOptype > 0 THEN C.subOpType ELSE B.opType END opType,
			CASE WHEN B.opType IN (59, 145) THEN 1 ELSE 0 END isIntelliSnap /*(SNAPBACKUP, SNAP_BACKUP_ADMIN)*/
		FROM APP_Application A (NOLOCK)
		JOIN archFile (NOLOCK) R ON R.id = @archFileId
		JOIN JMBkpStats (NOLOCK) B ON B.jobId = R.jobId AND B.appId = A.id AND B.commcellId = @commCellId
		JOIN JMJobStats (NOLOCK) C ON B.jobId = C.jobId and B.commcellId = C.commcellId
		AND B.opType <> 60 -- SNAPTOTAPE - Exclude backup copy
		AND B.dataStatus = 0 --DATA_STATUS_VALID - Exclude aged jobs
	END
	ELSE
	BEGIN
		INSERT INTO #tblAppId
		(appId, backupSetId, clientId, isParent)
		SELECT id, backupSet, clientId, 0 isParent
		FROM APP_Application (NOLOCK) WHERE clientId = @vmClientId AND @vmInstanceId = 0 AND @vmBackupSetId = 0 AND @vmsubClientId = 0
		UNION ALL
		SELECT id, backupSet, clientId, 0 isParent
		FROM APP_Application (NOLOCK) WHERE id = @vmsubClientId
		UNION ALL
		SELECT id, backupSet, clientId, 0 isParent
		FROM APP_Application (NOLOCK) WHERE backupSet = @vmBackupSetId AND @vmsubClientId = 0
		UNION ALL
		SELECT id, backupSet, clientId, 0 isParent
		FROM APP_Application (NOLOCK) WHERE instance = @vmInstanceId AND @vmBackupSetId = 0 AND @vmsubClientId = 0
		UNION ALL
		SELECT id, backupSet, clientId, 1 isParent
		FROM APP_Application (NOLOCK) WHERE clientId = @parentClientId AND @parentSubclientId = 0 AND @vmClientId = 0 AND @vmInstanceId = 0 AND @vmBackupSetId = 0 AND @vmsubClientId = 0
		UNION ALL
		SELECT id, backupSet, clientId, 1 isParent
		FROM APP_Application (NOLOCK) WHERE id = @parentSubclientId AND @vmClientId = 0 AND @vmInstanceId = 0 AND @vmBackupSetId = 0 AND @vmsubClientId = 0
		IF @fromTime = 0
		BEGIN
			INSERT INTO #tblJobInfo
			(jobId, commcellId, clientId, subClientId, jobSubStatus, jobStartTime, jobEndTime, dataArchGroupId, backupLevel, bkpAttributesEx, isParent, opType)
			SELECT jobId, commCellId, clientId, appId, status, T.servStartDate, servEndDate, dataArchGrpId, bkpLevel, bkpAttributesEx, isParent, opType
			FROM
			(
				SELECT TOP 1 JM.jobId, JM.commCellId, JM.appId, A.clientId, JM.status, JM.servStartDate, JM.servEndDate, JM.dataArchGrpId, JM.bkpLevel, JM.bkpAttributesEx, A.isParent,
				CASE WHEN B.subOptype > 0 THEN B.subOptype ELSE JM.opType END opType
				FROM JMBkpStats JM (NOLOCK)
				JOIN #tblAppId A ON A.appId = JM.appId AND JM.commcellId = @commCellId
				JOIN JMJobStats (NOLOCK) B ON B.jobId = JM.jobId and B.commcellId = JM.commcellId
				WHERE JM.servEndDate <= @toTime
				AND JM.status IN (1, 3, 14) --JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
				AND JM.opType <> 60 -- SNAPTOTAPE - Exclude backup copy
				AND (B.subOptype IN (144, 145, 147 /*BACKUP_ADMIN , SNAP_BACKUP_ADMIN, SYNTH_FULL_ADMIN*/) OR dataStatus = 0) -- DATA_STATUS_VALID - Include unaged jobs only except when dummy parent
				ORDER BY JM.servEndDate DESC
			) T
			UNION ALL
			SELECT jobId, commCellId, clientId, appId, status, T.servStartDate, servEndDate, dataArchGrpId, bkpLevel, bkpAttributesEx, isParent, opType
			FROM
			(
				SELECT TOP 1 JM.jobId, JM.commCellId, JM.appId, AP.clientId, JM.status, JM.servStartDate, servEndDate, JM.dataArchGrpId, JM.bkpLevel, JM.bkpAttributesEx, A.isParent, JM.opType
				FROM JMBkpStats JM (NOLOCK)
				JOIN #tblAppId A ON A.isParent = 0
				JOIN JMQinetixUpdateStatus Q (NOLOCK) ON Q.clientId = A.clientId AND Q.jobId = JM.jobId AND JM.commcellId = @commCellId
				JOIN APP_Application AP (NOLOCK) ON AP.id = JM.appId
				WHERE servEndDate <= @toTime
				AND (JM.bkpAttributesEx & @vsaV2ParentJobAttr = 0) -- Exclude V2 parents in VM level job history(client filters)
				AND JM.opType <> 60 -- SNAPTOTAPE - Exclude backup copy
				AND JM.status IN (1, 3, 14) --JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
				AND dataStatus = 0 --DATA_STATUS_VALID - Exclude aged jobs
				ORDER BY JM.servEndDate DESC
			) T
		END
		ELSE
		BEGIN
			INSERT INTO #tblJobInfo
			(jobId, commcellId, subClientId, clientId, jobSubStatus, jobStartTime, jobEndTime, dataArchGroupId, backupLevel, bkpAttributesEx, isParent, opType)
			SELECT jobId, commCellId, appId, clientId, status, servStartDate, servEndDate, dataArchGrpId, bkpLevel, bkpAttributesEx, isParent, opType
			FROM
			(
				SELECT TOP 1 JM.jobId, JM.commCellId, JM.appId, A.clientId, JM.status, JM.servStartDate, JM.servEndDate, JM.dataArchGrpId, JM.bkpLevel, JM.bkpAttributesEx, A.isParent,
				CASE WHEN B.subOptype > 0 THEN B.subOptype ELSE JM.opType END opType
				FROM JMBkpStats JM (NOLOCK)
				JOIN #tblAppId A ON A.appId = JM.appId AND JM.commcellId = @commCellId
				JOIN JMJobStats (NOLOCK) B ON B.jobId = JM.jobId and B.commcellId = JM.commcellId
				WHERE JM.servEndDate <= @toTime
				AND JM.servStartDate >= @fromTime
				AND JM.status IN (1, 3, 14) --JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
				AND JM.opType <> 60 -- SNAPTOTAPE - Exclude backup copy
				AND (B.subOptype IN (144, 145, 147 /*BACKUP_ADMIN , SNAP_BACKUP_ADMIN, SYNTH_FULL_ADMIN*/) OR dataStatus = 0) -- DATA_STATUS_VALID - Include unaged jobs only except when dummy parent
				ORDER BY JM.servEndDate DESC
			) T
			UNION ALL
			SELECT jobId, commCellId, appId, clientId, status, T.servStartDate, servEndDate, dataArchGrpId, bkpLevel, bkpAttributesEx, isParent, opType
			FROM
			(
				SELECT TOP 1 JM.jobId, JM.commCellId, JM.appId, AP.clientId, JM.status, JM.servStartDate, JM.servEndDate, JM.dataArchGrpId, JM.bkpLevel, JM.bkpAttributesEx, A.isParent, JM.opType
				FROM JMBkpStats JM (NOLOCK)
				JOIN #tblAppId A ON A.isParent = 0
				JOIN JMQinetixUpdateStatus Q (NOLOCK) ON Q.clientId = A.clientId AND Q.jobId = JM.jobId AND JM.commcellId = @commCellId
				JOIN APP_Application AP (NOLOCK) ON AP.id = JM.appId
				WHERE servEndDate <= @toTime
				AND (JM.bkpAttributesEx & @vsaV2ParentJobAttr = 0) -- Exclude V2 parents in VM level job history(client filters)
				AND JM.status IN (1, 3, 14) --JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
				AND JM.opType <> 60 -- SNAPTOTAPE - Exclude backup copy
				AND servStartDate >= @fromTime
				AND dataStatus = 0 --DATA_STATUS_VALID - Exclude aged jobs
				ORDER BY JM.servEndDate DESC
			) T
		END
		INSERT INTO #tblIndexJobInfo
		(jobId, commcellId, clientId, subClientId, jobSubStatus, jobStartTime, jobEndTime, dataArchGroupId, backupLevel, isIndexingV2, opType, isIntelliSnap)
		SELECT B.jobId, B.commCellId, B.clientId, B.subClientId, B.status, B.servStartDate, B.servEndDate, B.dataArchGrpId, B.bkpLevel,
			CASE
				WHEN (B.bkpAttributesEx & @vsaV2Job <> 0)
					OR
					B.opType IN (144, 145, 147)	--BACKUP_ADMIN, SNAP_BACKUP_ADMIN, SYNTH_FULL_ADMIN
					THEN 1
					ELSE 0
					END isIndexingV2,
			B.opType,
			CASE WHEN B.opType IN (59, 145) THEN 1 ELSE 0 END isIntelliSnap /*(SNAPBACKUP, SNAP_BACKUP_ADMIN)*/
		FROM (
				SELECT TOP 1 jobId, commcellId, clientId, subClientId, jobSubStatus status, jobStartTime servStartDate, jobEndTime servEndDate, dataArchGroupId dataArchGrpId, backupLevel bkpLevel, bkpAttributesEx, isParent, opType
				FROM #tblJobInfo
				ORDER BY jobEndTime DESC
			) B
	END
	If @getBackupCopyInfo = 1
	BEGIN
		IF EXISTS(SELECT 1 FROM #tblIndexJobInfo WHERE isIntelliSnap = 1)
		BEGIN
			UPDATE TBL
			SET isBackupCopyDone = 1
			FROM #tblIndexJobInfo TBL
			WHERE TBL.opType = 59
			AND EXISTS (	SELECT 1
							FROM JMJobSnapshotStats SNAP
							WHERE SNAP.jobId = TBL.jobId AND SNAP.commcellId = TBL.commcellId
							AND SNAP.materializationStatus = 100  /*SNAPSHOT_MATSTATUS_READY*/
						 )
			-- For V2 parent admin job, there is no definitive way to check backup copy status as it has no data.
			-- We will find the child jobs and see if any of them are backup copied
			UPDATE TBL
			SET isBackupCopyDone = 1
			FROM #tblIndexJobInfo TBL
			WHERE TBL.opType = 145
			AND EXISTS (	SELECT 1
							FROM JMJobDataLink LNK
							JOIN JMJobSnapshotStats SNAP ON SNAP.jobId = LNK.childJobId AND SNAP.commcellId = LNK.commcellId
							WHERE LNK.parentJobId = TBL.jobId AND LNK.commcellId = TBL.commcellId
							AND SNAP.materializationStatus = 100  /*SNAPSHOT_MATSTATUS_READY*/
						 )
		END
	END
ALL_DONE:
	IF @errorCode = 0
	BEGIN
		SET @o_XML = (SELECT TOP 1
						[jobId] '@jobId',
						[jobSubStatus] '@jobSubStatus',
						[backupLevel] '@backupLevel',
						[isIndexingV2] '@isIndexingV2',
						[isIntelliSnap] '@isIntelliSnap',
						[isBackupCopyDone] '@isBackupCopyDone',
						[jobStartTime] 'jobStartTime/@time',
						[jobEndTime] 'jobEndTime/@time',
						[commCellId] 'commcell/@commCellId',
						[clientId] 'entity/@clientId',
						[subClientId] 'entity/@subclientId',
						[dataArchGroupId] 'storagePolicy/@storagePolicyId'
					FROM #tblIndexJobInfo
					ORDER BY jobEndTime DESC
					FOR XML PATH('jobInfoList'), ROOT('JobManager_JobIndexingQueryResp'))
	END
	ELSE
	BEGIN
		SET @o_XML =
		(
			SELECT(
					SELECT
					@errorCode '@errorCode',
					@errorString '@errLogMessage'
					FOR XML PATH('errList'), TYPE
				)
			FOR XML PATH('error'), ROOT('JobManager_JobIndexingQueryResp')
		)
	END
    IF @o_XML IS NULL
        SET @o_XML = '<JobManager_JobIndexingQueryResp/>'
	SELECT @o_XML o_XML
	IF object_id('tempdb.dbo.#tblAppId') IS NOT NULL DROP TABLE #tblAppId
	IF object_id('tempdb.dbo.#tblIndexJobInfo') IS NOT NULL DROP TABLE #tblIndexJobInfo
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetJobIndexInfo')
	delete from GxQscripts where name = 'JMGetJobIndexInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobIndexInfo')
	delete from GXDBVersions where aliasname = 'JMGetJobIndexInfo'
GO

insert into GXDBVersions values(2, 'JMGetJobIndexInfo',  'v1.1.2.5.4.2', 'JMGetJobIndexInfo', 'v1.1.2.5.4.2')
GO

