

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobHistory.sp] ---------- 

-- ---------------------------------------------------------------------------------------------------------------------------------------
--        ProcName: JmGetJobHistory
--        Returns the hourly jobcount with time for the last maxDays
--
--        input: 1. jobTypesFilter -defaulted 15(1+2+4+8) All jobs (1 - bkp,2 - restore,4 - admin,8 -laptopbackup)
--               2. maxDays - max number of days to retrieve jobcount
--               3. jobStatus - comma separated jobstatus from CVJobStatus defaulted to '1,16'  CVJobStatus::JMSUCCESS, COMMITTED
--
--        output:
--				jobcount   |       date_Time
--			  ---------------------------------------
--					5	   |  2018-09-14 00:00:00.000
--					0	   |  2018-09-14 01:00:00.000
--					4	   |  2018-09-14 02:00:00.000
--
--
------------------------------------------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JmGetJobHistory')
BEGIN
	print '>>> Drop Stored Procedure: JmGetJobHistory <<<'
	drop procedure JmGetJobHistory
END
IF EXISTS (select * from GxQscripts where name='JmGetJobHistory')
	delete from GxQscripts where name = 'JmGetJobHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JmGetJobHistory')
	delete from GXDBVersions where aliasname = 'JmGetJobHistory'
GO
print '... Creating Procedure: JmGetJobHistory'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JmGetJobHistory
  @jobTypesFilter INT = 15,
  @maxDays INT = 90,
  @jobStatus VARCHAR(256) = '1,16'
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @jobCount INT
  DECLARE @date_hour DATETIME
	--calculate for the previous hour as the current hour's data would not be complete
	SET NOCOUNT ON;
	DECLARE @daysToConsider INT = @maxDays
	DECLARE @secondsInhour INT = 60*60
	DECLARE @secondsInDay INT = @secondsInhour * 24
	DECLARE @time INT = DATEDIFF(SECOND, '1970-01-01 00:00:00', GETUTCDATE())
	DECLARE @currentDate INT = (@time / @secondsInDay) * @secondsInDay
	DECLARE @currentHr INT = (@time / @secondsInhour) * @secondsInhour
	DECLARE @configurableFromDateTimestamp INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name='FromTimeForAnomalyAlert' and modified=0),0)
	IF (@time - @configurableFromDateTimestamp)/(60*60*24) < @daysToConsider
		SET @daysToConsider = (@time - @configurableFromDateTimestamp)/(60*60*24)
	DECLARE @startDate INT = @currentDate - (@secondsInDay * (@daysToConsider-1)) - @secondsInhour
	DECLARE @useHistoryTable INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name='UseHistoryTableInsteadOfJobStats' and modified=0),1)
	IF OBJECT_ID('tempdb.dbo.#hrtable') IS NOT NULL
		DROP TABLE #hrtable
    CREATE TABLE #hrtable
    (
		hourlytime int,
		jobCount int
		primary key(hourlytime)
    )
    ;WITH cteNums(n) AS
    (
        SELECT @startDate + @secondsInhour
        UNION ALL
        SELECT n + @secondsInhour
        FROM cteNums WHERE n < @currentHr -- get till currnt time
    )
	INSERT #hrtable
    SELECT n,0 FROM cteNums
    OPTION (MAXRECURSION 0)
	IF OBJECT_ID('tempdb.dbo.#jobStatus') IS NOT NULL
		DROP TABLE #jobStatus
	CREATE TABLE #jobStatus
	(
		jstatus INT
	)
	INSERT INTO #jobStatus
		SELECT data FROM DBO.SPLIT(@jobStatus,',')
	IF @useHistoryTable = 0
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#jobTable') IS NOT NULL
			DROP TABLE #jobTable
		CREATE TABLE #jobTable
		(
		    jobId INT,
			subclientId INT,
			commcellId INT,
			evdateHour INT
		)
IF @jobTypesFilter & 1 <> 0 OR @jobTypesFilter & 8 <> 0
		INSERT INTO #jobTable
		 SELECT
			jobID,appId,commcellID,
			(servEndDate / @secondsInhour) * @secondsInhour
			FROM JMBkpStats INNER JOIN #jobStatus ON jstatus = status
			WHERE servEndDate > @startDate
IF @jobTypesFilter & 2 <> 0
		INSERT INTO #jobTable
		 SELECT
			jobId,0,commcellId,
			(servEndTime / @secondsInhour) * @secondsInhour
			FROM JMRestoreStats INNER JOIN #jobStatus ON jstatus = status
			WHERE servEndTime > @startDate
IF @jobTypesFilter & 4 <> 0
		INSERT INTO #jobTable
		 SELECT
			jobId,0,2,
			(servEnd / @secondsInhour) * @secondsInhour
			FROM JMAdminJobStatsTable INNER JOIN #jobStatus ON jstatus = status
			WHERE servEnd > @startDate
AND opType NOT IN (17,39,92,35,36,67,68,84,64,90)
		--if only one these two are selected, then filter out based on the type selected
IF (@jobTypesFilter & 1 <> 0 AND @jobTypesFilter & 8 = 0)OR(@jobTypesFilter & 1 = 0 AND @jobTypesFilter & 8 <> 0)
		BEGIN
			 DELETE Bkp
			 FROM #jobTable Bkp
			 INNER JOIN App_Application App ON Bkp.subclientId= App.Id
			 INNER JOIN App_Client Client ON Client.id = App.clientId
WHERE (Client.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000)) > 0 AND @jobTypesFilter & 8 = 0) OR
(Client.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000)) = 0 AND @jobTypesFilter & 1 = 0)
		END
		DECLARE @firstJobTime INT = 0
		SELECT @firstJobTime = MIN(evdateHour) FROM #jobTable
		DELETE FROM #hrtable WHERE hourlytime < @firstJobTime
		UPDATE  HR SET jobcount = JOB.jobCount
		FROM #hrtable HR
		INNER JOIN
		(   SELECT COUNT(1) jobCount, evdateHour
			FROM #jobTable
			GROUP BY evdateHour
		)JOB
		ON (JOB.evdateHour + @secondsInhour) = HR.hourlytime
	END
	ELSE
	BEGIN
		DECLARE @curHr INT = DATEPART(HOUR, DATEADD(SECOND,@currentHr,'19700101'))
		DECLARE @curDt DATE = DATEADD(SECOND,@currentDate,'19700101')
		--if history table doesnt contain the data for current hour, populate it
		IF NOT EXISTS( SELECT 1 FROM historyDB.dbo.jobStatusSummary WHERE evHour = @curHr AND evDate = @curDt)
			EXEC EvMoveJobStatsToHistoryDB
		UPDATE HR SET jobCount = JOB.occ
		FROM #hrtable HR
		INNER JOIN (
					SELECT DATEDIFF(SECOND,'19700101',evDate)+(3600*evHour) dateHour , SUM(occurances) occ
					FROM historyDB.dbo.jobStatusSummary INNER JOIN #jobStatus ON jobStatus = jstatus
					WHERE jobType & @jobTypesFilter > 0
					GROUP BY evHour,evDate
					)JOB ON JOB.dateHour = HR.hourlytime
		DECLARE @firstJobDate DATETIME
		DECLARE @firstJobHr DATETIME
		SELECT @firstJobDate = MIN(evdate) FROM historyDB.dbo.jobStatusSummary
		SELECT @firstJobHr = MIN(evHour) FROM historyDB.dbo.jobStatusSummary WHERE evdate = @firstJobDate
		SELECT @firstJobTime = DATEDIFF(SECOND,'19700101',@firstJobDate)+(3600*evHour) FROM historyDB.dbo.jobStatusSummary
		DELETE FROM #hrtable WHERE hourlytime < @firstJobTime
	END
	SELECT jobCount,DATEADD(SECOND,hourlyTime,'19700101') date_time FROM #hrtable order by hourlyTime
	IF OBJECT_ID('tempdb.dbo.#hrtable') IS NOT NULL
		DROP TABLE #hrtable
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetJobHistory')
	delete from GxQscripts where name = 'JMGetJobHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobHistory')
	delete from GXDBVersions where aliasname = 'JMGetJobHistory'
GO

insert into GXDBVersions values(2, 'JMGetJobHistory',  '00000000000000000000', 'JMGetJobHistory', '00000000000000000000')
GO

