

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--  +========================================================================+
--  |      Name	 :  JMGetJobDetails
--  |
--  | Description:  It queries JM and TM tables based on query criteria and returns the output XML.
--	|				Currently it is handling backup jobs. It can be extended for any kind of jobs later.
--	|				It returns one row for each request irrespective of whether it gets the valid data or not.
--	|
--  |	   Input :	input XML request
--	|
--  |      Output:  output XML
--	|
--  |   Revisions  Author      Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.1      Hemant Mishra  support for backup jobs
--  |
--  +========================================================================+
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetJobDetails.sp,v $ $Id: JMGetJobDetails.sp,v 1.13.2.17 2020/04/17 14:08:02 mnatarajan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetJobDetails')
BEGIN
	print '>>> Drop Stored Procedure: JMGetJobDetails <<<'
	drop procedure JMGetJobDetails
END
IF EXISTS (select * from GxQscripts where name='JMGetJobDetails')
	delete from GxQscripts where name = 'JMGetJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobDetails')
	delete from GXDBVersions where aliasname = 'JMGetJobDetails'
GO
print '... Creating Procedure: JMGetJobDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetJobDetails
  @xmlTextInput XML
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE		@oXML				XML
	DECLARE		@i_commCellID		INT
	DECLARE		@utcTime			BIGINT = (SELECT dbo.GetUnixTime(GETUTCDATE()))
	SET @i_commCellID = ISNULL(( SELECT ref.value('@commCellID', 'int')
							FROM @xmlTextInput.nodes('JobManager_JobInfoReq') R ( ref ) ),
						2)
	--
	-- Temporary table variables
	--
	DECLARE @tblQuery				TABLE (t_JobQueryType int, t_JobId bigint, t_subClientID int, t_clientId int, t_backupsetId int)
	DECLARE @localeID	INT				= ISNULL (( SELECT ref.value('@localeID', 'INT')
														FROM @xmlTextInput.nodes ('JobManager_JobInfoReq') R(ref)), 0)
	-- Note:  If you add any new fields to below table fix JMGetEdgeJobDetails.sp also !!!
	IF object_id('tempdb.dbo.#tblJobInfo') IS NOT NULL DROP TABLE #tblJobInfo
	CREATE TABLE #tblJobInfo(t_JobQueryType int, t_JobId bigint, t_JobType int, t_CientID int, t_SubClientID int, t_SizeOfBackup bigint DEFAULT NULL, t_NumberOfFiles bigint DEFAULT NULL,
										   t_JobStatus int DEFAULT NULL, t_JobSubState int DEFAULT NULL, t_JobSubStatus int DEFAULT NULL, t_JobSubmitError int DEFAULT NULL, t_JobStartTime bigint DEFAULT NULL, t_JobEndTime bigint DEFAULT NULL, currentUTCTime bigint, t_dataTransferredSize bigint DEFAULT NULL,
										   t_bkpAttributes bigint DEFAULT NULL, t_bkpAttributesEx bigint DEFAULT NULL, t_pendingReason nvarchar(max) DEFAULT NULL, t_dataArchGroupId INT DEFAULT NULL, t_backupLevel INT DEFAULT NULL)
	INSERT INTO @tblQuery
	SELECT	ref.value('@jobQueryType', 'int') ,
			ref.value('@jobID', 'bigint') ,
			CASE
				WHEN sc.value('@subclientId', 'int') > 0 THEN sc.value('@subclientId', 'int')
				ELSE ref.value('@subClientID', 'int')
			END,
			sc.value('@clientId', 'int'),
			sc.value('@backupsetId', 'int')
	FROM @xmlTextInput.nodes('JobManager_JobInfoReq/queryInfoList') R ( ref )
	OUTER APPLY ref.nodes('subclient') S(sc)
	IF ( ((SELECT COUNT(*) FROM @tblQuery) = 1)
				AND
		 EXISTS(SELECT 1 FROM @tblQuery Q
				INNER JOIN APP_Application APP WITH(NOLOCK) ON Q.t_subClientID = APP.id
				WHERE Q.t_JobQueryType IN (2, 3)
				AND APP.subclientStatus & 0x20000 <> 0 -- CV_STATUS_EDGEDRIVE_SUB
				)
	   )
	BEGIN
		DECLARE @clientId INT = 0
		DECLARE @subclientId INT = 0
		DECLARE @queryType INT = 0
		SELECT @clientId = t_clientId,
			   @subclientId = t_subClientID,
			   @queryType = t_JobQueryType
		FROM @tblQuery
		INSERT INTO #tblJobInfo
		EXEC JMGetEdgeJobDetails @i_commCellID, @clientId, @subclientId, @queryType, @localeID
			GOTO RETURN_RESULTS
	END
	-- 1) Processing requests with query type as JOB (JobQueryType = 1).
	-- 1a) Checking currently running jobs.
	INSERT INTO #tblJobInfo
	(t_JobQueryType, t_JobId, t_JobType, t_CientID, t_SubClientID, t_SizeOfBackup, t_NumberOfFiles, t_JobStatus, t_JobSubState, t_JobSubStatus, t_JobSubmitError, t_JobStartTime, t_JobEndTime, currentUTCTime, t_dataTransferredSize,
										   t_bkpAttributes, t_bkpAttributesEx, t_pendingReason, t_dataArchGroupId, t_backupLevel)
	SELECT t_JobQueryType, t_JobId, 1, (SELECT clientid from App_Application WHERE id = JBI.applicationId), JBI.applicationId, JBI.unCompBytes, JBI.filesXfered, 1, JI.state, NULL, NULL, JI.jobStartTime, NULL, @utcTime, JBI.nwTransBytes,
	JBI.bkpAttributes, JBI.bkpAttributesEx, dbo.JMGetLocalizedMessageFunc(@localeID, JI.failureReason), JBI.currentPolicy, JBI.bkpLevel
	FROM @tblQuery, JMJobInfo JI, JmbkpjobInfo JBI
	WHERE t_JobQueryType = 1 AND JBI.commcellId = @i_commCellID AND t_JobId = JI.jobID  AND t_JobId = JBI.jobID
	DELETE TQ FROM @tblQuery TQ, #tblJobInfo TJI WHERE TQ.t_JobId= TJI.t_JobId AND TQ.t_JobQueryType = 1 AND TQ.t_JobQueryType = TJI.t_JobQueryType
	IF NOT EXISTS (SELECT 1 FROM  @tblQuery)
		GOTO RETURN_RESULTS
	INSERT INTO #tblJobInfo
	(t_JobQueryType, t_JobId, t_JobType, t_CientID, t_SubClientID, t_NumberOfFiles, t_JobStatus, t_JobSubState, t_JobStartTime, currentUTCTime,
										   t_bkpAttributes, t_pendingReason)
	SELECT t_JobQueryType, t_JobId, 2, srcClientId, 0, JRI.totFiles2Xfer, 1, JI.state, JI.jobStartTime, @utcTime,
	JRI.rstattributes, dbo.JMGetLocalizedMessageFunc(@localeID, JI.failureReason)
	FROM @tblQuery, JMJobInfo JI, JMRstJobInfo JRI
	WHERE t_JobQueryType = 1 AND JRI.commCellId = @i_commCellID AND t_JobId = JI.jobId AND t_JobId = JRI.jobId
	DELETE TQ FROM @tblQuery TQ, #tblJobInfo TJI WHERE TQ.t_JobId= TJI.t_JobId AND TQ.t_JobQueryType = 1 AND TQ.t_JobQueryType = TJI.t_JobQueryType
	IF NOT EXISTS (SELECT 1 FROM  @tblQuery)
		GOTO RETURN_RESULTS
	-- 1b) Checking job history tables.
	INSERT INTO #tblJobInfo
	(t_JobQueryType, t_JobId, t_JobType, t_CientID, t_SubClientID, t_SizeOfBackup, t_NumberOfFiles, t_JobStatus, t_JobSubState, t_JobSubStatus, t_JobSubmitError, t_JobStartTime, t_JobEndTime, currentUTCTime, t_dataTransferredSize,
										   t_bkpAttributes, t_bkpAttributesEx, t_pendingReason, t_dataArchGroupId, t_backupLevel)
	SELECT t_JobQueryType, t_JobId, 1, (SELECT clientid from App_Application WHERE id = JBS.appId), JBS.appId, JBS.totalUncompBytes, JBS.totalNumOfFiles, 2, NULL,
		   JBS.status, JBS.failureErrorCode, JBS.servStartDate, JBS.servEndDate, @utcTime, JBS.nwTransBytes, JBS.bkpAttributes, JBS.bkpAttributesEx, dbo.JMGetLocalizedMessageFunc(@localeID, JBS.failureReason), JBS.dataArchGrpId, JBS.bkpLevel
	FROM @tblQuery, Jmbkpstats JBS
	WHERE t_JobQueryType = 1 AND JBS.commCellId = @i_commCellID AND t_JobId = JBS.jobID
	DELETE TQ FROM @tblQuery TQ, #tblJobInfo TJI WHERE TQ.t_JobId= TJI.t_JobId AND TQ.t_JobQueryType = 1 AND TQ.t_JobQueryType = TJI.t_JobQueryType
	IF NOT EXISTS (SELECT 1 FROM  @tblQuery)
		GOTO RETURN_RESULTS
	INSERT INTO #tblJobInfo
	(t_JobQueryType, t_JobId, t_JobType, t_CientID, t_SubClientID, t_NumberOfFiles, t_JobStatus, t_JobSubStatus, t_JobStartTime,
										   currentUTCTime, t_bkpAttributes, t_pendingReason)
	SELECT t_JobQueryType, t_JobId, 1, srcClientId, 0, ISNULL(CONVERT(BIGINT, JRS.totFiles2Xfer_h)*2147483648 + CONVERT(BIGINT,JRS.totFiles2Xfer_l), 0), 2, JRS.status, JRS.servStartTime,
	    @utcTime, JRS.rstattributes, dbo.JMGetLocalizedMessageFunc(@localeID, JRS.failureReason)
	FROM @tblQuery, JMJobStats JS, JMRestoreStats JRS
	WHERE t_JobQueryType = 1 AND JRS.commCellId = @i_commCellID AND t_JobId = JS.jobId AND t_JobId = JRS.jobId
	DELETE TQ FROM @tblQuery TQ, #tblJobInfo TJI WHERE TQ.t_JobId= TJI.t_JobId AND TQ.t_JobQueryType = 1 AND TQ.t_JobQueryType = TJI.t_JobQueryType
	IF NOT EXISTS (SELECT 1 FROM  @tblQuery)
		GOTO RETURN_RESULTS
	-- 1c) Checking currently running download update/install update jobs.
	INSERT INTO #tblJobInfo
	SELECT t_JobQueryType, t_JobId, 3, C.id, NULL, NULL, NULL,
	CASE
	WHEN t_clientId > 0 THEN
		CASE JQUPS.category
		WHEN 0 /*QCATEGORY_UNKNOWN*/ THEN 2 /*PREVIOUS_JOB*/
		WHEN 1 /*QCATEGORY_SUCCESS*/ THEN 2 /*PREVIOUS_JOB*/
		WHEN 2 /*QCATEGORY_PENDING*/ THEN 2 /*PREVIOUS_JOB*/
		WHEN 3 /*QCATEGORY_FAILED*/ THEN 2 /*PREVIOUS_JOB*/
		WHEN 4 /*QCATEGORY_ALREADY_UP_TO_DATE*/ THEN 2 /*PREVIOUS_JOB*/
		WHEN 8 /*QCATEGORY_PARTIAL_SUCCESS*/ THEN 2 /*PREVIOUS_JOB*/
		WHEN 5 /*QCATEGORY_INPROGRESS*/ THEN 1 /*CURRENT_JOB*/
		WHEN 7 /*QCATECORY_WAITING*/ THEN 1 /*CURRENT_JOB*/
		WHEN 9 /*QCATEGORY_SKIPPING*/ THEN 2 /*PREVIOUS_JOB*/
		WHEN 10 /*QCATEGORY_REBOOT_REQUIRED*/ THEN 2 /*PREVIOUS JOB*/
		ELSE 1 /*CURRENT_JOB*/
		END
	ELSE
		1 /*CURRENT_JOB*/
	END,
	CASE
	WHEN t_clientId > 0 THEN
		CASE JQUPS.category
		WHEN 7 /*QCATECORY_WAITING*/ THEN 3 /*WAITING*/
		WHEN 5 /*QCATEGORY_INPROGRESS*/ THEN 1 /*RUNNING*/
		ELSE NULL
		END
	ELSE
		JI.state
	END,
		CASE
	WHEN t_clientId > 0 THEN
		CASE JQUPS.category
		WHEN 0 /*QCATEGORY_UNKNOWN*/ THEN 2 /*FAIL*/
		WHEN 1 /*QCATEGORY_SUCCESS*/ THEN 1 /*JMSUCCESS*/
		WHEN 2 /*QCATEGORY_PENDING*/ THEN 2 /*FAIL*/
		WHEN 3 /*QCATEGORY_FAILED*/ THEN 2 /*FAIL*/
		WHEN 8 /*QCATEGORY_PARTIAL_SUCCESS*/ THEN 2 /*FAIL*/
		WHEN 4 /*QCATEGORY_ALREADY_UP_TO_DATE*/ THEN 1 /*JMSUCCESS*/
		WHEN 9 /*QCATEGORY_SKIPPING*/ THEN 1 /*JMSUCCESS*/
		WHEN 10 /*QCATEGORY_REBOOT_REQUIRED*/ THEN 2 /*FAIL*/
		ELSE NULL
		END
	ELSE
		NULL
	END,
	NULL, JI.jobStartTime, NULL, NULL, NULL, NULL, NULL, dbo.JMGetLocalizedMessageFunc(@localeID, JI.failureReason), NULL, NULL
	FROM @tblQuery, JMJobInfo JI, JMAdminJobInfoTable JAJI, JMQinetixUpdateStatus JQUPS, APP_Client C
	WHERE t_JobQueryType = 1 AND JI.commCellId = @i_commCellID AND JQUPS.commCellId = @i_commCellID
				AND t_JobId = JI.jobID  AND t_JobId = JAJI.jobID AND JAJI.jobId = JQUPS.jobId
				AND JQUPS.clientId = C.id AND JAJI.optype IN (35,36,67)
				AND (t_clientId = JQUPS.clientId OR t_clientId is null OR t_clientId = 0)
	UNION
	SELECT t_JobQueryType, t_JobId, 3, NULL, NULL, NULL, NULL, 1, JI.state, NULL, NULL, JI.jobStartTime, NULL, NULL, NULL, NULL, NULL, dbo.JMGetLocalizedMessageFunc(@localeID, JI.failureReason), NULL, NULL
	FROM @tblQuery, JMJobInfo JI, JMAdminJobInfoTable JAJI
	WHERE t_JobQueryType = 1 AND JI.commCellId = @i_commCellID
				AND t_JobId = JI.jobID  AND t_JobId = JAJI.jobID
				AND JI.commCellId = JAJI.commCellId
				AND JAJI.optype NOT IN (35,36,67)
	DELETE TQ FROM @tblQuery TQ, #tblJobInfo TJI WHERE TQ.t_JobId= TJI.t_JobId AND TQ.t_JobQueryType = 1 AND TQ.t_JobQueryType = TJI.t_JobQueryType
	IF NOT EXISTS (SELECT 1 FROM  @tblQuery)
		GOTO RETURN_RESULTS
	-- 1d) Checking the status of last download update/install update jobs (history tables).
	INSERT INTO #tblJobInfo
	SELECT t_JobQueryType, t_JobId, 3, C.id, NULL, NULL, NULL,
	2, /*PREVIOUS_JOB*/
	NULL,
	CASE
	WHEN t_clientId > 0 THEN
		CASE JQUPS.category
		WHEN 0 /*QCATEGORY_UNKNOWN*/ THEN 2 /*FAIL*/
		WHEN 1 /*QCATEGORY_SUCCESS*/ THEN 1 /*JMSUCCESS*/
		WHEN 2 /*QCATEGORY_PENDING*/ THEN 2 /*FAIL*/
		WHEN 3 /*QCATEGORY_FAILED*/ THEN 2 /*FAIL*/
		WHEN 8 /*QCATEGORY_PARTIAL_SUCCESS*/ THEN 2 /*FAIL*/
		WHEN 4 /*QCATEGORY_ALREADY_UP_TO_DATE*/ THEN 1 /*JMSUCCESS*/
		WHEN 9 /*QCATEGORY_SKIPPING*/ THEN 1 /*JMSUCCESS*/
		WHEN 10 /*QCATEGORY_REBOOT_REQUIRED*/ THEN 2 /*FAIL*/
		ELSE NULL
		END
	ELSE
		JAJS.status
	END,
	JAJS.failureErrorCode, JAJS.servStart, JAJS.servEnd, NULL, NULL, NULL, NULL, dbo.JMGetLocalizedMessageFunc(@localeID, JAJS.failureReason), NULL, NULL
	FROM @tblQuery, JMJobStats JS, JMAdminJobStatsTable JAJS, JMQinetixUpdateStatus JQUPS, APP_Client C
	WHERE t_JobQueryType = 1 AND JS.commCellId = @i_commCellID AND JQUPS.commCellId = @i_commCellID AND JAJS.commCellId = @i_commCellID
				AND t_JobId = JS.jobID  AND t_JobId = JAJS.jobID AND JAJS.jobId = JQUPS.jobId
				AND JQUPS.clientId = C.id AND JAJS.optype IN (35,36,67)
				AND JQUPS.clientId = t_clientId
	UNION
	SELECT t_JobQueryType, t_JobId, 3, NULL, NULL, NULL, NULL,	2, /*PREVIOUS_JOB*/NULL, JAJS.status, JAJS.failureErrorCode, JAJS.servStart, JAJS.servEnd, NULL, NULL, NULL, NULL, dbo.JMGetLocalizedMessageFunc(@localeID, JAJS.failureReason), NULL, NULL
	FROM @tblQuery, JMJobStats JS, JMAdminJobStatsTable JAJS
	WHERE t_JobQueryType = 1 AND JS.commCellId = @i_commCellID AND JAJS.commCellId = @i_commCellID
				AND t_JobId = JS.jobID  AND t_JobId = JAJS.jobID
				AND JS.commCellId = JAJS.commCellId
				AND JAJS.optype NOT IN (35,36,67)
	DELETE TQ FROM @tblQuery TQ, #tblJobInfo TJI WHERE TQ.t_JobId= TJI.t_JobId AND TQ.t_JobQueryType = 1 AND TQ.t_JobQueryType = TJI.t_JobQueryType
	IF NOT EXISTS (SELECT 1 FROM  @tblQuery)
		GOTO RETURN_RESULTS
	-- 2) Processing requests with query type as SUBCLIENT_CURRENT_JOB (JobQueryType = 2)(Returns job info for currently running job for given subclient If any).
	-- Filter backup copy jobs also here since they shouldnt block OSC backups from running. MR 272759
	-- We should not consider synth full job or stateless job or backup copy job (optype#14,#116,#60) with this query criteria.
	INSERT INTO #tblJobInfo
	(t_JobQueryType, t_JobId, t_JobType, t_CientID, t_SubClientID, t_SizeOfBackup, t_NumberOfFiles, t_JobStatus, t_JobSubState, t_JobSubStatus, t_JobSubmitError, t_JobStartTime, t_JobEndTime, currentUTCTime, t_dataTransferredSize,
										   t_bkpAttributes, t_bkpAttributesEx, t_pendingReason, t_dataArchGroupId, t_backupLevel)
	SELECT t_JobQueryType, JBI.jobId, 1, (SELECT clientid from App_Application WHERE id = t_subClientID), t_subClientID, JBI.unCompBytes, JBI.filesXfered, 1, JI.state, NULL, NULL, JI.jobStartTime, null, null, JBI.nwTransBytes, JBI.bkpAttributes, JBI.bkpAttributesEx, dbo.JMGetLocalizedMessageFunc(@localeID, JI.failureReason), JBI.currentPolicy, JBI.bkpLevel
	FROM @tblQuery, JMJobInfo JI, JmbkpjobInfo JBI
	WHERE t_JobQueryType = 2 AND JBI.commcellId = @i_commCellID AND t_subClientID = JBI.applicationId  AND JBI.jobId = JI.jobId AND JI.opType NOT IN (14, 116, 60)
	DELETE TQ FROM @tblQuery TQ, #tblJobInfo TJI WHERE TQ.t_subClientID= TJI.t_subClientID AND TQ.t_JobQueryType = 2 AND TQ.t_JobQueryType = TJI.t_JobQueryType
	IF NOT EXISTS (SELECT 1 FROM  @tblQuery)
		GOTO RETURN_RESULTS
	-- 3) Processing requests with query type as SUBCLIENT_LAST_SUCC_JOB (JobQueryType = 3)(Returns job info for last successful job for given subclient If any).
	INSERT INTO #tblJobInfo
	(t_JobQueryType, t_JobId, t_JobType, t_CientID, t_SubClientID, t_SizeOfBackup, t_NumberOfFiles, t_JobStatus, t_JobSubState, t_JobSubStatus, t_JobSubmitError, t_JobStartTime, t_JobEndTime, currentUTCTime, t_dataTransferredSize,
										   t_bkpAttributes, t_bkpAttributesEx, t_pendingReason, t_dataArchGroupId, t_backupLevel)
	SELECT TOP 1 t_JobQueryType, JBS.jobId, 1, (SELECT clientid from App_Application WHERE id = t_subClientID), t_subClientID, JBS.totalUncompBytes,
			JBS.totalNumOfFiles, 2, NULL, JBS.status, NULL, JBS.servStartDate, JBS.servEndDate, @utcTime, JBS.nwTransBytes, JBS.bkpAttributes, JBS.bkpAttributesEx, dbo.JMGetLocalizedMessageFunc(@localeID, JBS.failureReason), JBS.dataArchGrpId, JBS.bkpLevel
	FROM @tblQuery, Jmbkpstats JBS
	WHERE t_JobQueryType = 3 AND JBS.commCellId = @i_commCellID AND t_subClientID = JBS.appId AND JBS.status in (1,3,14) AND JBS.bkpLevel in (1,2,4)
	ORDER BY JBS.servEndDate desc
	DELETE TQ FROM @tblQuery TQ, #tblJobInfo TJI WHERE TQ.t_subClientID= TJI.t_subClientID AND TQ.t_JobQueryType = 3 AND TQ.t_JobQueryType = TJI.t_JobQueryType
	IF NOT EXISTS (SELECT 1 FROM  @tblQuery)
		GOTO RETURN_RESULTS
	-- 4) Processing requests with query type as CLIENT (JobQueryType = 4)(Returns job info for currently running job for given client If any).
	-- We should not consider synth full job or stateless job (optype#14,#116) with this query criteria.
	INSERT INTO #tblJobInfo
	(t_JobQueryType, t_JobId, t_JobType, t_CientID, t_SubClientID, t_SizeOfBackup, t_NumberOfFiles, t_JobStatus, t_JobSubState, t_JobSubStatus, t_JobSubmitError, t_JobStartTime, t_JobEndTime, currentUTCTime, t_dataTransferredSize,
										   t_bkpAttributes, t_bkpAttributesEx, t_pendingReason, t_dataArchGroupId, t_backupLevel)
	SELECT t_JobQueryType, JBI.jobId, 1, t_clientId, APP.id, JBI.unCompBytes, JBI.filesXfered, 1, JI.state, NULL, NULL, JI.jobStartTime, null, null, JBI.nwTransBytes, JBI.bkpAttributes, JBI.bkpAttributesEx, dbo.JMGetLocalizedMessageFunc(@localeID, JI.failureReason), JBI.currentPolicy, JBI.bkpLevel
	FROM @tblQuery, JMJobInfo JI, JmbkpjobInfo JBI, APP_Application APP
	WHERE t_JobQueryType = 4 AND JBI.commcellId = @i_commCellID AND JBI.applicationId = APP.id AND JBI.jobId = JI.jobId AND JI.opType NOT IN (14, 116) AND APP.clientId = t_clientId
	DELETE TQ FROM @tblQuery TQ, #tblJobInfo TJI WHERE TQ.t_clientId = TJI.t_CientID AND TQ.t_JobQueryType = 4 AND TQ.t_JobQueryType = TJI.t_JobQueryType
	IF NOT EXISTS (SELECT 1 FROM  @tblQuery)
		GOTO RETURN_RESULTS
	--4) Checking for scheduled jobs which are yet to be picked by JM.
	--#define BKP_APPID				100001
	--Jobsubstate => TO_BE_PICKED_BY_JM = 100
	-- 4a)
	INSERT INTO #tblJobInfo
	(t_JobQueryType, t_JobId, t_JobType, t_JobStatus, t_JobSubState)
	SELECT t_JobQueryType, t_JobId,
	CASE ST.subTaskType
	WHEN 1 /*SUB_TASK_TYPE_ADMIN*/ THEN 3 /*ADMIN*/
	WHEN 2 /*SUB_TASK_TYPE_BACKUP*/ THEN 1 /*BACKUP*/
	WHEN 3 /*SUB_TASK_TYPE_RESTORE*/ THEN 2 /*RESTORE*/
	END,
	1, 100
	FROM @tblQuery Q
	JOIN TM_JOBS TJ ON TJ.jobId = Q.t_JobId AND TJ.status IN (0,1)
	JOIN TM_JobRequest JR ON JR.jobRequestId = TJ.jobRequestId
	JOIN TM_SubTask ST ON ST.subTaskId = JR.subTaskId
	WHERE t_JobQueryType = 1
	DELETE TQ FROM @tblQuery TQ, #tblJobInfo TJI WHERE TQ.t_JobId= TJI.t_JobId AND TQ.t_JobQueryType = 1 AND TQ.t_JobQueryType = TJI.t_JobQueryType
	IF NOT EXISTS (SELECT 1 FROM  @tblQuery)
		GOTO RETURN_RESULTS
	-- 4b)
	INSERT INTO #tblJobInfo
	(t_JobQueryType, t_JobId, t_JobType, t_CientID, t_SubClientID, t_SizeOfBackup, t_NumberOfFiles, t_JobStatus, t_JobSubState, t_JobSubStatus, t_JobSubmitError, t_JobStartTime, t_JobEndTime, currentUTCTime, t_dataTransferredSize,
										   t_bkpAttributes, t_bkpAttributesEx, t_pendingReason, t_dataArchGroupId, t_backupLevel)
	SELECT t_JobQueryType, TJO.jobId, 1, (SELECT clientid from APP_Application where id = t_subClientID), t_subClientID, NULL, NULL, 1, 100, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
	FROM @tblQuery, TM_JOBS TJ, TM_JobOptions TJO
	WHERE t_JobQueryType = 2 AND t_subClientID = TJO.value AND  TJ.jobId = TJO.jobId AND TJO.optionId=100001 AND TJ.status IN (0,1)
	DELETE TQ FROM @tblQuery TQ, #tblJobInfo TJI WHERE TQ.t_subClientID= TJI.t_subClientID AND TQ.t_JobQueryType = 2 AND TQ.t_JobQueryType = TJI.t_JobQueryType
	IF NOT EXISTS (SELECT 1 FROM  @tblQuery)
		GOTO RETURN_RESULTS
	-- 5) Processing requests with query type as SUBCLIENT_LAST_SUCC_INC_JOB (JobQueryType = 5)(Returns job info for last successful incremental job for given subclient).
	INSERT INTO #tblJobInfo
	(t_JobQueryType, t_JobId, t_JobType, t_CientID, t_SubClientID, t_SizeOfBackup, t_NumberOfFiles, t_JobStatus, t_JobSubState, t_JobSubStatus, t_JobSubmitError, t_JobStartTime, t_JobEndTime, currentUTCTime, t_dataTransferredSize,
										   t_bkpAttributes, t_bkpAttributesEx, t_pendingReason, t_dataArchGroupId, t_backupLevel)
	SELECT TOP 1 t_JobQueryType, JBS.jobId, 1, (SELECT clientid from App_Application WHERE id = t_subClientID), t_subClientID, JBS.totalUncompBytes,
			JBS.totalNumOfFiles, 2, NULL, JBS.status, NULL, JBS.servStartDate, JBS.servEndDate, @utcTime, JBS.nwTransBytes, JBS.bkpAttributes, JBS.bkpAttributesEx, dbo.JMGetLocalizedMessageFunc(@localeID, JBS.failureReason), JBS.dataArchGrpId, JBS.bkpLevel
	FROM @tblQuery, Jmbkpstats JBS
	WHERE t_JobQueryType = 5 AND JBS.commCellId = @i_commCellID AND t_subClientID = JBS.appId AND JBS.status in (1,3,14) AND JBS.bkpLevel = 2
	ORDER BY JBS.servEndDate desc
	DELETE TQ FROM @tblQuery TQ, #tblJobInfo TJI WHERE TQ.t_subClientID= TJI.t_subClientID AND TQ.t_JobQueryType = 5 AND TQ.t_JobQueryType = TJI.t_JobQueryType
	IF NOT EXISTS (SELECT 1 FROM  @tblQuery)
		GOTO RETURN_RESULTS
	-- 6) Processing requests with query type as BKPSET_CURRENT_RST_JOB (JobQueryType = 6)(Return the current running restore jobs for a backupset if any).
	INSERT INTO #tblJobInfo
	(t_JobQueryType, t_JobId, t_JobType, t_CientID, t_SubClientID, t_NumberOfFiles, t_JobStatus, t_JobSubState, t_JobStartTime, currentUTCTime,
										   t_bkpAttributes, t_pendingReason)
	SELECT t_JobQueryType, JI.jobId, 2, srcClientId, 0, JRI.totFiles2Xfer, 1, JI.state, JI.jobStartTime, @utcTime,
	JRI.rstattributes, dbo.JMGetLocalizedMessageFunc(@localeID, JI.failureReason)
	FROM @tblQuery, JMJobInfo JI, JMRstJobInfo JRI
	WHERE t_JobQueryType = 6 AND JRI.commCellId = @i_commCellID AND JI.jobId = JRI.jobId AND t_backupsetId = JRI.bkpSetID
	DELETE TQ FROM @tblQuery TQ, #tblJobInfo TJI WHERE TQ.t_clientId = TJI.t_CientID AND TQ.t_JobQueryType = 6 AND TQ.t_JobQueryType = TJI.t_JobQueryType
	IF EXISTS (SELECT 1 FROM  @tblQuery)
	BEGIN
		-- If data is not found in JM/TM tables then returning CVJOBSTATUS_ERROR as JobStatus.
		INSERT INTO #tblJobInfo
		SELECT t_JobQueryType, t_JobId, NULL, NULL, (CASE WHEN t_subClientID IS NOT null THEN t_subClientID ELSE t_subClientID END),
				NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL FROM @tblQuery
	END
RETURN_RESULTS:
	-- Treat Inactive status as success for OSC
	UPDATE #tblJobInfo
	SET t_JobStatus = 2,
		t_JobSubState = NULL,
		t_jobSubStatus = 1, --JMSUCCESS
		t_JobEndTime = (SELECT MAX(endTime)
						FROM JMBkpAttemptInfo
						WHERE jobid = t_JobId AND commCellId = @i_commCellID
						AND status IN (1,3,14)
						)
	WHERE t_JobStatus = 1 AND t_JobSubState = 20 --INACTIVE
	SET @oXML = (SELECT
					[t_JobQueryType] '@jobQueryType',
					[t_JobId] '@jobID',
					[t_JobType] '@jobType',
					[t_CientID] '@clientID',
					[t_SubClientID] '@subClientID',
					[t_SizeOfBackup] '@sizeOfBackup',
					[t_NumberOfFiles] '@numberOfFiles',
					[t_JobStatus] '@jobStatus',
					[t_JobSubState] '@jobSubState',
					[t_JobSubStatus] '@jobSubStatus',
					[t_JobSubmitError] '@jobSubmitError',
					[t_JobStartTime] '@jobStartTime',
					[t_JobEndTime] '@jobEndTime',
					[currentUTCTime] '@currentUTCTime',
					[t_dataTransferredSize] '@dataTransferredSize',
					[t_bkpAttributes] '@bkpAttributes',
					[t_bkpAttributesEx] '@bkpAttributesEx',
					[t_pendingReason] '@jobPendingReason',
					[t_backupLevel] '@backupLevel',
					[t_dataArchGroupId] 'storagePolicy/@storagePolicyId'
				FROM #tblJobInfo
				ORDER BY t_JobQueryType
				FOR XML PATH('jobInfoList'), ROOT('JobManager_JobInfoResp'))
	SELECT @oXML
DROP TABLE #tblJobInfo
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetJobDetails')
	delete from GxQscripts where name = 'JMGetJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobDetails')
	delete from GXDBVersions where aliasname = 'JMGetJobDetails'
GO

insert into GXDBVersions values(2, 'JMGetJobDetails',  '00010013000200170000', 'JMGetJobDetails', '00010013000200170000')
GO

