

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobCountForSubclient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetJobCountForSubclient.sp,v $ $Id: JMGetJobCountForSubclient.sp,v 1.1.2.2 2016/01/30 21:47:44 pbedhapudi Exp $";
---- =============================================
---- Author:		Divakar
---- Create date:	01/13/2016
---- Description:	Get no of successfull jobs for a subclient after a given job
---- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetJobCountForSubclient <<<'

IF EXISTS (select * from sysobjects where name='JMGetJobCountForSubclient')
	drop procedure JMGetJobCountForSubclient
IF EXISTS (select * from GxQscripts where name='JMGetJobCountForSubclient')
	delete from GxQscripts where name = 'JMGetJobCountForSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobCountForSubclient')
	delete from GXDBVersions where aliasname = 'JMGetJobCountForSubclient'
GO
print '... Creating Procedure: JMGetJobCountForSubclient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetJobCountForSubclient
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inXMl XML
AS
BEGIN
  DECLARE @xmlText XML 
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @inSubclientId INT
DECLARE @commCellID	   INT
DECLARE @fromJobID			BIGINT
SET @inSubclientId = ISNULL (( SELECT ref.value('@subClientID', 'INTEGER')FROM @inXMl.nodes('JobManager_GetJobCountForSubClientReq') R(ref)), 0)
SET @commCellID	   = ISNULL (( SELECT ref.value('@commcellId', 'INTEGER')FROM @inXMl.nodes('JobManager_GetJobCountForSubClientReq') R(ref)), 0)
SET @fromJobID	   = ISNULL (( SELECT ref.value('@fromJobID', 'BIGINT')FROM @inXMl.nodes('JobManager_GetJobCountForSubClientReq') R(ref)), 0)
DECLARE @jobCount INTEGER = ISNULL((SELECT COUNT(*) FROM JMBkpStats WITH (NOLOCK)
	WHERE appId = @inSubclientId AND commCellId = @commCellID AND status IN (1,3,14,16) AND jobId > @fromJobID),0)
SET @xmlText = (SELECT @jobCount as '@jobCount'
	FOR XML PATH('JobManager_GetJobCountForSubClientResp'))
IF @xmlText IS NULL
	SET @xmlText = '<JobManager_GetJobCountForSubClientResp/>'
SELECT @xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetJobCountForSubclient')
	delete from GxQscripts where name = 'JMGetJobCountForSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobCountForSubclient')
	delete from GXDBVersions where aliasname = 'JMGetJobCountForSubclient'
GO

insert into GXDBVersions values(2, 'JMGetJobCountForSubclient',  '00010001000200020000', 'JMGetJobCountForSubclient', '00010001000200020000')
GO

