

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobCompletedDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
--	+===========================================================================================================+
--	|  									  JMGetJobCompletedDetails	    |
--	|	This sp including this SPBodies/JMJobSummaryPrologue.spb for jobFiltering option 		    |
--	|   			and necessary security checks.							    |
--  	|	Option#1 : It will send out the list of dates on which backup jobs completed with job counts 	    |
--	|	 		   & as well as option with whether any content indexed jobs or not.  		    |
--  	|													    |
--  	|   Option#2 : It will sends backup job information if any backup jobs completed within given time range.   |
--  	|													    |
--  	|   Option#3 : It will send the latest backup job information wrt to given time range                       |
--  	|              if any backup jobs not completed within given time range.		                    |
--	+===========================================================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMGetJobCompletedDetails')
BEGIN
	print '>>> Drop Stored Procedure: JMGetJobCompletedDetails <<<'
	drop procedure JMGetJobCompletedDetails
END
IF EXISTS (select * from GxQscripts where name='JMGetJobCompletedDetails')
	delete from GxQscripts where name = 'JMGetJobCompletedDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobCompletedDetails')
	delete from GXDBVersions where aliasname = 'JMGetJobCompletedDetails'
GO
print '... Creating Procedure: JMGetJobCompletedDetails'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMGetJobCompletedDetails
  @xml XML
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @i_userId INT = ISNULL((SELECT @xml.value('(//processinginstructioninfo/user/@userId)[1]', 'INT')), 0)
	DECLARE @i_xml XML = (SELECT T.c.query('.') FROM @xml.nodes ('//jobFilter') T(c) FOR XML PATH('JobManager_JobListRequest'))
	DECLARE @DEFAULT_JOB_COMPLETED_TIME INT = 300 -- By default 5 min i.e 5*60 sec
	DECLARE @TOTAL_SECONDS_IN_DAY INT = 86400 -- 24*60*60 sec
	DECLARE @i_databaseId INT = 0
	DECLARE @lookForLastBackup BIT = 0
	DECLARE @adminConsoleOffset INT = 0
	DECLARE @isGetDateListResponseSet BIT = 0
	DECLARE @timeZoneStdName VARCHAR(256)
DECLARE @defCCID INT = 2
	SELECT @isGetDateListResponseSet = ISNULL(ref.value('@getDateListResponse', 'BIT'),0),
		   @lookForLastBackup = ISNULL(ref.value('@lookForLastBackup', 'BIT'),0),
		   @i_databaseId = ISNULL(ref.value('@databaseId', 'INT'), 0),
		   @timeZoneStdName = ref.value('timeZone[1]/@TimeZoneName', 'VARCHAR(256)')
                              FROM  @xml.nodes('JobManager_GetJobCompletedDetailsReq') R ( ref )
-- TroubleShooting
DECLARE @dynamicSQLPrint INT = 0
SELECT
	@dynamicSQLPrint = 1		-- ROW EXISTS
FROM GXGlobalParam WITH(NOLOCK)
WHERE
	name = 'JMSummaryTroubleShooting'
	AND modified = 0
if OBJECT_ID('tempdb.dbo.#JobSummary') is not null drop table dbo.#JobSummary
	CREATE TABLE #JobSummary  (
		id int,
		userId INT,
		jobId int,
		commcellID int,
		jobType int,
		destClientId int,
		destClientName nvarchar(512),
		clientId int,
		clientName nvarchar(512),
		state int,
		status int,
		statusName varchar(max),
		currentPhaseName varchar(256),
		percentComplete int,
		pendingCause varchar(max),
		jobStartTime int,
		jobElapsedTime int,
		appTypeId int,
		appTypeName nvarchar(256),
		backupSetId int,
		backupsetName nvarchar(256) DEFAULT NULL,
		subclientId int,
		subclientName nvarchar(256) DEFAULT NULL,
		statusColor varchar(10) DEFAULT 'black',
		lastUpdateTime int,
		operationName varchar(256) DEFAULT null,
		sizeOfApplication bigint null,
		sizeOfMediaOnDisk bigint null,
		percentSavings float null,
		totalNumOfFiles bigint null,
		scanFileFailures int,
		scanFolderFailures int,
		backupFileFailures int,
		backupFolderFailures int,
		pendingReason			nvarchar(max),
		backupLevel				int,
		backupLevelName			varchar(256),
		jobSubmitErrorCode		int,
		aged					int,
		pendingReasonErrorCode	varchar(max),
		instanceId				int,
		instanceName			nvarchar(256),
		localizedOperationName	nvarchar(256),
		localizedStatus			nvarchar(256),
		localizedBackupLevel	nvarchar(256),
		isPreemptable int,
		jobEndTime int,
		Username nvarchar(510),
		errorType INTEGER,
		alertColorLevel INTEGER,
		vsaParentJobID BIGINT,
		isAnomalous INT,
		thresholdTime INT,
		bkpAttributes BIGINT DEFAULT NULL,
		clientDisplayName nvarchar(512) DEFAULT NULL,
		destDisplayClientName nvarchar(512) DEFAULT NULL,
		storagePolicyName nvarchar(288) DEFAULT NULL,
		storagePolicyId int DEFAULT 0,
		dataSourceName nvarchar(288) DEFAULT NULL,
		dataSourceId int DEFAULT 0,
		phasePercentagesList nvarchar(512),
		phaseTimingsList nvarchar(512),
		currentPhase int,
		attemptStartTime int,
		stubDataSize BIGINT DEFAULT NULL,
		currentPhaseType bigint,
		totalClients int DEFAULT 0,
		successfullClients int DEFAULT 0,
		skippedClients int DEFAULT 0,
		pendingClients int DEFAULT 0,
		failedClients int DEFAULT 0,
		partialSuccessClients int DEFAULT 0,
		totalInProgressClients int DEFAULT 0,
		distributedAppsClusterType int,
		bkpAttributesEx BIGINT DEFAULT NULL
	)
	-- Paging Parameters
	DECLARE @i_startRowNum INT = 0
	DECLARE @i_endRowNum INT = 0
	DECLARE @i_limit INT = 0
	DECLARE @sortField VARCHAR(MAX) = 'jobId'
	DECLARE @sortDirection INT = 1
	-- Other filters
	DECLARE @DELIMITER VARCHAR(1) = ' '
	DECLARE @JOB_REASON_DELIMITER VARCHAR(7) = '!#911#!'
	DECLARE @GRAPH_VAL_DELIMITER VARCHAR(7) = '!#100#!'
	DECLARE @graphJobFromTime INT = 0
	DECLARE @graphJobToTime INT = 0
	DECLARE @doNotSearch INT = 0
	DECLARE @i_eventMessageId INT = 0
	DECLARE @i_filterClientId INT = 0
	DECLARE @i_filterSubclientId INT = 0
	DECLARE @i_backupSetId INT = 0
	DECLARE @i_apptypeId INT = 0
	DECLARE @i_instanceID INT = 0
	DECLARE @i_mediaAgentId INT = 0
	DECLARE @i_mediaAgentname NVARCHAR(MAX)
	-- change to use BIT instead of INT so that when count(*) > 1, this boolean will be set to 1
	DECLARE @JobIdFilters BIT = 0
	DECLARE @JobTypeFilters BIT = 0
	DECLARE @JobStatusFilters BIT = 0
	DECLARE @clientIdFilters BIT = 0
	DECLARE @dataSourceIdFilters BIT = 0
	DECLARE @backupLevelFilters BIT = 0
	DECLARE @appTypeFilters BIT = 0
	DECLARE @isWorkFlowFilterSet BIT = 0
	DECLARE @showAgedJobs INT = 0
	DECLARE @tblSubclientId	TABLE (bkpSetId INT, appId INT)
	DECLARE @startTimeRangefromTime INT = 0
	DECLARE @startTimeRangetoTime INT = 0
	DECLARE @endTimeRangefromTime INT = 0
	DECLARE @endTimeRangetoTime INT = 0
	DECLARE @scheduleId INT = 0
	DECLARE @hideAdminJobs INT = 0
	DECLARE @schedulePolicyId INT = 0
	DECLARE @entity_clientName VARCHAR(MAX)
	DECLARE @entity_instanceName VARCHAR(MAX)
	DECLARE @entity_backupSetName VARCHAR(MAX)
	DECLARE @entity_subclientName VARCHAR(MAX)
	DECLARE @entity_clientGroupNameFilter VARCHAR(MAX)
	DECLARE @ISclientGroupIdListFilterSet INT = 0
	DECLARE @lastCompletedTime INT
	DECLARE @showAnomalous INT = 0
	DECLARE @username NVARCHAR(150)
	DECLARE @i_scope INT = 0
	DECLARE @i_localeId INT = 0
	DECLARE @i_category INT = 0
	DECLARE @commcellName NVARCHAR(512) = (SELECT aliasName FROM APP_CommCell WHERE id = 2)
	DECLARE @vsaV2ParentJobAttr BIGINT = (CAST(0x40000000 AS BIGINT) | CAST(0x100000000000000 AS BIGINT)) -- JMBKP_EX_PSEUDO_PARENT_JOB | JMBKP_EX_VSA_PARENT_SYNTHFULL
	DECLARE @i_dataSourceId INT = 0
	DECLARE @showOnlyLaptopJobs INT = 0
	DECLARE @showOnlyArchiveBackupsetJobs INT = 0
	DECLARE @i_isActiveJobView INT = 0
	DECLARE @i_viewLevel INT = 0
	-- Global settings
	DECLARE @showSyncRestores INT = ISNULL((SELECT CAST(value AS INT)
										FROM GXGlobalParam WITH (NOLOCK)
										WHERE name = 'JMShowSyncRestoreJobs'
										AND modified = 0), 0)
	DECLARE @isTelstraOEM INT =	ISNULL((SELECT 1
										FROM GXGlobalParam WITH (NOLOCK)
										WHERE name = 'MSP Id'
										AND modified = 0
										AND value = '1'), 0)
	DECLARE @showIndexRestores INT = ISNULL((SELECT CAST(value AS INT)
										FROM GXGlobalParam WITH (NOLOCK)
										WHERE name = 'JMShowIndexRestoreJobs'
										AND modified = 0), 0)
	DECLARE @showPseudoVMJobs INT = ISNULL((SELECT CAST(value AS INT)
										FROM GXGlobalParam WITH (NOLOCK)
										WHERE name = 'JMShowPseudoVMJobs'
										AND modified = 0), 0)
	DECLARE @showPersistentRecoveryJobs INT = ISNULL((SELECT CAST(value AS INT)
										FROM GXGlobalParam WITH (NOLOCK)
										WHERE name = 'showPersistentRecoveryJobs'
										AND modified = 0), 0)
	DECLARE @maxJobsToReturn INT = 1000000 -- 1 million max for now.
	-- Temp tables definitions
	if OBJECT_ID('tempdb.dbo.#JobIdFilter') is not null drop table dbo.#JobIdFilter
	create table #JobIdFilter(jobId integer);
	if OBJECT_ID('tempdb.dbo.#JobStatusFilter') is not null drop table dbo.#JobStatusFilter
	create table #JobStatusFilter(status varchar(max));
	if OBJECT_ID('tempdb.dbo.#JobTypeFilter') is not null drop table dbo.#JobTypeFilter
	create table #JobTypeFilter(jobType integer);
	if OBJECT_ID('tempdb.dbo.#JobStatusIdFilter') is not null drop table dbo.#JobStatusIdFilter
	create table #JobStatusIdFilter(status INT);
	if OBJECT_ID('tempdb.dbo.#JobStateIdFilter') is not null drop table dbo.#JobStateIdFilter
	create table #JobStateIdFilter(state INT);
	if OBJECT_ID('tempdb.dbo.#backupLevelFilter') is not null drop table dbo.#backupLevelFilter
	create table #backupLevelFilter(backupLevel integer);
	if OBJECT_ID('tempdb.dbo.#appTypeFilter') is not null drop table dbo.#appTypeFilter
	create table #appTypeFilter(appType integer);
	if OBJECT_ID('tempdb.dbo.#clientIdFilter') is not null drop table dbo.#clientIdFilter
	create table #clientIdFilter(clientId integer);
	IF OBJECT_ID('tempdb.dbo.#clientGroupListFilter') is not null drop table dbo.#clientGroupListFilter
	create table #clientGroupListFilter(groupId integer PRIMARY KEY);
	IF OBJECT_ID('tempdb.dbo.#dataSourceFilter') is not null drop table dbo.#dataSourceFilter
	create table #dataSourceFilter(dataSourceId integer PRIMARY KEY);
	IF OBJECT_ID(N'tempdb.dbo.#WorkflowIdFilter') IS NOT NULL DROP TABLE #WorkflowIdFilter
	CREATE TABLE #WorkflowIdFilter (workFlowId INTEGER PRIMARY KEY);
	IF OBJECT_ID('tempdb.dbo.#clientGroupXMLListb') is not null drop table dbo.#clientGroupXMLListb
	create table #clientGroupXMLListb
	(
		clientid integer,
		clientGroupList xml
		PRIMARY KEY(clientid)
	);
	IF OBJECT_ID(N'tempdb.dbo.#TempOperationNames') IS NOT NULL
		DROP TABLE #TempOperationNames
	IF OBJECT_ID(N'tempdb.dbo.#TempBkpLevelNames') IS NOT NULL
		DROP TABLE #TempBkpLevelNames
	IF OBJECT_ID(N'tempdb.dbo.#TempStatusNames') IS NOT NULL
		DROP TABLE #TempStatusNames
	IF OBJECT_ID(N'tempdb.dbo.#TempStateNames') IS NOT NULL
		DROP TABLE #TempStateNames
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Bkp') IS NOT NULL
		DROP TABLE #SecIDANodeAccessTemp_Bkp
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_VM') IS NOT NULL
		DROP TABLE #SecIDANodeAccessTemp_VM
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Rst') IS NOT NULL
		DROP TABLE #SecIDANodeAccessTemp_Rst
	IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_adminObject') IS NOT NULL
		DROP TABLE #JMCanManageJob_adminObject
	IF OBJECT_ID(N'tempdb.dbo.#sec_VMJobIDsList') IS NOT NULL
		DROP TABLE #sec_VMJobIDsList
	IF OBJECT_ID(N'tempdb.dbo.#JobIDsList') IS NOT NULL
		DROP TABLE #JobIDsList
	IF OBJECT_ID('tempdb.dbo.#JMCanManageJob_rstObject') IS NOT NULL
		DROP TABLE dbo.#JMCanManageJob_rstObject
	IF OBJECT_ID('tempdb.dbo.#JMCanManageJob_adminObject') IS NOT NULL
		DROP TABLE dbo.#JMCanManageJob_adminObject
	IF OBJECT_ID('tempdb.dbo.#EntityAssoc') IS NOT NULL
		DROP TABLE #EntityAssoc
	IF OBJECT_ID(N'tempdb.dbo.#AdminFinishedJobIDsList') IS NOT NULL
		DROP TABLE #AdminFinishedJobIDsList
	IF OBJECT_ID('tempdb.dbo.#getUsersInCompanyOutputTbl') IS NOT NULL
		DROP TABLE #getUsersInCompanyOutputTbl
	IF OBJECT_ID(N'tempdb.dbo.#VsaVmStats') IS NOT NULL
		DROP TABLE #VsaVmStats
	IF OBJECT_ID(N'tempdb.dbo.#VsaVmStatusCount') IS NOT NULL
		DROP TABLE #VsaVmStatusCount
	CREATE TABLE #JobIDsList	--Table to get list of jobs to build general view (any agent but not for VM jobs)
	(
		JobID INTEGER,
		commCellID INTEGER,
		PRIMARY KEY(JobID, commCellID)
	)
	CREATE TABLE #AdminFinishedJobIDsList
	(
		JobID INTEGER,
		commCellID INTEGER,
		servEndDate INTEGER,
		PRIMARY KEY(JobID, commCellID)
	)
	CREATE TABLE #sec_VMJobIDsList	--Table to get list of jobs to build VM level view and jobs that ran on VM parent
	(
		JobID INTEGER,
		commCellID INTEGER,
		PRIMARY KEY(JobID, commCellID)
	)
	CREATE TABLE #TempOperationNames
	(
		opType INTEGER,
		opName nvarchar(128)
		PRIMARY KEY(opType)
	)
	CREATE TABLE #TempBkpLevelNames
	(
		bkpLevel INTEGER,
		bkpLevelName nvarchar(128),
		PRIMARY KEY(bkpLevel)
	)
	CREATE TABLE #TempStatusNames
	(
		stateType INTEGER,
		stateName nvarchar(128),
		PRIMARY KEY(stateType)
	)
	CREATE TABLE #TempStateNames
	(
		stateType INTEGER,
		stateName nvarchar(128),
		PRIMARY KEY(stateType)
	)
	CREATE TABLE #SecIDANodeAccessTemp_Bkp
	(
		t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
	)
	CREATE NONCLUSTERED INDEX [#SecIDANodeAccessTemp_Bkp_ClientID] ON [#SecIDANodeAccessTemp_Bkp]([t_clientId] ASC)
	CREATE NONCLUSTERED INDEX [#SecIDANodeAccessTemp_Bkp_subclientId] ON [#SecIDANodeAccessTemp_Bkp]([t_subclientId] ASC)
	CREATE TABLE #SecIDANodeAccessTemp_VM
	(
		t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
	)
	CREATE NONCLUSTERED INDEX [#SecIDANodeAccessTemp_VM_ClientID] ON [#SecIDANodeAccessTemp_VM]([t_clientId] ASC)
create table  #JMCanManageJob_adminObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
create table  #JMCanManageJob_rstObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	CREATE TABLE #VsaVmStats
	(
		JobID INTEGER,
		commCellID INTEGER,
		totalClients INTEGER,
		successfullClients INTEGER,
		skippedClients INTEGER,
		pendingClients INTEGER,
		failedClients INTEGER,
		partialSuccessClients INTEGER,
		totalInProgressClients INTEGER,
		PRIMARY KEY(JobID, commCellID)
	)
	CREATE TABLE #VsaVmStatusCount
	(
		JobID INTEGER,
		commCellID INTEGER,
		status NVARCHAR(MAX) NOT NULL,
		statusCount INTEGER
	)
	-- Get the input parameters
	-- Global parameters
	SELECT
		@i_scope = ISNULL(ref.value('@scope', 'INT'), 1),
		@i_localeId = ISNULL(ref.value('@localeId', 'INT'), 0),
		@i_category = ISNULL(ref.value('@category', 'INT'), 0),
		@i_isActiveJobView  = ISNULL(ref.value('@isActiveJobView', 'INT'), 0)
	FROM
	@i_xml.nodes('/JobManager_JobListRequest') doc(ref)
	-- Read other input params like paging and sorting
	SELECT
		@i_startRowNum = ISNULL(ref.value('@offset', 'INT'), 0),
		@i_limit = ISNULL(ref.value('@limit', 'INT'), 0),
		@sortField = ISNULL(ref.value('@sortField', 'VARCHAR(64)'), 'jobId'),
		@sortDirection = ISNULL(ref.value('@sortDirection', 'INT'), 1)
	FROM
	@i_xml.nodes('JobManager_JobListRequest/pagingConfig') doc(ref)
	IF @i_limit <> 0
	BEGIN
		SET @i_startRowNum = @i_startRowNum + 1 -- This is done as GUI doesnt want to send 1 as the start :)
		SET @i_endRowNum = @i_startRowNum + @i_limit
	END
	-- To get around nested case statements for dynamic order by clause.
	IF @sortDirection = 1
		SET @sortField = @sortField + 'DESC'
	-- Now read all filters
	INSERT INTO #JobIdFilter
	SELECT ref.value('@val', 'INT')
	FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/jobId') R(ref)
	SELECT
		@i_eventMessageId = ISNULL(ref.value('@messageId', 'INT'), 0),
		@showAgedJobs = ISNULL(ref.value('@showAgedJobs', 'INT'), 1), -- Default is true
		@i_viewLevel = ISNULL(ref.value('@viewLevel', 'INT'), 0)
	FROM @i_xml.nodes('JobManager_JobListRequest/jobFilter') doc(ref)
	INSERT INTO #JobIdFilter
	SELECT DISTINCT jobId  FROM JMFailureReasonMsg
	WHERE messageId = @i_eventMessageId
	SET @JobIdFilters = (SELECT COUNT(*) FROM #JobIdFilter)
	-- If job Id filter is passed, no need to read any other filter
	IF @JobIdFilters = 0
	BEGIN
		INSERT INTO #JobStatusFilter
		SELECT ref.value('@val', 'varchar(256)')
		FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/statusList') R(ref)
		INSERT INTO #JobTypeFilter
		SELECT ref.value('@val', 'INT')
		FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/jobTypeList') R(ref)
		IF EXISTS(SELECT 1 FROM #JobTypeFilter WHERE jobType = 4/*BACKUP*/)
		BEGIN
			-- if calling from JMGetJobCompletedDetails, do not include backup copy
			INSERT INTO #JobTypeFilter VALUES(59), (98), (43), (101), (18), (65), (144), (145) /*SNAP BACKUP, TURBO ARCHIVE, SYSRECOVERYBACKUP, OPEN BACKUP, BACKUP3RD, SNAPBACKUP3RD, BACKUP_ADMIN, SNAP_BACKUP_ADMIN */
		END
		INSERT INTO #backupLevelFilter
		SELECT ref.value('@val', 'INT')
		FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/backupLevel') R(ref)
		INSERT INTO #clientIdFilter
		SELECT ref.value('@clientId', 'INT')
		FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/clientList') R(ref)
		WHERE ref.value('@clientId', 'INT') IS NOT NULL
		INSERT INTO #appTypeFilter
		SELECT ref.value('@applicationId', 'INT')
		FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/appType') R(ref)
		INSERT INTO #clientGroupListFilter
		SELECT ref.value('@clientGroupId', 'INT')
		FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/clientGroupIdList') R(ref)
		WHERE ref.value('@clientGroupId', 'INT') IS NOT NULL
		SET @ISclientGroupIdListFilterSet = @@ROWCOUNT
		SET @i_filterClientId = ISNULL (( SELECT ref.value('@clientId', 'INT')
						FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/client') R(ref)), 0)
		SELECT
			@i_filterSubclientId = ISNULL(ref.value('@subclientId', 'INT'), 0),
			@i_backupSetId = ISNULL(ref.value('@backupsetId', 'INT'), 0),
			@i_apptypeId = ISNULL(ref.value('@applicationId', 'INT'), 0),
			@i_instanceID = ISNULL(ref.value('@instanceId', 'INT'), 0),
			@i_filterClientId = ISNULL(ref.value('@clientId', 'INT'), @i_filterClientId), --We have new generic variable called entity. This variable overrides existing client variable.
			@i_dataSourceId = ISNULL(ref.value('@dataSourceId', 'INT'), 0),
			@i_mediaAgentId = ISNULL(ref.value('@mediaAgentId', 'INT'), 0)
		FROM
		@i_xml.nodes('JobManager_JobListRequest/jobFilter/entity') doc(ref)
		IF @i_category <> 1	--ACTIVE. Media agent filter is available only for running jobs.
			SET @i_mediaAgentId = 0
		IF @i_mediaAgentId > 0
			SELECT @i_mediaAgentname = name FROM APP_Client WHERE id = @i_mediaAgentId
		IF @i_filterClientId > 0
		BEGIN
			INSERT INTO #clientIdFilter
			SELECT @i_filterClientId
		END
		IF @i_dataSourceId > 0
		BEGIN
			INSERT INTO #dataSourceFilter
			SELECT @i_dataSourceId
			-- datasourceid only apply to following optypes
			/* offline content indexing, data analytics 2, subclient content indexing, online crawl, solr index import, multi node content indexing  */
			INSERT INTO #JobTypeFilter VALUES(53), (112), (113), (130), (143), (124)
		END
		INSERT INTO #WorkflowIdFilter
		SELECT ref.value('@workflowId', 'INT')
		FROM  @i_xml.nodes ('JobManager_JobListRequest/jobFilter/workFlowList') R(ref)
		WHERE ref.value('@workflowId', 'INT') IS NOT NULL
		IF @@ROWCOUNT > 0
			SET @isWorkFlowFilterSet = 1
		SELECT
			@startTimeRangefromTime = ISNULL(ref.value('@fromTime', 'INT'), 0),
			@startTimeRangetoTime = ISNULL(ref.value('@toTime', 'INT'), 0)
		FROM
		@i_xml.nodes('JobManager_JobListRequest/jobFilter/startTimeRange') doc(ref)
		SELECT
			@endTimeRangefromTime = ISNULL(ref.value('@fromTime', 'INT'), 0),
			@endTimeRangetoTime = ISNULL(ref.value('@toTime', 'INT'), 0)
		FROM
		@i_xml.nodes('JobManager_JobListRequest/jobFilter/endTimeRange') doc(ref)
		SELECT
			@entity_clientName = ISNULL(ref.value('@clientName', 'NVARCHAR(256)'), ''),
			@entity_instanceName = ISNULL(ref.value('@instanceName', 'NVARCHAR(256)'), ''),
			@entity_backupSetName = ISNULL(ref.value('@backupSetName', 'NVARCHAR(256)'), ''),
			@entity_subclientName = ISNULL(ref.value('@subclientName', 'NVARCHAR(256)'), ''),
			@entity_clientGroupNameFilter = ISNULL(ref.value('@clientGroupName', 'NVARCHAR(256)'), '')
		FROM
		@i_xml.nodes('JobManager_JobListRequest/jobFilter/entityNamePattern') doc(ref)
		-- Other filters
		SELECT
			@lastCompletedTime = ISNULL(ref.value('@completedJobLookupTime', 'INT'), @DEFAULT_JOB_COMPLETED_TIME),
			@scheduleId = ISNULL (ref.value('@scheduleId', 'INT'), 0),
			@hideAdminJobs = ISNULL (ref.value('@hideAdminJobs', 'INT'), 0),
			@schedulePolicyId = ISNULL (ref.value('@schedulePolicyId', 'INT'), 0),
			@showAnomalous = ISNULL (ref.value('@showAnomalous', 'INT'), 0),
			@i_eventMessageId = ISNULL (ref.value('@messageId', 'INT'), 0),
			@showOnlyLaptopJobs = ISNULL (ref.value('@showOnlyLaptopJobs', 'INT'), 0),
			@showOnlyArchiveBackupsetJobs = ISNULL (ref.value('@showOnlyArchiveBackupsetJobs', 'INT'), 0)
		FROM
		@i_xml.nodes('JobManager_JobListRequest/jobFilter') doc(ref)
		-- Time adjustment
		IF @doNotSearch = 0 AND @endTimeRangefromTime = 0 AND @endTimeRangetoTime = 0
		BEGIN
			SET @endTimeRangetoTime = dbo.GetUnixTime(GETUTCDATE())
			SET @endTimeRangefromTime = @endTimeRangetoTime - @lastCompletedTime
		END
		-- Boolean type values to indicate if filters are present
		SET @clientIdFilters = (SELECT COUNT(*) FROM #clientIdFilter)
		SET @JobTypeFilters = (SELECT COUNT(*) FROM #JobTypeFilter)
		SET @JobStatusFilters = (SELECT COUNT(*) FROM #JobStatusFilter)
		SET @backupLevelFilters = (SELECT COUNT(*) FROM #backupLevelFilter)
		SET @appTypeFilters = (SELECT COUNT(*) FROM #appTypeFilter)
		SET @dataSourceIdFilters = (SELECT COUNT(*) FROM #dataSourceFilter)
	END
	ELSE
	BEGIN
		SET @showSyncRestores = 1 -- If queried by jobID, include sync restores also
	END
	-- Special case - @TODO - Remove such handling
	DECLARE @isUserAdmin INT = 0
	DECLARE @hasVMProvisioningFilter INT = 0
	EXECUTE sec_isUserAdmin   @i_userId , @isUserAdmin  OUTPUT
	--FOR VM PROVISIONING JOBS, REMOVE JOBS NOT BELONGING TO USER
	IF ((@i_userId <> 0) AND EXISTS(SELECT * FROM #JobTypeFilter WHERE jobType=85))
	BEGIN
		SET @hasVMProvisioningFilter = 1
	END
	-- Populate static helper tables
	insert into JMJobOperationNames select distinct operation, OpName, 0 from JMOpTable where operation not in (select optype from JMJobOperationNames)
	INSERT INTO #TempOperationNames
	SELECT opType,CASE WHEN messageId > 0 THEN dbo.fn_EvFormatEventMsgText(0, @i_localeId,messageId, 0, 2) ELSE opName END FROM JMJobOperationNames
	UPDATE #TempOperationNames
SET opName = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (2309 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
	WHERE @isTelstraOEM = 1 AND opType = 4
	UPDATE #TempOperationNames
SET opName = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1615 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
	WHERE opType = 29
	CREATE INDEX IXT ON #TempOperationNames(opType)
	INSERT INTO #TempBkpLevelNames
	SELECT bkpLevel,dbo.fn_EvFormatEventMsgText(0, @i_localeId,messageId, 0, 2) FROM JMBackupLevelNames
DECLARE @transLogLevelName nvarchar(max) = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (774 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
DECLARE @logOnlyLevelName nvarchar(1024) = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1707 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0, 2)
	INSERT INTO #TempStatusNames
	SELECT stateType,dbo.fn_EvFormatEventMsgText(0, @i_localeId,messageId, 0, 2) FROM JMJobStatusNames
	INSERT INTO #TempStateNames
	SELECT stateType,dbo.fn_EvFormatEventMsgText(0, @i_localeId,messageId, 0, 2) FROM JMJobStateNames
	SET @username= ISNULL((SELECT TOP 1 [login] FROM UMUsers WHERE id = @i_userId),'')
	-- Filter the entity table based on above filters
	CREATE TABLE #EntityAssoc
	(	ClientID int
		,ClientName nvarchar(255)
		,displayName nvarchar(512)
		,ApptypeID int
		,ApptypeName nvarchar(255)
		,InstanceID int
		,InstanceName nvarchar(512)
		,Backupsetid int
		,BackupSetName nvarchar(128)
		,SubClientID int
		,SubclientName nvarchar(128) ,
		visibility INT
		PRIMARY KEY CLUSTERED (SubclientID))
	-- Optimize security check if jobId filters are used.
	-- Below query is optmized for job history page but not if called repeatedly based on jobids.
	IF @JobIdFilters = 1
	BEGIN
		-- This table is only needed for completed backup jobs to fetch entity names.
		-- In other cases it is also used to do security check and entity filtering but if explicit jobid is passed, this is skipped as an optimization
		-- as populating this table is costly for each job.
		INSERT #EntityAssoc(ClientID, ClientName, displayName, ApptypeID, ApptypeName, InstanceID, InstanceName, backupsetid, BackupSetName, SubClientID, SubclientName, visibility )
		SELECT DISTINCT C.id, C.name, C.displayName, IDA.type, IDA.displayName, INS.id, INS.name, BS.id, BS.name, APP.id, APP.subclientName, 1
		FROM #JobIdFilter JF
			JOIN JMBkpStats JM ON JM.jobId = JF.jobId
			JOIN App_Application APP ON APP.id = JM.appId
			JOIN App_Client C ON C.id = APP.clientId
			JOIN APP_iDAType IDA ON  IDA.type = APP.appTypeId
			JOIN APP_InstanceName INS ON INS.id = APP.instance
			JOIN APP_BackupSetName  BS ON  BS.id  = APP.backupset
	END
	ELSE
	BEGIN
		DECLARE @adminCap INTEGER
		SET @adminCap = POWER(2,1-1) | POWER(2,16-1) | POWER(2,4-1) | POWER(2,8-1) | POWER(2,31-1)
		--POWER(2,EV_SCHEDULE_ADMIN-1) | POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_MANAGE_ARCHIVES-1) | POWER(2,EV_MANAGE_LIBRARY-1) | POWER(2,EV_VISIBILITY-1)
		DECLARE @restoreCap INTEGER
		-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_VISIBILITY-1)
		SET @restoreCap = POWER(2,16-1) | POWER(2,20-1) | POWER(2,22-1) | POWER(2,31-1)
		-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_BACKUP-1)| POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_BROWSE-1)| POWER(2,EV_RUN_REPORTS-1) | POWER(2,EV_VISIBILITY-1)
		exec sec_getIdaObjectsForUser @i_userId,7,0,0,'#SecIDANodeAccessTemp_Bkp',0,'16,12,20,22,13,15,31',0
		-- This is causing VSA jobs to be shown in global views with only apptype filter.
		-- Skip the logic of bubbling up VM rights, if we are not even going to show VSA jobs.
		-- This will fix the bug and help with performance by eliminating this special logic.
		IF (
				@i_viewLevel <> 1  /*LevelView.VMGROUP*/
				AND
				(
					@i_apptypeId = 0 -- No filters
						OR
					@i_apptypeId = 106 -- VSA apptype filter
				)
				AND
				(
					@appTypeFilters = 0 -- No filter list passed
						OR
					EXISTS (SELECT 1 FROM #appTypeFilter WHERE appType = 106) -- VSA filter passed in list
				)
			)
		BEGIN
			-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_BACKUP-1)| POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_BROWSE-1)| POWER(2,EV_RUN_REPORTS-1) | POWER(2,EV_VISIBILITY-1)
			exec sec_getIdaObjectsForUser @i_userId,3,0,0,'#SecIDANodeAccessTemp_VM',0,'16,12,20,22,13,15,31',0
			-- Delete the clients which are either not a VM or not V1
			DELETE SEC
			FROM #SecIDANodeAccessTemp_VM SEC
			LEFT JOIN App_ClientProp CP ON SEC.t_clientId = CP.componentNameId AND CP.attrName = 'Virtual Server Discovered Clients' AND CP.attrVal = '1' AND CP.modified = 0
			--LEFT JOIN App_ClientProp CP2 ON SEC.t_clientId = CP2.componentNameId AND CP2.attrName = 'IndexingV2_VSA' AND CP2.attrVal = '1' AND CP2.modified = 0
			LEFT JOIN APP_IDAName IDA ON IDA.clientId = SEC.t_clientId
			LEFT JOIN APP_IDAProp IPROP ON IPROP.componentNameId = IDA.id AND IPROP.attrName = 'Pseudo Apptype' AND IPROP.modified = 0 AND IPROP.attrVal = '1'
			WHERE CP.id IS NULL -- Not a VM
				  --OR CP2.id IS NOT NULL -- V2 enabled -- Also include V2 clients as they could have V1 jobs run at some point.
				  OR
				  (
						IPROP.id IS NOT NULL -- Is a Pseudo client - It means it is a discovered client that got converted to a VM. So don't count as a VM
						AND
						@i_viewLevel = 0 /*LevelView.NONE*/
				  )
		END
		exec sec_getUserObjects @i_userId,2013,0,'#JMCanManageJob_adminObject'
		exec sec_getUserObjects @i_userId,14033,0,'#JMCanManageJob_adminObject'
		exec sec_getUserObjects @i_userId,2231,0,'#JMCanManageJob_adminObject'
		exec sec_getUserObjects @i_userId,2012,0,'#JMCanManageJob_rstObject'
		DELETE FROM #JMCanManageJob_adminObject
			WHERE  (Capabilities & @adminCap) = 0
		DELETE FROM #JMCanManageJob_rstObject
			WHERE  (Capabilities & @restoreCap) = 0
		-- Convert names to IDs
		IF @JobStatusFilters <> 0
		BEGIN
			INSERT INTO #JobStateIdFilter
			SELECT S.stateType
			FROM JMJobStateNames S
			INNER JOIN #JobStatusFilter F
			ON S.stateName = F.status
			INSERT INTO #JobStatusIdFilter
			SELECT S.stateType
			FROM JMJobStatusNames S
			INNER JOIN #JobStatusFilter F
			ON S.stateName = F.status
		END
		IF @showOnlyLaptopJobs = 1
		BEGIN
			IF @clientIdFilters = 0
			BEGIN
				INSERT INTO #clientIdFilter
				SELECT CL.id FROM App_Client CL WITH (NOLOCK)
WHERE CL.status & CONVERT(INT,0x1000) <> 0
				SET @clientIdFilters = 1 -- Intentionally setting 1, If no entry in table, then return no result.
			END
			ELSE
			BEGIN
				DELETE CF FROM #clientIdFilter CF
				INNER JOIN APP_Client CL ON CF.clientId = CL.id
WHERE CL.status & CONVERT(INT,0x1000) = 0
			END
		END
		IF @showOnlyArchiveBackupsetJobs = 1 AND @clientIdFilters <> 0
    		BEGIN
			INSERT INTO @tblSubclientId
				SELECT DISTINCT APP.backupset, APP.id FROM APP_Application APP WITH(NOLOCK)
					INNER JOIN #clientIdFilter CIF ON CIF.clientId = APP.ClientID
					LEFT JOIN APP_BackupsetProp ABP WITH(NOLOCK) 				-- Get archive subclient.
						ON APP.backupset = ABP.componentNameId
						AND ABP.attrName = 'Is Archiving Enabled'
						AND ABP.attrVal = '1'
						AND ABP.modified = 0
					LEFT JOIN APP_SubclientProp SP WITH (NOLOCK)							-- Get one-pass subclient.
						ON APP.id = SP.componentNameId
						AND SP.attrName = N'Turbo Mode Enable Stubbing'
   					AND SP.cs_attrName = CHECKSUM(N'Turbo Mode Enable Stubbing')
						AND SP.attrVal = '1'
						AND SP.modified = 0
					WHERE ((@appTypeFilters = 0 OR (APP.appTypeId IN (SELECT appType FROM #appTypeFilter)))
							AND (ABP.componentNameId IS NOT NULL OR SP.componentNameId IS NOT NULL))
			UNION
				SELECT DISTINCT APP.backupset, APP.id FROM APP_Application APP WITH(NOLOCK)
					INNER JOIN #clientIdFilter CIF ON CIF.clientId = APP.ClientID
					INNER JOIN APP_SubclientProp SCP_ASP WITH (NOLOCK)				-- Get subclient which associated with subclient policy having archiving rules enabled.
						ON APP.id = SCP_ASP.componentNameId
						AND SCP_ASP.attrName = N'Associated subclient Policy'
   					AND SCP_ASP.cs_attrName = CHECKSUM(N'Associated subclient Policy')
						AND SCP_ASP.attrVal <> '0'
						AND SCP_ASP.modified = 0
					INNER JOIN APP_SubclientProp SP WITH (NOLOCK)
              			ON CAST(SCP_ASP.attrVal AS INT) = SP.componentNameId
              			AND SP.attrName = N'Turbo Mode Enable Stubbing'
              			AND SP.attrVal = '1'
              			AND SP.modified = 0
					LEFT JOIN APP_SubclientProp SCP_PLAN WITH (NOLOCK)
						ON APP.id = SCP_PLAN.componentNameId
						AND SCP_PLAN.attrName = N'Associated Plan'
						AND SCP_PLAN.cs_attrName = CHECKSUM(N'Associated Plan')
						AND SCP_PLAN.attrVal <> '0'
						AND SCP_PLAN.modified = 0
					WHERE ((@appTypeFilters = 0 OR (APP.appTypeId IN (SELECT appType FROM #appTypeFilter)))
							AND SCP_PLAN.componentNameId IS NULL)
    		END
		ELSE IF @i_scope = 1 AND @clientIdFilters <> 0
		BEGIN
			INSERT INTO @tblSubclientId
			SELECT A.backupSet, A.id
			FROM APP_Application A WITH (NOLOCK)
			WHERE A.clientId IN (select clientId from #clientIdFilter)
		END
		ELSE IF @ISclientGroupIdListFilterSet != 0
		BEGIN
			SET @clientIdFilters = @ISclientGroupIdListFilterSet
			INSERT INTO @tblSubclientId
			SELECT A.backupSet, A.id
			FROM APP_Application A WITH (NOLOCK)
			INNER JOIN
			APP_ClientGroupAssoc B WITH (NOLOCK)
			ON A.clientId = B.clientId
			WHERE B.clientgroupid IN (SELECT groupId FROM #clientGroupListFilter)
			INSERT INTO #clientIdFilter
			SELECT DISTINCT clientId
			FROM APP_ClientGroupAssoc
			WHERE clientgroupid IN (SELECT groupId FROM #clientGroupListFilter)
		END
		ELSE IF @entity_clientGroupNameFilter != ''
		BEGIN
			INSERT INTO #clientIdFilter
			SELECT distinct A.clientId
			FROM APP_ClientGroupAssoc A WITH(NOLOCK)
			INNER JOIN
			APP_ClientGroup B WITH(NOLOCK) ON A.clientgroupid = B.id
			WHERE(B.name LIKE '%' + @entity_clientGroupNameFilter + '%')
			SET @clientIdFilters = (SELECT COUNT(*) FROM #clientIdFilter)
			INSERT INTO @tblSubclientId
			SELECT A.backupSet, A.id
			FROM APP_Application A WITH (NOLOCK)
			WHERE A.clientId IN (select clientId from #clientIdFilter)
		END
		IF @clientIdFilters <> 0
		BEGIN
			-- Remove all VMs that are not part of filter.
			DELETE SEC
			FROM #SecIDANodeAccessTemp_VM SEC
			LEFT OUTER JOIN #clientIdFilter CF
								ON CF.clientId =  SEC.t_clientId
			WHERE CF.clientId IS NULL
		END
		-- Now populate the required VM jobs
		-- For VSA, even if user has rights on VM, we should show the VSA job. Only for V1
		IF EXISTS (SELECT 1 FROM #SecIDANodeAccessTemp_VM)
		BEGIN
			IF @i_category IN (0, 2) -- ALL, FINISHED
			BEGIN
				INSERT INTO #sec_VMJobIDsList
				SELECT DISTINCT Q.jobId, Q.commCellId
				FROM JMQinetixUpdateStatus Q
				INNER JOIN JMBkpStats JM ON Q.jobId = JM.jobId AND Q.commcellId = JM.commcellId
				INNER JOIN App_Application APP ON APP.id = JM.appID
				INNER JOIN #SecIDANodeAccessTemp_VM SEC ON Q.clientId = SEC.t_clientId
				WHERE (@clientIdFilters = 0 OR JM.bkpAttributesEx & @vsaV2ParentJobAttr = 0) -- Exclude V2 parents in VM level job history(client filters)
				AND (@i_backupSetId = 0 OR APP.backupset = @i_backupSetId)
				AND (@i_filterSubclientId = 0 OR APP.id = @i_filterSubclientId)
				-- For calendar, look at jobs based on start time and no need to lookup runningjobs or restore jobs
				AND	(
                        (@startTimeRangefromTime = 0 AND @startTimeRangetoTime = 0)
                                			OR
                        (servStartDate BETWEEN @startTimeRangefromTime AND @startTimeRangetoTime)
                    )
			END
		END
		-- Removed OR Clauses by using Dymanic SQL to improve performance by converting SCAN to SEEK Ops
		DECLARE @whereClause2 NVARCHAR(MAX) = ''
		DECLARE @wcAND NVARCHAR(10) = '	AND '
		IF (@clientIdFilters > 0)
		BEGIN
			SET @whereClause2 = '
				c.id in (select clientId from #clientIdFilter)
			'
		END
		IF (@i_apptypeId > 0)
		BEGIN
			IF (@whereClause2 <> '')
			BEGIN
				SET @whereClause2 += @wcAND
			END
			SET @whereClause2 += CAST(@i_apptypeId AS NVARCHAR(12)) + ' = t_appTypeId
			'
		END
		IF (@i_instanceID > 0)
		BEGIN
			IF (@whereClause2 <> '')
			BEGIN
				SET @whereClause2 += @wcAND
			END
			SET @whereClause2 += CAST(@i_instanceID AS NVARCHAR(12)) + ' = t_instanceId
			'
		END
		IF (@i_backupSetId > 0)
		BEGIN
			IF (@whereClause2 <> '')
			BEGIN
				SET @whereClause2 += @wcAND
			END
			SET @whereClause2 += CAST(@i_backupSetId AS NVARCHAR(12)) + ' = t_backupsetId
			'
		END
		IF (@i_filterSubclientId > 0)
		BEGIN
			IF (@whereClause2 <> '')
			BEGIN
				SET @whereClause2 += @wcAND
			END
			SET @whereClause2 += CAST(@i_filterSubclientId AS NVARCHAR(12)) + ' = t_subclientId
			'
		END
		IF (@whereClause2 = '')
		BEGIN
			SET @whereClause2 = ' 1 = 1 '
		END
		DECLARE @sqlCmd NVARCHAR(MAX) = '
			INSERT #EntityAssoc(ClientID,ClientName,displayName,ApptypeID ,ApptypeName ,InstanceID ,InstanceName ,backupsetid ,BackupSetName ,SubClientID ,SubclientName,visibility )
			SELECT DISTINCT
				C.id,C.name, C.displayName, sec.t_appTypeId ,ida.name ,sec.t_instanceId ,inst.name ,sec.t_backupsetId ,bs.name ,sec.t_subclientId ,app.subclientName, 1
			FROM #SecIDANodeAccessTemp_Bkp Sec
				JOIN App_Client C on c.id=sec.t_clientId
				JOIN APP_iDAType IDA on  ida.type =sec.t_appTypeId
				JOIN APP_InstanceName Inst on Inst.id =sec.t_instanceId
				JOIN APP_BackupSetName  BS on  bs.id  =sec.t_backupsetId
				JOIN app_application   app on  app.id  =sec.t_subclientId
			WHERE
		' + @whereClause2
		IF (@dynamicSQLPrint = 1)
		BEGIN
			PRINT 'JMJobSummaryPrologue: sqlCmd [
			' + @sqlCmd + '
			]'
		END
		EXEC(@sqlCmd)
		IF @appTypeFilters <> 0
			DELETE FROM #EntityAssoc WHERE  appTypeId NOT IN (SELECT appType FROM #appTypeFilter)
		IF @i_scope = 1 AND  @clientIdFilters = 1
			DELETE FROM #EntityAssoc  WHERE SubClientID NOT IN (SELECT appId FROM @tblSubclientId)
		IF EXISTS(SELECT 1 FROM #sec_VMJobIDsList)
		BEGIN
			-- Insert VSA clients for corresponding VM level clients also for jobs to show up
			-- All filtering is already applied on the table #sec_VMJobIDsList so we dont really need a where clause or join with VM entity table #SecIDANodeAccessTemp_VM.
			SET @sqlCmd = '
				INSERT #EntityAssoc(ClientID,ClientName, displayName, ApptypeID ,ApptypeName ,InstanceID ,InstanceName ,backupsetid ,BackupSetName ,SubClientID ,SubclientName,visibility )
				SELECT DISTINCT
					APP.clientId, C.name, C.displayName, APP.appTypeId, IDA.name ,APP.instance, Inst.name, APP.backupSet, BS.name, APP.id,APP.subclientName, 0
				FROM #sec_VMJobIDsList VM
					JOIN JMBkpStats JBS ON JBS.jobId = VM.jobId AND JBS.commcellId = VM.commcellId
					JOIN APP_Application APP ON APP.id = JBS.appId
					JOIN App_Client C on c.id=APP.clientId
					JOIN APP_iDAType IDA on  ida.type =APP.appTypeId
					JOIN APP_InstanceName Inst on Inst.id = APP.instance
					JOIN APP_BackupSetName  BS on  bs.id  = APP.backupSet
					LEFT JOIN #EntityAssoc Ea on Ea.SubClientID =app.id
				WHERE
					EA.SubClientID IS NULL
			'
			IF (@dynamicSQLPrint = 1)
			BEGIN
				PRINT 'JMJobSummaryPrologue: sqlCmd [
				' + @sqlCmd + '
				]'
			END
			EXEC(@sqlCmd)
		END
		IF @entity_clientName != ''
		BEGIN
			DELETE #EntityAssoc
			WHERE (clientName NOT LIKE '%' + @entity_clientName + '%')
		END
		IF @entity_instanceName != ''
		BEGIN
			DELETE #EntityAssoc
			WHERE (instanceName NOT LIKE '%' + @entity_instanceName + '%')
		END
		IF @entity_backupSetName != ''
		BEGIN
			DELETE #EntityAssoc
			WHERE (backupsetName NOT LIKE '%' + @entity_backupSetName + '%')
		END
		IF @entity_subclientName != ''
		BEGIN
			DELETE #EntityAssoc
			WHERE (subclientName NOT LIKE '%' + @entity_subclientName + '%')
		END
	END
	--Tenant admin should be able to view jobs submitted by other users in the company.
	CREATE TABLE #getUsersInCompanyOutputTbl (
		userId INTEGER,
		PRIMARY KEY(userId)
	)
	--Populates #getUsersInCompanyOutputTbl
	EXEC sec_getUsersInCompany @i_userId
	DECLARE @DDBAndIndexBackSubclientsInfo TABLE(
			subclientId int
	)
	--Remove DDB Backup subclient, Index Backup subclient
	INSERT INTO @DDBAndIndexBackSubclientsInfo
	SELECT componentNameId
        FROM APP_SubClientProp (NOLOCK) P
	INNER JOIN #EntityAssoc EA ON EA.SubClientID = P.componentNameId
        WHERE (attrName = 'DDB Backup' AND attrVal = '1' AND modified = 0)
        UNION
        SELECT componentNameId
        FROM APP_SubClientProp (NOLOCK) P
        INNER JOIN #EntityAssoc EA ON EA.SubClientID = P.componentNameId
        WHERE (attrName = 'Index SubClient' AND attrVal = '1' AND modified = 0)
	--Live update jobs backup metadata and needs to be excluded in calendar view.
	DECLARE @shouldExcludeLiveUpdateJobs BIT = 0
	IF EXISTS (SELECT 1 FROM #JobTypeFilter WHERE jobType = 4)
		IF NOT EXISTS (SELECT 1 FROM APP_AdvanceSettings (NOLOCK) WHERE keyName = 'IncludeLiveUpdateJobsInCalendarView' AND value = 'true' AND enabled = 1 AND deleted = 0)
			SET @shouldExcludeLiveUpdateJobs = 1
	IF @i_databaseId = 0
	BEGIN
		INSERT INTO  #JobIDsList
                SELECT DISTINCT JM.jobId, JM.commCellId
                FROM JMBkpStats JM
                INNER JOIN JMJobStats JStats ON JM.jobId = JStats.jobId And JM.CommcellId = JStats.CommcellId
                INNER JOIN #EntityAssoc EA ON EA.SubClientID =JM.appId
                LEFT OUTER JOIN #sec_VMJobIDsList SJ ON SJ.jobId = JM.jobId AND SJ.commcellId = JM.commcellId
                WHERE (@JobIdFilters > 0 OR (
                                (@startTimeRangefromTime = 0 AND @startTimeRangetoTime = 0)
                                				 OR
                                (servStartDate BETWEEN @startTimeRangefromTime AND @startTimeRangetoTime)
                            	)
                        )
                        AND (
                                (@JobIdFilters = 0 AND @JobTypeFilters =0 AND @JobStatusFilters = 0) --No filters
                                                                    OR
                                (@JobIdFilters > 0 AND JM.jobID IN(SELECT jobId FROM #JobIdFilter)) --JobId filters
                                                                	OR
                                (
                                	@JobIdFilters = 0 AND
                                	(@JobTypeFilters = 0 OR JM.optype IN(SELECT jobType FROM #JobTypeFilter))
                                                                        AND
                                	(@JobStatusFilters = 0 OR JM.status IN(SELECT status FROM #JobStatusIdFilter))
                                )
                            )
                        AND (
								(JM.appType <> 106 AND username = @username) -- For VM level, V2 parent jobs end up showing for users as they have started it. So exclude VSA.
                                        OR
                              	EA.visibility = 1
                              			OR
                                SJ.jobId IS NOT NULL -- VM level security
                            )
                   		AND (@showAgedJobs = 1 OR (JM.dataStatus NOT IN (1, 2)) OR (JM.dataStatus IN (1, 2) AND JM.status IN (2, 4)))
			AND (EA.SubClientID = 0 OR EA.SubClientID NOT IN (SELECT subclientId FROM @DDBAndIndexBackSubclientsInfo))  -- To filter out DDBBackup and Index Backup jobs from response
			AND (@shouldExcludeLiveUpdateJobs = 0 OR JStats.subOpType <> 148 /*LIVE_UPDATE*/)
		-- Creating NONCLUSTERED INDEX on #JobSummary table column jobEndTime
		CREATE NONCLUSTERED INDEX [#JobSummary_jobEndTime] ON [#JobSummary]([jobEndTime] DESC)
		INSERT INTO #JobSummary (jobId,
					commcellId,
					clientId,
					clientName,
					jobStartTime,
					appTypeId,
					appTypeName,
					backupSetId,
					backupsetName,
					subclientId,
					subclientName,
					backupLevel,
					backupLevelName,
					instanceId,
					instanceName,
					jobEndTime,
					bkpAttributes,
					bkpAttributesEx)
		SELECT
			jobId = JM.jobID,
			commcellId = JM.commcellID,
			clientId =    COALESCE(TargetClient.id, EA.clientId),
			clientName = COALESCE(TargetClient.name, EA.ClientName),
			jobStartTime = servStartDate,
			appTypeId = EA.ApptypeID,
			appTypeName = EA.ApptypeName,
			backupSetId = EA.Backupsetid,
			backupSetName = EA.BackupsetName,
			subclientId = EA.SubclientID,
			subclientName = EA.SubclientName,
			backupLevel = JM.bkpLevel,
			backupLevelName =  (
					CASE WHEN JM.bkpLevel = 2 AND appTypeId IN (5, 81, 126) AND JStats.opType <> 98
						THEN @transLogLevelName
					WHEN JM.bkpLevel = 2 AND appTypeId IN (125) AND NOT (JStats.opType IN (59, 60) AND JM.bkpAttributesEx & 16 = 16) --JMBKP_EX_BLOCK_LEVEL_SNAP = 0x10
						THEN @logOnlyLevelName
					ELSE (SELECT bkpLevelName FROM JMBackupLevelNames BK WHERE BK.bkpLevel = JM.bkpLevel)
					END),
			instanceId = EA.InstanceId,
			instanceName = EA.InstanceName,
			jobEndTime = servEndDate,
			bkpAttributes,
			bkpAttributesEx
		FROM JMBkpStats JM
		INNER JOIN JMJobStats JStats ON JM.jobId = JStats.jobId And JM.CommcellId = JStats.CommcellId
		INNER JOIN #JobIDsList JLIST ON JM.jobId = JLIST.jobId And JM.CommcellId = JLIST.CommcellId
LEFT OUTER JOIN APP_Client TargetClient ON TargetClient.id = JM.targetClientId AND  JM.bkpattributes & 0x100000000 = 0x100000000
		INNER JOIN #EntityAssoc EA ON EA.SubClientID = JM.appId
	END
	IF @i_databaseId <> 0
	BEGIN
		INSERT INTO #JobSummary (jobId,
					commcellId,
					clientId,
					clientName,
					jobStartTime,
					appTypeId,
					appTypeName,
					backupSetId,
					backupsetName,
					subclientId,
					subclientName,
					backupLevel,
					backupLevelName,
					instanceId,
					instanceName,
					jobEndTime,
					bkpAttributes,
					bkpAttributesEx)
		SELECT
			jobId = sqlDB.jobId,
			commcellId = JM.commcellID,
			clientId =  EA.clientId,
			clientName = EA.ClientName,
			jobStartTime = sqlDB.backup_start_Date,
			appTypeId = EA.ApptypeID,
			appTypeName = EA.ApptypeName,
			backupSetId = EA.Backupsetid,
			backupSetName = EA.BackupsetName,
			subclientId = EA.SubclientID,
			subclientName = EA.SubclientName,
			backupLevel = JM.bkpLevel,
			backupLevelName = (
					CASE WHEN JM.bkpLevel = 2 AND appTypeId IN (5, 81, 126) AND JStats.opType <> 98
						THEN @transLogLevelName
					WHEN JM.bkpLevel = 2 AND appTypeId IN (125) AND NOT (JStats.opType IN (59, 60) AND JM.bkpAttributesEx & 16 = 16) --JMBKP_EX_BLOCK_LEVEL_SNAP = 0x10
						THEN @logOnlyLevelName
					ELSE (SELECT bkpLevelName FROM JMBackupLevelNames BK WHERE BK.bkpLevel = JM.bkpLevel)
					END),
			instanceId = EA.InstanceId,
			instanceName = EA.InstanceName,
			jobEndTime = sqlDB.backup_finish_Date,
			bkpAttributes = JM.bkpAttributes,
			bkpAttributesEx = JM.bkpAttributesEx
		FROM sqlDbBackupInfo sqlDB
		INNER JOIN JMBkpStats JM ON JM.jobId = sqlDB.jobId
		INNER JOIN JMJobStats JStats ON JM.jobId = JStats.jobId And JM.CommcellId = JStats.CommcellId
		INNER JOIN #EntityAssoc EA ON EA.InstanceID = sqlDB.instanceId AND EA.SubClientID = sqlDB.appId
		WHERE ((backup_start_Date BETWEEN @startTimeRangefromTime AND @startTimeRangetoTime) OR (@startTimeRangefromTime = 0 AND @startTimeRangetoTime = 0))
			  AND sqlDB.sqlNameId = @i_databaseId
			  AND (@JobTypeFilters = 0 OR JM.optype IN(SELECT jobType FROM #JobTypeFilter))
			  AND (@JobStatusFilters = 0 OR JM.status IN(SELECT status FROM #JobStatusIdFilter))
		UNION
		SELECT
			jobId = sqlDB.jobId,
			commcellId = JM.commcellID,
			clientId =  EA.clientId,
			clientName = EA.ClientName,
			jobStartTime = sqlDB.backup_start_Date,
			appTypeId = EA.ApptypeID,
			appTypeName = EA.ApptypeName,
			backupSetId = EA.Backupsetid,
			backupSetName = EA.BackupsetName,
			subclientId = EA.SubclientID,
			subclientName = EA.SubclientName,
			backupLevel = JM.bkpLevel,
			backupLevelName = (
					CASE WHEN JM.bkpLevel = 2 AND appTypeId IN (5, 81, 126) AND JStats.opType <> 98
						THEN @transLogLevelName
					WHEN JM.bkpLevel = 2 AND appTypeId IN (125) AND NOT (JStats.opType IN (59, 60) AND JM.bkpAttributesEx & 16 = 16) --JMBKP_EX_BLOCK_LEVEL_SNAP = 0x10
						THEN @logOnlyLevelName
					ELSE (SELECT bkpLevelName FROM JMBackupLevelNames BK WHERE BK.bkpLevel = JM.bkpLevel)
					END),
			instanceId = EA.InstanceId,
			instanceName = EA.InstanceName,
			jobEndTime = sqlDB.backup_finish_Date,
			bkpAttributes = JM.bkpAttributes,
			bkpAttributesEx = JM.bkpAttributesEx
		FROM sqlAnalysisDbBackupInfo sqlDB
		INNER JOIN JMBkpStats JM
			ON JM.jobId = sqlDB.jobId
		INNER JOIN JMJobStats JStats
			ON JM.jobId = JStats.jobId
				And JM.CommcellId = JStats.CommcellId
		INNER JOIN #EntityAssoc EA
			ON EA.InstanceID = sqlDB.instanceId
				AND EA.SubClientID = sqlDB.appId
		WHERE ((backup_start_Date BETWEEN @startTimeRangefromTime AND @startTimeRangetoTime) OR (@startTimeRangefromTime = 0 AND @startTimeRangetoTime = 0))
			  AND sqlDB.dbId = @i_databaseId
			  AND (@JobTypeFilters = 0 OR JM.optype IN(SELECT jobType FROM #JobTypeFilter))
			  AND (@JobStatusFilters = 0 OR JM.status IN(SELECT status FROM #JobStatusIdFilter))
	END
	IF OBJECT_ID('tempdb.dbo.#JobDateMap') IS NOT NULL DROP TABLE dbo.#JobDateMap
		CREATE TABLE #JobDateMap(jobStartTimeDayStart INT, hasContentIndexedJob INT)
	-- Use CS timezone if not available.
	IF @timeZoneStdName IS NULL OR @timeZoneStdName = ''
	BEGIN
		SET @timeZoneStdName = dbo.GetClientTimeZone(@defCCID)
	END
	IF @isGetDateListResponseSet = 1 AND @lookForLastBackup = 0
	BEGIN
		--IF OBJECT_ID('tempdb.dbo.#JobDateMap') IS NOT NULL DROP TABLE dbo.#JobDateMap
		--	CREATE TABLE #JobDateMap(jobStartTimeDayStart INT, hasContentIndexedJob INT)
		-- Use CS timezone if not available.
		--IF @timeZoneStdName IS NULL OR @timeZoneStdName = ''
		--BEGIN
		--	SET @timeZoneStdName = dbo.GetClientTimeZone(@defCCID)
		--END
		--DECLARE @jobStartTimeDT DATETIME = dbo.GetDateTime(@jobStartTime) -- Get Date time object from timestamp
		--DECLARE @jobStartTimeDTLocal DATETIME = dbo.UTCToLocalTime(@jobStartTimeDT, @timeZoneStdName) -- Convert to local time
		--DECLARE @jobStartTimeLocalDayStartDT DATETIME = CAST(@jobStartTimeDTLocal AS DATE) -- Chop of time and get date beginning
		--DECLARE @jobStartTimeDayStartDT DATETIME =  dbo.LocalToUTCTime(@jobStartTimeLocalDayStartDT, @timeZoneStdName) -- Convert back to UTC time
		--DECLARE @jobStartTimeDayStart INT =  dbo.GetUnixTime(jobStartTimeDayStartDT) -- Get time stamp from date time object
		INSERT INTO #JobDateMap(jobStartTimeDayStart, hasContentIndexedJob)
		SELECT dbo.GetUnixTime(dbo.LocalToUTCTime((CAST(dbo.UTCToLocalTime(dbo.GetDateTime(jobStartTime), @timeZoneStdName) AS DATE)), @timeZoneStdName)), -- See commented code above for explanation of this!
				(CASE
WHEN (bkpAttributes & 0x4000000) > 0 THEN 1
					ELSE 0
				END)
		FROM #JobSummary
		SET @xml = ISNULL((SELECT
			MAX(hasContentIndexedJob) as '@hasContentIndexedJob' , count(1) as '@jobCounter', (SELECT jobStartTimeDayStart as '@time' FOR XML PATH('date'),TYPE)
			FROM  #JobDateMap
			GROUP BY jobStartTimeDayStart
			FOR XML PATH('jobDays'),
		ROOT('JobManager_GetJobCompletedDetailsResp'),TYPE), N'<JobManager_GetJobCompletedDetailsResp/>')
	END
	ELSE
	BEGIN
		DECLARE @lastJobStartTime int = 0
		DECLARE @lastJobMonthStartTimeStamp int
		DECLARE @lastJobMonthEndTimeStamp int
		DECLARE @lastJobDayStartTimeStamp int
		DECLARE @lastJobDayEndTimeStamp int
		DECLARE @gettDateListResponseXml XML = N''
		IF @isGetDateListResponseSet = 1
		BEGIN
			IF @startTimeRangefromTime = 0 AND @startTimeRangetoTime = 0
				SET @lastJobStartTime = (SELECT TOP 1 jobStartTime FROM #JobSummary order by jobStartTime DESC)
			ELSE
				SET @lastJobStartTime = (SELECT TOP 1 jobStartTime FROM #JobSummary WHERE jobStartTime BETWEEN @startTimeRangefromTime  AND @startTimeRangetoTime order by jobStartTime DESC)
			IF @lastJobStartTime is not NULL or @lastJobStartTime <> 0
			BEGIN
				DECLARE @jobStartDateTime DATETIME
				SET @jobStartDateTime = CAST(dbo.UTCToLocalTime(dbo.GetDateTime(@lastJobStartTime), @timeZoneStdName) AS DATETIME)
				DECLARE @lastJobMonthStartTime DATETIME
				DECLARE @lastJobMonthEndTime DATETIME
				DECLARE @lastJobDayStartTime DATETIME
				DECLARE @lastJobDayEndTime DATETIME
				SET @lastJobMonthStartTime = (SELECT DATEADD(month, DATEDIFF(month, -1, @jobStartDateTime) - 1, 0))
				SET @lastJobMonthEndTime = (SELECT DATEADD(ss, -1, DATEADD(month, DATEDIFF(month, 0, @jobStartDateTime) + 1, 0)))
				SET @lastJobDayStartTime = (SELECT DATEADD(DAY, DATEDIFF(DAY, -1, @jobStartDateTime) - 1, 0))
				SET @lastJobDayEndTime = (SELECT DATEADD(ss, -1, DATEADD(DAY, DATEDIFF(DAY, 0, @jobStartDateTime) + 1, 0)))
				SET @lastJobMonthStartTimeStamp = (select dbo.GetUnixTime(dbo.LocalToUTCTime(@lastJobMonthStartTime, @timeZoneStdName)))
				SET @lastJobMonthEndTimeStamp = (select dbo.GetUnixTime(dbo.LocalToUTCTime(@lastJobMonthEndTime, @timeZoneStdName)))
				SET @lastJobDayStartTimeStamp = (select dbo.GetUnixTime(dbo.LocalToUTCTime(@lastJobDayStartTime, @timeZoneStdName)))
				SET @lastJobDayEndTimeStamp = (select dbo.GetUnixTime(dbo.LocalToUTCTime(@lastJobDayEndTime, @timeZoneStdName)))
				SET @startTimeRangefromTime = @lastJobDayStartTimeStamp
				SET @startTimeRangetoTime = @lastJobDayEndTimeStamp
				INSERT INTO #JobDateMap(jobStartTimeDayStart, hasContentIndexedJob)
				SELECT dbo.GetUnixTime(dbo.LocalToUTCTime((CAST(dbo.UTCToLocalTime(dbo.GetDateTime(jobStartTime), @timeZoneStdName) AS DATE)), @timeZoneStdName)), -- See commented code above for explanation of this!
						(CASE
							WHEN (bkpAttributes & 0x4000000) > 0 THEN 1
							ELSE 0
						END)
				FROM #JobSummary WHERE jobStartTime BETWEEN @lastJobMonthStartTimeStamp AND @lastJobMonthEndTimeStamp
				SET @gettDateListResponseXml = ISNULL((SELECT
					MAX(hasContentIndexedJob) as '@hasContentIndexedJob' , count(1) as '@jobCounter', (SELECT jobStartTimeDayStart as '@time' FOR XML PATH('date'),TYPE)
					FROM  #JobDateMap
					GROUP BY jobStartTimeDayStart
					FOR XML PATH('jobDays')), N'')
			END
		END
		-- add vmStatus details for VSA jobs
		if OBJECT_ID('tempdb.dbo.#VmStatusInfo') is not null drop table dbo.#VmStatusInfo
		CREATE TABLE #VmStatusInfo  (
			jobId		int,
			commcellID	int,
			clientId	INT,
			VmGUID		NVARCHAR(MAX)
		)
		IF EXISTS(SELECT 1 FROM #Jobsummary WHERE appTypeId = 106 ) -- VIRTUAL_SERVER_IDA
		BEGIN
   		DECLARE @vmJobAttr BIGINT = CAST(0x4000000 AS BIGINT) | CAST(0x20000000000 AS BIGINT) -- JMBKP_EX_PSEUDO_CHILD_JOB, JMBKP_EX_VM_LEVEL_SYNTHFULL
   		DECLARE @parentJobAttr BIGINT = CAST(0x40000000 AS BIGINT) | CAST(0x100000000000000 AS BIGINT) -- JMBKP_EX_PSEUDO_PARENT_JOB, JMBKP_EX_VSA_PARENT_SYNTHFULL
   		DECLARE @v2JobAttr BIGINT = CAST(0x4000000 AS BIGINT) | CAST(0x20000000000 AS BIGINT) | CAST(0x40000000 AS BIGINT) | CAST(0x100000000000000 AS BIGINT) -- JMBKP_EX_PSEUDO_CHILD_JOB, JMBKP_EX_VM_LEVEL_SYNTHFULL, JMBKP_EX_PSEUDO_PARENT_JOB, JMBKP_EX_VSA_PARENT_SYNTHFULL
			INSERT INTO #VmStatusInfo (jobId, commcellID, clientId, VmGUID)
			-- for vm pseudo jobs & VM Level synthetic full, return its vmStatus
			SELECT J.jobId, J.commcellId, J.clientId, VMP.attrVal
			FROM #JobSummary J
			INNER JOIN App_VMProp VMP WITH(NOLOCK) ON J.jobId = VMP.ClientJobId
				AND J.commcellId = VMP.commcellId
				AND J.clientId = VMP.VMclientId
				AND VMP.attrName = 'vmGUID'
			WHERE J.bkpAttributesEx & @vmJobAttr <> 0
   			AND J.appTypeId = 106 -- VIRTUAL_SERVER_IDA
			UNION
			-- for VSA parent jobs and parent synthetic full
			SELECT J.jobId, J.commcellId, VMP.VMclientId, VMP.attrVal
			FROM #JobSummary J
			INNER JOIN App_VMProp VMP WITH(NOLOCK) ON J.jobId = VMP.jobId
				AND J.commcellId = VMP.commcellId
				AND VMP.attrName = 'vmGUID'
			WHERE (J.bkpAttributesEx & @parentJobAttr <> 0)
   			AND J.appTypeId = 106 -- VIRTUAL_SERVER_IDA
			UNION
			-- for VSA V1 jobs
			SELECT J.jobId, J.commcellId, VMP.VMclientId, VMP.attrVal
			FROM #JobSummary J
			INNER JOIN App_VMProp VMP WITH(NOLOCK) ON J.jobId = VMP.jobId
				AND J.commcellId = VMP.commcellId
				AND VMP.attrName = 'vmGUID'
			WHERE J.bkpAttributesEx & @v2JobAttr  = 0
				AND J.clientId <> VMP.VMclientId
				AND J.appTypeId = 106 -- VIRTUAL_SERVER_IDA
		END
		IF (EXISTS(SELECT TOP 1 * FROM #JobSummary WHERE jobStartTime BETWEEN @startTimeRangefromTime  AND @startTimeRangetoTime ) OR (@startTimeRangefromTime = 0 AND @startTimeRangetoTime = 0))
		BEGIN
				SET @xml =
						ISNULL((SELECT  @gettDateListResponseXml,
							(
									SELECT	jobId 'jobSummary/@jobId' ,
											commcellId 'jobSummary/@commcellId' ,
											jobStartTime 'jobSummary/@jobStartTime',
											jobEndTime 'jobSummary/@jobEndTime',
											backupLevelName 'jobSummary/@backupLevelName',
											CASE
WHEN (bkpAttributes & 0x4000000) > 0 THEN 1
												ELSE 0
											END 'jobSummary/@contentIndexed',
											-- Return the subclient entity - Below entity should be used always to get the correct client information.
											J.clientId 'jobSummary/subclient/@clientId',
											clientName 'jobSummary/subclient/@clientName',
											appTypeId 'jobSummary/subclient/@applicationId',
											appTypeName 'jobSummary/subclient/@appName',
											instanceId 'jobSummary/subclient/@instanceId',
											dbo.EncodeInvalidXMLChar(instanceName) 'jobSummary/subclient/@instanceName',
											backupsetId 'jobSummary/subclient/@backupsetId',
											backupsetName 'jobSummary/subclient/@backupsetName',
											subclientId 'jobSummary/subclient/@subclientId',
											subclientName 'jobSummary/subclient/@subclientName',
											(SELECT (SELECT (SELECT VMS.clientId AS '@clientId' , VMS.vmGUID AS '@GUID'
												FROM #VmStatusInfo VMS WHERE jobId = J.jobId AND commcellId = J.commcellId
												FOR XML PATH('vmStatus'), TYPE)
												FOR XML PATH('clientStatusInfo'), TYPE)
												FOR XML PATH('jobDetail'), TYPE)
									FROM #JobSummary J
									WHERE ((jobStartTime BETWEEN @startTimeRangefromTime  AND @startTimeRangetoTime )
																OR
										   (@startTimeRangefromTime = 0 AND @startTimeRangetoTime = 0))
									FOR XML PATH('jobs'), TYPE)
							FOR XML PATH('JobManager_GetJobCompletedDetailsResp'), TYPE),N'<JobManager_GetJobCompletedDetailsResp/>')
		END
		ELSE
		BEGIN
			SET @xml = N'<JobManager_GetJobCompletedDetailsResp/>'
		END
	END
	IF OBJECT_ID(N'tempdb.dbo.#TempOperationNames') IS NOT NULL
		DROP TABLE #TempOperationNames
	IF OBJECT_ID(N'tempdb.dbo.#TempBkpLevelNames') IS NOT NULL
		DROP TABLE #TempBkpLevelNames
	IF OBJECT_ID(N'tempdb.dbo.#TempStatusNames') IS NOT NULL
		DROP TABLE #TempStatusNames
	IF OBJECT_ID(N'tempdb.dbo.#TempStateNames') IS NOT NULL
		DROP TABLE #TempStateNames
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Bkp') IS NOT NULL
		DROP TABLE #SecIDANodeAccessTemp_Bkp
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Rst') IS NOT NULL
		DROP TABLE #SecIDANodeAccessTemp_Rst
	IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_adminObject') IS NOT NULL
		DROP TABLE #JMCanManageJob_adminObject
	IF OBJECT_ID('tempdb.dbo.#clientGroupListFilter') IS NOT NULL
		DROP TABLE dbo.#clientGroupListFilter
	IF OBJECT_ID('tempdb.dbo.#dataSourceFilter') IS NOT NULL
		DROP TABLE dbo.#dataSourceFilter
	IF OBJECT_ID('tempdb.dbo.#clientGroupXMLListb') IS NOT NULL
		DROP TABLE dbo.#clientGroupXMLListb
	IF OBJECT_ID('tempdb.dbo.#JobDateMap') IS NOT NULL
		DROP TABLE dbo.#JobDateMap
	--SELECT @totalRecords
	SELECT @xml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetJobCompletedDetails')
	delete from GxQscripts where name = 'JMGetJobCompletedDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobCompletedDetails')
	delete from GXDBVersions where aliasname = 'JMGetJobCompletedDetails'
GO

insert into GXDBVersions values(2, 'JMGetJobCompletedDetails',  '00000000000000000000', 'JMGetJobCompletedDetails', '00000000000000000000')
GO

