

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobActivityLevelForJobType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Gokul Pattabiraman
--	Date:   05/09/2019
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetJobActivityLevelForJobType.sp,v $ $Id: JMGetJobActivityLevelForJobType.sp,v 1.1.2.3 2019/08/28 19:16:12 bzhu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetJobActivityLevelForJobType')
BEGIN
	print '>>> Drop Stored Procedure: JMGetJobActivityLevelForJobType <<<'
	drop procedure JMGetJobActivityLevelForJobType
END
IF EXISTS (select * from GxQscripts where name='JMGetJobActivityLevelForJobType')
	delete from GxQscripts where name = 'JMGetJobActivityLevelForJobType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobActivityLevelForJobType')
	delete from GXDBVersions where aliasname = 'JMGetJobActivityLevelForJobType'
GO
print '... Creating Procedure: JMGetJobActivityLevelForJobType'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetJobActivityLevelForJobType
  @i_opType INT,
  @i_isNewRM INTEGER
AS
  DECLARE @jobCount INTEGER
	SET NOCOUNT ON
	DECLARE @runningCount INT = 0
	DECLARE @waitingonRMCount INT = 0
	SELECT @runningCount = COUNT(1)
	FROM JMJobInfo JI (NOLOCK)
	WHERE JI.opType = @i_opType
	AND JI.state = 1 -- RUNNING
	IF @i_isNewRM = 1
	BEGIN
		-- If new RM mode is enabled, we need to count the jobs that are pending inside RM also.
		-- If these jobs are not counted, we may end up sending many requests that exceed the high water mark and potentially run more jobs over watermark value
		SELECT @waitingonRMCount = COUNT(1)
		FROM JMJobInfo JI (NOLOCK)
		INNER JOIN (SELECT DISTINCT RR.JobId, RR.CommCellId
					FROM RMReservationRequest RR (NOLOCK)
					INNER JOIN RMJobControl RC (NOLOCK) ON RR.JobId = RC.JobId AND RR.CommCellId = RC.CommCellId
					WHERE RR.RequestCategory in (2, 3, 8) -- RM_RESERVATION_BACKUP, RM_RESERVATION_AUXCOPY, RM_RESERVATION_DASHCOPY
					AND (RR.ErrorCode = -1 /*Means it is active*/ OR (RR.ErrorCode = 0  AND RR.RequestTime <> -1 /*Means success and not yet returned to JM*/))
					AND RR.JobId > 0
					AND RC.Status = 1 -- RM_RESERVATION_REQUEST_ACTIVE
					) RM ON RM.JobId = JI.jobId AND RM.CommCellId = JI.commCellId
		WHERE JI.state <> 1 AND JI.opType = @i_opType -- Exclude Running jobs
   	OPTION (MAXDOP 1)
	END
	SELECT (@runningCount + @waitingonRMCount) AS jobCount
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetJobActivityLevelForJobType')
	delete from GxQscripts where name = 'JMGetJobActivityLevelForJobType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobActivityLevelForJobType')
	delete from GXDBVersions where aliasname = 'JMGetJobActivityLevelForJobType'
GO

insert into GXDBVersions values(2, 'JMGetJobActivityLevelForJobType',  '00010001000200030000', 'JMGetJobActivityLevelForJobType', '00010001000200030000')
GO

