

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetJobActivityLevel.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Amey Karandikar
--	Date:   10/03/2005
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetJobActivityLevel.sp,v $ $Id: JMGetJobActivityLevel.sp,v 1.8.210.3 2018/03/22 03:11:51 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetJobActivityLevel <<<'

IF EXISTS (select * from sysobjects where name='JMGetJobActivityLevel')
	drop procedure JMGetJobActivityLevel
IF EXISTS (select * from GxQscripts where name='JMGetJobActivityLevel')
	delete from GxQscripts where name = 'JMGetJobActivityLevel'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobActivityLevel')
	delete from GXDBVersions where aliasname = 'JMGetJobActivityLevel'
GO
print '... Creating Procedure: JMGetJobActivityLevel'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetJobActivityLevel
  @checkStreams INTEGER
AS
  DECLARE @ActivityLevel INTEGER
	SET NOCOUNT ON
	IF @checkStreams = 1
	BEGIN
		-- select jobs from jobinfo and MMResourceToJob using a left outer join so that even jobs that
		-- dont have a resource will be returned in this one query. Also if multiple resources are allocated
		-- then multiple rows will be returned, one for each resource
		SELECT @ActivityLevel = COUNT(*)
		FROM JMJobInfo JI
		LEFT OUTER JOIN JMBkpJobInfo JBI ON JI.jobId = JBI.jobId AND JI.commCellId = JBI.commCellId
		LEFT OUTER JOIN MMResourceToJob MMR	ON MMR.JobId_l = JI.jobId
WHERE JI.state in (1,6,7,8,13,17,18) AND JI.commCellId = 2
AND (JBI.jobId IS NULL OR JBI.bkpAttributesEx & 0x4000000 = 0 OR MMR.jobId_l IS NOT NULL) -- Ingore pseudo VM job. Condition is either not a backup, or not a pseudo VM job or it should have a stream.
	END
	ELSE
	BEGIN
		-- get only jobs that are in the running state. ignore the running streams
SELECT @ActivityLevel = COUNT(*) FROM JMJobInfo WHERE state in (1,6,7,8,13,17,18) AND JMJobInfo.commCellId = 2
	END
	SELECT @ActivityLevel
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetJobActivityLevel')
	delete from GxQscripts where name = 'JMGetJobActivityLevel'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetJobActivityLevel')
	delete from GXDBVersions where aliasname = 'JMGetJobActivityLevel'
GO

insert into GXDBVersions values(2, 'JMGetJobActivityLevel',  '00010008021000030000', 'JMGetJobActivityLevel', '00010008021000030000')
GO

