

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetIndexCreationInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetIndexCreationInfo.sp,v $ $Id: JMGetIndexCreationInfo.sp,v 1.7.86.2 2018/03/22 03:05:46 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "JMGetIndexCreationInfo"								|
--	|																		|
--	|																		|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetIndexCreationInfo <<<'

IF EXISTS (select * from sysobjects where name='JMGetIndexCreationInfo')
	drop procedure JMGetIndexCreationInfo
IF EXISTS (select * from GxQscripts where name='JMGetIndexCreationInfo')
	delete from GxQscripts where name = 'JMGetIndexCreationInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetIndexCreationInfo')
	delete from GXDBVersions where aliasname = 'JMGetIndexCreationInfo'
GO
print '... Creating Procedure: JMGetIndexCreationInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetIndexCreationInfo
  @in_SubClientId integer,
  @in_isRequestForSyntheticFull integer = 0
AS
  DECLARE @o_fullBkpJobId integer
  DECLARE @o_fullBkpJobTime integer
  DECLARE @o_incrBkpJobId integer
  DECLARE @o_incrBkpJobTime integer
  DECLARE @o_bkpType integer
  DECLARE @o_indexCreationTime integer
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--Select last successful FULL jobid, time for the give subclient
--Status =1 means completed, 3 = partial, 16 = user committed and bkpLevel = 1 mean FULL
-- datastatus 0 means valid data
DECLARE @maxCycleNumber INT = 0
if @in_isRequestForSyntheticFull = 0
	select top 1 @o_fullBkpJobId = jobId, @o_fullBkpJobTime = servEndDate from JmBkpStats where appId = @in_SubClientId and status IN (1,3,16) and datastatus = 0 and commCellId=2 and bkpLevel = 1 order by jobId desc
else
begin
    SELECT @maxCycleNumber = MAX(fullCycleNum) from JMBkpStats where appId = @in_SubClientId and status IN (1,3,16) and datastatus = 0 and commCellId=2
	select top 1 @o_fullBkpJobId = jobid, @o_fullBkpJobTime = servEndDate from JMBkpStats where appId = @in_SubClientId and status IN (1,3,16) and bkpLevel IN (64,128) and datastatus = 0 and commCellId=2 and fullCycleNum = @maxCycleNumber
	if @o_fullBkpJobId = 0 or @o_fullBkpJobId is null
		select top 1 @o_fullBkpJobId = jobId, @o_fullBkpJobTime = servEndDate from JmBkpStats where appId = @in_SubClientId and status IN (1,3,16) and datastatus = 0 and commCellId=2 and bkpLevel = 1 order by jobId desc
end
--Select last successful Incremental jobid, time for the give subclient
--Status =1 means completed, 3 = partial, 16 = user committed and bkpLevel = 2 mean Incremental
select top 1 @o_incrBkpJobId = jobId, @o_incrBkpJobTime = servEndDate from JmBkpStats where appId = @in_SubClientId and status IN (1,3,16) and datastatus = 0 and commCellId=2 and bkpLevel = 2 order by jobId desc
--Select indexCreationTime and bkplevel
--Here we are fetching the latest index creation time(It may be incremental or full backup type)
select top 1 @o_indexCreationTime = cTime, @o_bkpType = backupLevel from archfile where fileType = 1 and appId =@in_SubClientId and commCellId=2 order by cTime desc
select @o_fullBkpJobId, @o_fullBkpJobTime, @o_incrBkpJobId, @o_incrBkpJobTime, @o_bkpType, @o_indexCreationTime
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetIndexCreationInfo')
	delete from GxQscripts where name = 'JMGetIndexCreationInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetIndexCreationInfo')
	delete from GXDBVersions where aliasname = 'JMGetIndexCreationInfo'
GO

insert into GXDBVersions values(2, 'JMGetIndexCreationInfo',  '00010007008600020000', 'JMGetIndexCreationInfo', '00010007008600020000')
GO

