

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetForeginJobsForMining.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetForeginJobsForMining.sp,v $ $Id: JMGetForeginJobsForMining.sp,v 1.8.60.2 2018/03/22 03:04:22 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMGetForeginJobsForMining
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetForeginJobsForMining <<<'

IF EXISTS (select * from sysobjects where name='JMGetForeginJobsForMining')
	drop procedure JMGetForeginJobsForMining
IF EXISTS (select * from GxQscripts where name='JMGetForeginJobsForMining')
	delete from GxQscripts where name = 'JMGetForeginJobsForMining'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetForeginJobsForMining')
	delete from GXDBVersions where aliasname = 'JMGetForeginJobsForMining'
GO
print '... Creating Procedure: JMGetForeginJobsForMining'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetForeginJobsForMining
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inXMl XML
AS
  DECLARE @dummyXml XML
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN TRY
BEGIN TRAN
declare @inMiningJobId int
declare @inMiningAppId int
declare @inMiningCCId int
declare @minableJobId int
declare @minableAppId int
declare @minableCCId int
declare @minableCommCellType int
declare @preparedJobId int
declare @miningOpType int
SET @preparedJobId = 0
SET @inMiningJobId = ISNULL (( SELECT ref.value('@miningJobId', 'INTEGER')FROM @inXMl.nodes('JobManager_ForeginJobsReq') R(ref)), 0)
SET @inMiningAppId = ISNULL (( SELECT ref.value('@miningSubclientId', 'INTEGER')FROM @inXMl.nodes('JobManager_ForeginJobsReq') R(ref)), 0)
SET @inMiningCCId = ISNULL (( SELECT ref.value('@miningCommCellId', 'INTEGER')FROM @inXMl.nodes('JobManager_ForeginJobsReq') R(ref)), 0)
select @miningOpType = opType from JMJobInfo where jobId = @inMiningJobId and commCellId = @inMiningCCId
IF @miningOpType = 4 -- Backup
BEGIN
		SELECT @minableJobId = jobId, @minableCCId = commCellId, @minableAppId = appId FROM JMJobMiningStats
		WHERE miningJobId = @inMiningJobId AND miningCommCellId = @inMiningCCId
END
ELSE IF @miningOpType = 60 -- Backup
BEGIN
	-- Get minable jobInfo from JMJobWF table
	SELECT @minableJobId = processedJobId, @minableCCId = processedCommcellId, @minableAppId = applicationId FROM JMJobWF  WHERE childJobId = @inMiningJobId AND commcellId = @inMiningCCId
END
SELECT @minableCommCellType = type FROM APP_CommCell WHERE id = @minableCCId
if @minableCommCellType >= 100
--It is a foregin job
	SELECT @preparedJobId = preparedJobId FROM JmPreparedJob WHERE jobId = @minableJobId and commCellId = @minableCCId
else
	-- The minableJobId is a preparedJob
	IF EXISTS (SELECT * FROM JMPreparedJob WHERE preparedJobId = @minableJobId AND preparedJobCCId = @minableCCId)
		SET @preparedJobId = @minableJobId
IF @preparedJobId > 0
BEGIN
	if object_id('dbo.edcJobIdMap') is null
		set @inXMl = ''
	else
	begin
		set @inXMl = ''
		set @inXMl =(
		select edcJobIdMap.foreignJobId "@foreignJobId" ,
		 edcJobIdMap.mergedCcId "@foreigncommCellId",
		 JMPreparedJob.jobId "@minableJobId",
		 JMPreparedJob.commCellId "@minableCommCellId",
		 JMPreparedJob.appId "@minableAppId",
		 JMPreparedJob.preparedJobId "@preparedJobId",
		 JMPreparedJob.preparedJobCCId "@preparedCommCellId"
		from edcJobIdMap, JMPreparedJob where JMPreparedJob.preparedJobId = @preparedJobId and
		JMPreparedJob.jobId = edcJobIdMap.newJobId and JMPreparedJob.commCellId = edcJobIdMap.mergedCcId
		FOR XML PATH('foreginJobs'), ROOT('JobManager_ForeginJobsResp'))
	end
END
ELSE
BEGIN
	set @inXMl = ''
	set @inXMl =(
	select JMJobMiningStats.jobId "@foreignJobId" ,
	JMJobMiningStats.commCellId "@foreigncommCellId",
	JMJobMiningStats.jobId "@minableJobId",
	JMJobMiningStats.commCellId "@minableCommCellId",
	JMJobMiningStats.appId "@minableAppId",
	JMJobMiningStats.jobId "@preparedJobId",
	JMJobMiningStats.commCellId "@preparedCommCellId"
	from JMJobMiningStats  where JMJobMiningStats.miningJobId = @inMiningJobId	and JMJobMiningStats.miningCommCellId = @inMiningCCId
	FOR XML PATH('foreginJobs'), ROOT('JobManager_ForeginJobsResp'))
END
COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	set @inXMl = ''
	ROLLBACK TRANSACTION
END CATCH;
select @inXMl
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetForeginJobsForMining')
	delete from GxQscripts where name = 'JMGetForeginJobsForMining'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetForeginJobsForMining')
	delete from GXDBVersions where aliasname = 'JMGetForeginJobsForMining'
GO

insert into GXDBVersions values(2, 'JMGetForeginJobsForMining',  '00010008006000020000', 'JMGetForeginJobsForMining', '00010008006000020000')
GO

