

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetFailedVMs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetFailedVMs.sp,v $ $Id: JMGetFailedVMs.sp,v 1.8.12.5 2017/02/10 21:48:12 sjohnson Exp $";
---- =============================================
---- Author:		Jaya Rama Raju Inavolu
---- Create date:	09/26/2012
---- Description:	Get the failed vms
---- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetFailedVMs <<<'

IF EXISTS (select * from sysobjects where name='JMGetFailedVMs')
	drop procedure JMGetFailedVMs
IF EXISTS (select * from GxQscripts where name='JMGetFailedVMs')
	delete from GxQscripts where name = 'JMGetFailedVMs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetFailedVMs')
	delete from GXDBVersions where aliasname = 'JMGetFailedVMs'
GO
print '... Creating Procedure: JMGetFailedVMs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetFailedVMs
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inXMl XML
AS
BEGIN
  DECLARE @xmlText XML 
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @inSubclientId INT
DECLARE @inOpType	   INT
DECLARE @lastCWEJobId			INT
DECLARE @lastSuccessFullJobId	INT
DECLARE @queryStmt				NVARCHAR(MAX)
DECLARE @parameterDef			NVARCHAR(MAX)
DECLARE @vmStatus				VARCHAR(64)
DECLARE @isFromClient			INT = 1
DECLARE @backupCWEVMsWithFailedVMs				INT = 0
DECLARE @currentJobId			INT = 0
SET @inSubclientId = ISNULL (( SELECT ref.value('@subclientId', 'INTEGER')FROM @inXMl.nodes('JobManager_GetFailedVMsReq') R(ref)), 0)
SET @inOpType	   = ISNULL (( SELECT ref.value('@opType', 'INTEGER')FROM @inXMl.nodes('JobManager_GetFailedVMsReq') R(ref)), 0)
SET @lastCWEJobId	   = ISNULL (( SELECT ref.value('@jobId', 'INTEGER')FROM @inXMl.nodes('JobManager_GetFailedVMsReq') R(ref)), 0)
SET @currentJobId	   = ISNULL (( SELECT ref.value('@currentjobId', 'INTEGER')FROM @inXMl.nodes('JobManager_GetFailedVMsReq') R(ref)), 0)
IF (@lastCWEJobId > 0 OR @currentJobId = 0)
 SET @isFromClient = 0
IF EXISTS (select * from dbo.GetAllJobOptions(@currentJobId) where optionId=768879332)
	SET @backupCWEVMsWithFailedVMs = 1
--
-- Criteria for getting failed VM list.
-- Last partial success job.
-- Ignore synth, killed and aged job.
IF @lastCWEJobId = 0 --For backend request jobId will not be set
BEGIN
	-- JMBKP_EX_PSEUDO_CHILD_JOB 0x4000000
	SET @queryStmt  = N'select top 1 @outJobId = ISNULL(JmBkpStats.jobId, 0)
						From JmBkpStats, JMJobStats
						Where JMJobStats.jobId = JMBkpStats.jobId And JMJobStats.CommcellId = JMBkpStats.CommcellId And
						JMBkpStats.appId = @inputSCId And JmBkpStats.Status = @inStatus And JMJobStats.opType IN(@inputOpType, 14) And
						JMBkpStats.bkpAttributesEx & 0x4000000 = 0 /*Skip pseudo VM jobs*/
						And JMBkpStats.fullCycleNum =(select ISNULL(CAST(attrval as Int), 0) from APP_SubClientProp where componentNameId = @inputSCId and attrName = ''sys:full cycle num'' and modified=0) /*Current cycle*/
						Order by JmBkpStats.servEndDate desc'
	SET @parameterDef = N'@inputSCId INT, @inStatus INT, @inputOpType INT, @outJobId INT OUTPUT'
	EXEC sp_executesql @queryStmt, @parameterDef, @inputSCId = @inSubclientId, @inStatus = 3/*Partial Success*/, @inputOpType = @inOpType, @outJobId = @lastCWEJobId OUTPUT
	EXEC sp_executesql @queryStmt, @parameterDef, @inputSCId = @inSubclientId, @inStatus = 1/*Successful*/, @inputOpType = @inOpType, @outJobId = @lastSuccessFullJobId OUTPUT
	IF @lastSuccessFullJobId > @lastCWEJobId
		SET @lastCWEJobId = 0
END
SET @xmlText = (SELECT
	vmProps.VMclientId '@clientId',
	(select ISNULL(attrVal,'') From APP_ClientProp(nolock) where attrName = 'Virtual Machine Instance UUID' and componentNameId = vmProps.VMclientId and modified=0) '@vmGUID',
	(select ISNULL(attrVal,'') From APP_ClientProp(nolock) where attrName = 'Virtual Machine Name' and componentNameId = vmProps.VMclientId and modified=0)  '@vmName',
	(select top 1 ISNULL(attrVal,'') From APP_VMProp(nolock) where attrName = 'vmFailureReason' and jobId = @lastCWEJobId and VMClientId = vmProps.VMclientId)  '@failureReason',
	ISNULL(vmProps.attrVal, '1') '@status'
	FROM APP_VMProp(nolock) vmProps WHERE jobId = @lastCWEJobId And attrName = 'vmStatus' And
	(
	  (@isFromClient = 0 AND attrVal in('1','3','6')) --From GUI/Server return both failed/killed VMs and Partial success VMs
	OR
	  (@isFromClient = 1 AND @backupCWEVMsWithFailedVMs =0 AND attrVal in('1','6'))
	OR
	  (@isFromClient = 1 AND @backupCWEVMsWithFailedVMs =1 AND attrVal in('1','3','6'))
	)
	FOR XML PATH('failedVMs'), ROOT('JobManager_GetFailedVMsResp')
)
IF @xmlText IS NULL
	SET @xmlText = '<JobManager_GetFailedVMsResp/>'
SELECT @xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetFailedVMs')
	delete from GxQscripts where name = 'JMGetFailedVMs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetFailedVMs')
	delete from GXDBVersions where aliasname = 'JMGetFailedVMs'
GO

insert into GXDBVersions values(2, 'JMGetFailedVMs',  '00010008001200050000', 'JMGetFailedVMs', '00010008001200050000')
GO

