

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetFailedFilesExistStatus.sp] ---------- 

-- ==================================================================================================================
-- 	Author:			Kaushal Ghai
-- 	Create date: 		20/02/2012
-- 	Description:		To provide the failed file status in previous ran backup
--
--
--	CurrentBkp		Behaviour
--
--
--	Fulls : 		It returns 0 always.
--	Incrementals : 		Depends on the previous Backup. Returns true if Failed File Existed in the previous Full/Incremental backups only.
--	Differentials : 	If there was no Synthetic Full ever ran after the last full backup then look for failed files in the last full and all the --				incrementals or differentials that ran after last full.
--
--				If there was 1 or more Synthetic Full ran after the last full then look for failed files from the last full upto the last   --				Synthetic full covering all incrementals/differentials in between. But dont see in any incrementals/differentials after last --				synthetic full
--	Any Other Bkp :		Returns 0.
-- ====================================================================================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetFailedFilesExistStatus <<<'

IF EXISTS (select * from sysobjects where name='JMGetFailedFilesExistStatus')
	drop procedure JMGetFailedFilesExistStatus
IF EXISTS (select * from GxQscripts where name='JMGetFailedFilesExistStatus')
	delete from GxQscripts where name = 'JMGetFailedFilesExistStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetFailedFilesExistStatus')
	delete from GXDBVersions where aliasname = 'JMGetFailedFilesExistStatus'
GO
print '... Creating Procedure: JMGetFailedFilesExistStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetFailedFilesExistStatus
  @appId integer,
  @currentBkpLevel integer
AS
  DECLARE @backupFailedFileCount integer;
  DECLARE @doesFailedFileExists integer;
create table #jobDetailsForDifferential (jobId integer, backupFileFailures integer)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF @currentBkpLevel = 4                     -- For Differentials
begin
	if exists (select jobId from JMBkpStats where status = 1 and appId = @appId and bkpLevel in (64,128) and servStartDate > (select top 1 servEndDate  				from JMBkpStats where status = 1 and appId = @appId and bkpLevel = 1 order by servEndDate desc))
	begin
		insert into #jobDetailsForDifferential
			Select jobId , backupFileFailures from JMBkpStats where appId = @appId and status = 1 and bkpLevel IN (1,2,4) and servStartDate >= 			(select top 1 servStartDate from JMBkpStats where status =1 and appId = @appId and bkpLevel = 1 order by servEndDate desc) and 					servEndDate < (select top 1 servStartDate from JMBkpStats where appId = @appId and status = 1 and bkpLevel IN (64,128) order by 			servStartDate desc)
	end
	else
	begin
		insert into #jobDetailsForDifferential
			select jobId , backupFileFailures from JMBkpStats where appId = @appId and status = 1 and bkpLevel IN (1,2,4) and servStartDate >= 			(select top 1  servStartDate from JMBkpStats where status = 1 and appId = @appId and bkpLevel = 1 order by servEndDate desc)
	end
	select @backupFailedFileCount = SUM(backupFileFailures) from #jobDetailsForDifferential
end
ELSE IF @currentBkpLevel = 2		   -- For Incrementals
	SET @backupFailedFileCount = (SELECT ISNULL((select top 1 backupFileFailures from JMBkpStats where appId = @appId and status = 1 and bkpLevel IN (1,2) order by servStartDate desc),0))
ELSE
	SET @backupFailedFileCount = 0
IF @backupFailedFileCount > 0
SET @doesFailedFileExists = 1
ELSE
SET @doesFailedFileExists = 0
drop table #jobDetailsForDifferential
select @backupFailedFileCount, @doesFailedFileExists
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetFailedFilesExistStatus')
	delete from GxQscripts where name = 'JMGetFailedFilesExistStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetFailedFilesExistStatus')
	delete from GXDBVersions where aliasname = 'JMGetFailedFilesExistStatus'
GO

insert into GXDBVersions values(2, 'JMGetFailedFilesExistStatus',  '00000000000000000000', 'JMGetFailedFilesExistStatus', '00000000000000000000')
GO

