

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetExchangeIndexServer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  JMGetExchangeIndexServer()
--  |
--  | Description:  Gives the Exchange Index Server Details for a given Subclient ID
--  |
--  |       Input:  appId
--  |
--  |      Output:  Exchange Index Server id, name, displayName
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------------------	        --------------------------------
--  |   1.1        Jawahar Ragunathan           Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetExchangeIndexServer')
BEGIN
	print '>>> Drop Stored Procedure: JMGetExchangeIndexServer <<<'
	drop procedure JMGetExchangeIndexServer
END
IF EXISTS (select * from GxQscripts where name='JMGetExchangeIndexServer')
	delete from GxQscripts where name = 'JMGetExchangeIndexServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetExchangeIndexServer')
	delete from GXDBVersions where aliasname = 'JMGetExchangeIndexServer'
GO
print '... Creating Procedure: JMGetExchangeIndexServer'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetExchangeIndexServer
  @i_appId INT
AS
  DECLARE @id INTEGER
  DECLARE @name NVARCHAR(512)
  DECLARE @displayName NVARCHAR(512)
SET NOCOUNT ON
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SELECT client.id, client.name, client.displayName FROM APP_IDAName idaName
		INNER JOIN APP_IDAProp idaProp ON idaName.Id = idaProp.componentNameId
										AND idaName.appTypeId = 137
										AND idaProp.attrName = 'OnePass Index Server'
										AND idaProp.modified=0
		INNER JOIN APP_Application app ON app.clientId = idaName.clientId
										AND app.id = @i_appId
		INNER JOIN APP_Client client ON CAST(client.id AS NCHAR) = idaProp.attrVal
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetExchangeIndexServer')
	delete from GxQscripts where name = 'JMGetExchangeIndexServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetExchangeIndexServer')
	delete from GXDBVersions where aliasname = 'JMGetExchangeIndexServer'
GO

insert into GXDBVersions values(2, 'JMGetExchangeIndexServer',  '00000000000000000000', 'JMGetExchangeIndexServer', '00000000000000000000')
GO

