

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetEventCodeForFailure.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetEventCodeForFailure.sp,v $ $Id: JMGetEventCodeForFailure.sp,v 1.1.4.4 2018/03/27 08:48:16 jiechen Exp $";
--
--  +========================================================================+
--  |      Cursor:  JMGetEventCodeForFailure()
--  |
--  | Description:  Retrieves the event code for the failure
--  |
--  |      Input:   ???
--  |
--  |      Output:  Returns rows that match input criteria
--  |
--  |      Notes:
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        madeira 	Initial release
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetEventCodeForFailure <<<'

IF EXISTS (select * from sysobjects where name='JMGetEventCodeForFailure')
	drop procedure JMGetEventCodeForFailure
IF EXISTS (select * from GxQscripts where name='JMGetEventCodeForFailure')
	delete from GxQscripts where name = 'JMGetEventCodeForFailure'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetEventCodeForFailure')
	delete from GXDBVersions where aliasname = 'JMGetEventCodeForFailure'
GO
print '... Creating Procedure: JMGetEventCodeForFailure'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetEventCodeForFailure
  @messages CHAR(256)
AS
  DECLARE @r_ErrorCode VARCHAR(4000)
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- .. :PARAM input lines
--			FETCH ALL THE ALERT ACTION ROWS FOR WHICH THERE IS A USER ASSOCIATION
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @messageId int = CAST(SUBSTRING(@messages, 0, CHARINDEX(',', @messages, 0)) AS INT)
SELECT @r_ErrorCode = CAST(EV.SubsystemID AS NVARCHAR(256)) + ':' + CAST(EV.MessageNum AS NVARCHAR(256))
	FROM JMFailureReasonMsg JMF
	INNER JOIN EvLocaleMsgs EV ON JMF.messageId = EV.MessageID AND EV.LocaleID = 0
	AND JMF.id = @messageId
SELECT @r_ErrorCode
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetEventCodeForFailure')
	delete from GxQscripts where name = 'JMGetEventCodeForFailure'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetEventCodeForFailure')
	delete from GXDBVersions where aliasname = 'JMGetEventCodeForFailure'
GO

insert into GXDBVersions values(2, 'JMGetEventCodeForFailure',  '00010001000400040000', 'JMGetEventCodeForFailure', '00010001000400040000')
GO

