

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetEdgeJobDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--  +========================================================================+
--  |      Name	 :  JMGetEdgeJobDetails
--  +========================================================================+
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetEdgeJobDetails.sp,v $ $Id: JMGetEdgeJobDetails.sp,v 1.6.14.4 2018/03/22 02:59:47 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetEdgeJobDetails <<<'

IF EXISTS (select * from sysobjects where name='JMGetEdgeJobDetails')
	drop procedure JMGetEdgeJobDetails
IF EXISTS (select * from GxQscripts where name='JMGetEdgeJobDetails')
	delete from GxQscripts where name = 'JMGetEdgeJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetEdgeJobDetails')
	delete from GXDBVersions where aliasname = 'JMGetEdgeJobDetails'
GO
print '... Creating Procedure: JMGetEdgeJobDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetEdgeJobDetails
  @i_commCellID INT,
  @i_clientID INT,
  @i_subclientID INT,
  @i_queryType INT,
  @i_localeID INT
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE		@utcTime			BIGINT = (SELECT dbo.GetUnixTime(GETUTCDATE()))
	--
	-- Temporary table variables
	--
	CREATE TABLE #jobInfoTbl(i_queryType int, t_JobId bigint, t_JobType int, t_CientID int, i_subclientID int, t_SizeOfBackup bigint, t_NumberOfFiles bigint,
										   t_JobStatus int, t_JobSubState int, t_JobSubStatus int, t_JobSubmitError int, t_JobStartTime bigint, t_JobEndTime bigint, currentUTCTime bigint, t_dataTransferredSize bigint,
				  						   t_bkpAttributes bigint, t_bkpAttributesEx bigint, t_pendingReason nvarchar(max), t_dataArchGroupId INT, t_backupLevel INT)
	-- 2) Processing requests with query type as SUBCLIENT_CURRENT_JOB (JobQueryType = 2)(Returns job info for currently running job for given subclient If any).
	IF @i_queryType = 2
	BEGIN
		INSERT INTO #jobInfoTbl
		SELECT @i_queryType, JBI.jobId, 1, JBI.targetClientId, @i_subclientID, JBI.unCompBytes, JBI.filesXfered, 1, JI.state, NULL, NULL, JI.jobStartTime, null, null, JBI.nwTransBytes,
		JBI.bkpAttributes, JBI.bkpAttributesEx, dbo.JMGetLocalizedMessageFunc(@i_localeID, JI.failureReason), JBI.currentPolicy, JBI.bkpLevel
		FROM JMJobInfo JI, JmbkpjobInfo JBI
		WHERE JBI.commcellId = @i_commCellID AND @i_subclientID = JBI.applicationId  AND JBI.jobId = JI.jobId AND JBI.targetClientId = @i_clientID
	END
	ELSE
	IF @i_queryType = 3
	BEGIN
		-- 3) Processing requests with query type as SUBCLIENT_LAST_SUCC_JOB (JobQueryType = 3)(Returns job info for last successful job for given subclient If any).
		INSERT INTO #jobInfoTbl
		SELECT TOP 1 @i_queryType, JBS.jobId, 1, JBS.targetClientId, @i_subclientID, JBS.totalUncompBytes,
				JBS.totalNumOfFiles, 2, NULL, JBS.status, NULL, JBS.servStartDate, JBS.servEndDate, @utcTime, JBS.nwTransBytes,
				JBS.bkpAttributes, JBS.bkpAttributesEx, dbo.JMGetLocalizedMessageFunc(@i_localeID, JBS.failureReason), JBS.dataArchGrpId, JBS.bkpLevel
		FROM Jmbkpstats JBS
		WHERE JBS.commCellId = @i_commCellID AND @i_subclientID = JBS.appId AND JBS.targetClientId = @i_clientID
		AND JBS.status in (1,3,14) AND JBS.bkpLevel in (1,2)
		ORDER BY JBS.servEndDate desc
	END
	IF NOT EXISTS (SELECT 1 FROM  #jobInfoTbl)
	BEGIN
		-- If data is not found in JM/TM tables then returning CVJOBSTATUS_ERROR as JobStatus.
		INSERT INTO #jobInfoTbl
		SELECT @i_queryType, 0, NULL, NULL, @i_subclientID,
				NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
	END
	SELECT *
	FROM #jobInfoTbl
DROP TABLE #jobInfoTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetEdgeJobDetails')
	delete from GxQscripts where name = 'JMGetEdgeJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetEdgeJobDetails')
	delete from GXDBVersions where aliasname = 'JMGetEdgeJobDetails'
GO

insert into GXDBVersions values(2, 'JMGetEdgeJobDetails',  '00010006001400040000', 'JMGetEdgeJobDetails', '00010006001400040000')
GO

