

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetDynamicPriorityConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--			Author: Divakar Radhakrishnan
--			Date:   12/06/2011
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMGetDynamicPriorityConfig')
BEGIN
	print '>>> Drop Stored Procedure: JMGetDynamicPriorityConfig <<<'
	drop procedure JMGetDynamicPriorityConfig
END
IF EXISTS (select * from GxQscripts where name='JMGetDynamicPriorityConfig')
	delete from GxQscripts where name = 'JMGetDynamicPriorityConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetDynamicPriorityConfig')
	delete from GXDBVersions where aliasname = 'JMGetDynamicPriorityConfig'
GO
print '... Creating Procedure: JMGetDynamicPriorityConfig'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMGetDynamicPriorityConfig
  @subClientID INTEGER,
  @bkpLevel INTEGER,
  @opType INTEGER
AS
  DECLARE @AppID INTEGER
  DECLARE @IsSLAMissed INTEGER
  DECLARE @StrikeCount INTEGER
  DECLARE @EstimatedRunTime INTEGER
	DECLARE @ClientID INTEGER
	DECLARE @appType INTEGER
	DECLARE @ScPropAttrName NVARCHAR(1024)
	SET @ScPropAttrName = N'Estimated Run Time_' + CAST(@opType AS NVARCHAR(16))+ N'_' + CAST(@bkpLevel AS NVARCHAR(16))
	SELECT TOP 1 @ClientID = clientId , @appType = appTypeId
	FROM APP_Application WITH (NOLOCK) WHERE id = @subClientID
	-- Check if any special group to consider for data collection.
	-- Get the list of client group ids if exists
	DECLARE @ExcludedAppIds TABLE (appId INT)
	INSERT INTO @ExcludedAppIds
	SELECT componentNameId FROM APP_subclientProp WITH (NOLOCK) WHERE attrName IN ('DDB Backup', 'SILO Copy ID') AND attrVal <> '0' AND modified = 0
	UNION
	SELECT id FROM APP_Application WITH (NOLOCK)
	WHERE clientId IN (SELECT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Content Index Server' AND attrVal = '1' AND modified = 0)
	IF OBJECT_ID('tempdb.dbo.#TblStrikes') IS NOT NULL DROP TABLE #TblStrikes
	CREATE TABLE #TblStrikes (
        vmClientId INT, appId INT, strikeType INT, lastSuccJobId INT, nFailedJobs INT, failedSince DATETIME,
        lastJobId INT, lastJobBkpLvl INT, lastJobStart INT, lastJobEnd INT, lastJobStatus INT, failureReason VARCHAR(256),lastSJobStart INT,lastSJobEnd INT)
	IF OBJECT_ID('tempdb.dbo.#TblLastFailedJob') IS NOT NULL DROP TABLE #TblLastFailedJob
	CREATE TABLE #TblLastFailedJob (entityId INT, fullJobId INT, incrJobId INT)
	INSERT  INTO #TblLastFailedJob
	SELECT  appId, MAX(CASE WHEN bkpLevel IN (1, 1024, 32768) THEN jobId ELSE 0 END), MAX(CASE WHEN bkpLevel IN (1, 1024, 32768) THEN 0 ELSE jobId END)
	FROM    JMBkpStats WITH (NOLOCK)
	WHERE   appId = @subClientID AND bkpLevel NOT IN (64, 128, 16384)
	    AND status NOT IN (1, 14) AND (status <> 9 OR failureErrorCode = 8)
	    AND (status <> 3 OR appType NOT IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1))
	    AND opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND commCellId = 2
	    AND appType < 1000 AND appType NOT BETWEEN 600 AND 700 AND appType <> 106
	GROUP BY appId
	INSERT  INTO #TblStrikes
	SELECT  0, F.entityId, 1, MAX(ISNULL(J.jobId, 0)), 0, NULL, F.fullJobId, 0, 0, 0, 0, NULL,NULL,NULL
	FROM    #TblLastFailedJob F
	        INNER JOIN APP_Application A WITH (NOLOCK) ON F.entityId = A.id
	        LEFT OUTER JOIN JMBkpStats J WITH (NOLOCK) ON J.appId = F.entityId
	    AND bkpLevel IN (1, 1024, 32768)
	    AND (status IN (1, 14) OR status = 3 AND appType IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1))
	    AND opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND commCellId = 2
	GROUP BY F.entityId, F.fullJobId
	HAVING  MAX(ISNULL(J.jobId, 0)) < F.fullJobId
	INSERT  INTO #TblStrikes
	SELECT  0, F.entityId, 2, MAX(ISNULL(J.jobId, 0)), 0, NULL, F.incrJobId, 0, 0, 0, 0, NULL,NULL,NULL
	FROM    #TblLastFailedJob F
	        INNER JOIN APP_Application A WITH (NOLOCK) ON F.entityId = A.id
	        LEFT OUTER JOIN JMBkpStats J WITH (NOLOCK) ON J.appId = F.entityId
	    AND bkpLevel NOT IN (64, 128, 16384)
	    AND (status IN (1, 14) OR status = 3 AND appType IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1))
	    AND opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND commCellId = 2
	GROUP BY F.entityId, F.incrJobId
	HAVING  MAX(ISNULL(J.jobId, 0)) < F.incrJobId
	DELETE  #TblLastFailedJob
	IF OBJECT_ID('tempdb.dbo.#TblFailedJobStats') IS NOT NULL DROP TABLE #TblFailedJobStats
	CREATE TABLE #TblFailedJobStats (entityId INT, strikeType INT, nFailedJobs INT, failedSince INT)
	INSERT  INTO #TblFailedJobStats
	SELECT  F.appId, F.strikeType, COUNT(J.jobId), MIN(J.servStartDate)
	FROM    JMBkpStats J WITH (NOLOCK) INNER JOIN #TblStrikes F ON J.appId = F.appId
	WHERE   (F.strikeType = 1 AND J.bkpLevel IN (1, 1024, 32768) OR F.strikeType = 2 AND J.bkpLevel NOT IN (1, 64, 128, 16384, 1024, 32768))
	    AND J.status NOT IN (1, 14) AND (J.status <> 9 OR J.failureErrorCode = 8)
	    AND (J.status <> 3 OR J.appType NOT IN (SELECT type FROM APP_iDAType WITH (NOLOCK) WHERE isCWEjobValid = 1))
	    AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND J.commCellId = 2
	    AND J.jobId > F.lastSuccJobId
	GROUP BY F.appId, F.strikeType
	UPDATE  #TblStrikes
	SET     nFailedJobs = F.nFailedJobs
	FROM    #TblStrikes A INNER JOIN #TblFailedJobStats F ON A.appId = F.entityId
	DELETE  #TblFailedJobStats
	DELETE  #TblStrikes
	FROM    #TblStrikes F INNER JOIN APP_Application A WITH (NOLOCK) ON F.appId = A.id
	WHERE   dbo.IsSubClientValid(A.appTypeId, A.subclientStatus, 0) = 0
	    OR  A.dataArchGrpId <= 1 AND A.logArchGrpId <= 1
	    OR (A.subclientStatus & (2 | 4)) > 0
	    OR  A.id IN (SELECT appId FROM @ExcludedAppIds)
	DELETE  S FROM #TblStrikes S
	        INNER JOIN APP_SubClientProp SP WITH (NOLOCK) ON S.appId = SP.componentNameId AND SP.attrName = 'Exclude From SLA' AND SP.attrVal = '1' AND SP.modified = 0
	DELETE  S FROM #TblStrikes S INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id
	        INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON A.clientId = CP.componentNameId AND CP.attrName = 'Exclude From SLA' AND CP.attrVal = '1' AND CP.modified = 0
	DELETE  S FROM #TblStrikes S
	        INNER JOIN JMJobAction J WITH (NOLOCK) ON  S.appId = J.appId
	WHERE   J.opType = 4 AND J.action = 1
	DELETE  S FROM #TblStrikes S INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id
	        INNER JOIN JMJobAction J WITH (NOLOCK) ON A.clientId = J.clientId
	WHERE   J.opType = 4 AND J.action = 1 AND J.appType IN (A.AppTypeId, 0)
	DELETE  S FROM #TblStrikes S INNER JOIN APP_Application A WITH (NOLOCK) ON S.appId = A.id
	        INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON A.clientId = CGA.clientId
	        INNER JOIN JMJobAction J WITH (NOLOCK) ON CGA.clientGroupId = J.clientGroupId
	            AND J.clientGroupId > 0 AND J.ClientId = 1 AND J.AppType = 0 AND J.AppId = 1
	            AND J.opType = 4 AND J.action = 1
	IF @appType= 106
	BEGIN
		INSERT  INTO #TblLastFailedJob
		SELECT  V.clientId, MAX(CASE WHEN J.bkpLevel IN (1, 1024, 32768) THEN J.jobId ELSE 0 END), MAX(CASE WHEN J.bkpLevel IN (1, 1024, 32768) THEN 0 ELSE J.jobId END)
		FROM    JMBkpStats J WITH (NOLOCK)
		        INNER JOIN JMQinetixUpdateStatus V WITH (NOLOCK) ON J.jobId = V.jobId AND J.commCellId = V.commCellId AND V.status IN (1, 2, 4)
		        INNER JOIN APP_Client C WITH (NOLOCK) ON V.clientId = C.id
		        INNER JOIN APP_Application A ON J.appId = A.id AND (A.subclientStatus & (16|32|4|2) = 0)
		 WHERE  J.appType = 106 AND J.commCellId = 2 AND appId = @subClientID
		    AND J.bkpLevel NOT IN (64, 128, 16384)
		    AND J.status NOT IN (1, 14) AND (J.status <> 9 OR J.failureErrorCode = 8)
		    AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
		GROUP BY V.clientId
		INSERT INTO #TblStrikes
		SELECT  F.entityId, 0, 1, MAX(ISNULL(J.jobId, 0)), 0, NULL, F.fullJobId, 0, 0, 0, 0, NULL,NULL,NULL
		FROM    #TblLastFailedJob F
				LEFT OUTER JOIN APP_VMProp V WITH (NOLOCK) ON V.VMClientId = F.entityId AND V.attrName = 'vmStatus' AND V.attrVal IN ('0', '3')
				LEFT OUTER JOIN JMBkpStats J WITH (NOLOCK) ON J.jobId = V.jobId AND J.commCellId = V.commCellId
			AND J.appType = 106 AND J.commCellId = 2
			AND J.bkpLevel NOT IN (64, 128, 16384)
			AND J.status IN (1,3 ,14) AND J.failureErrorCode <> 8
			AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
		GROUP BY F.entityId, F.fullJobId
		HAVING  MAX(ISNULL(J.jobId, 0)) < F.fullJobId
		INSERT INTO #TblStrikes
		SELECT  F.entityId, 0, 2, MAX(ISNULL(J.jobId, 0)), 0, NULL, F.incrJobId, 0, 0, 0, 0, NULL,NULL,NULL
		FROM    #TblLastFailedJob F
		        INNER JOIN APP_Client C WITH (NOLOCK) ON F.entityId = C.id
		        LEFT OUTER JOIN JMQinetixUpdateStatus V WITH (NOLOCK) ON V.clientId = F.entityId AND V.status IN (0, 3)
		        LEFT OUTER JOIN JMBkpStats J WITH (NOLOCK) ON J.jobId = V.jobId AND J.commCellId = V.commCellId
		    AND J.appType = 106 AND J.commCellId = 2
		    AND J.bkpLevel NOT IN (64, 128, 16384)
		    AND J.status IN (1,3 ,14) AND (J.status <> 9 OR J.failureErrorCode = 8)
		    AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
		GROUP BY F.entityId, F.incrJobId
		HAVING  MAX(ISNULL(J.jobId, 0)) < F.incrJobId
		--DROP TABLE #TblLastFailedJob
		INSERT  INTO #TblFailedJobStats
		SELECT  F.VMClientId, F.strikeType, COUNT(J.jobId), MIN(J.servStartDate)
		FROM    JMBkpStats J WITH (NOLOCK)
		        INNER JOIN JMQinetixUpdateStatus V WITH (NOLOCK) ON J.jobId = V.jobId AND J.commCellId = V.commCellId AND V.status IN (1, 2, 4)
		        INNER JOIN #TblStrikes F ON V.clientId = F.VMClientId
		        INNER JOIN APP_Application A ON J.appId = A.id AND (A.subclientStatus & (16|32|4|2) = 0)
		WHERE   (F.strikeType = 1 AND J.bkpLevel IN (1, 1024, 32768) OR F.strikeType = 2 AND J.bkpLevel NOT IN (1, 64, 128, 16384, 1024, 32768))
		    AND J.status NOT IN (1, 14) AND (J.status <> 9 OR J.failureErrorCode = 8)
		    AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND J.commCellId = 2
		    AND J.jobId > F.lastSuccJobId
		GROUP BY F.VMClientId, F.strikeType
		HAVING COUNT(J.jobId) > 0
		UPDATE  #TblStrikes
		SET     nFailedJobs = F.nFailedJobs
		FROM    #TblStrikes A INNER JOIN #TblFailedJobStats F ON A.VMClientId = F.entityId AND A.strikeType = F.strikeType
		--DROP TABLE #TblFailedJobStats
	END
	UPDATE  #TblStrikes
	SET     appId = J.appId, lastJobBkpLvl = J.bkpLevel, lastJobStart = J.servStartDate, lastJobEnd = J.servEndDate, lastJobStatus = J.status, failureReason = J.failureReason
	FROM    #TblStrikes S INNER JOIN JMBkpStats J WITH (NOLOCK) ON S.lastJobId = J.jobId AND J.commCellId = 2
	UPDATE  #TblStrikes
	SET     lastSJobStart = J.servStartDate, lastSJobEnd = J.servEndDate
	FROM    #TblStrikes S INNER JOIN JMBkpStats J WITH (NOLOCK) ON S.lastSuccJobId = J.jobId AND J.commCellId = 2
	AND J.commCellId = 2 and S.lastSuccJobId>0
	DELETE  S FROM #TblStrikes S
        INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON S.vmClientId = CP.componentNameId AND CP.attrName = 'Exclude From SLA' AND CP.attrVal = '1' AND CP.modified = 0
	-- Exclude VMs if the VSA subclient is deconfigured or disabled for backup or excluded from SLA
	DELETE  #TblStrikes
	FROM    #TblStrikes F INNER JOIN
	        (SELECT S.appId
	        FROM    APP_Application A WITH (NOLOCK)
	                INNER JOIN (SELECT DISTINCT appId FROM #TblStrikes WHERE VMClientId > 0) S ON A.id = S.appId AND A.appTypeId = 106
	        WHERE   A.dataArchGrpId <= 1
	            OR (A.subclientStatus & (2|4)) > 0
	            OR EXISTS (SELECT * FROM JMJobAction WITH (NOLOCK) WHERE opType = 4 AND action = 1 AND (clientId = A.ClientId AND appType IN (A.AppTypeId, 0) OR appId = A.id))
	            OR A.clientId IN (SELECT DISTINCT CGA.clientId FROM JMJobAction J WITH (NOLOCK) INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK)
	                    ON CGA.clientGroupId = J.clientGroupId
	                    AND J.clientGroupId > 0 AND J.ClientId = 1 AND J.AppType = 0 AND J.AppId = 1
	                    AND J.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND J.action = 1)
	            OR A.id IN (SELECT componentNameId FROM APP_SubclientProp WITH (NOLOCK) WHERE attrName = 'Exclude From SLA' AND attrVal = '1' AND modified = 0)
	        ) T ON F.appId = T.appId AND F.vmClientId > 0
	DELETE  #TblStrikes
	FROM    #TblStrikes S
	        INNER JOIN APP_Application A WITH (NOLOCK) ON A.clientId = S.vmClientId AND A.appTypeId <> 106
	        INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.appId = A.id AND B.servStartDate > S.lastJobStart
	        AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101) AND B.commCellId = 2
	SET @IsSLAMissed = 1
	SELECT @isSLAMissed = (CASE WHEN status = 2 THEN 1 ELSE 0 END) FROM RptSLASubclient (NOLOCK) WHERE appId = @subClientID AND fullJobsOnly = 0
	IF EXISTS (SELECT 1 FROM #TblStrikes)
	BEGIN
		SELECT  ISNULL(F.appId,@subClientID) as subClientID,
				@isSLAMissed as IsSlaMissed,
				ISNULL(F.nFailedJobs,0) as StrikeCount ,
				ISNULL((SELECT attrVal FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @subClientID AND attrName = @ScPropAttrName AND modified = 0),0) as EstimatedRunTime
		FROM    #TblStrikes F
		ORDER BY CASE WHEN F.nFailedJobs > 3 THEN 3 ELSE F.nFailedJobs END DESC
	END
	ELSE
	BEGIN
		SELECT @subClientID as subClientID, @isSLAMissed as IsSlaMissed, 0 as StrikeCount,ISNULL((SELECT attrVal FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @subClientID AND attrName = @ScPropAttrName AND modified = 0),0) as EstimatedRunTime
	END
	DROP TABLE #TblStrikes
	DROP TABLE #TblFailedJobStats
	DROP TABLE #TblLastFailedJob
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetDynamicPriorityConfig')
	delete from GxQscripts where name = 'JMGetDynamicPriorityConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetDynamicPriorityConfig')
	delete from GXDBVersions where aliasname = 'JMGetDynamicPriorityConfig'
GO

insert into GXDBVersions values(2, 'JMGetDynamicPriorityConfig',  '00000000000000000000', 'JMGetDynamicPriorityConfig', '00000000000000000000')
GO

