

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetDataCopiedInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetDataCopiedInfo.sp,v $ $Id: JMGetDataCopiedInfo.sp,v 1.6.2.13 2019/05/09 20:17:12 chandru Exp $";
---- =============================================
---- Author:		Jaya Rama Raju Inavolu
---- Description:	Get the data copied info.
---- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetDataCopiedInfo')
BEGIN
	print '>>> Drop Stored Procedure: JMGetDataCopiedInfo <<<'
	drop procedure JMGetDataCopiedInfo
END
IF EXISTS (select * from GxQscripts where name='JMGetDataCopiedInfo')
	delete from GxQscripts where name = 'JMGetDataCopiedInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetDataCopiedInfo')
	delete from GXDBVersions where aliasname = 'JMGetDataCopiedInfo'
GO
print '... Creating Procedure: JMGetDataCopiedInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetDataCopiedInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId INT,
  @localeId INT,
  @inXMl XML
AS
BEGIN
  DECLARE @outXml XML 
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @jobId		INT
DECLARE @commcellId INT
SET @jobId = ISNULL((SELECT ref.value('@jobId', 'INTEGER') FROM @inXMl.nodes('JobManager_AdvanceJobDetailsReq') R(ref)), 0)
SET @commcellId = ISNULL((SELECT ref.value('@commCellId', 'INTEGER') FROM @inXMl.nodes('JobManager_AdvanceJobDetailsReq') R(ref)), 2)
IF OBJECT_ID('tempdb.dbo.#DataCopiedStats') IS NOT NULL
	DROP TABLE #DataCopiedStats
CREATE TABLE #DataCopiedStats
(
	archGrpCopyId		INT,
	streamCopyId		INT, -- This is mapped to GACP copy Id so that it can be looked up from JMJobStreams table.
	BytesXferred		BIGINT,
	mediaUsageTime		INT,
	dataToCopy			BIGINT,
	muxFactor			INT,
	destCombinedStreams	INT,
	failureReason		VARCHAR(256),
	copyName			NVARCHAR(MAX),
	srcCopyId			INT,
	SIDBStoreId			INT,
	totalChunks INTEGER DEFAULT 0,
	totalProcessedChunks INTEGER DEFAULT 0,
	totalSentChunks INTEGER DEFAULT 0,
	totalSkippedChunks INTEGER DEFAULT 0,
	totalSkippedAgedChunks INTEGER DEFAULT 0,
	totalSkippedDisabledChunks INTEGER DEFAULT 0,
	totalFailedChunks INTEGER DEFAULT 0,
	totalPopulatedChunks INTEGER DEFAULT 0,
	Status				INTEGER DEFAULT 0,
	someDataSkippedOrFailed				INTEGER DEFAULT 0
)
INSERT INTO #DataCopiedStats (archGrpCopyId, streamCopyId, BytesXferred, mediaUsageTime, dataToCopy, muxFactor, destCombinedStreams, failureReason, copyName, srcCopyId, SIDBStoreId)
SELECT	archGrpCopyId,
		(
			CASE
WHEN AGC.extendedFlags & 2 = 2 THEN AGC.destMediaCopyId
				ELSE archGrpCopyId
			END
		),
		BytesXferred,
		mediaUsageTime,
		dataToCopy,
		muxFactor,
		destCombinedStreams,
		failureReason,
		copyName,
		srcCopyId,
		ISNULL(CS.SIDBStoreId,0)
FROM
JMDataCopiedStatsTable JMDC
LEFT OUTER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON JMDC.archGrpCopyID = AGC.id
LEFT OUTER JOIN archCopySIDBStore  CS WITH (READUNCOMMITTED) ON CS.copyId = AGC.id AND ((CS.Flags & (2|4)) = (2|4))
WHERE JMDC.jobId = @jobId AND JMDC.commCellId = @commcellId
AND ((AGC.extendedFlags & 1 = 0) OR (AGC.id IS NULL))
IF EXISTS (SELECT	*
			FROM	JMJobStats WITH (READUNCOMMITTED)
		WHERE	JobId = @JobId
				AND CommCellId = @CommCellId
				AND opType = 104 /*AUXCOPY2*/)
BEGIN
	DECLARE @MAX_FAILURE_COUNT INT = 3
		SELECT  TOP 1 @MAX_FAILURE_COUNT = ISNULL(value, 3)
		FROM    MMConfigs WITH (READUNCOMMITTED)
		WHERE   name = 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT'
	UPDATE	D
	SET		totalChunks = T.totalChunks,
			totalPopulatedChunks = T.totalPopulatedChunks,
			totalSentChunks = T.totalSentChunks,
			totalProcessedChunks = T.totalProcessedChunks,
			totalSkippedChunks = T.totalSkippedChunks,
			totalSkippedAgedChunks = T.totalSkippedAgedChunks,
			totalSkippedDisabledChunks = T.totalSkippedDisabledChunks,
			totalFailedChunks = T.totalFailedChunks
	FROM	#DataCopiedStats D,
			(SELECT	DestCopyId,
					totalChunks = COUNT(*),
totalPopulatedChunks = ISNULL(SUM(CASE WHEN archChunkToReplicate.Status = 0 THEN  1 ELSE 0 END), 0),
totalSentChunks = ISNULL(SUM(CASE WHEN archChunkToReplicate.Status = 1 THEN  1 ELSE 0 END), 0),
totalProcessedChunks = ISNULL(SUM(CASE WHEN archChunkToReplicate.Status = 2 THEN  1 WHEN archChunkToReplicate.Status = 9 THEN  1 ELSE 0 END), 0),
totalSkippedChunks = ISNULL(SUM(CASE WHEN archChunkToReplicate.Status = 3 AND (archChunkToReplicate.SkippedCount < @MAX_FAILURE_COUNT OR archChunkToReplicate.ExtraFlags & 64 > 0)
OR archChunkToReplicate.Status = 5 AND (archChunkToReplicate.SkippedCount < @MAX_FAILURE_COUNT OR archChunkToReplicate.ExtraFlags & 64 > 0) THEN  1 ELSE 0 END), 0),
totalSkippedAgedChunks = ISNULL(SUM(CASE WHEN archChunkToReplicate.Status = 6 THEN  1 ELSE 0 END), 0),
totalSkippedDisabledChunks = ISNULL(SUM(CASE WHEN archChunkToReplicate.Status = 7 THEN  1 ELSE 0 END), 0),
totalFailedChunks = ISNULL(SUM(CASE WHEN (archChunkToReplicate.Status = 4
OR archChunkToReplicate.Status = 5 AND archChunkToReplicate.SkippedCount >= @MAX_FAILURE_COUNT AND archChunkToReplicate.ExtraFlags & 64 = 0
OR archChunkToReplicate.Status = 8
OR archChunkToReplicate.Status = 3 AND archChunkToReplicate.SkippedCount >= @MAX_FAILURE_COUNT AND archChunkToReplicate.ExtraFlags & 64 = 0) THEN  1 ELSE 0 END), 0)
			FROM	archChunkToReplicate WITH (READUNCOMMITTED)
			WHERE	adminJobID = @jobId
			GROUP BY DestCopyId) T
	WHERE	D.archGrpCopyId = T.DestCopyId
	UPDATE	D
	SET		totalChunks += T.totalChunks,
			totalProcessedChunks += T.totalProcessedChunks
	FROM	#DataCopiedStats D,
			(SELECT	DestCopyId,
					totalChunks = COUNT(*),
totalProcessedChunks = ISNULL(SUM(CASE WHEN archChunkToReplicateHistory.Status = 2 THEN  1 WHEN archChunkToReplicateHistory.Status = 9 THEN  1 ELSE 0 END), 0)
			FROM	archChunkToReplicateHistory WITH (READUNCOMMITTED)
			WHERE	adminJobID = @jobId
			GROUP BY DestCopyId) T
	WHERE	D.archGrpCopyId = T.DestCopyId
	UPDATE	#DataCopiedStats
	SET		Status = (CASE 	WHEN (totalPopulatedChunks > 0 OR totalSkippedChunks > 0 OR totalSentChunks > 0) THEN
								CASE	WHEN (totalPopulatedChunks = 0 AND totalSentChunks = 0) THEN 10 --DASHCOPY_ARCHMGR_MORE_TO_COPY_ALL_SKIPPED
										ELSE 3 --DASHCOPY_ARCHMGR_MORE_TO_COPY -- More to process
								END
							WHEN (totalChunks = totalProcessedChunks) THEN 4 --DASHCOPY_ARCHMGR_JOB_SUCCESS -- SUCCESS
							WHEN (totalChunks = totalFailedChunks) THEN 5 --DASHCOPY_ARCHMGR_JOB_FAIL -- FAILED
							WHEN (totalFailedChunks = 0 AND totalSkippedChunks = 0 AND (totalSkippedAgedChunks > 0 OR totalSkippedDisabledChunks > 0)) THEN 9 --DASHCOPY_ARCHMGR_JOB_CWW -- CWW
							ELSE 6 --DASHCOPY_ARCHMGR_JOB_CWE -- PARTIALSUCCESS
					 END),
			someDataSkippedOrFailed = (CASE WHEN totalFailedChunks > 0 OR totalSkippedChunks > 0 OR totalSkippedAgedChunks > 0 OR totalSkippedDisabledChunks > 0 THEN 1 ELSE 0 END)
END
SET @outXml =
(
SELECT
	BytesXferred	'@dataCopied',
	mediaUsageTime	'@mediaUsageTime',
	dataToCopy		'@dataToBeCopied',
	ISNULL((select COUNT(*) from JMJobStreams JS(READUNCOMMITTED) where JS.status = 1/*STREAMACTIVE*/ and JS.jobId = @jobId and JS.destCopyId = DC.streamCopyId and JS.srcCopyId = DC.srcCopyId),0) '@noOfRunningStreams',
	muxFactor		'@muxFactor',
	destCombinedStreams	'@destinationStreams',
	ISNULL((select sum(throughput) from JMJobStreams JS(READUNCOMMITTED) where JS.status = 1/*STREAMACTIVE*/ and JS.jobId = @jobId and JS.destCopyId = streamCopyId and JS.srcCopyId = DC.srcCopyId),0) '@overallThroughput',
	dbo.JMGetLocalizedMessageFunc(@localeId, failureReason) '@failureReason',
	Status			'@status',
	someDataSkippedOrFailed '@someDataSkippedOrFailed',
	(select SIDBStoreAliasName from IdxSIDBStore WITH (READUNCOMMITTED)  WHERE IdxSIDBStore.SIDBStoreId = DC.SIDBStoreId) '@ddbStore',
	(SELECT
	archGrpCopyId	'@copyId',
	copyName		'@copyName'
	FOR XML PATH('destinationCopy'), TYPE),
	(SELECT
	srcCopyId		'@copyId',
	(select name From archGroupCopy(READUNCOMMITTED) where id = srcCopyId) '@copyName'
	FOR XML PATH('sourceCopy'),TYPE)
	FROM  #DataCopiedStats DC
	FOR XML PATH('copyInfo'), ROOT('JobManager_ArchDataInfo')
)
IF @outXml IS NULL
	SET @outXml = '<JobManager_ArchCopyInfo/>'
SELECT @outXml
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetDataCopiedInfo')
	delete from GxQscripts where name = 'JMGetDataCopiedInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetDataCopiedInfo')
	delete from GXDBVersions where aliasname = 'JMGetDataCopiedInfo'
GO

insert into GXDBVersions values(2, 'JMGetDataCopiedInfo',  '00010006000200130000', 'JMGetDataCopiedInfo', '00010006000200130000')
GO

