

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetDANForMultiNodeCIStartedFromDCPlan.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +=================================================================================+
--  |   Procedure:  JMGetDANForMultiNodeCIStartedFromDCPlan()
--  |
--  | Description:  Gets the data access for multi node content indexing job started
--  |				from data collection plan.
--  |
--  |       Input:  commcellId, dcPlanId
--  |
--  |      Output:  data access node client ids and names
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------------------	        --------------------------------
--  |   1.1        Jawahar Ragunathan           Initial Edit
--  +=================================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMGetDANForMultiNodeCIStartedFromDCPlan')
BEGIN
	print '>>> Drop Stored Procedure: JMGetDANForMultiNodeCIStartedFromDCPlan <<<'
	drop procedure JMGetDANForMultiNodeCIStartedFromDCPlan
END
IF EXISTS (select * from GxQscripts where name='JMGetDANForMultiNodeCIStartedFromDCPlan')
	delete from GxQscripts where name = 'JMGetDANForMultiNodeCIStartedFromDCPlan'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetDANForMultiNodeCIStartedFromDCPlan')
	delete from GXDBVersions where aliasname = 'JMGetDANForMultiNodeCIStartedFromDCPlan'
GO
print '... Creating Procedure: JMGetDANForMultiNodeCIStartedFromDCPlan'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMGetDANForMultiNodeCIStartedFromDCPlan
  @i_commcellId INT,
  @i_dcPlanId INT,
  @i_userId INT
AS
  DECLARE @dataAccessNodeId INT
  DECLARE @dataAccessNodeName NVARCHAR(255)
SET NOCOUNT ON
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF OBJECT_ID('tempdb.dbo.#DCPlanInfoSubclientInfoTbl') IS NOT NULL DROP TABLE #DCPlanInfoSubclientInfoTbl
	IF OBJECT_ID('tempdb.dbo.#AccessNodesInfoTbl') IS NOT NULL DROP TABLE #AccessNodesInfoTbl
	CREATE TABLE #DCPlanInfoSubclientInfoTbl (id INT NOT NULL IDENTITY PRIMARY KEY, subclientId INT, subclientName NVARCHAR(255), appTypeId INT,backupSetId INT, instanceId INT, clientId INT, storagePolicyId INT)
	CREATE TABLE #AccessNodesInfoTbl (dataAccessNodeId INT ,  dataAccessNodeName NVARCHAR(255))
	--Populate #DCPlanInfoSubclientInfoTbl
	EXEC dbo.AppGetDCPlanEntitiesForCIJobPrologue @i_userId, 0, @i_dcPlanId, @i_commcellId
	SELECT DISTINCT dataAccessNodeId, dataAccessNodeName FROM #AccessNodesInfoTbl
	IF OBJECT_ID('tempdb.dbo.#AccessNodesInfoTbl') IS NOT NULL DROP TABLE #AccessNodesInfoTbl
	IF OBJECT_ID('tempdb.dbo.#DCPlanInfoSubclientInfoTbl') IS NOT NULL DROP TABLE #DCPlanInfoSubclientInfoTbl
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetDANForMultiNodeCIStartedFromDCPlan')
	delete from GxQscripts where name = 'JMGetDANForMultiNodeCIStartedFromDCPlan'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetDANForMultiNodeCIStartedFromDCPlan')
	delete from GXDBVersions where aliasname = 'JMGetDANForMultiNodeCIStartedFromDCPlan'
GO

insert into GXDBVersions values(2, 'JMGetDANForMultiNodeCIStartedFromDCPlan',  '00000000000000000000', 'JMGetDANForMultiNodeCIStartedFromDCPlan', '00000000000000000000')
GO

