

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetConflictingPatchDownloadJobList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  JMGetConflictingPatchDownloadJobList()
--  |				 Description:  Get the list of conflicting job for the calling job
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetConflictingPatchDownloadJobList.sp,v $ $Id: JMGetConflictingPatchDownloadJobList.sp,v 1.1.2.4 2020/08/24 15:16:36 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetConflictingPatchDownloadJobList')
BEGIN
	print '>>> Drop Stored Procedure: JMGetConflictingPatchDownloadJobList <<<'
	drop procedure JMGetConflictingPatchDownloadJobList
END
IF EXISTS (select * from GxQscripts where name='JMGetConflictingPatchDownloadJobList')
	delete from GxQscripts where name = 'JMGetConflictingPatchDownloadJobList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetConflictingPatchDownloadJobList')
	delete from GXDBVersions where aliasname = 'JMGetConflictingPatchDownloadJobList'
GO
print '... Creating Procedure: JMGetConflictingPatchDownloadJobList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetConflictingPatchDownloadJobList
  @i_jobId integer,
  @i_commCellId integer
AS
	SET NOCOUNT ON
  DECLARE @jobId integer
	DECLARE	@isDownloadSoftware	integer
	DECLARE	@isSyncCache		integer
DECLARE @csId INT = ISNULL((select TOP 1 clientid from APP_Platform WITH (NOLOCK) where (platformType & 1) =1 order by clientid ASC), 0)
	if object_id('tempdb.dbo.#conflictingJobs') is not null DROP TABLE #conflictingJobs
	CREATE TABLE #conflictingJobs
	(
		jobId			integer
	)
	CREATE CLUSTERED  INDEX idx_conflictingJobsJobId ON #conflictingJobs(jobId)
	if object_id('tempdb.dbo.#clientListToRun') is not null DROP TABLE #clientListToRun
	CREATE TABLE #clientListToRun
	(
		clientId		integer,
		type			integer,
		flag			integer
	)
	CREATE CLUSTERED  INDEX idx_clientListToRunClientId ON #clientListToRun(clientId)
	if object_id('tempdb.dbo.#clientListRunning') is not null DROP TABLE #clientListRunning
	CREATE TABLE #clientListRunning
	(
		jobId			integer,
		clientId		integer,
		type			integer,
		flag			integer
	)
	CREATE CLUSTERED  INDEX idx_clientListRunningJobIdClientId ON #clientListRunning(jobid, clientId)
	if object_id('tempdb.dbo.#clientIdListToRun') is not null DROP TABLE #clientIdListToRun
	CREATE TABLE #clientIdListToRun
	(
		clientId				integer
	)
	CREATE CLUSTERED  INDEX idx_clientIdListToRunClientId ON #clientIdListToRun(clientId)
	if object_id('tempdb.dbo.#clientIdListRunning') is not null DROP TABLE #clientIdListRunning
	CREATE TABLE #clientIdListRunning
	(
		jobId			integer,
		clientId		integer
	)
	CREATE CLUSTERED  INDEX idx_clientIdListRunningJobIdClientId ON #clientIdListRunning(jobId, clientId)
	INSERT INTO #clientListToRun
	SELECT IsNULL(CONVERT(xml, value).value('(/clientAndClientGroups/@clientId)[1]', 'int'), 0) as clientId,
		CONVERT(xml, value).value('(/clientAndClientGroups/@_type_)[1]', 'int') as type,
		IsNULL(CONVERT(xml, value).value('(/clientAndClientGroups/flags[1]/@exclude)[1]', 'int'), 0) as flag
FROM GetJobOptionList(@i_jobId, 239177580)
SELECT @isDownloadSoftware = ISNULL(dbo.GetJobOption(@i_jobId, 786609819), 0)
SELECT @isSyncCache = ISNULL(dbo.GetJobOption(@i_jobId, 2080737598), 0)
	-- for download job, need to wait for all download/sync job to finish
	IF @isDownloadSoftware = 1
	BEGIN
		INSERT INTO #conflictingJobs
		SELECT jobid FROM JMJobInfo WHERE opType = 36  AND commCellId = @i_commCellId    -- 36 - PATCHDOWNLOAD
	END
	-- for sync job, if there is download job running, return it
	ELSE IF EXISTS(SELECT jobid FROM JMJobInfo
			WHERE opType = 36  AND commCellId = @i_commCellId    -- 36 - PATCHDOWNLOAD
AND ISNULL(dbo.GetJobOption(jobid, 786609819), 0) = 1)
	BEGIN
		INSERT INTO #conflictingJobs
		SELECT jobid FROM JMJobInfo
			WHERE opType = 36  AND commCellId = @i_commCellId    -- 36 - PATCHDOWNLOAD
AND ISNULL(dbo.GetJobOption(jobid, 786609819), 0) = 1
	END
	ELSE
	BEGIN
		IF EXISTS(SELECT * FROM #clientListToRun WHERE type = 2)   -- 2 - ALL_CLIENTS
		BEGIN
			INSERT INTO #clientIdListToRun
			SELECT distinct C.id FROM APP_Client C
				INNER JOIN simInstalledPackages simPkgs ON C.id = simPkgs.ClientId
				WHERE C.id not in ( 1, @csId, @i_commCellId)
				AND C.id NOT IN(SELECT clientId FROM #clientListToRun WHERE flag = 1 )  -- exclude - 1
		END
		INSERT INTO #clientIdListToRun
		SELECT clientId FROM #clientListToRun WHERE type = 3 AND flag <> 1   -- exclude - 1
		INSERT INTO #clientListRunning
		SELECT jobid, clientId, type, flag
		FROM
		(
			SELECT jobid FROM JMJobInfo WHERE opType = 36  AND commCellId = @i_commCellId     -- 36 - PATCHDOWNLOAD
		) AS JOBS
		CROSS APPLY
		(
			SELECT IsNULL(CONVERT(xml, value).value('(/clientAndClientGroups/@clientId)[1]', 'int'), 0) as clientId,
				CONVERT(xml, value).value('(/clientAndClientGroups/@_type_)[1]', 'int') as type ,
				IsNULL(CONVERT(xml, value).value('(/clientAndClientGroups/flags[1]/@exclude)[1]', 'int'), 0) as flag
FROM GetJobOptionList(JOBS.jobid, 239177580 )
		) AS JO
		IF EXISTS(SELECT * FROM #clientListRunning WHERE type = 2)   -- 2 - ALL_CLIENTS
		BEGIN
			INSERT INTO #clientIdListRunning
			SELECT distinct CLR.jobid, C.id FROM APP_Client C, simInstalledPackages simPkgs, #clientListRunning CLR
			WHERE CLR.type = 2 AND C.id = simPkgs.ClientId
				AND C.id not in ( 1, @csId, @i_commCellId)
				AND C.id NOT IN(SELECT clientId FROM #clientListRunning WHERE flag = 1 )  -- exclude - 1
		END
		INSERT INTO #clientIdListRunning
		SELECT jobId, clientId FROM #clientListRunning WHERE type = 3 AND flag <> 1   -- exclude - 1
		-- unless no client to run, figure out these already running and exclude them and run the job
		IF EXISTS(SELECT clientId FROM #clientIdListToRun WHERE clientId NOT IN(SELECT DISTINCT clientId FROM #clientIdListRunning) )
		BEGIN
			DECLARE @errorCode integer
			DECLARE @errorString NVARCHAR(MAX)
			DECLARE @taskId integer
			DECLARE @subTaskId integer
			DECLARE @lastJobId integer
			SELECT top 1 @taskId = taskId,  @subTaskId = subTaskId, @lastJobId = lastJobId FROM TM_JobOptions where jobid = @i_jobId AND optionid = 239177580
			DECLARE ClientListCur CURSOR FOR
			SELECT clientId FROM #clientIdListToRun WHERE clientId IN(SELECT DISTINCT clientId FROM #clientIdListRunning)
			DECLARE @clientId INT
			OPEN ClientListCur
			FETCH ClientListCur INTO @clientId
			WHILE   @@FETCH_STATUS = 0
			BEGIN
				DECLARE @opXmlText XML
				SET @opXmlText = ( SELECT name '@clientName', id '@clientId',  3 '@_type_', 1 'flags/@exclude'
					FROM App_client WHERE id = @clientId
					FOR XML PATH('clientAndClientGroups'))
				INSERT INTO TM_JobOptions(jobId, optionId, type, value, taskId, subTaskId, lastJobId, created, modified)
VALUES(@i_jobId , 239177580, 0, CONVERT(NVARCHAR(MAX), @opXmlText) , @taskId, @subTaskId, @lastJobId, DATEDIFF(s, '1970-01-01', GETUTCDATE()), 0)
				FETCH ClientListCur INTO @clientId
			END
		END
		ELSE
		BEGIN
			-- for sync job, return sync job containing same client
			INSERT INTO #conflictingJobs
			SELECT jobid FROM #clientIdListRunning WHERE clientId in (SELECT clientId FROM #clientIdListToRun)
		END
	END
	SELECT DISTINCT jobId FROM #conflictingJobs
	DROP TABLE #conflictingJobs
	DROP TABLE #clientListToRun
	DROP TABLE #clientListRunning
	DROP TABLE #clientIdListToRun
	DROP TABLE #clientIdListRunning
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetConflictingPatchDownloadJobList')
	delete from GxQscripts where name = 'JMGetConflictingPatchDownloadJobList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetConflictingPatchDownloadJobList')
	delete from GXDBVersions where aliasname = 'JMGetConflictingPatchDownloadJobList'
GO

insert into GXDBVersions values(2, 'JMGetConflictingPatchDownloadJobList',  '00010001000200040000', 'JMGetConflictingPatchDownloadJobList', '00010001000200040000')
GO

