

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetConflictingJobList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  JMGetConflictingJobList()
--  |				 Description:  Only selective job or streaming job will call this SP - not for snap backup
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetConflictingJobList.sp,v $ $Id: JMGetConflictingJobList.sp,v 1.1.2.6 2020/08/24 15:16:54 sjohnson Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetConflictingJobList')
BEGIN
	print '>>> Drop Stored Procedure: JMGetConflictingJobList <<<'
	drop procedure JMGetConflictingJobList
END
IF EXISTS (select * from GxQscripts where name='JMGetConflictingJobList')
	delete from GxQscripts where name = 'JMGetConflictingJobList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetConflictingJobList')
	delete from GXDBVersions where aliasname = 'JMGetConflictingJobList'
GO
print '... Creating Procedure: JMGetConflictingJobList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetConflictingJobList
  @i_jobId integer,
  @i_appId integer,
  @i_bkpAttributesEx bigint,
  @i_commCellId integer
AS
	SET NOCOUNT ON
  DECLARE @jobId integer
  DECLARE @opType integer
  DECLARE @bkpLevel integer
  DECLARE @bkpAttributesEx bigint
	if object_id('tempdb.dbo.#conflictingJobs') is not null DROP TABLE #conflictingJobs
	CREATE TABLE #conflictingJobs
	(
		jobId				integer,
		opType				integer,
		bkpLevel			integer,
		bkpAttributesEx		bigint,
	)
	CREATE CLUSTERED  INDEX idx_conflictingJobsJobId ON #conflictingJobs(jobId)
	DECLARE @vmGuid nvarchar(255)
	DECLARE @xml_options xml
SELECT TOP 1 @xml_options = CONVERT(xml, value) FROM GetJobOptionList(@i_jobId, 765158193)
	SET @vmGuid = ISNULL(@xml_options.value('(//./selectiveVMInfo/@vmGuid)[1]','nvarchar(255)'), '')
	-- for VM selective job, if other jobs was running at VM level, need to wait for it to complete
   -- except for synthtic full, which allows other jobs like inc, diff, full backup job to run in parallel
	INSERT INTO #conflictingJobs
	SELECT JBKP.jobId,
		JI.opType,
		JBKP.bkpLevel,
		JBKP.bkpAttributesEx
	FROM JMBkpJobInfo JBKP WITH (NOLOCK)
		INNER JOIN JMJobInfo JI WITH (NOLOCK) ON JBKP.jobId = JI.jobId AND JBKP.commcellId = JI.commcellId
		INNER JOIN APP_Application APP WITH (NOLOCK) ON JBKP.applicationId = APP.id
		INNER JOIN App_clientProp P WITH (NOLOCK) ON P.componentNameId = APP.clientId
		INNER JOIN APP_VMBackupSet VMBS WITH (NOLOCK) ON VMBS.VMClientId = APP.clientId AND VMBS.ChildBackupSetId = APP.BackupSet
		INNER JOIN APP_Application APP2 WITH (NOLOCK) ON APP2.BackupSet = VMBS.ParentBackupSetId
	WHERE JBKP.commCellId = @i_commCellId
		AND P.attrName = 'Virtual Machine Instance UUID' AND P.modified =0
		AND P.attrVal = @vmGuid
		AND P.modified = 0
		AND APP2.id = @i_appId
		AND JI.opType <> 14  -- SYNTHFULL
	-- for VM seletive job, if job from same VM, then need to wait for it
	INSERT INTO #conflictingJobs
		SELECT JBKP.jobId,
			JI.opType,
			JBKP.bkpLevel,
			JBKP.bkpAttributesEx
		FROM JMBkpJobInfo JBKP WITH (NOLOCK)
			INNER JOIN JMJobInfo JI WITH (NOLOCK) ON JBKP.jobId = JI.jobId AND JBKP.commcellId = JI.commcellId
		WHERE JBKP.applicationId = @i_appId
			AND JBKP.commcellId = @i_commCellId
			AND JI.jobId <> @i_jobId
AND EXISTS(SELECT 1 FROM GetJobOptionList(JBKP.jobId, 765158193) WHERE value LIKE '%' + @vmGuid + '%' )
	SELECT DISTINCT jobId, opType, bkpLevel, bkpAttributesEx FROM #conflictingJobs
	DROP TABLE #conflictingJobs
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetConflictingJobList')
	delete from GxQscripts where name = 'JMGetConflictingJobList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetConflictingJobList')
	delete from GXDBVersions where aliasname = 'JMGetConflictingJobList'
GO

insert into GXDBVersions values(2, 'JMGetConflictingJobList',  '00010001000200060000', 'JMGetConflictingJobList', '00010001000200060000')
GO

