

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetCommittedJobDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2008  CommVault Systems, Inc.
--                  All rights reserved.
--  +========================================================================+
--  |      Name	 :  JMGetCommittedJobDetails
--  |
--  | Description:
--	|
--  |	   Input :	inCommcellId, inJobId
--	|
--  |      Output:  outLastCommittedJobInCycle,outLastCommittedJobBackupLevel
--	|
--  |   Revisions  Author      Description
--  |   ---------  -------  ---------------------------------------------
--  |     1.1      Hemant Mishra
--  +========================================================================+
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetCommittedJobDetails.sp,v $ $Id: JMGetCommittedJobDetails.sp,v 1.7.2.9 2019/11/01 22:02:06 jragunathan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetCommittedJobDetails')
BEGIN
	print '>>> Drop Stored Procedure: JMGetCommittedJobDetails <<<'
	drop procedure JMGetCommittedJobDetails
END
IF EXISTS (select * from GxQscripts where name='JMGetCommittedJobDetails')
	delete from GxQscripts where name = 'JMGetCommittedJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetCommittedJobDetails')
	delete from GXDBVersions where aliasname = 'JMGetCommittedJobDetails'
GO
print '... Creating Procedure: JMGetCommittedJobDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetCommittedJobDetails
  @inCommcellId integer,
  @inJobId integer
AS
  DECLARE @outLastCommittedJobInCycle integer
  DECLARE @outLastCommittedJobBackupLevel integer
	DECLARE @bkpLvl integer
	DECLARE @appId integer = 0
	DECLARE @lastSuccessfulBkpTime integer = 0
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SELECT TOP 1 @bkpLvl = bkpLevel, @appId = applicationId FROM JMBkpJobInfo WHERE jobId = @inJobId AND commcellId = @inCommcellId
	IF @bkpLvl <> 4  -- 4 is DIFFERENTIAL
	BEGIN
		SELECT @lastSuccessfulBkpTime = ISNULL(MAX(servEndDate),0) FROM JMBkpStats WHERE commCellId = @inCommcellId AND appId = @appId AND status in (1,3,14)  AND displayStatus <> 16 AND (bkpAttributesEx & 0x10000000000/*JMBKP_EX_AS_HOC_BACKUP*/) = 0 AND optype = 4
		SELECT TOP 1 jobId, bkpLevel FROM JMBkpStats
		WHERE
			appId = @appId AND commCellId = @inCommcellId
			AND (
				displaystatus = 16  -- COMMITTED
					OR
((bkpAttributesEx & 0x1000000 <> 0) AND status IN (1,3,14))
			)
			AND (bkpAttributesEx & 0x10000000000/*JMBKP_EX_AS_HOC_BACKUP*/) = 0
			AND servEndDate >= @lastSuccessfulBkpTime
		ORDER BY fullCycleNum desc, cycleSequence DESC
	END
	ELSE
	BEGIN
		-- Check if last full/synth full job was committed.
SELECT @lastSuccessfulBkpTime = ISNULL(MAX(servEndDate),0) FROM JMBkpStats WHERE commCellId = @inCommcellId AND appId = @appId AND status in (1,3,14) AND displayStatus <> 16 AND (bkpAttributesEx & 0x10000000000/*JMBKP_EX_AS_HOC_BACKUP*/) = 0 AND bkpLevel IN(1, 64, 128) AND bkpAttributesEx & 0x1000000 = 0
		SELECT TOP 1 jobId, bkpLevel FROM JMBkpStats
		WHERE
			appId = @appId AND commCellId = @inCommcellId
			AND	(
				bkpLevel = 1 AND displaystatus = 16  -- COMMITTED
					OR
((bkpAttributesEx & 0x1000000 <> 0) AND status IN (1,3,14))
			)
			AND (bkpAttributesEx & 0x10000000000/*JMBKP_EX_AS_HOC_BACKUP*/) = 0
			AND servEndDate >= @lastSuccessfulBkpTime
		ORDER BY fullCycleNum desc, cycleSequence DESC
	END
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetCommittedJobDetails')
	delete from GxQscripts where name = 'JMGetCommittedJobDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetCommittedJobDetails')
	delete from GXDBVersions where aliasname = 'JMGetCommittedJobDetails'
GO

insert into GXDBVersions values(2, 'JMGetCommittedJobDetails',  '00010007000200090000', 'JMGetCommittedJobDetails', '00010007000200090000')
GO

