

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetClientThrottleSettings.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetClientThrottleSettings.sp,v $ $Id: JMGetClientThrottleSettings.sp,v 1.1.2.3 2020/08/18 05:48:21 sbonilla Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "JMGetClientThrottleSettings"				|
--	|									|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetClientThrottleSettings')
BEGIN
	print '>>> Drop Stored Procedure: JMGetClientThrottleSettings <<<'
	drop procedure JMGetClientThrottleSettings
END
IF EXISTS (select * from GxQscripts where name='JMGetClientThrottleSettings')
	delete from GxQscripts where name = 'JMGetClientThrottleSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetClientThrottleSettings')
	delete from GXDBVersions where aliasname = 'JMGetClientThrottleSettings'
GO
print '... Creating Procedure: JMGetClientThrottleSettings'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetClientThrottleSettings
  @inClientId integer
AS
  DECLARE @outJobThrottleEnabled integer
  DECLARE @outDataThresHold integer
  DECLARE @outLogThresHold integer
  DECLARE @outClientGroupId integer
  DECLARE @outClientGroupName nvarchar(1024)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
    IF  object_id('tempdb.dbo.#tempAppClientProp') is not null DROP TABLE #tempAppClientProp
CREATE TABLE #tempAppClientProp (jobThrottleEnabled INT, dataJobThrottle INT, logJobThrottle INT, clientGroupId INT, clientGroupName NVARCHAR(1024))
	CREATE CLUSTERED INDEX tempAppClientProp_jobThrottleEnabled_IDX on #tempAppClientProp(jobThrottleEnabled);
    -- Get data from App_ClientProp table
	INSERT INTO #tempAppClientProp
	(jobThrottleEnabled, dataJobThrottle, logJobThrottle, clientGroupId, clientGroupName)
    SELECT
		ISNULL([Throttle Jobs Enabled],0)                   AS jobThrottleEnabled,
		ISNULL([Throttle Jobs - Data Threshold],1)          AS dataJobThrottle,
		ISNULL([Throttle Jobs - Log Threshold],1)           AS logJobThrottle,
		0 clientGroupId,
		'' clientGroupName
        FROM
        (
            SELECT  componentNameId, attrName, attrVal
            FROM    App_ClientProp
            WHERE   componentNameId = @inClientId
            AND     modified = 0
        ) AS clients
        PIVOT
        (
            MAX(attrVal)
            FOR attrName IN
            (
                [Throttle Jobs Enabled],
                [Throttle Jobs - Data Threshold],
                [Throttle Jobs - Log Threshold]
            )
        ) AS pvt
	INSERT INTO #tempAppClientProp
	(jobThrottleEnabled, dataJobThrottle, logJobThrottle, clientGroupId, clientGroupName)
	SELECT
CASE WHEN P.propertyTypeId = 3650 THEN longVal ELSE 0 END jobThrottleEnabled,
CASE WHEN P.propertyTypeId = 3651 THEN longVal ELSE 0 END dataJobThrottle,
CASE WHEN P.propertyTypeId = 3652 THEN longVal ELSE 0 END logJobThrottle,
		G.id, G.name
	FROM APP_ComponentProp P
	JOIN APP_ClientGroupAssoc A ON A.clientGroupId = P.componentId
	JOIN APP_ClientGroup G ON A.clientGroupId = G.id
AND P.componentType = 8
	AND P.modified = 0
	AND A.clientId = @inClientId
	--GET CLIENT THE ROW WITH THROTTLE ENABLED
	SELECT TOP 1 @outClientGroupId=clientGroupId, @outJobThrottleEnabled=jobThrottleEnabled, @outClientGroupName = clientGroupName
	FROM #tempAppClientProp
	WHERE jobThrottleEnabled&1 = 1	--CV_PROP_JOB_THROTTLE_ENABLED
	ORDER BY clientGroupId, dataJobThrottle, logJobThrottle DESC	--ORDER BY CLIENT GROUP FIRST SO THAT CLIENT INFO WILL BE ON TOP SINCE THE CG ID WILL BE 0
	--GET THROTTLE INFO FOR THAT ROW
	SELECT @outDataThresHold=MAX(dataJobThrottle), @outLogThresHold=MAX(logJobThrottle)
	FROM #tempAppClientProp
	WHERE clientGroupId = @outClientGroupId
	SELECT @outJobThrottleEnabled, @outDataThresHold, @outLogThresHold, @outClientGroupId, @outClientGroupName
    IF  object_id('tempdb.dbo.#tempAppClientProp') is not null DROP TABLE #tempAppClientProp
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetClientThrottleSettings')
	delete from GxQscripts where name = 'JMGetClientThrottleSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetClientThrottleSettings')
	delete from GXDBVersions where aliasname = 'JMGetClientThrottleSettings'
GO

insert into GXDBVersions values(2, 'JMGetClientThrottleSettings',  '00010001000200030000', 'JMGetClientThrottleSettings', '00010001000200030000')
GO

