

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetClientThrottleInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetClientThrottleInfo.sp,v $ $Id: JMGetClientThrottleInfo.sp,v 1.1.2.10.8.2 2021/03/13 03:01:42 hmishra Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "JMGetClientThrottleInfo"						|
--	|																		|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMGetClientThrottleInfo')
BEGIN
	print '>>> Drop Stored Procedure: JMGetClientThrottleInfo <<<'
	drop procedure JMGetClientThrottleInfo
END
IF EXISTS (select * from GxQscripts where name='JMGetClientThrottleInfo')
	delete from GxQscripts where name = 'JMGetClientThrottleInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetClientThrottleInfo')
	delete from GXDBVersions where aliasname = 'JMGetClientThrottleInfo'
GO
print '... Creating Procedure: JMGetClientThrottleInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMGetClientThrottleInfo
  @inJobId integer,
  @inClientId integer,
  @inCalledFromAutoWakeUpThread integer
AS
  DECLARE @outJobThrottleEnabled integer
  DECLARE @outDataCount integer
  DECLARE @outLogCount integer
  DECLARE @outClientGroupId integer
  DECLARE @outClientGroupName nvarchar(1024)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @defaultCommCellId INTEGER  = 2
	DECLARE @JMBKP_THROTTLE_FOR_DATA BIGINT = 0x400000000000000
	DECLARE @JMBKP_THROTTLE_FOR_LOG BIGINT = 0x800000000000000
	DECLARE @bkpAttribute BIGINT = 0
	DECLARE	@combinedPriority INT = 0
	DECLARE @jobType INT = 4 --BACKUP
	DECLARE @subOptype INT = 0
	DECLARE @throttleAsDataJob INT = 0
	DECLARE @dontConsiderBackupCopyForThrottling INT =	ISNULL((SELECT 1
										FROM GXGlobalParam WITH (NOLOCK)
										WHERE name = 'dontConsiderBackupCopyForThrottling'
										AND modified = 0
										AND value = '1'), 0)
    IF  object_id('tempdb.dbo.#tempAppClientProp') is not null DROP TABLE #tempAppClientProp
CREATE TABLE #tempAppClientProp (jobThrottleEnabled INT, dataJobThrottle INT, logJobThrottle INT, jobDataCount INT DEFAULT 0, jobLogCount INT DEFAULT 0, clientGroupId INT, clientGroupName NVARCHAR(1024))
	CREATE CLUSTERED INDEX tempAppClientProp_clientGroupId_IDX on #tempAppClientProp(clientGroupId);
    IF  object_id('tempdb.dbo.#tempjobInfo') is not null DROP TABLE #tempjobInfo
		CREATE TABLE #tempjobInfo (jobId INT, applicationId INT, bkpattributes BIGINT, clientId INT, clientGroupId INT, state INT, pendingCause INT, combPriority INT)
	CREATE CLUSTERED INDEX tempjobInfo_clientId_clientGroupId_IDX on #tempjobInfo(clientId, clientGroupId);
    IF  object_id('tempdb.dbo.#tempThrottleInfo') is not null DROP TABLE #tempThrottleInfo
		CREATE TABLE #tempThrottleInfo (jobThrottleEnabled INT, dataJobThrottle INT, logJobThrottle INT, clientGroupId INT, subclientId INT, clientId INT)
    IF  object_id('tempdb.dbo.#tempClientGroupInfo') is not null DROP TABLE #tempClientGroupInfo
		CREATE TABLE #tempClientGroupInfo (clientId INT, clientGroupId INT)
    -- Get data from App_ClientProp table
	INSERT INTO #tempAppClientProp
	(jobThrottleEnabled, dataJobThrottle, logJobThrottle, clientGroupId, clientGroupName)
    SELECT
		ISNULL([Throttle Jobs Enabled],0)                   AS jobThrottleEnabled,
		ISNULL([Throttle Jobs - Data Threshold],1)          AS dataJobThrottle,
		ISNULL([Throttle Jobs - Log Threshold],1)           AS logJobThrottle,
		0 clientGroupId,
		'' clientGroupName
        FROM
        (
            SELECT  componentNameId, attrName, attrVal
            FROM    App_ClientProp
            WHERE   componentNameId = @inClientId
            AND     modified = 0
        ) AS clients
        PIVOT
        (
            MAX(attrVal)
            FOR attrName IN
            (
                [Throttle Jobs Enabled],
                [Throttle Jobs - Data Threshold],
                [Throttle Jobs - Log Threshold]
            )
        ) AS pvt
	INSERT INTO #tempAppClientProp
	(jobThrottleEnabled, dataJobThrottle, logJobThrottle, clientGroupId, clientGroupName)
	SELECT
ISNULL([3650], 0)                    AS jobThrottleEnabled,
ISNULL([3651], 0)     AS dataJobThrottle,
ISNULL([3652], 0)      AS logJobThrottle,
	id clientGroupId,
	name clientGroupName
	FROM
	(
		SELECT
		P.propertyTypeId, longVal, G.id, G.name
		FROM APP_ComponentProp P
		JOIN APP_ClientGroupAssoc A ON A.clientGroupId = P.componentId
		JOIN APP_ClientGroup G ON A.clientGroupId = G.id
		AND P.componentType = 8
		AND P.modified = 0
		AND A.clientId = @inClientId
	) AS groups
	PIVOT
	(
		MAX(longVal)
		FOR propertyTypeId IN
		(
[3650],
[3651],
[3652]
		)
	) AS pvt
	--DELETE ENTRIES FOR WHICH THROTTLE IS NOT ENABLED
	DELETE #tempAppClientProp
	WHERE jobThrottleEnabled & 1 = 0	--CV_PROP_JOB_THROTTLE_ENABLED
	IF NOT EXISTS(SELECT 1 FROM #tempAppClientProp)
		GOTO EXIT_PROC
	SELECT @combinedPriority=combPriority, @jobType=opType, @subOptype=subOpType
	FROM JMJobInfo (NOLOCK)
	WHERE jobId = @inJobId
	--NEED TO GET ATTRIBUTE INFO TO DETERMINE BACKUP TYPE (DATA OR LOG)
	IF @jobType IN (4, 14)	--BACKUP, SYNTHFULL
	BEGIN
		SELECT @bkpAttribute=bkpattributes
		FROM JMBkpJobInfo (NOLOCK)
		WHERE jobId = @inJobId
	END
	ELSE IF @subOptype IN (130)	--ONLINE_CRAWL
	BEGIN
			SET @throttleAsDataJob = 1
	END
	--GET JOBS THAT ARE RUNNING FOR THE CLIENT OR CLIENT GROUP
	INSERT INTO #tempThrottleInfo
	(jobThrottleEnabled, dataJobThrottle, logJobThrottle, clientGroupId, subclientId, clientId)
	SELECT CP.jobThrottleEnabled, CP.dataJobThrottle, CP.logJobThrottle, CP.clientGroupId, APP.id subclientId, @inClientId clientId
	FROM #tempAppClientProp CP
	JOIN APP_Application APP ON APP.clientId = @inClientId AND CP.clientGroupId = 0 --AND CP.jobThrottleEnabled > 0
	UNION
	SELECT CP.jobThrottleEnabled, CP.dataJobThrottle, CP.logJobThrottle, CP.clientGroupId, APP.id subclientId, 0 clientId
	FROM #tempAppClientProp CP
	JOIN APP_ClientGroupAssoc CGA ON CGA.clientGroupId = CP.clientGroupId --AND CP.jobThrottleEnabled > 0
	JOIN APP_Application APP ON APP.clientId = CGA.clientId
	INSERT INTO #tempjobInfo
	(jobId, applicationId, bkpattributes, clientId, clientGroupId, state, pendingCause, combPriority)
	SELECT BKP.jobId, BKP.applicationId, BKP.bkpattributes, CP.clientId, CP.clientGroupId, INFO.state, INFO.pendingCause, INFO.combPriority
	FROM #tempThrottleInfo CP
	JOIN JMBkpJobInfo BKP ON BKP.commcellId = @defaultCommCellId AND BKP.applicationId = CP.subclientId --AND BKP.jobId <> @inJobId
	JOIN JMJobInfo INFO ON INFO.jobId = BKP.jobId
	AND INFO.state NOT in (2 /* PENDING */, 5 /* STOPPED */, 16 /* DORMANTSCHEDWAIT */)
	AND INFO.opType NOT IN (14)	--SYNTHFULL
	AND (
			INFO.opType != 60	--SNAPTOTAPE
			OR
			@dontConsiderBackupCopyForThrottling = 0
		)
	AND (
			(INFO.initFrom <> 1 /* THIRDPARTY */)
							OR
			(INFO.displayState <> 3 /* WAITING */) -- If it is third party, dont count display state waiting jobs. This means they are waiting on streams and so don't count them.
		)
	INSERT INTO #tempClientGroupInfo
	(clientId, clientGroupId)
	SELECT DISTINCT CGA.clientId, CGA.clientGroupId
	FROM APP_ClientGroupAssoc CGA
	JOIN #tempThrottleInfo TI ON TI.clientGroupId = CGA.clientGroupId
	--GET INDEXING JOBS RUNNING PER ACCESS NODE CLIENT
	INSERT INTO #tempjobInfo
	(jobId, applicationId, bkpattributes, clientId, clientGroupId, state, pendingCause, combPriority)
	SELECT DISTINCT ADM.jobId, ADM.appID, 0, CP.clientId, CP.clientGroupId, INFO.state, INFO.pendingCause, INFO.combPriority
	FROM #tempThrottleInfo CP
	JOIN JMAdminJobInfoTable ADM ON ADM.commcellId = @defaultCommCellId
		AND ADM.opType = 53	--OFFLINECONTENTINDEX
	JOIN JMJobInfo INFO ON INFO.subOpType IN (130 /*ONLINE_CRAWL*/)
		AND ADM.jobId = INFO.jobId
	LEFT OUTER JOIN #tempClientGroupInfo CG ON CG.clientGroupId = CP.clientGroupId
	JOIN SEDataSourceProperty DSP ON DSP.PropertyValue IN (CAST(CG.clientId AS VARCHAR(10)), CAST(@inClientId AS VARCHAR(10)))
	JOIN APP_SubClientProp SCP ON SCP.componentNameId = ADM.appID
		AND DSP.datasourceId = CAST(SCP.attrval AS INT)
		AND ISNUMERIC(DSP.PropertyValue) = 1
		AND SCP.attrName = N'Indexing datasource id'
		AND SCP.modified=0
		AND SCP.cs_attrName = CHECKSUM(N'Indexing datasource id')
		AND ISNUMERIC(SCP.attrVal) = 1
	JOIN SEProperty SEP ON DSP.PropertyId = SEP.PropertyId
		AND SEP.PropertyName = 'accessnodeclientid'
	AND INFO.state NOT in (2 /* PENDING */, 5 /* STOPPED */, 16 /* DORMANTSCHEDWAIT */)
	--ONLY KEEP THOSE JOBS THAT WERE QUEUED BECAUSE FOR THROTTLE REASONS
	DELETE #tempjobInfo
	WHERE state = 15 /* QUEUED */
	AND pendingCause <> 13 /*THROTTLEDCAUSE*/
	--REMOVE THOSE JOBS WERE QUEUED BECAUSE FOR THROTTLE AND JOB PRIORITY REASONS
	DELETE #tempjobInfo
	WHERE state = 15 /* QUEUED */
	AND pendingCause = 13 /*THROTTLEDCAUSE*/
	AND
	(
		--Lower or equal priority then current job when called from AutoWakeUpThread
		(@combinedPriority <= combPriority AND @inCalledFromAutoWakeUpThread = 1)
		OR
		--Lower priority on current job when called from other code path
		(@combinedPriority < combPriority AND @inCalledFromAutoWakeUpThread = 0)
	)
	UPDATE #tempAppClientProp
	SET jobDataCount = T.nJobs
	FROM
	(
		SELECT JB.nJobs, JB.clientGroupId cgId, JB.dataJobThrottle dth
		FROM
		(
			SELECT COUNT(JI.jobId) nJobs, CP.clientGroupId, CP.dataJobThrottle
			FROM #tempAppClientProp CP
			JOIN #tempjobInfo JI ON JI.clientGroupId = CP.clientGroupId
			WHERE JI.bkpattributes & @JMBKP_THROTTLE_FOR_DATA = @JMBKP_THROTTLE_FOR_DATA AND CP.dataJobThrottle > 0
				AND JI.jobId <> @inJobId	--DO NOT COUNT CURRENT JOB
			GROUP BY CP.clientGroupId, CP.dataJobThrottle
		) JB
	) T
	WHERE T.cgId = clientGroupId
	AND T.dth = dataJobThrottle
	--COUNT INDEXING JOB AS DATA COUNT
	UPDATE #tempAppClientProp
	SET jobDataCount = T.nJobs + ISNULL(jobDataCount, 0)
	FROM
	(
		SELECT JB.nJobs, JB.clientGroupId cgId, JB.dataJobThrottle dth
		FROM
		(
			SELECT COUNT(JI.jobId) nJobs, CP.clientGroupId, CP.dataJobThrottle
			FROM #tempAppClientProp CP
			JOIN #tempjobInfo JI ON JI.clientGroupId = CP.clientGroupId
			WHERE JI.jobId <> @inJobId	--DO NOT COUNT CURRENT JOB
			AND JI.bkpattributes & @JMBKP_THROTTLE_FOR_DATA = 0
			AND JI.bkpattributes & @JMBKP_THROTTLE_FOR_LOG = 0
			AND CP.dataJobThrottle > 0
			GROUP BY CP.clientGroupId, CP.dataJobThrottle
		) JB
	) T
	WHERE T.cgId = clientGroupId
	AND T.dth = dataJobThrottle
	UPDATE #tempAppClientProp
	SET jobLogCount = T.nJobs
	FROM
	(
		SELECT COUNT(JI.jobId) nJobs, CP.clientGroupId cgId, CP.logJobThrottle lth
		FROM #tempAppClientProp CP
		JOIN #tempjobInfo JI ON JI.clientGroupId = CP.clientGroupId
		WHERE
		(
			JI.bkpattributes & @JMBKP_THROTTLE_FOR_LOG = @JMBKP_THROTTLE_FOR_LOG AND CP.logJobThrottle > 0
			AND JI.bkpattributes & @JMBKP_THROTTLE_FOR_DATA = 0
			AND JI.jobId <> @inJobId	--DO NOT COUNT CURRENT JOB
		)
		GROUP BY CP.clientGroupId, CP.logJobThrottle
	) T
	WHERE T.cgId = clientGroupId
	AND T.lth = logJobThrottle
	--DELETE ENTRIES WHICH HAVE NOT GONE OVER THE THRESHOLD
	--MAKE SURE TO CONSIDER LOG AND DATA THROTTLE SEPARATELY
	DELETE #tempAppClientProp
	WHERE
	(
		jobDataCount < dataJobThrottle
		AND
		(
			@bkpAttribute&@JMBKP_THROTTLE_FOR_DATA = @JMBKP_THROTTLE_FOR_DATA
			OR
			@throttleAsDataJob = 1
		)
	)
	OR
	(
		jobLogCount < logJobThrottle
		AND
		@bkpAttribute&@JMBKP_THROTTLE_FOR_LOG = @JMBKP_THROTTLE_FOR_LOG
		-- Get Log only jobs. EXCLUDE DATA+LOG JOBS.
		AND
		@bkpAttribute&@JMBKP_THROTTLE_FOR_DATA = 0
	)
	SELECT TOP 1 @outJobThrottleEnabled=jobThrottleEnabled,
		@outDataCount=jobDataCount,
		@outLogCount=jobLogCount,
		@outClientGroupId=clientGroupId,
		@outClientGroupName=clientGroupName
	FROM #tempAppClientProp
	ORDER BY clientGroupId
	--THERE SHOULD ONLY BE ONE ROW UNLESS CLIENT AND GROUP HAVE SAME VALUE BUT THROTTLE-ENABLED FLAG IS DIFFERENT
	--FROM EXCLUDE IMMEDIATE JOBS. ORDERED BY CLIENTGROUPID WILL PUT ON TOP WHEN VALUE IS 0, SO CLIENT WILL TAKE PRECEDENCE
EXIT_PROC:
	SELECT @outJobThrottleEnabled, @outDataCount, @outLogCount, @outClientGroupId, @outClientGroupName
    IF  object_id('tempdb.dbo.#tempClientGroupInfo') is not null DROP TABLE #tempClientGroupInfo
    IF  object_id('tempdb.dbo.#tempAppClientProp') is not null DROP TABLE #tempAppClientProp
    IF  object_id('tempdb.dbo.#tempjobInfo') is not null DROP TABLE #tempjobInfo
    IF  object_id('tempdb.dbo.#tempThrottleInfo') is not null DROP TABLE #tempThrottleInfo
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetClientThrottleInfo')
	delete from GxQscripts where name = 'JMGetClientThrottleInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetClientThrottleInfo')
	delete from GXDBVersions where aliasname = 'JMGetClientThrottleInfo'
GO

insert into GXDBVersions values(2, 'JMGetClientThrottleInfo',  'v1.1.2.10.8.2', 'JMGetClientThrottleInfo', 'v1.1.2.10.8.2')
GO

