

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetClientPriority.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetClientPriority.sp,v $ $Id: JMGetClientPriority.sp,v 1.1.2.2 2019/05/03 00:00:09 sbonilla Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "JMGetClientPriority"						|
--	|																		|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetClientPriority')
BEGIN
	print '>>> Drop Stored Procedure: JMGetClientPriority <<<'
	drop procedure JMGetClientPriority
END
IF EXISTS (select * from GxQscripts where name='JMGetClientPriority')
	delete from GxQscripts where name = 'JMGetClientPriority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetClientPriority')
	delete from GXDBVersions where aliasname = 'JMGetClientPriority'
GO
print '... Creating Procedure: JMGetClientPriority'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetClientPriority
  @inClientId integer
AS
  DECLARE @outPriority integer = 6	--CV_DEFAULT_CLIENT_PRIORITY
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
    IF  object_id('tempdb.dbo.#tempClientPriority') is not null
		DROP TABLE #tempClientPriority
	CREATE TABLE #tempClientPriority (priority INT, clientId INT, clientGroupId INT DEFAULT 0)
	INSERT INTO #tempClientPriority
	(priority, clientId, clientGroupId)
	SELECT CAST(attrVal AS INT), @inClientId, 0
	FROM APP_ClientProp
	WHERE attrName = 'JMPriority'
	AND modified = 0
	AND componentNameId = @inClientId
	AND ISNUMERIC(attrVal) = 1
	UNION
	SELECT P.longVal, @inClientId, A.clientGroupId
	FROM APP_ComponentProp P
	JOIN APP_ClientGroupAssoc A
		ON A.clientGroupId = P.componentId
		AND A.clientId = @inClientId
WHERE P.componentType = 8
	AND P.modified = 0
AND P.propertyTypeId = 3660
	--GIVE PRIORITY TO CLIENT SETTING
	SELECT @outPriority =  priority
	FROM #tempClientPriority P
	WHERE priority <> 6	--CV_DEFAULT_CLIENT_PRIORITY	IGNORE ENTRIES WITH DEFAULT PRIORITY
	AND clientGroupId = 0
	IF @outPriority IS NULL
	BEGIN
		SELECT @outPriority = MIN(priority)
		FROM #tempClientPriority P
		WHERE priority <> 6	--CV_DEFAULT_CLIENT_PRIORITY	IGNORE ENTRIES WITH DEFAULT PRIORITY
		AND clientGroupId > 0
	END
    IF  object_id('tempdb.dbo.#tempClientPriority') is not null
		DROP TABLE #tempClientPriority
EXIT_PROC:
	SELECT @outPriority
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetClientPriority')
	delete from GxQscripts where name = 'JMGetClientPriority'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetClientPriority')
	delete from GXDBVersions where aliasname = 'JMGetClientPriority'
GO

insert into GXDBVersions values(2, 'JMGetClientPriority',  '00010001000200020000', 'JMGetClientPriority', '00010001000200020000')
GO

