

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetBkpJobIdsUpToEndTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   01/09/2007
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetBkpJobIdsUpToEndTime.sp,v $ $Id: JMGetBkpJobIdsUpToEndTime.sp,v 1.2.302.2 2019/10/10 17:16:18 gpattabiraman Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetBkpJobIdsUpToEndTime')
BEGIN
	print '>>> Drop Stored Procedure: JMGetBkpJobIdsUpToEndTime <<<'
	drop procedure JMGetBkpJobIdsUpToEndTime
END
IF EXISTS (select * from GxQscripts where name='JMGetBkpJobIdsUpToEndTime')
	delete from GxQscripts where name = 'JMGetBkpJobIdsUpToEndTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetBkpJobIdsUpToEndTime')
	delete from GXDBVersions where aliasname = 'JMGetBkpJobIdsUpToEndTime'
GO
print '... Creating Procedure: JMGetBkpJobIdsUpToEndTime'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetBkpJobIdsUpToEndTime
  @i_appId integer,
  @i_endTime integer
AS
  DECLARE @i_JobId integer;
  DECLARE @i_CommCellId integer;
	DECLARE @i_FullCycle	integer
	SET @i_FullCycle = (SELECT TOP 1 fullCycleNum FROM JMBkpStats WHERE appId=@i_appId AND servEndDate<=@i_endTime ORDER BY fullCycleNum DESC)
	IF EXISTS (SELECT 1 FROM JMVSAAppJobLink WHERE childAppId = @i_appId)
	BEGIN
		-- All jobs run as Full for AppAware child subclients and with new design we only increment cycle if parent job was laucnhed as a Full.
		-- So we could potentially end up with multiple Full jobs within the same cycle for AppAware child subclients.
		-- To keep behavior correct, for AppAware child subclients, we return only the most recent job in the cycle that matches the time criteria.
		SELECT TOP 1 jobId, commCellId FROM JMBkpStats WHERE appId=@i_appId AND servEndDate<=@i_endTime AND fullCycleNum=@i_FullCycle ORDER BY servEndDate DESC
	END
	ELSE
	BEGIN
		SELECT jobId, commCellId FROM JMBkpStats WHERE appId=@i_appId AND servEndDate<=@i_endTime AND fullCycleNum=@i_FullCycle
	END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'JMGetBkpJobIdsUpToEndTime')
	delete from GxQscripts where name = 'JMGetBkpJobIdsUpToEndTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetBkpJobIdsUpToEndTime')
	delete from GXDBVersions where aliasname = 'JMGetBkpJobIdsUpToEndTime'
GO

insert into GXDBVersions values(2, 'JMGetBkpJobIdsUpToEndTime',  '00010002030200020000', 'JMGetBkpJobIdsUpToEndTime', '00010002030200020000')
GO

