

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetBkpJobCountForThrottle.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--			Author: Gokul Pattabiraman
--			Date:   12/06/2011
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetBkpJobCountForThrottle <<<'

IF EXISTS (select * from sysobjects where name='JMGetBkpJobCountForThrottle')
	drop procedure JMGetBkpJobCountForThrottle
IF EXISTS (select * from GxQscripts where name='JMGetBkpJobCountForThrottle')
	delete from GxQscripts where name = 'JMGetBkpJobCountForThrottle'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetBkpJobCountForThrottle')
	delete from GXDBVersions where aliasname = 'JMGetBkpJobCountForThrottle'
GO
print '... Creating Procedure: JMGetBkpJobCountForThrottle'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetBkpJobCountForThrottle
  @inJobID INTEGER,
  @inClientID INTEGER,
  @inAppTypeID INTEGER,
  @inIncludeAttributes BIGINT,
  @inExcludeAttributes BIGINT
AS
  DECLARE @outJobCount INTEGER
	SET NOCOUNT ON
DECLARE @defaultCommCellId INTEGER  = 2
	SELECT @outJobCount = COUNT(*) FROM JMBkpJobInfo BKP WITH (NOLOCK)
	INNER JOIN JMJobInfo INFO WITH (NOLOCK) ON BKP.jobId = INFO.jobId AND BKP.commcellId = INFO.commCellId
	WHERE BKP.jobId <> @inJobID AND BKP.commcellId = @defaultCommCellId
	AND BKP.bkpattributes & @inIncludeAttributes = @inIncludeAttributes
	AND BKP.bkpattributes & @inExcludeAttributes = 0
	AND BKP.applicationId in (SELECT id FROM APP_Application
							  WHERE clientId = @inClientID) -- Check client level count.
							  --AND appTypeId = @inAppTypeID)
	AND INFO.state NOT in (2 /* PENDING */, 5 /* STOPPED */, 15 /* QUEUED */, 16 /* DORMANTSCHEDWAIT */)
	AND (
			(INFO.initFrom <> 1 /* THIRDPARTY */)
							OR
			(INFO.displayState <> 3 /* WAITING */) -- If it is third party, dont count display state waiting jobs. This means they are waiting on streams and so dont count them.
		)
	SELECT @outJobCount
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetBkpJobCountForThrottle')
	delete from GxQscripts where name = 'JMGetBkpJobCountForThrottle'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetBkpJobCountForThrottle')
	delete from GXDBVersions where aliasname = 'JMGetBkpJobCountForThrottle'
GO

insert into GXDBVersions values(2, 'JMGetBkpJobCountForThrottle',  '00000000000000000000', 'JMGetBkpJobCountForThrottle', '00000000000000000000')
GO

