

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetBkpAtmptStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetBkpAtmptStats.sp,v $ $Id: JMGetBkpAtmptStats.sp,v 1.1.2.3 2020/06/28 03:36:40 gstoops Exp $";
--
--  +========================================================================+
--  |      Cursor:  JMGetBkpAtmptStats()
--  |
--  | Description:  Retrieves the Backup Statistics from the database
--  |
--  |      Input:   ???
--  |
--  |      Output:  Returns rows that match input criteria. It skips the skipped phases
--  |
--  |      Notes:	Moved from JMGetBkpAtmptStats.cur
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        madeira 	Initial release
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetBkpAtmptStats')
BEGIN
	print '>>> Drop Stored Procedure: JMGetBkpAtmptStats <<<'
	drop procedure JMGetBkpAtmptStats
END
IF EXISTS (select * from GxQscripts where name='JMGetBkpAtmptStats')
	delete from GxQscripts where name = 'JMGetBkpAtmptStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetBkpAtmptStats')
	delete from GXDBVersions where aliasname = 'JMGetBkpAtmptStats'
GO
print '... Creating Procedure: JMGetBkpAtmptStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetBkpAtmptStats
  @localeId integer,
  @commcellId integer,
  @jobID integer
AS
--If output of cursor is being change, column in temp table #TempAttemptStats also needs to be changed
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- .. :PARAM input lines
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @opType INT = ISNULL((SELECT CASE opType WHEN 94/*RefCopy*/ THEN 14/*SynthFull*/
											 WHEN 97/*PST Archiving*/ THEN 14/*SynthFull*/
											 ELSE opType END
											 FROM JMBkpStats WHERE jobId = @jobID and commCellId = @commcellId), 4)
	DECLARE @appType INT = (SELECT appType FROM JMBkpStats WHERE jobId = @jobID AND commCellId = @commcellId)
	DECLARE @opTableId INT = (SELECT id FROM JMOpTable WHERE operation = @opType AND appTypeType = @appType)
	IF OBJECT_ID('tempdb.dbo.#TempAttemptStats') IS NOT NULL DROP TABLE #TempAttemptStats
	CREATE TABLE #TempAttemptStats
	(
		number          integer,
		appType         integer,
		opType          integer,
		phase           integer,
		phaseType       bigint,
		phaseName       NVARCHAR(64),
		status          integer,
		maxStreamsUsed  integer,
		archGrpId       integer,
		archGrpName     NVARCHAR(145),
		copyId          integer,
		copyName        NVARCHAR(65),
		servStartDate       integer,
		servEndDate     integer,
		elapsedTime     integer,
		uncompBytes     bigint,
		compBytes       bigint,
		numObjects      bigint,
		numFolders      bigint,
		failureReason   NVARCHAR(1024),
		writeTime       integer,
		attributes      integer,
		mediaAgent      NVARCHAR(MAX),
		libraryName     NVARCHAR(4000),
		drivePoolName   NVARCHAR(4000),
		failureKBArticle        NVARCHAR(MAX),
		nwTransBytes    bigint,
		readThroughput		float,
		writeThroughput		float,
		networkThroughput	float,
		sidbLookups			float
	);
	INSERT INTO #TempAttemptStats
	SELECT	DISTINCT number,
		appType = @appType,
		opType = @opType,
		JMBkpAtmptStats.phase,
		phaseType = JMPhase.phaseType,
		phaseName = JMPhase.name,
		JMBkpAtmptStats.status,
		maxStreamsUsed,
		JMBkpAtmptStats.archGrpId,
		CASE JMBkpAtmptStats.archGrpId
			WHEN 0 THEN ''
			ELSE ISNULL((SELECT name FROM archGroup WITH (READUNCOMMITTED) WHERE id = JMBkpAtmptStats.archGrpId),'')
		END,
		JMBkpAtmptStats.copyId,
		CASE JMBkpAtmptStats.copyId
			WHEN 0 THEN ''
			ELSE ISNULL((SELECT name FROM archGroupCopy WITH (READUNCOMMITTED) WHERE id = JMBkpAtmptStats.copyId),'')
		END,
		servStartDate,
		servEndDate,
		elapsedTime,
		JMBkpAtmptStats.unCompBytes,
		JMBkpAtmptStats.compBytes,
		JMBkpAtmptStats.numObjects,
		JMBkpAtmptStats.numFolders,
		dbo.JMGetLocalizedMessageFunc(@localeId,failureReason),
		writeTime,
		attributes,
		JMBkpAtmptStats.mediaAgent,
		isnull(MMLibrary.AliasName,'') [Library],
		CASE MMDrivePool.DrivePoolType
		WHEN 10001 THEN ''
		ELSE ISNULL(MMDrivePool.DrivePoolName,'')
		END [Drive Pool],
		dbo.JMGetKBArticlesForFailures(failureReason, 0) AS [failureKBArticle],
		JMBkpAtmptStats.nwTransBytes,
		readThroughput,
		writeThroughput,
		networkThroughput,
		sidbLookups
	FROM JMBkpAtmptStats LEFT OUTER JOIN JMJobResourceHistory WITH (READUNCOMMITTED)
	ON JMJobResourceHistory.jobId = JMBkpAtmptStats.jobId
	AND JMJobResourceHistory.commcellId = JMBkpAtmptStats.commcellId
	AND JMJobResourceHistory.phasenum = JMBkpAtmptStats.phase
	AND JMJobResourceHistory.attemptNum = JMBkpAtmptStats.number
	AND JMJobResourceHistory.copyId = JMBkpAtmptStats.copyId
	LEFT OUTER JOIN MMDrivePool WITH (READUNCOMMITTED)
	ON JMJobResourceHistory.DrivePoolId = MMDrivePool.DrivePoolId
	LEFT OUTER JOIN MMMasterPool WITH (READUNCOMMITTED)
	ON JMJobResourceHistory.MasterPoolId = MMMasterPool.MasterPoolId
	LEFT OUTER JOIN MMLibrary WITH (READUNCOMMITTED)
	ON MMLibrary.LibraryId = MMMasterPool.LibraryId
	LEFT OUTER JOIN JMPhase WITH (READUNCOMMITTED)
	ON JMPhase.phase = JMBkpAtmptStats.phase
	AND JMPhase.opTableId = @opTableId
	WHERE JMBkpAtmptStats.jobId = @jobID AND JMBkpAtmptStats.commCellId = @commcellId AND
		JMBkpAtmptStats.status <> 8
	--ORDER BY servStartDate ASC
		--Column should be in same order as :OUT defined
	SELECT DISTINCT tAttmp2.number,tAttmp2.appType,tAttmp2.optype,tAttmp2.phase,tAttmp2.phaseType,tAttmp2.phaseName,
		tAttmp2.status,tAttmp2.maxStreamsUsed,tAttmp2.archGrpId,tAttmp2.archGrpName,tAttmp2.copyid,tAttmp2.copyName,tAttmp2.servStartDate,tAttmp2.servEndDate,
			tAttmp2.elapsedTime,tAttmp2.uncompBytes,tAttmp2.compBytes,tAttmp2.numObjects,tAttmp2.numFolders,tAttmp2.failureReason,tAttmp2.writeTime,
				tAttmp2.attributes,
				SUBSTRING((
						SELECT ',' + RTRIM(LTRIM(tAttmp1.mediaAgent)) AS [text()]
							FROM  #TempAttemptStats tAttmp1
							WHERE tAttmp1.number = tAttmp2.number
										AND tAttmp1.phase = tAttmp2.phase
											AND tAttmp1.appType = tAttmp2.appType
												AND tAttmp1.opType = tAttmp2.opType
													AND tAttmp1.copyid = tAttmp2.copyid
							ORDER BY tAttmp1.servStartDate ASC
							FOR XML PATH('')
					),2,4000)[MediaAgents],
				SUBSTRING((
						SELECT ',' + RTRIM(LTRIM(tAttmp1.libraryName))  AS [text()]
							FROM  #TempAttemptStats tAttmp1
							WHERE tAttmp1.number = tAttmp2.number
										AND tAttmp1.phase = tAttmp2.phase
											AND tAttmp1.appType = tAttmp2.appType
												AND tAttmp1.opType = tAttmp2.opType
													AND tAttmp1.copyid = tAttmp2.copyid
							ORDER BY tAttmp1.servStartDate ASC
							FOR XML PATH('')
					),2,4000)[Libraries],
				tAttmp2.drivePoolName,tAttmp2.failureKBArticle,tAttmp2.nwTransBytes,
				readThroughput,
				writeThroughput,
				networkThroughput,
				sidbLookups
	FROM #TempAttemptStats tAttmp2
	ORDER BY tAttmp2.servStartDate ASC
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetBkpAtmptStats')
	delete from GxQscripts where name = 'JMGetBkpAtmptStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetBkpAtmptStats')
	delete from GXDBVersions where aliasname = 'JMGetBkpAtmptStats'
GO

insert into GXDBVersions values(2, 'JMGetBkpAtmptStats',  '00010001000200030000', 'JMGetBkpAtmptStats', '00010001000200030000')
GO

