

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetBackupSummaryReport.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetBackupSummaryReport.sp,v $ $Id: JMGetBackupSummaryReport.sp,v 1.1.4.3 2018/04/25 16:17:17 bzhu Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "JMGetBackupSummaryReport"
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetBackupSummaryReport <<<'

IF EXISTS (select * from sysobjects where name='JMGetBackupSummaryReport')
	drop procedure JMGetBackupSummaryReport
IF EXISTS (select * from GxQscripts where name='JMGetBackupSummaryReport')
	delete from GxQscripts where name = 'JMGetBackupSummaryReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetBackupSummaryReport')
	delete from GXDBVersions where aliasname = 'JMGetBackupSummaryReport'
GO
print '... Creating Procedure: JMGetBackupSummaryReport'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetBackupSummaryReport
-- Input arguments
  @userId INT,
  @reqStartTime_DATETIME DATETIME,
  @reqEndTime_DATETIME DATETIME,
  @timeFrameType INT = 1,
  @frequency INT = 1,
  @numberOfPeriods INT = 7
AS
  DECLARE @jobId INT
  DECLARE @clientId INT
  DECLARE @client NVARCHAR(1024)
  DECLARE @agent NVARCHAR(1024)
  DECLARE @instance NVARCHAR(1024)
  DECLARE @backupset NVARCHAR(1024)
  DECLARE @subclient NVARCHAR(1024)
  DECLARE @operation INT
  DECLARE @backupType INT
  DECLARE @jobStatus INT
  DECLARE @applicationSize BIGINT
  DECLARE @startDate DATETIME
  DECLARE @endDate DATETIME
  DECLARE @protectedObjects BIGINT
  DECLARE @failedObjects BIGINT
  DECLARE @failedFolders BIGINT
  DECLARE @networkSize BIGINT
  DECLARE @schedule NVARCHAR(256)
  DECLARE @schedulePolicy NVARCHAR(256)
  DECLARE @clientGroup NVARCHAR(MAX)
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	/*
	---------------- Inputs for the report----------------------------------------------
	DECLARE  @userId					  INT = 502
	-- Time range values
	DECLARE  @timeFrameType               INT = 1-- Default is relative 1. For absolute value pass 0.
	DECLARE  @frequency                   INT = 1 -- Default is value 1 which is days for time range relative frequency
	DECLARE  @numberOfPeriods             INT = 7 -- Default is 7 days for relative.
	DECLARE	 @reqStartTime_DATETIME		  DATETIME = '2017-10-13 15:57:11.670'
	DECLARE	 @reqEndTime_DATETIME		  DATETIME = '2017-10-13 15:57:11.670'
	*/
	---------------- Inputs end--------------------------------------------------------
	--------------- Harcoded values for now as not needed as inputs--------------------
	-- Agents and MA filters
	DECLARE  @includeAllAgents            INT = 1 -- If 0, need to fill in @AgentId
	DECLARE  @includeAllMediaAgents       INT = 1 -- If 0, need to fill in @MediaAgentId
	DECLARE @AgentId      TABLE(AgentId INT)
	DECLARE @MediaAgentId  TABLE  (MediaAgentId INT)
	-- Job Status values -- Default include all
	DECLARE  @statusCompleted             INT = 1
	DECLARE  @statusCompletedErr          INT = 1
	DECLARE  @statusCompletedWrn          INT = 1
	DECLARE  @statusFailed                INT = 1
	DECLARE  @statusKilled                INT = 1
	DECLARE  @statusDelayed               INT = 1
	DECLARE  @statusActive                INT = 1
	DECLARE  @statusNoRun                 INT = 1
	DECLARE  @backupFull                  INT = 1
	DECLARE  @backupIncremental           INT = 1
	DECLARE  @backupDifferential          INT = 1
	DECLARE  @backupSynthetic             INT = 1
	-- Other
	DECLARE  @localeId                    INT = 0
	----- Hardcoded values end--------------------------------------------------------
	---- Local Variables and logic Begins--------------------------------------------
	DECLARE @csTimeZone    VARCHAR(256)
	SELECT @csTimeZone = timeZone FROM APP_CommCell WITH (NOLOCK) WHERE id = 2
	DECLARE	@TimeZoneBias	INT = DATEDIFF(SECOND, GETUTCDATE(), GETDATE())
	SELECT @csTimeZone = TimeZoneStdName FROM SchedTimeZone WITH (NOLOCK)
	WHERE  TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
	IF @reqStartTime_DATETIME IS NULL  OR @reqEndTime_DATETIME IS NULL
	BEGIN
		SET @reqStartTime_DATETIME = dateadd(hour,-7*24,getutcdate()) -- 7  days
		SET @reqEndTime_DATETIME =  GETUTCDATE()
	END
	DECLARE  @reqStartTime                BIGINT = dbo.GetUnixTime(dbo.LocalToUTCTime(@reqStartTime_DATETIME, @csTimeZone))
	DECLARE  @reqEndTime                  BIGINT = dbo.GetUnixTime(dbo.LocalToUTCTime(@reqEndTime_DATETIME, @csTimeZone))
	DECLARE @startTime                   BIGINT = 0
	DECLARE @endTime                     BIGINT = dbo.GetUnixTime(GETUTCDATE())
	DECLARE  @includeAllClientGroups      INT = 1
	DECLARE  @includeAllClients           INT = 1
	-- Temp table helpers
	IF OBJECT_ID('tempdb.dbo.#ClientId')       IS NOT null DROP TABLE #ClientId
	IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__UserObjects')   IS NOT null DROP TABLE #JobSummary_tmp__UserObjects
	IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__EntityId')      IS NOT null DROP TABLE #JobSummary_tmp__EntityId
	IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__Entity')        IS NOT null DROP TABLE #JobSummary_tmp__Entity
	IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp_clientGroups')   IS NOT null DROP TABLE #JobSummary_tmp_clientGroups
	IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__Jobs')          IS NOT null DROP TABLE #JobSummary_tmp__Jobs
	IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__MediaAgent')    IS NOT null DROP TABLE #JobSummary_tmp__MediaAgent
	-- These tables should have been created outside for filtering. Create them if not, for queries to run
	IF OBJECT_ID('tempdb.dbo.#ClientId')   IS null 	CREATE TABLE #ClientId (ClientId INT)
	IF OBJECT_ID('tempdb.dbo.#ClientGroupId')   IS null 	CREATE TABLE #ClientGroupId (ClientGroupId INT)
	CREATE TABLE #JobSummary_tmp__EntityId
	(
		commCellId          INT,
		groupId             INT,
		clientId            INT,
		appTypeId           INT,
		instanceId          INT,
		backupsetId         INT,
		subclientId         INT,
		logDeletedClient    INT,
		logDeletedSubclient INT
	)
	CREATE CLUSTERED INDEX JobSummary_tmp__EntityId_clientId ON #JobSummary_tmp__EntityId(clientId)
	CREATE TABLE #JobSummary_tmp__Entity
	(
		clientId            INT,
		appTypeId           INT,
		subclientId         INT,
	)
	CREATE CLUSTERED INDEX #JobSummary_tmp__Entity_subclientId ON #JobSummary_tmp__Entity(subclientId)
	CREATE TABLE #JobSummary_tmp_clientGroups (clientId INT, clientGroupString NVARCHAR(MAX))
	CREATE TABLE #JobSummary_tmp__Jobs
	(
		jobId                   INT,
		clientGroup             NVARCHAR(MAX),
		clientId                INT,
		appTypeId               INT,
		subclientId             INT,
		opType                  INT,
		operationName           NVARCHAR(128),
		backupLevel             INT,
		backupTypeName          NVARCHAR(128),
		startTime               INT,
		startTimeStr            NVARCHAR(255),
		endTime                 INT,
		endTimeStr              NVARCHAR(255),
		appSize                 BIGINT,
		nwTransBytes            BIGINT,
		protectedObjects        BIGINT,
		failedObjects           BIGINT,
		failedFolders           INT,
		jobStatus               INT,
		jobStatusName           NVARCHAR(128),
		subtaskId				INT,
		subtaskName				NVARCHAR(256),
		taskId					INT,
		taskName				NVARCHAR(256),
		initFrom				INT
	)
	create table  #JobSummary_tmp__UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	IF EXISTS(SELECT 1 FROM #clientGroupId) OR EXISTS(SELECT 1 FROM #ClientId)
	BEGIN
		SET @includeAllClientGroups = 0
		SET @includeAllClients = 0
	END
	IF (@reqStartTime <> 0)
	BEGIN
		SET @startTime = @reqStartTime
	END
	IF (@reqEndTime > 0)
	BEGIN
		SET @endTime = @reqEndTime
	END
	------------------------- Filter logic begins--------------------------------------------------------------------
	IF @timeFrameType = 1
	BEGIN
		IF @frequency = 1 BEGIN
			SET @endTime 	= dbo.GetUnixTime(GETUTCDATE())
			SET	@startTime	= dbo.GetUnixTime(DATEADD(DD, -@numberOfPeriods, GETUTCDATE()))
		END
		ELSE IF @frequency = 2 BEGIN
			SET @endTime 	= dbo.GetUnixTime(GETUTCDATE())
			SET	@startTime	= dbo.GetUnixTime(DATEADD(WK, -@numberOfPeriods, GETUTCDATE()))
		END
		ELSE IF @frequency = 3 BEGIN
			BEGIN
				SET @endTime 	= dbo.GetUnixTime(GETUTCDATE())
				SET	@startTime	= dbo.GetUnixTime(DATEADD(MM, -@numberOfPeriods, GETUTCDATE()))
			END
		END
		ELSE IF @frequency = 4 BEGIN
			SET @endTime 	= dbo.GetUnixTime(GetUTCDate())
			SET	@startTime	= dbo.GetUnixTime(DATEADD(HH, -@numberOfPeriods, GetUTCDate()))
		END
	END
	EXEC wr_UserCellSelection @userId, N'#JobSummary_tmp__EntityId', 1, 0 /*@includeLogDeletedClients*/, 0/*@includeLogDeletedSubclients*/, N'reportEntities', N''
	IF	@includeAllClients = 0
	BEGIN
		IF @includeAllClientGroups = 1
			INSERT	INTO #ClientId
			SELECT	DISTINCT E.clientId
			FROM	#JobSummary_tmp__EntityId E LEFT OUTER JOIN #ClientId C ON E.clientId = C.ClientId
			WHERE	groupId > 0 AND C.ClientId IS NULL
		ELSE
			INSERT	INTO #ClientId
			SELECT	DISTINCT CGA.clientId
			FROM	#clientGroupId T, APP_ClientGroupAssoc CGA WITH (NOLOCK)
			WHERE	T.clientGroupId = CGA.clientGroupId
				AND CGA.clientId NOT IN (SELECT clientId FROM #ClientId)
		INSERT	INTO #JobSummary_tmp__Entity(clientId, appTypeId, subclientId)
		SELECT	DISTINCT C.ClientId, B.appType, B.appId
		FROM	#ClientId C
				INNER JOIN APP_VMProp VM  WITH (NOLOCK) ON VM.VMclientId = C.ClientId AND VM.attrName = 'vmStatus'
				INNER JOIN JMBkpStats B   WITH (NOLOCK) ON B.jobId = VM.jobId AND B.commCellId = VM.commCellId
		UNION
		SELECT	DISTINCT E.clientId, appTypeId, subclientId
		FROM	#JobSummary_tmp__EntityId E INNER JOIN #ClientId C ON E.clientId = C.ClientId
		WHERE	subclientId > 0
	END
	ELSE
		INSERT	INTO #JobSummary_tmp__Entity(clientId, appTypeId, subclientId)
		SELECT	DISTINCT clientId, appTypeId, subclientId
		FROM	#JobSummary_tmp__EntityId
		WHERE	subclientId > 0
	DROP TABLE  #JobSummary_tmp__EntityId
	IF	EXISTS (SELECT ClientId FROM #ClientId)
		DELETE	#JobSummary_tmp__Entity
		FROM	#JobSummary_tmp__Entity E LEFT OUTER JOIN #ClientId C
			ON	E.clientId = C.ClientId
		WHERE	C.ClientId IS NULL
	IF	EXISTS (SELECT AgentId FROM @AgentId)
	BEGIN
		DELETE	#JobSummary_tmp__Entity
		FROM	#JobSummary_tmp__Entity E LEFT OUTER JOIN @AgentId A
			ON	E.appTypeId = A.AgentId
		WHERE	A.AgentId IS NULL
	END
	INSERT INTO #JobSummary_tmp_clientGroups(clientId, clientGroupString)
	SELECT DISTINCT clientId, dbo.GetClientGroupV2(clientId)
	FROM #JobSummary_tmp__Entity
	-- Get the list of jobs now with all filters
	INSERT INTO #JobSummary_tmp__Jobs(
			jobId,
			clientGroup,
			clientId,
			appTypeId,
			subclientId,
			opType, operationName,
			backupLevel, backupTypeName,
			startTime, startTimeStr, endTime, endTimeStr,
			appSize,
			nwTransBytes,
			protectedObjects, failedObjects, failedFolders,
			jobStatus, jobStatusName,
			subtaskId, initFrom,
			subTaskName, taskName)
	-- -- -- finished backup jobs
	SELECT  jobId = B.jobId,
			clientGroup = CG.clientGroupString,
			clientId = A.clientId,
			appTypeId = A.appTypeId,
			subclientId = A.subclientId, --subcoientName = A.subclientName,
			opType = B.opType, operationName = dbo.GetJobOperationString(@localeId, B.opType, A.appTypeId),
			backupLevel = B.bkpLevel, backupTypeName = dbo.GetJobBackupTypeString(@localeId, B.bkpLevel, A.appTypeId),
			startTime = B.servStartDate, startTimeStr = N'', endTime = B.servEndDate, endTimeStr = N'',
			appSize = B.totalUncompBytes,
			nwTransBytes = B.nwTransBytes,
			protectedObjects = B.totalNumOfFolders + totalNumOfFiles, failedObjects = B.backupFileFailures, failedFolders = B.backupFolderFailures,
			jobStatus = dbo.GetJobStatusForReport((CASE B.displayStatus WHEN 0 THEN B.status ELSE B.displayStatus END), 1), jobStatusName = dbo.GetJobStatusString(@localeId, dbo.GetJobStatusForReport((CASE B.displayStatus WHEN 0 THEN B.status ELSE B.displayStatus END), 1)),
			subtaskId = B.subtaskId, initFrom = B.initFrom,
			subTaskName = ST.subTaskName, taskName = T.taskName
	FROM    JMBkpStats B WITH (NOLOCK)
			--INNER JOIN (SELECT DISTINCT commCellName, clientId, clientName, appTypeId, appTypeName,	instanceId, instanceName, backupsetId, backupsetName, subclientId, subclientName
			INNER JOIN (SELECT DISTINCT clientId, appTypeId,  subclientId
						FROM #JobSummary_tmp__Entity) A ON B.appId = A.subclientId
			INNER JOIN #JobSummary_tmp_clientGroups CG ON A.clientId = CG.clientId
			LEFT OUTER JOIN TM_Subtask ST ON B.subTaskId = ST.subTaskId AND B.initFrom = 3
			LEFT OUTER JOIN TM_Task T ON ST.taskId = T.taskId
			WHERE ( servEndDate >= @startTime AND servEndDate <= @endTime )
			-- filter out backup types
			AND (dbo.isBkpJobLevelMatches(B.bkpLevel, @backupFull, @backupIncremental, @backupDifferential, @backupSynthetic) = 1)
			-- filter out job statuses
			AND (dbo.isJobStatusMatches((CASE B.displayStatus WHEN 0 THEN B.status ELSE B.displayStatus END), @statusCompleted, @statusCompletedErr, @statusCompletedWrn, @statusFailed, @statusKilled, @statusDelayed, @statusActive, @statusNoRun) = 1)
	SELECT		JB.jobId                                    AS 'JobId',
				CL.id										AS 'ClientId',
				CL.name										AS 'Client',
				IDA.name									AS 'Agent',
				I.name										AS 'Instance',
				BS.name										AS 'Backupset',
				APP.subclientName                           AS 'Subclient',
				JB.operationName                            AS 'Operation',
				JB.backupTypeName                           AS 'Backup Type',
				JB.jobStatusName                            AS 'Job Status',
				dbo.GetAutoSizeStr(JB.appSize)              AS 'Application size',
				dbo.UTCToLocalTime(dbo.GetDateTime(JB.startTime),@csTimeZone) as 'Start Date',
				dbo.UTCToLocalTime(dbo.GetDateTime(JB.endTime),@csTimeZone) as 'End Date',
				JB.protectedObjects                         AS 'Protected Objects',
				JB.failedObjects                            AS 'Failed Objects',
				JB.failedFolders                            AS 'Failed Folders',
				dbo.GetAutoSizeStr(JB.nwTransBytes)         AS 'Network size',
				ISNULL(JB.subTaskName, '')					AS 'Schedule',
				ISNULL(JB.taskName, '')						AS 'Schedule Policy',
				JB.clientGroup								AS 'Client Group'
			FROM   #JobSummary_tmp__Jobs JB
			INNER JOIN APP_Application   APP WITH (NOLOCK) ON APP.id = JB.subclientId
			INNER JOIN APP_CommCell      CC  WITH (NOLOCK) ON CC.id = APP.origCCId
			INNER JOIN APP_Client        CL  WITH (NOLOCK) ON CL.id = APP.clientId
			INNER JOIN APP_iDAType       IDA WITH (NOLOCK) ON IDA.[type] = APP.appTypeId
			INNER JOIN APP_InstanceName  I   WITH (NOLOCK) ON I.id = APP.instance
			INNER JOIN APP_BackupSetName BS  WITH (NOLOCK) ON BS.id = APP.backupset
			order by JB.clientId
	IF OBJECT_ID('tempdb.dbo.#ClientId')       IS NOT null DROP TABLE #ClientId
	IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__UserObjects')   IS NOT null DROP TABLE #JobSummary_tmp__UserObjects
	IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__EntityId')      IS NOT null DROP TABLE #JobSummary_tmp__EntityId
	IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__Entity')        IS NOT null DROP TABLE #JobSummary_tmp__Entity
	IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp_clientGroups')   IS NOT null DROP TABLE #JobSummary_tmp_clientGroups
	IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__Jobs')          IS NOT null DROP TABLE #JobSummary_tmp__Jobs
	IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__MediaAgent')    IS NOT null DROP TABLE #JobSummary_tmp__MediaAgent
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetBackupSummaryReport')
	delete from GxQscripts where name = 'JMGetBackupSummaryReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetBackupSummaryReport')
	delete from GXDBVersions where aliasname = 'JMGetBackupSummaryReport'
GO

insert into GXDBVersions values(2, 'JMGetBackupSummaryReport',  '00010001000400030000', 'JMGetBackupSummaryReport', '00010001000400030000')
GO

