

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetBackupSummaryCounts.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetBackupSummaryCounts.sp,v $ $Id: JMGetBackupSummaryCounts.sp,v 1.1.4.28.4.2 2021/03/29 15:29:28 sbonilla Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "JMGetBackupSummaryCounts"
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMGetBackupSummaryCounts')
BEGIN
	print '>>> Drop Stored Procedure: JMGetBackupSummaryCounts <<<'
	drop procedure JMGetBackupSummaryCounts
END
IF EXISTS (select * from GxQscripts where name='JMGetBackupSummaryCounts')
	delete from GxQscripts where name = 'JMGetBackupSummaryCounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetBackupSummaryCounts')
	delete from GXDBVersions where aliasname = 'JMGetBackupSummaryCounts'
GO
print '... Creating Procedure: JMGetBackupSummaryCounts'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMGetBackupSummaryCounts
-- Input arguments
  @i_userId INT,
  @i_NumberOfDays INT,
  @i_DashboardType NVARCHAR(128) = 'Server',
  @i_AppTypes NVARCHAR(MAX) = '',
  @i_flag INT = 0,					--0 : As of 12:00 AM every day, -1 : As of current Time from today
  @i_dailyweeklychange INT = 0		--1 : Get today, yesterday and lastweek values
AS
  DECLARE @dayBegin DATETIME
  DECLARE @completed INT
  DECLARE @failed INT
  DECLARE @killed INT
  DECLARE @running INT
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	DECLARE @csTimeZone    VARCHAR(256)
	SELECT @csTimeZone = timeZone FROM APP_CommCell WITH (NOLOCK) WHERE id = 2
	DECLARE	@TimeZoneBias	INT = DATEDIFF(SECOND, GETUTCDATE(), GETDATE())
	SELECT @csTimeZone = TimeZoneStdName FROM SchedTimeZone WITH (NOLOCK)
	WHERE  TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
	IF object_id('tempdb.dbo.#appTypes') IS NOT NULL DROP TABLE #appTypes
	 -- Table for apptypes if any
    CREATE TABLE #appTypes (apptypeId         INTEGER)
	IF @i_AppTypes IS NOT NULL AND @i_AppTypes <> ''
	BEGIN
		INSERT INTO #appTypes
		SELECT CAST(_ID AS INT)
		FROM dbo.SplitIDString(@i_AppTypes)
	END
	DECLARE @dtBegin DATETIME
	DECLARE @dtEnd   DATETIME
	DECLARE @i INT
	DECLARE @showPersistentRecoveryJobs INT = 0
	SELECT @showPersistentRecoveryJobs = ISNULL(CAST(value AS INT), 0)
	FROM GXGlobalParam WITH (NOLOCK)
	WHERE name = N'showPersistentRecoveryJobs'
	IF object_id('tempdb.dbo.#DailyTbl') IS NOT NULL DROP TABLE #DailyTbl
	CREATE TABLE #DailyTbl (DayVal date, DayBeginDT DATETIME, DayEndDT DATETIME, DayBegin INT, DayEnd INT, rowNo INT)
	CREATE CLUSTERED INDEX [#DailyTbl_DayBeginDT] ON [#DailyTbl]([DayBeginDT] ASC)
	IF object_id('tempdb.dbo.#JobResultsTbl') IS NOT NULL DROP TABLE #JobResultsTbl
	CREATE TABLE #JobResultsTbl (DayBeginDT DATETIME, Completed INT, CWE INT, CWW INT, Failed INT, Killed INT)
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Bkp') IS NOT NULL DROP TABLE #SecIDANodeAccessTemp_Bkp
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_VM') IS NOT NULL DROP TABLE #SecIDANodeAccessTemp_VM
	IF OBJECT_ID(N'tempdb.dbo.#sec_JobIDsList') IS NOT NULL DROP TABLE #sec_JobIDsList
	--Tenant admin should be able to view jobs submitted by other users in the company.
	IF OBJECT_ID('tempdb.dbo.#getUsersInCompanyOutputTbl') IS NOT NULL
		DROP TABLE #getUsersInCompanyOutputTbl
	CREATE TABLE #getUsersInCompanyOutputTbl (
		userId INTEGER,
		PRIMARY KEY(userId)
	)
	--Populates #getUsersInCompanyOutputTbl
	EXEC sec_getUsersInCompany @i_userId
	IF @i_flag = 0	--As of 12:00 AM
		SET @dtBegin	= DATEADD(Day, DATEDIFF(Day, 0, GETDATE()), 0)
	ELSE IF @i_flag = -1 --As of Current Time
		SET @dtBegin	= DATEADD(Day, -1, GETDATE())
	ELSE IF @i_flag > 0 -- will return data by timezone
    BEGIN
        SET @csTimeZone = (SELECT top(1) TimeZoneStdName from SchedTimeZone (NOLOCK) where TimeZoneID=@i_flag)
        SET @dtBegin    = dbo.UTCToLocalTime(GETUTCDATE(),@csTimeZone )
        SET @dtBegin    = DATEADD(Day, DATEDIFF(Day, 0, @dtBegin), 0)
    END
	SET @dtEnd	= DATEADD(Day, 1, @dtBegin)
	SET @i = 0
	IF @i_dailyweeklychange = 1 AND @i_NumberOfDays = 1 --current day, yesterday and lastweek
	SET @i_NumberOfDays = 8
	WHILE @i < @i_NumberOfDays
	BEGIN
		INSERT	INTO #DailyTbl
		SELECT	@dtBegin, @dtBegin, @dtEnd, 0, 0, @i
		SET @dtEnd	 = @dtBegin
		SET @dtBegin = DATEADD(Day, -1, @dtEnd)
		SET @i = (@i + 1)
	END
	IF @i_dailyweeklychange = 1 --current day, yesterday and lastweek
		DELETE FROM #DailyTbl WHERE rowNo NOT IN (0, 1, 7)
	UPDATE	#DailyTbl SET DayBeginDT = dbo.LocalToUTCTime(DayBeginDT, @csTimeZone), DayEndDT = dbo.LocalToUTCTime(DayEndDT, @csTimeZone)
	UPDATE	#DailyTbl SET DayBegin = dbo.GetUnixTime(DayBeginDT), DayEnd = dbo.GetUnixTime(DayEndDT)
	CREATE TABLE #SecIDANodeAccessTemp_Bkp
	(
		t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
	)
	CREATE CLUSTERED INDEX [#SecIDANodeAccessTemp_Bkp_subclientId] ON [#SecIDANodeAccessTemp_Bkp]([t_subclientId] ASC)
	CREATE TABLE #SecIDANodeAccessTemp_VM
    (
        t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
    )
    CREATE NONCLUSTERED INDEX [#SecIDANodeAccessTemp_VM_ClientID] ON [#SecIDANodeAccessTemp_VM]([t_clientId] ASC)
	CREATE TABLE #sec_JobIDsList
	(
		JobID INTEGER,
		commCellID INTEGER,
	)
	CREATE CLUSTERED INDEX JIDIDX ON #sec_JobIDsList(JobID, commCellID)
	DECLARE @isMSPUserComcellAdmin INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 1, @isMSPUserComcellAdmin OUT,1,2
	IF @i_DashboardType IN ('Commcell', 'ApplianceCommcell', 'Appliance')
	BEGIN
		IF @isMSPUserComcellAdmin =0
			SET @i_DashboardType = 'Server'
	END
	BEGIN
		-- Security check from JMJobSummaryPrologue.spb
		EXEC sec_getIdaObjectsForUser @i_userId, 7,0,0,'#SecIDANodeAccessTemp_Bkp',0,'16,12,20,22,13,15,31',0
		-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_BACKUP-1)| POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_BROWSE-1)| POWER(2,EV_RUN_REPORTS-1) | POWER(2,EV_VISIBILITY-1)
		exec sec_getIdaObjectsForUser @i_userId,3,0,0,'#SecIDANodeAccessTemp_VM',0,'16,12,20,22,13,15,31',0
		-- Delete the clients which are either not a VM or not V1
		DELETE SEC
		FROM #SecIDANodeAccessTemp_VM SEC
		LEFT JOIN App_ClientProp CP ON SEC.t_clientId = CP.componentNameId AND CP.attrName = 'Virtual Server Discovered Clients' AND CP.attrVal = '1' AND CP.modified = 0
		--LEFT JOIN App_ClientProp CP2 ON SEC.t_clientId = CP2.componentNameId AND CP2.attrName = 'IndexingV2_VSA' AND CP2.attrVal = '1' AND CP2.modified = 0
		LEFT JOIN APP_IDAName IDA ON IDA.clientId = SEC.t_clientId
		LEFT JOIN APP_IDAProp IPROP ON IPROP.componentNameId = IDA.id AND IPROP.attrName = 'Pseudo Apptype' AND IPROP.modified = 0 AND IPROP.attrVal = '1'
		WHERE CP.id IS NULL -- Not a VM
			  --OR CP2.id IS NOT NULL -- V2 enabled
			  OR IPROP.id IS NOT NULL -- Is a Pseudo client - It means it is a discovered client that got converted to a VM. So don't count as a VM
		-- For VSA, even if user has rights on VM, we should show the VSA job. Only for V1
		IF EXISTS (SELECT 1 FROM #SecIDANodeAccessTemp_VM)
		BEGIN
			INSERT INTO #sec_JobIDsList
			SELECT DISTINCT Q.jobId, Q.commCellId
			FROM JMQinetixUpdateStatus Q
			INNER JOIN #SecIDANodeAccessTemp_VM SEC ON Q.clientId = SEC.t_clientId
		END
		DECLARE @restoreCap INTEGER
		-- POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_RESTORE_IN_PLACE-1) | POWER(2,EV_RESTORE_OUTOF_PLACE-1) | POWER(2,EV_VISIBILITY-1)
		SET @restoreCap = POWER(2,16-1) | POWER(2,20-1) | POWER(2,22-1) | POWER(2,31-1)
		IF object_id('tempdb.dbo.#JMCanManageJob_rstObject') IS NOT NULL DROP TABLE #JMCanManageJob_rstObject
create table  #JMCanManageJob_rstObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		exec sec_getUserObjects @i_userId,2012,0,'#JMCanManageJob_rstObject'
		DELETE FROM #JMCanManageJob_rstObject
		WHERE  (Capabilities & @restoreCap) = 0
		DECLARE @isAllAssoc INT = (SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK) WHERE
								   (rstUserObject.commCellId=2 AND rstUserObject.clientGroupId=0 AND rstUserObject.clientId=0 AND rstUserObject.appTypeId=0 AND rstUserObject.instanceId=0 AND rstUserObject.backupsetId=0 AND rstUserObject.subClientId=0 AND rstUserObject.mediaAgentId=0 AND rstUserObject.libraryId=0 AND rstUserObject.archGroupId=0 AND rstUserObject.vtContainerId=0 AND rstUserObject.vtPolicyId=0 AND rstUserObject.vtShelfId=0 AND rstUserObject.reviewSetId=0 AND rstUserObject.querySetId=0 AND rstUserObject.downloadSetId=0 AND rstUserObject.ermId=0 AND rstUserObject.legalHoldId=0 AND rstUserObject.tagId=0 AND rstUserObject.cdPolicyId=0 AND rstUserObject.complianceReportId=0 AND rstUserObject.taskId=0 AND rstUserObject.workflowId=0 AND rstUserObject.logMonitoringPolicyId=0 AND rstUserObject.arrayId=0 AND rstUserObject.cloudId=0 AND rstUserObject.userGroupId=0 AND rstUserObject.providerId=0 AND rstUserObject.entityId1=0 AND rstUserObject.entityId2=0 AND rstUserObject.entityId3=0 AND rstUserObject.entityId4=0 AND rstUserObject.entityId5=0									AND rstUserObject.entityId6=0 AND rstUserObject.entityId7=0 AND rstUserObject.entityId8=0 AND rstUserObject.entityId9=0)
								   OR (rstUserObject.clientId=-10))
		IF (@isAllAssoc <> 1)
			MERGE #JMCanManageJob_rstObject DST
			USING (SELECT dbo.BitWiseOR(SEC.capabilities) AS capabilities, CGA.clientId
				   FROM #JMCanManageJob_rstObject SEC
				   INNER JOIN App_ClientGroupAssoc CGA ON SEC.clientGroupId = CGA.clientGroupId
				   GROUP BY CGA.clientId ) SRC
			ON SRC.clientId = DST.clientId
			WHEN MATCHED THEN
				UPDATE SET DST.capabilities = DST.capabilities | SRC.capabilities
			WHEN NOT MATCHED THEN
				INSERT (capabilities, clientId)
				VALUES( SRC.capabilities, SRC.clientId);
	END
	DECLARE @restoreJobs INT = 0, @adminJobs INT  = 0
	IF object_id('tempdb.dbo.#RestoreJobs') IS NOT NULL DROP TABLE #RestoreJobs
	CREATE TABLE #RestoreJobs (DayBeginDT DATETIME, JobID INT, Status INT)
	IF object_id('tempdb.dbo.#AdminJobs') IS NOT NULL DROP TABLE #AdminJobs
	CREATE TABLE #AdminJobs (DayBeginDT DATETIME, JobID INT, Status INT)
	IF @i_DashboardType IN ('Commcell', 'ApplianceCommcell', 'Appliance') --No security check
	BEGIN
		SELECT @running = count(J.jobId) FROM JMJobInfo J WITH(READUNCOMMITTED) WHERE J.opType <> 12 --Exclude Index Restore Jobs
		INSERT INTO #JobResultsTbl
		SELECT  DayBeginDT, SUM(Completed) Completed, SUM(CWE) CWE, SUM(CWW) CWW, SUM(Failed) Failed,SUM(Killed) Killed
		 FROM
         (
		   SELECT   d.DayBeginDT AS 'DayBeginDT',
					isnull(sum(case when displayStatus in ( 1 ) then 1 else 0 end),0) as 'Completed',
					isnull(sum(case when displayStatus in ( 3 ) then 1 else 0 end),0) as 'CWE',
					isnull(sum(case when displayStatus in ( 14 ) then 1 else 0 end),0) as 'CWW',
					isnull(sum(case when displayStatus in ( 2,9 ) then 1 else 0 end),0) as 'Failed',
					isnull(sum(case when displayStatus in ( 4 ) then 1 else 0 end),0) as 'Killed'
			FROM #DailyTbl d
			INNER JOIN JMBkpStats B WITH(READUNCOMMITTED) ON servEndDate >= d.DayBegin AND servEndDate <= d.DayEnd
			WHERE ((B.dataStatus IN (1, 2) AND B.status IN (2, 4)) OR B.dataStatus NOT IN (1,2))
			GROUP BY d.DayBeginDT
            UNION ALL
			SELECT d.DayBeginDT AS 'DayBeginDT',
					isnull(sum(case when status in ( 1 ) then 1 else 0 end),0) as 'Completed',
					isnull(sum(case when status in ( 3 ) then 1 else 0 end),0) as 'CWE',
					isnull(sum(case when status in ( 14 ) then 1 else 0 end),0) as 'CWW',
					isnull(sum(case when status in ( 2,9 ) then 1 else 0 end),0) as 'Failed',
					isnull(sum(case when status in ( 4 ) then 1 else 0 end),0) as 'Killed'
			FROM #DailyTbl d
			INNER JOIN JMAdminJobStatsTable  B WITH(READUNCOMMITTED) ON servEnd >= d.DayBegin AND servEnd <= d.DayEnd
			WHERE ((B.dataStatus IN (1, 2) AND B.status IN (2, 4)) OR B.dataStatus NOT IN (1,2))
			GROUP BY d.DayBeginDT
			UNION ALL
				SELECT d.DayBeginDT AS 'DayBeginDT',
					isnull(sum(case when status in ( 1 ) then 1 else 0 end),0) as 'Completed',
					isnull(sum(case when status in ( 3 ) then 1 else 0 end),0) as 'CWE',
					isnull(sum(case when status in ( 14 ) then 1 else 0 end),0) as 'CWW',
					isnull(sum(case when status in ( 2,9 ) then 1 else 0 end),0) as 'Failed',
					isnull(sum(case when status in ( 4 ) then 1 else 0 end),0) as 'Killed'
			FROM #DailyTbl d
			INNER JOIN JMRestoreStats  B WITH(READUNCOMMITTED) ON servEndtime >= d.DayBegin AND servEndtime <= d.DayEnd  AND B.opType <> 12 --Exclude Index Restore Jobs
			GROUP BY d.DayBeginDT
			) JobStats
			GROUP BY DayBeginDT
	END
	ELSE IF @i_DashboardType = 'Server'	--With security check. Used in tenant dashboard
	BEGIN
		--Running restore jobs
		SELECT @restoreJobs = count(DISTINCT JM.jobId)
		FROM JMRstJobInfo JM WITH(READUNCOMMITTED)
		INNER JOIN JMJobInfo JI on JM.jobid = JI.jobId AND JM.commcellId = JI.commcellId
		WHERE --dbo.isRstJobVisible(@i_userId, J.commCellId, J.srcClientId, J.destClientId,  J.appType, J.instanceID, J.bkpSetID) =1
		(((rstattributes & 0x100 /*JMRST_SYNC_RESTORE*/) = 0))
		AND
		(
		JI.userId = @i_userId OR @isAllAssoc = 1 OR
		EXISTS(
					SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK) WHERE
					-- if you have the rights on the destination at any level then you will see the restore job
					(rstUserObject.clientid=destClientID AND destClientID <> 0 AND appType <> 78) OR  -- For UNC restores from web console, destination client could be 0. Do not use it to check security. Ignore for share point CV_APPTYPE_MS_SHAREPOINTV2_DOC
					(rstUserObject.clientid=srcClientID AND apptypeid=0) OR
					(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=0) OR
					(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=0) OR
					(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=bkpSetID AND rstUserObject.subclientid=0) --OR
					-- Not needed because we expand it above
					--((rstUserObject.clientgroupid <> 0 AND EXISTS (SELECT TOP 1 1 FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = rstUserObject.clientGroupId  OR rstUserObject.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=srcClientID OR APP_ClientGroupAssoc.clientid=destClientID))))
					)
		)
		AND JI.opType <> 12 --Exclude Index Restore Jobs
		-- Running admin jobs
		IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_adminObject') IS NOT NULL	DROP TABLE #JMCanManageJob_adminObject
		DECLARE @adminCap INTEGER
		SET @adminCap = POWER(2,1-1) | POWER(2,16-1) | POWER(2,4-1) | POWER(2,8-1) | POWER(2,31-1)
		--POWER(2,EV_SCHEDULE_ADMIN-1) | POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_MANAGE_ARCHIVES-1) | POWER(2,EV_MANAGE_LIBRARY-1) | POWER(2,EV_VISIBILITY-1)
create table  #JMCanManageJob_adminObject ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		exec sec_getUserObjects @i_userId,2013,0,'#JMCanManageJob_adminObject'
		exec sec_getUserObjects @i_userId,14033,0,'#JMCanManageJob_adminObject'
		exec sec_getUserObjects @i_userId,2231,0,'#JMCanManageJob_adminObject'
		DELETE FROM #JMCanManageJob_adminObject
			WHERE  (Capabilities & @adminCap) = 0
		SELECT @adminJobs = COUNT(DISTINCT RA.jobId)
		FROM RunningAdminJobs RA
		INNER JOIN JMAdminJobInfoTable JMA
			ON RA.jobId = JMA.jobId
			AND RA.commCellId = JMA.commCellId
		INNER JOIN JMJobInfo JI
			ON RA.jobId = JI.jobId
		LEFT JOIN #getUsersInCompanyOutputTbl UIC
			ON UIC.userId = RA.userId
		WHERE @i_userId = 0
				OR @i_userId = RA.userId
				OR UIC.userId IS NOT NULL
				OR EXISTS
				(
					SELECT 1 FROM #JMCanManageJob_adminObject userObject
					WHERE
						(RA.opType = 90 AND JMA.workFlowID <> 0 AND userObject.workflowId = JMA.workFlowID)
					union all
					SELECT 1 FROM #JMCanManageJob_adminObject userObject
					WHERE
						(RA.opType IN (104,13) AND RA.archGrpId <> 0 AND userObject.archGroupId = RA.archGrpId)
					union all
					SELECT 1 FROM #JMCanManageJob_adminObject userObject
					WHERE
(userObject.commCellId=2 AND userObject.clientGroupId=0 AND userObject.clientId=0 AND userObject.appTypeId=0 AND userObject.instanceId=0 AND userObject.backupsetId=0 AND userObject.subClientId=0 AND userObject.mediaAgentId=0 AND userObject.libraryId=0 AND userObject.archGroupId=0 AND userObject.vtContainerId=0 AND userObject.vtPolicyId=0 AND userObject.vtShelfId=0 AND userObject.reviewSetId=0 AND userObject.querySetId=0 AND userObject.downloadSetId=0 AND userObject.ermId=0 AND userObject.legalHoldId=0 AND userObject.tagId=0 AND userObject.cdPolicyId=0 AND userObject.complianceReportId=0 AND userObject.taskId=0 AND userObject.workflowId=0 AND userObject.logMonitoringPolicyId=0 AND userObject.arrayId=0 AND userObject.cloudId=0 AND userObject.userGroupId=0 AND userObject.providerId=0 AND userObject.entityId1=0 AND userObject.entityId2=0 AND userObject.entityId3=0 AND userObject.entityId4=0 AND userObject.entityId5=0									AND userObject.entityId6=0 AND userObject.entityId7=0 AND userObject.entityId8=0 AND userObject.entityId9=0)
					union all
					SELECT 1 FROM #JMCanManageJob_adminObject userObject
					WHERE
						(RA.opType IN (21,32,41,42,46,47)  AND (libraryId =-10 OR userObject.libraryId IN (SELECT attributeValueInt FROM JMJobOptions jOption WITH(NOLOCK) WHERE jOption.jobId = RA.jobID AND jOption.commCellId = RA.commCellId AND jOption.attributeId = 10)))
					UNION ALL
					-- For subclient level jobs, check for backup rights
					SELECT 1 FROM #SecIDANodeAccessTemp_Bkp bkpObjects
					WHERE
						(RA.opType IN (134, 139, 113, 112, 130) AND bkpObjects.t_subclientId = RA.appId)
				)
		AND JMA.opType <> 53 --Exclude Data Analytics Job
		--All running jobs
		SELECT @running = count(B.jobId) + @restoreJobs + @adminJobs
		FROM JMJobInfo J WITH(READUNCOMMITTED)
		INNER JOIN JMBkpJobInfo B WITH(READUNCOMMITTED) ON J.jobId = B.jobId AND J.commcellId = B.commCellId
		INNER JOIN #SecIDANodeAccessTemp_Bkp SEC
			ON SEC.t_subclientId = B.applicationId
		INSERT INTO #RestoreJobs
		SELECT DISTINCT d.DayBeginDT, RS.jobId, RS.status
		FROM #DailyTbl d
		INNER JOIN JMRestoreStats RS WITH(READUNCOMMITTED)
			ON RS.servEndTime >= d.DayBegin AND RS.servEndTime <= d.DayEnd
			AND (@isAllAssoc = 1 OR EXISTS(
							SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK) WHERE
							-- if you have the rights on the destination at any level then you will see the restore job
							(rstUserObject.clientid=destClientID AND destClientID <> 0 AND appType <> 78) OR  -- For UNC restores from web console, destination client could be 0. Do not use it to check security. Ignore for share point CV_APPTYPE_MS_SHAREPOINTV2_DOC
							(rstUserObject.clientid=srcClientID AND apptypeid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=bkpSetID AND rstUserObject.subclientid=0) --OR
							-- Not needed because we expand it above
							--((rstUserObject.clientgroupid <> 0 AND EXISTS (SELECT TOP 1 1 FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = rstUserObject.clientGroupId  OR rstUserObject.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=srcClientID OR APP_ClientGroupAssoc.clientid=destClientID))))
							)
			--AND  dbo.isRstJobVisible(@i_userId,commCellId,srcClientID,destClientID,appType,instanceID,bkpSetID) = 1
			)
		AND RS.opType <> 12 --Exclude Index Restore Jobs
		AND (RS.opType <> 29 /*QUICKDMRST*/ OR @showPersistentRecoveryJobs = 1) --Hide persistent restore jobs from UI
		INSERT INTO #AdminJobs
		SELECT DISTINCT d.DayBeginDT, JM.jobId, JM.status
		FROM #DailyTbl d
		INNER JOIN JMAdminJobStatsTable JM
			ON JM.servEnd >= d.DayBegin AND JM.servEnd <= d.DayEnd
			AND ((JM.dataStatus IN (1, 2) AND JM.status IN (2, 4)) OR JM.dataStatus NOT IN (1,2))
		INNER JOIN JMJobStats JStats
			ON JM.jobId = JStats.jobId
			And JM.CommcellId = JStats.CommcellId
		LEFT JOIN #getUsersInCompanyOutputTbl UIC
			ON UIC.userId = (SELECT id FROM UMUsers WHERE login=JM.UserName)
		WHERE @i_userId = 0
				OR @i_userId = (SELECT id FROM UMUsers WHERE login=JM.UserName)
				OR UIC.userId IS NOT NULL
				OR EXISTS
				(SELECT 1 FROM #JMCanManageJob_adminObject userObject
						WHERE
							(JM.opType = 90 AND JM.workFlowID <> 0 AND userObject.workflowId = JM.workFlowID)
					union all
				SELECT 1 FROM #JMCanManageJob_adminObject userObject
						WHERE
							(JM.opType IN (104,13) AND JM.archGrpId <> 0 AND userObject.archGroupId = JM.archGrpId)
					union all
				SELECT 1 FROM #JMCanManageJob_adminObject userObject
						WHERE
(userObject.commCellId=2 AND userObject.clientGroupId=0 AND userObject.clientId=0 AND userObject.appTypeId=0 AND userObject.instanceId=0 AND userObject.backupsetId=0 AND userObject.subClientId=0 AND userObject.mediaAgentId=0 AND userObject.libraryId=0 AND userObject.archGroupId=0 AND userObject.vtContainerId=0 AND userObject.vtPolicyId=0 AND userObject.vtShelfId=0 AND userObject.reviewSetId=0 AND userObject.querySetId=0 AND userObject.downloadSetId=0 AND userObject.ermId=0 AND userObject.legalHoldId=0 AND userObject.tagId=0 AND userObject.cdPolicyId=0 AND userObject.complianceReportId=0 AND userObject.taskId=0 AND userObject.workflowId=0 AND userObject.logMonitoringPolicyId=0 AND userObject.arrayId=0 AND userObject.cloudId=0 AND userObject.userGroupId=0 AND userObject.providerId=0 AND userObject.entityId1=0 AND userObject.entityId2=0 AND userObject.entityId3=0 AND userObject.entityId4=0 AND userObject.entityId5=0									AND userObject.entityId6=0 AND userObject.entityId7=0 AND userObject.entityId8=0 AND userObject.entityId9=0)
					union all
				SELECT 1 FROM #JMCanManageJob_adminObject userObject
						WHERE
							(JM.opType IN (21,32,41,42,46,47)  AND (libraryId =-10 OR userObject.libraryId IN (SELECT attributeValueInt FROM JMJobOptions WITH(NOLOCK) WHERE jobId = JM.jobID AND commCellId = JM.commCellId AND attributeId = 10)))
					union all
						-- For subclient level jobs, check for backup rights
					SELECT 1 FROM #SecIDANodeAccessTemp_Bkp bkpObjects
					WHERE
						(JM.opType IN (134, 139, 113, 112, 130) AND bkpObjects.t_subclientId = JM.appId)
				)
		AND JM.opType <> 53 --Exclude Data Analytics Job
		IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_adminObject') IS NOT NULL DROP TABLE #JMCanManageJob_adminObject
		INSERT INTO #JobResultsTbl
		SELECT  DayBeginDT, SUM(Completed) Completed, SUM(CWE) CWE, SUM(CWW) CWW, SUM(Failed) Failed,SUM(Killed) Killed
		FROM
		(SELECT d.DayBeginDT AS 'DayBeginDT',
				isnull(sum(case when displayStatus in ( 1 ) then 1 else 0 end),0) as 'Completed',
				isnull(sum(case when displayStatus in ( 3 ) then 1 else 0 end),0) as 'CWE',
				isnull(sum(case when displayStatus in ( 14 ) then 1 else 0 end),0) as 'CWW',
				isnull(sum(case when displayStatus in ( 2,9 ) then 1 else 0 end),0) as 'Failed',
				isnull(sum(case when displayStatus in ( 4 ) then 1 else 0 end),0) as 'Killed'
		FROM #DailyTbl d
		INNER JOIN JMBkpStats B WITH(READUNCOMMITTED) ON servEndDate >= d.DayBegin AND servEndDate <= d.DayEnd
		LEFT OUTER JOIN #SecIDANodeAccessTemp_Bkp SEC ON SEC.t_subclientId = B.appId
		LEFT OUTER JOIN #sec_JobIDsList SJ ON SJ.jobId = B.jobId AND SJ.commcellId = B.commcellId
		WHERE
		((B.dataStatus IN (1, 2) AND B.status IN (2, 4)) OR B.dataStatus NOT IN (1,2))
		AND (SEC.t_clientId IS NOT NULL OR SJ.jobId IS NOT NULL) -- Either standard security rights or rights bubbled up from VM
		GROUP BY d.DayBeginDT
		UNION ALL
		SELECT
			RS.DayBeginDT,
			isnull(sum(case when Status in ( 1 ) then 1 else 0 end),0) as 'Completed',
			isnull(sum(case when Status in ( 3 ) then 1 else 0 end),0) as 'CWE',
			isnull(sum(case when Status in ( 14 ) then 1 else 0 end),0) as 'CWW',
			isnull(sum(case when Status in ( 2,9 ) then 1 else 0 end),0) as 'Failed',
			isnull(sum(case when Status in ( 4 ) then 1 else 0 end),0) as 'Killed'
		FROM #DailyTbl d INNER JOIN #RestoreJobs RS ON d.DayBeginDT = RS.DayBeginDT
		GROUP BY RS.DayBeginDT
		UNION ALL
		SELECT
			RS.DayBeginDT,
			isnull(sum(case when Status in ( 1 ) then 1 else 0 end),0) as 'Completed',
			isnull(sum(case when Status in ( 3 ) then 1 else 0 end),0) as 'CWE',
			isnull(sum(case when Status in ( 14 ) then 1 else 0 end),0) as 'CWW',
			isnull(sum(case when Status in ( 2,9 ) then 1 else 0 end),0) as 'Failed',
			isnull(sum(case when Status in ( 4 ) then 1 else 0 end),0) as 'Killed'
		FROM #DailyTbl d INNER JOIN #AdminJobs RS ON d.DayBeginDT = RS.DayBeginDT
		GROUP BY RS.DayBeginDT) JobStats
		GROUP BY DayBeginDT
	END
	ELSE IF @i_DashboardType = 'Endpoint'
	BEGIN
		--Running restore jobs
		SELECT @restoreJobs = count(DISTINCT JM.jobId)
		FROM JMRstJobInfo JM WITH(READUNCOMMITTED)
		INNER JOIN JMJobInfo JI on JM.jobid = JI.jobId AND JM.commcellId = JI.commcellId
		INNER JOIN APP_Client CL ON JM.srcClientId = CL.id AND CL.status & 0x1000 = 0x1000 --Laptops
		WHERE --dbo.isRstJobVisible(@i_userId, J.commCellId, J.srcClientId, J.destClientId,  J.appType, J.instanceID, J.bkpSetID) =1
		(((rstattributes & 0x100 /*JMRST_SYNC_RESTORE*/) = 0))
		AND
		(
		JI.userId = @i_userId OR @isAllAssoc = 1 OR
		EXISTS(
					SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK) WHERE
					-- if you have the rights on the destination at any level then you will see the restore job
					(rstUserObject.clientid=destClientID AND destClientID <> 0 AND appType <> 78) OR  -- For UNC restores from web console, destination client could be 0. Do not use it to check security. Ignore for share point CV_APPTYPE_MS_SHAREPOINTV2_DOC
					(rstUserObject.clientid=srcClientID AND apptypeid=0) OR
					(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=0) OR
					(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=0) OR
					(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=bkpSetID AND rstUserObject.subclientid=0) --OR
					-- Not needed because we expand it above
					--((rstUserObject.clientgroupid <> 0 AND EXISTS (SELECT TOP 1 1 FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = rstUserObject.clientGroupId  OR rstUserObject.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=srcClientID OR APP_ClientGroupAssoc.clientid=destClientID))))
					)
		)
		AND JI.opType <> 12 --Exclude Index Restore Jobs
		-- Running admin jobs
		SELECT @adminJobs = COUNT(DISTINCT JM.jobId)
		FROM JMAdminJobInfoTable JM WITH(READUNCOMMITTED)
		INNER JOIN APP_Application APP
			ON JM.appID = APP.id
		INNER JOIN #SecIDANodeAccessTemp_Bkp SEC
			ON SEC.t_subclientId = APP.id
		INNER JOIN APP_Client CL
			ON SEC.t_clientId = CL.id
			AND CL.status & 0x1000 = 0x1000 --Laptops
			AND JM.opType <> 53 --Exclude Data Analytics Job
		--All running jobs
		SELECT @running = count(B.jobId) + @restoreJobs + @adminJobs
		FROM JMJobInfo J WITH(READUNCOMMITTED)
		INNER JOIN JMBkpJobInfo B WITH(READUNCOMMITTED) ON J.jobId = B.jobId AND J.commcellId = B.commCellId
		INNER JOIN #SecIDANodeAccessTemp_Bkp SEC
			ON SEC.t_subclientId = B.applicationId
		INNER JOIN App_Application APP ON B.applicationId = APP.id
		INNER JOIN App_Client CL ON CL.id = APP.clientId AND CL.status & 0x1000 = 0x1000 --Laptops
		INSERT INTO #RestoreJobs
		SELECT DISTINCT d.DayBeginDT, RS.jobId, RS.status
		FROM #DailyTbl d
		INNER JOIN JMRestoreStats RS WITH(READUNCOMMITTED)
			ON RS.servEndTime >= d.DayBegin AND RS.servEndTime <= d.DayEnd
		INNER JOIN APP_Client CL
			ON CL.id = RS.srcClientId
			AND CL.status & 0x1000 = 0x1000 --Laptops
			AND (@isAllAssoc = 1 OR EXISTS(
							SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK) WHERE
							-- if you have the rights on the destination at any level then you will see the restore job
							(rstUserObject.clientid=destClientID AND destClientID <> 0 AND appType <> 78) OR  -- For UNC restores from web console, destination client could be 0. Do not use it to check security. Ignore for share point CV_APPTYPE_MS_SHAREPOINTV2_DOC
							(rstUserObject.clientid=srcClientID AND apptypeid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=bkpSetID AND rstUserObject.subclientid=0) --OR
							-- Not needed because we expand it above
							--((rstUserObject.clientgroupid <> 0 AND EXISTS (SELECT TOP 1 1 FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = rstUserObject.clientGroupId  OR rstUserObject.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=srcClientID OR APP_ClientGroupAssoc.clientid=destClientID))))
							)
			--AND  dbo.isRstJobVisible(@i_userId,commCellId,srcClientID,destClientID,appType,instanceID,bkpSetID) = 1
			)
		AND RS.opType <> 12 --Exclude Index Restore Jobs
		AND (RS.opType <> 29 /*QUICKDMRST*/ OR @showPersistentRecoveryJobs = 1) --Hide persistent restore jobs from UI
		INSERT INTO #AdminJobs
		SELECT DISTINCT d.DayBeginDT, JM.jobId, JM.status
		FROM #DailyTbl d
		INNER JOIN JMAdminJobStatsTable JM
			ON JM.servEnd >= d.DayBegin AND JM.servEnd <= d.DayEnd
			AND ((JM.dataStatus IN (1, 2) AND JM.status IN (2, 4)) OR JM.dataStatus NOT IN (1,2))
		INNER JOIN APP_Application APP
			ON JM.appID = APP.id
		INNER JOIN #SecIDANodeAccessTemp_Bkp SEC
			ON SEC.t_subclientId = APP.id
		INNER JOIN APP_Client CL
			ON CL.id = APP.clientId
			AND CL.status & 0x1000 = 0x1000 --Laptops
			AND JM.opType <> 53 --Exclude Data Analytics Job
		INSERT INTO #JobResultsTbl
		SELECT  DayBeginDT, SUM(Completed) Completed, SUM(CWE) CWE, SUM(CWW) CWW, SUM(Failed) Failed,SUM(Killed) Killed
		FROM
		(SELECT d.DayBeginDT AS 'DayBeginDT',
				isnull(sum(case when displayStatus in ( 1 ) then 1 else 0 end),0) as 'Completed',
				isnull(sum(case when displayStatus in ( 3 ) then 1 else 0 end),0) as 'CWE',
				isnull(sum(case when displayStatus in ( 14 ) then 1 else 0 end),0) as 'CWW',
				isnull(sum(case when displayStatus in ( 2,9 ) then 1 else 0 end),0) as 'Failed',
				isnull(sum(case when displayStatus in ( 4 ) then 1 else 0 end),0) as 'Killed'
		FROM #DailyTbl d
		INNER JOIN JMBkpStats B WITH(READUNCOMMITTED) ON servEndDate >= d.DayBegin AND servEndDate <= d.DayEnd
		INNER JOIN App_Application APP ON B.appId = APP.id
		INNER JOIN App_Client CL ON CL.id = APP.clientId
		INNER JOIN #SecIDANodeAccessTemp_Bkp SEC ON SEC.t_subclientId = B.appId
		WHERE
		((B.dataStatus IN (1, 2) AND B.status IN (2, 4)) OR B.dataStatus NOT IN (1,2)) AND
		 CL.status & 0x1000 = 0x1000 --Laptops
		GROUP BY d.DayBeginDT
		UNION ALL
		SELECT
			RS.DayBeginDT,
			isnull(sum(case when Status in ( 1 ) then 1 else 0 end),0) as 'Completed',
			isnull(sum(case when Status in ( 3 ) then 1 else 0 end),0) as 'CWE',
			isnull(sum(case when Status in ( 14 ) then 1 else 0 end),0) as 'CWW',
			isnull(sum(case when Status in ( 2,9 ) then 1 else 0 end),0) as 'Failed',
			isnull(sum(case when Status in ( 4 ) then 1 else 0 end),0) as 'Killed'
		FROM #DailyTbl d INNER JOIN #RestoreJobs RS ON d.DayBeginDT = RS.DayBeginDT
		GROUP BY RS.DayBeginDT
		UNION ALL
		SELECT
			RS.DayBeginDT,
			isnull(sum(case when Status in ( 1 ) then 1 else 0 end),0) as 'Completed',
			isnull(sum(case when Status in ( 3 ) then 1 else 0 end),0) as 'CWE',
			isnull(sum(case when Status in ( 14 ) then 1 else 0 end),0) as 'CWW',
			isnull(sum(case when Status in ( 2,9 ) then 1 else 0 end),0) as 'Failed',
			isnull(sum(case when Status in ( 4 ) then 1 else 0 end),0) as 'Killed'
		FROM #DailyTbl d INNER JOIN #AdminJobs RS ON d.DayBeginDT = RS.DayBeginDT
		GROUP BY RS.DayBeginDT) JobStats
		GROUP BY DayBeginDT
	END
	ELSE IF @i_DashboardType = 'Replication'
	BEGIN
		--Running restore jobs
		SELECT @restoreJobs = count(DISTINCT JM.jobId)
		FROM JMRstJobInfo JM WITH(READUNCOMMITTED)
		INNER JOIN JMJobInfo JI on JM.jobid = JI.jobId AND JM.commcellId = JI.commcellId  and JI.opType = 105
		WHERE --dbo.isRstJobVisible(@i_userId, J.commCellId, J.srcClientId, J.destClientId,  J.appType, J.instanceID, J.bkpSetID) =1
		(((rstattributes & 0x100 /*JMRST_SYNC_RESTORE*/) = 0))
		AND
		(
		JI.userId = @i_userId OR @isAllAssoc = 1 OR
		EXISTS(
					SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK) WHERE
					-- if you have the rights on the destination at any level then you will see the restore job
					(rstUserObject.clientid=destClientID AND destClientID <> 0 AND appType <> 78) OR  -- For UNC restores from web console, destination client could be 0. Do not use it to check security. Ignore for share point CV_APPTYPE_MS_SHAREPOINTV2_DOC
					(rstUserObject.clientid=srcClientID AND apptypeid=0) OR
					(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=0) OR
					(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=0) OR
					(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=bkpSetID AND rstUserObject.subclientid=0) --OR
					-- Not needed because we expand it above
					--((rstUserObject.clientgroupid <> 0 AND EXISTS (SELECT TOP 1 1 FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = rstUserObject.clientGroupId  OR rstUserObject.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=srcClientID OR APP_ClientGroupAssoc.clientid=destClientID))))
					)
		)
		-- Running admin jobs
		IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_adminObject') IS NOT NULL	DROP TABLE #JMCanManageJob_adminObject1
		DECLARE @adminCap1 INTEGER
		SET @adminCap1 = POWER(2,1-1) | POWER(2,16-1) | POWER(2,4-1) | POWER(2,8-1) | POWER(2,31-1)
		--POWER(2,EV_SCHEDULE_ADMIN-1) | POWER(2,EV_MANAGE_OPERATIONS-1) | POWER(2,EV_MANAGE_ARCHIVES-1) | POWER(2,EV_MANAGE_LIBRARY-1) | POWER(2,EV_VISIBILITY-1)
create table  #JMCanManageJob_adminObject1 ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		exec sec_getUserObjects @i_userId,2013,0,'#JMCanManageJob_adminObject1'
		exec sec_getUserObjects @i_userId,14033,0,'#JMCanManageJob_adminObject1'
		exec sec_getUserObjects @i_userId,2231,0,'#JMCanManageJob_adminObject1'
		DELETE FROM #JMCanManageJob_adminObject1
			WHERE  (Capabilities & @adminCap1) = 0
		SELECT @adminJobs = COUNT(DISTINCT RA.jobId)
		FROM RunningAdminJobs RA
		INNER JOIN JMAdminJobInfoTable JMA
			ON RA.jobId = JMA.jobId
			AND RA.commCellId = JMA.commCellId
		INNER JOIN JMJobInfo JI
			ON RA.jobId = JI.jobId AND JMA.opType in ( 126, 135)
		LEFT JOIN #getUsersInCompanyOutputTbl UIC
			ON UIC.userId = RA.userId
		WHERE @i_userId = 0
				OR @i_userId = RA.userId
				OR UIC.userId IS NOT NULL
				OR EXISTS
				(
					SELECT 1 FROM #JMCanManageJob_adminObject1 userObject
					WHERE
(userObject.commCellId=2 AND userObject.clientGroupId=0 AND userObject.clientId=0 AND userObject.appTypeId=0 AND userObject.instanceId=0 AND userObject.backupsetId=0 AND userObject.subClientId=0 AND userObject.mediaAgentId=0 AND userObject.libraryId=0 AND userObject.archGroupId=0 AND userObject.vtContainerId=0 AND userObject.vtPolicyId=0 AND userObject.vtShelfId=0 AND userObject.reviewSetId=0 AND userObject.querySetId=0 AND userObject.downloadSetId=0 AND userObject.ermId=0 AND userObject.legalHoldId=0 AND userObject.tagId=0 AND userObject.cdPolicyId=0 AND userObject.complianceReportId=0 AND userObject.taskId=0 AND userObject.workflowId=0 AND userObject.logMonitoringPolicyId=0 AND userObject.arrayId=0 AND userObject.cloudId=0 AND userObject.userGroupId=0 AND userObject.providerId=0 AND userObject.entityId1=0 AND userObject.entityId2=0 AND userObject.entityId3=0 AND userObject.entityId4=0 AND userObject.entityId5=0									AND userObject.entityId6=0 AND userObject.entityId7=0 AND userObject.entityId8=0 AND userObject.entityId9=0)
				)
		SELECT @running = @restoreJobs + @adminJobs
		INSERT INTO #RestoreJobs
		SELECT DISTINCT d.DayBeginDT, RS.jobId, RS.status
		FROM #DailyTbl d
		INNER JOIN JMRestoreStats RS WITH(READUNCOMMITTED)
			ON RS.servEndTime >= d.DayBegin AND RS.servEndTime <= d.DayEnd
			AND (@isAllAssoc = 1 OR EXISTS(
							SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK) WHERE
							-- if you have the rights on the destination at any level then you will see the restore job
							(rstUserObject.clientid=destClientID AND destClientID <> 0 AND appType <> 78) OR  -- For UNC restores from web console, destination client could be 0. Do not use it to check security. Ignore for share point CV_APPTYPE_MS_SHAREPOINTV2_DOC
							(rstUserObject.clientid=srcClientID AND apptypeid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=bkpSetID AND rstUserObject.subclientid=0) --OR
							-- Not needed because we expand it above
							--((rstUserObject.clientgroupid <> 0 AND EXISTS (SELECT TOP 1 1 FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = rstUserObject.clientGroupId  OR rstUserObject.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=srcClientID OR APP_ClientGroupAssoc.clientid=destClientID))))
							)
			--AND  dbo.isRstJobVisible(@i_userId,commCellId,srcClientID,destClientID,appType,instanceID,bkpSetID) = 1
			)
		WHERE RS.opType = 105
		INSERT INTO #AdminJobs
		SELECT DISTINCT d.DayBeginDT, JM.jobId, JM.status
		FROM #DailyTbl d
		INNER JOIN JMAdminJobStatsTable JM
			ON JM.servEnd >= d.DayBegin AND JM.servEnd <= d.DayEnd
			AND ((JM.dataStatus IN (1, 2) AND JM.status IN (2, 4)) OR JM.dataStatus NOT IN (1,2))
		INNER JOIN JMJobStats JStats
			ON JM.jobId = JStats.jobId
			And JM.CommcellId = JStats.CommcellId 		AND JM.opType in ( 126, 135)
		LEFT JOIN #getUsersInCompanyOutputTbl UIC
			ON UIC.userId = (SELECT id FROM UMUsers WHERE login=JM.UserName)
		WHERE @i_userId = 0
				OR @i_userId = (SELECT id FROM UMUsers WHERE login=JM.UserName)
				OR UIC.userId IS NOT NULL
				OR EXISTS
				(SELECT 1 FROM #JMCanManageJob_adminObject1 userObject
						WHERE
(userObject.commCellId=2 AND userObject.clientGroupId=0 AND userObject.clientId=0 AND userObject.appTypeId=0 AND userObject.instanceId=0 AND userObject.backupsetId=0 AND userObject.subClientId=0 AND userObject.mediaAgentId=0 AND userObject.libraryId=0 AND userObject.archGroupId=0 AND userObject.vtContainerId=0 AND userObject.vtPolicyId=0 AND userObject.vtShelfId=0 AND userObject.reviewSetId=0 AND userObject.querySetId=0 AND userObject.downloadSetId=0 AND userObject.ermId=0 AND userObject.legalHoldId=0 AND userObject.tagId=0 AND userObject.cdPolicyId=0 AND userObject.complianceReportId=0 AND userObject.taskId=0 AND userObject.workflowId=0 AND userObject.logMonitoringPolicyId=0 AND userObject.arrayId=0 AND userObject.cloudId=0 AND userObject.userGroupId=0 AND userObject.providerId=0 AND userObject.entityId1=0 AND userObject.entityId2=0 AND userObject.entityId3=0 AND userObject.entityId4=0 AND userObject.entityId5=0									AND userObject.entityId6=0 AND userObject.entityId7=0 AND userObject.entityId8=0 AND userObject.entityId9=0)
				)
		IF OBJECT_ID(N'tempdb.dbo.#JMCanManageJob_adminObject') IS NOT NULL DROP TABLE #JMCanManageJob_adminObject
		INSERT INTO #JobResultsTbl
		SELECT DayBeginDT, SUM(Completed) Completed, SUM(CWE) CWE, SUM(CWW) CWW, SUM(Failed) Failed, SUM(Killed) Killed
		FROM
		(
		SELECT
			RS.DayBeginDT,
			isnull(sum(case when Status in ( 1 ) then 1 else 0 end),0) as 'Completed',
			isnull(sum(case when Status in ( 3 ) then 1 else 0 end),0) as 'CWE',
			isnull(sum(case when Status in ( 14 ) then 1 else 0 end),0) as 'CWW',
			isnull(sum(case when Status in ( 2,9 ) then 1 else 0 end),0) as 'Failed',
			isnull(sum(case when Status in ( 4 ) then 1 else 0 end),0) as 'Killed'
		FROM #DailyTbl d INNER JOIN #RestoreJobs RS ON d.DayBeginDT = RS.DayBeginDT
		GROUP BY RS.DayBeginDT
		UNION ALL
		SELECT
			RS.DayBeginDT,
			isnull(sum(case when Status in ( 1 ) then 1 else 0 end),0) as 'Completed',
			isnull(sum(case when Status in ( 3 ) then 1 else 0 end),0) as 'CWE',
			isnull(sum(case when Status in ( 14 ) then 1 else 0 end),0) as 'CWW',
			isnull(sum(case when Status in ( 2,9 ) then 1 else 0 end),0) as 'Failed',
			isnull(sum(case when Status in ( 4 ) then 1 else 0 end),0) as 'Killed'
		FROM #DailyTbl d INNER JOIN #AdminJobs RS ON d.DayBeginDT = RS.DayBeginDT
		GROUP BY RS.DayBeginDT) JobStats
		GROUP BY DayBeginDT
	END
	ELSE -- Virtualization, DB, Cloud Apps
	BEGIN
		--Running restore jobs
		SELECT @restoreJobs = count(DISTINCT JM.jobId)
		FROM JMRstJobInfo JM WITH(READUNCOMMITTED)
		INNER JOIN JMJobInfo JI on JM.jobid = JI.jobId AND JM.commcellId = JI.commcellId
		INNER JOIN App_Application APP ON JM.bkpSetID = APP.backupSet
		INNER JOIN #appTypes AT ON APP.appTypeId = AT.apptypeId
		WHERE --dbo.isRstJobVisible(@i_userId, J.commCellId, J.srcClientId, J.destClientId,  J.appType, J.instanceID, J.bkpSetID) =1
		(((rstattributes & 0x100 /*JMRST_SYNC_RESTORE*/) = 0))
		AND
		(
		JI.userId = @i_userId OR @isAllAssoc = 1 OR
		EXISTS(
					SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK) WHERE
					-- if you have the rights on the destination at any level then you will see the restore job
					(rstUserObject.clientid=destClientID AND destClientID <> 0 AND appType <> 78) OR  -- For UNC restores from web console, destination client could be 0. Do not use it to check security. Ignore for share point CV_APPTYPE_MS_SHAREPOINTV2_DOC
					(rstUserObject.clientid=srcClientID AND apptypeid=0) OR
					(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=0) OR
					(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=0) OR
					(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=bkpSetID AND rstUserObject.subclientid=0) --OR
					-- Not needed because we expand it above
					--((rstUserObject.clientgroupid <> 0 AND EXISTS (SELECT TOP 1 1 FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = rstUserObject.clientGroupId  OR rstUserObject.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=srcClientID OR APP_ClientGroupAssoc.clientid=destClientID))))
					)
		)
		AND JI.opType <> 12 --Exclude Index Restore Jobs
		-- Running admin jobs for apptype
		SELECT @adminJobs = COUNT(DISTINCT JM.jobId)
		FROM JMAdminJobInfoTable JM WITH(READUNCOMMITTED)
		INNER JOIN APP_Application APP
			ON JM.appID = APP.id
		INNER JOIN #SecIDANodeAccessTemp_Bkp SEC
			ON SEC.t_subclientId = APP.id
		INNER JOIN #appTypes AT
			ON AT.apptypeId = APP.appTypeId
			AND JM.opType <> 53 --Exclude Data Analytics Job
		--All running jobs
		SELECT @running = count(B.jobId) + @restoreJobs + @adminJobs
		FROM JMJobInfo J WITH(READUNCOMMITTED)
		INNER JOIN JMBkpJobInfo B WITH(READUNCOMMITTED) ON J.jobId = B.jobId AND J.commcellId = B.commCellId
		INNER JOIN #SecIDANodeAccessTemp_Bkp SEC
			ON SEC.t_subclientId = B.applicationId
		INNER JOIN App_Application APP ON B.applicationId = APP.id
		INNER JOIN #appTypes AT ON APP.appTypeId = AT.apptypeId
		INSERT INTO #RestoreJobs
		SELECT DISTINCT d.DayBeginDT, RS.jobId, RS.status
		FROM #DailyTbl d
		INNER JOIN JMRestoreStats RS WITH(READUNCOMMITTED)
			ON RS.servEndTime >= d.DayBegin AND RS.servEndTime <= d.DayEnd
		INNER JOIN App_Application APP
			ON RS.bkpSetID = APP.backupSet
		INNER JOIN #appTypes AT
			ON APP.appTypeId = AT.apptypeId
			AND (@isAllAssoc = 1 OR EXISTS(
							SELECT TOP 1 1 FROM #JMCanManageJob_rstObject rstUserObject WITH(NOLOCK) WHERE
							-- if you have the rights on the destination at any level then you will see the restore job
							(rstUserObject.clientid=destClientID AND destClientID <> 0 AND appType <> 78) OR  -- For UNC restores from web console, destination client could be 0. Do not use it to check security. Ignore for share point CV_APPTYPE_MS_SHAREPOINTV2_DOC
							(rstUserObject.clientid=srcClientID AND apptypeid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=0) OR
							(rstUserObject.clientid=srcClientID AND rstUserObject.apptypeid=appType AND rstUserObject.instanceid=instanceID AND rstUserObject.backupsetid=bkpSetID AND rstUserObject.subclientid=0) --OR
							-- Not needed because we expand it above
							--((rstUserObject.clientgroupid <> 0 AND EXISTS (SELECT TOP 1 1 FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE (APP_ClientGroupAssoc.clientGroupId = rstUserObject.clientGroupId  OR rstUserObject.clientGroupId=-10) AND (APP_ClientGroupAssoc.clientid=srcClientID OR APP_ClientGroupAssoc.clientid=destClientID))))
							)
			--AND  dbo.isRstJobVisible(@i_userId,commCellId,srcClientID,destClientID,appType,instanceID,bkpSetID) = 1
			)
		AND RS.opType <> 12 --Exclude Index Restore Jobs
		AND (RS.opType <> 29 /*QUICKDMRST*/ OR @showPersistentRecoveryJobs = 1) --Hide persistent restore jobs from UI
		INSERT INTO #AdminJobs
		SELECT DISTINCT d.DayBeginDT, JM.jobId, JM.status
		FROM #DailyTbl d
		INNER JOIN JMAdminJobStatsTable JM
			ON JM.servEnd >= d.DayBegin AND JM.servEnd <= d.DayEnd
			AND ((JM.dataStatus IN (1, 2) AND JM.status IN (2, 4)) OR JM.dataStatus NOT IN (1,2))
		INNER JOIN APP_Application APP
			ON JM.appID = APP.id
		INNER JOIN #SecIDANodeAccessTemp_Bkp SEC
			ON SEC.t_subclientId = APP.id
		INNER JOIN #appTypes AT
			ON AT.apptypeId = APP.appTypeId
			AND JM.opType <> 53 --Exclude Data Analytics Job
		INSERT INTO #JobResultsTbl
		SELECT  DayBeginDT, SUM(Completed) Completed, SUM(CWE) CWE, SUM(CWW) CWW, SUM(Failed) Failed,SUM(Killed) Killed
		FROM
		(SELECT d.DayBeginDT AS 'DayBeginDT',
				isnull(sum(case when displayStatus in ( 1 ) then 1 else 0 end),0) as 'Completed',
				isnull(sum(case when displayStatus in ( 3 ) then 1 else 0 end),0) as 'CWE',
				isnull(sum(case when displayStatus in ( 14 ) then 1 else 0 end),0) as 'CWW',
				isnull(sum(case when displayStatus in ( 2,9 ) then 1 else 0 end),0) as 'Failed',
				isnull(sum(case when displayStatus in ( 4 ) then 1 else 0 end),0) as 'Killed'
		FROM #DailyTbl d
		INNER JOIN JMBkpStats B WITH(READUNCOMMITTED) ON servEndDate >= d.DayBegin AND servEndDate <= d.DayEnd
		INNER JOIN App_Application APP ON B.appId = APP.id
		INNER JOIN #appTypes AT ON APP.appTypeId = AT.apptypeId
		INNER JOIN #SecIDANodeAccessTemp_Bkp SEC ON SEC.t_subclientId = B.appId
		WHERE
		((B.dataStatus IN (1, 2) AND B.status IN (2, 4)) OR B.dataStatus NOT IN (1,2))
		GROUP BY d.DayBeginDT
		UNION ALL
		SELECT
			RS.DayBeginDT,
			isnull(sum(case when Status in ( 1 ) then 1 else 0 end),0) as 'Completed',
			isnull(sum(case when Status in ( 3 ) then 1 else 0 end),0) as 'CWE',
			isnull(sum(case when Status in ( 14 ) then 1 else 0 end),0) as 'CWW',
			isnull(sum(case when Status in ( 2,9 ) then 1 else 0 end),0) as 'Failed',
			isnull(sum(case when Status in ( 4 ) then 1 else 0 end),0) as 'Killed'
		FROM #DailyTbl d INNER JOIN #RestoreJobs RS ON d.DayBeginDT = RS.DayBeginDT
		GROUP BY RS.DayBeginDT
		UNION ALL
		SELECT
			RS.DayBeginDT,
			isnull(sum(case when Status in ( 1 ) then 1 else 0 end),0) as 'Completed',
			isnull(sum(case when Status in ( 3 ) then 1 else 0 end),0) as 'CWE',
			isnull(sum(case when Status in ( 14 ) then 1 else 0 end),0) as 'CWW',
			isnull(sum(case when Status in ( 2,9 ) then 1 else 0 end),0) as 'Failed',
			isnull(sum(case when Status in ( 4 ) then 1 else 0 end),0) as 'Killed'
		FROM #DailyTbl d INNER JOIN #AdminJobs RS ON d.DayBeginDT = RS.DayBeginDT
		GROUP BY RS.DayBeginDT) JobStats
		GROUP BY DayBeginDT
	END
	SELECT D.DayBeginDT AS 'DayBeginDT', ISNULL(J.Completed, 0) AS 'Completed', ISNULL(J.CWE, 0) AS 'CWE', ISNULL(J.CWW, 0) AS 'CWW', ISNULL(J.Failed, 0) AS 'Failed', ISNULL(J.Killed, 0) AS 'Killed', CASE WHEN D.rowNo = 0 THEN @running ELSE 0 END AS 'Running'
	FROM #DailyTbl D
	 LEFT OUTER JOIN #JobResultsTbl J
		ON D.DayBeginDT = J.DayBeginDT
	IF object_id('tempdb.dbo.#JMCanManageJob_rstObject') IS NOT NULL DROP TABLE #JMCanManageJob_rstObject
	IF object_id('tempdb.dbo.#RestoreJobs') IS NOT NULL DROP TABLE #RestoreJobs
	IF object_id('tempdb.dbo.#AdminJobs') IS NOT NULL DROP TABLE #AdminJobs
	IF object_id('tempdb.dbo.#appTypes') IS NOT NULL DROP TABLE #appTypes
	IF object_id('tempdb.dbo.#DailyTbl') IS NOT NULL DROP TABLE #DailyTbl
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_Bkp') IS NOT NULL DROP TABLE #SecIDANodeAccessTemp_Bkp
	IF OBJECT_ID(N'tempdb.dbo.#JobResultsTbl') IS NOT NULL DROP TABLE #JobResultsTbl
	IF OBJECT_ID(N'tempdb.dbo.#SecIDANodeAccessTemp_VM') IS NOT NULL DROP TABLE #SecIDANodeAccessTemp_VM
	IF OBJECT_ID(N'tempdb.dbo.#sec_JobIDsList') IS NOT NULL DROP TABLE #sec_JobIDsList
	SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetBackupSummaryCounts')
	delete from GxQscripts where name = 'JMGetBackupSummaryCounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetBackupSummaryCounts')
	delete from GXDBVersions where aliasname = 'JMGetBackupSummaryCounts'
GO

insert into GXDBVersions values(2, 'JMGetBackupSummaryCounts',  'v1.1.4.28.4.2', 'JMGetBackupSummaryCounts', 'v1.1.4.28.4.2')
GO

