

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetBackupHistory.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   09/21/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetBackupHistory.sp,v $ $Id: JMGetBackupHistory.sp,v 1.4.296.3 2020/03/02 18:35:11 jragunathan Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetBackupHistory')
BEGIN
	print '>>> Drop Stored Procedure: JMGetBackupHistory <<<'
	drop procedure JMGetBackupHistory
END
IF EXISTS (select * from GxQscripts where name='JMGetBackupHistory')
	delete from GxQscripts where name = 'JMGetBackupHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetBackupHistory')
	delete from GXDBVersions where aliasname = 'JMGetBackupHistory'
GO
print '... Creating Procedure: JMGetBackupHistory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetBackupHistory
  @xmlText XML
AS
	DECLARE @i_UserName		NVARCHAR(255)
	DECLARE @i_BackupSetId	INT
	DECLARE @userId			INT
	SET @i_UserName = ISNULL(( SELECT ref.value('@userName', 'nvarchar(255)')
						FROM @xmlText.nodes('CVGui_GetBackupHistoryReq') R ( ref ) ), '')
	SET @i_BackupSetId = ISNULL(( SELECT ref.value('@backupSetId', 'INT')
						FROM @xmlText.nodes('CVGui_GetBackupHistoryReq') R ( ref ) ), 0)
	SET @userId = ISNULL((SELECT [id] FROM UMUsers WHERE login = @i_UserName), 0)
	IF object_id('tempdb.dbo.#TmpAFCIInfo') IS NOT NULL DROP TABLE #TmpAFCIInfo
	CREATE TABLE #TmpAFCIInfo (AFCIJobId INT, AFCICommCellId INT, AFCIFlags INT, AFCICloudId INT, AFCITime INT)
	INSERT INTO #TmpAFCIInfo
		SELECT jobId, commCellId, MAX(flags & 496), MAX(cloudId), MAX(contentIndexTime)
		FROM  archFile
		group by jobId, commcellId HAVING MAX(cloudId) <> 0
	SELECT jobID = JMBkpStats.jobId,
		appID,
		JMBkpStats.opType,
		JMBkpStats.commCellId,
		commcellNumber = (select number from APP_CommCell where id = JMBkpStats.commCellId),
		commcellName = (select aliasName from APP_CommCell where id = JMBkpStats.commCellId),
		clientId, clientName = (select name from APP_Client where id = clientId),
		appType, appTypeName = (select name from APP_iDAType where type = appType),
		instance, instanceName = (select name from APP_InstanceName where id = instance),
		backupSet, backupSetName = (select name from APP_BackupSetName where id = backupSet),
		subclientName,
		numStreams, numStreamsRequested,
		numCopies=1,
		JMBkpStats.dataArchGrpId,
		dataArchGrpName = CASE
								WHEN appType = 47 OR appType = 50 THEN ISNULL((SELECT name FROM QRPolicy WHERE id = JMBkpStats.dataArchGrpId),'Unavailable')
								WHEN JMBkpStats.dataArchGrpId = 0 THEN ''
	 								ELSE ISNULL((SELECT name FROM archGroup WHERE id = JMBkpStats.dataArchGrpId),'Unavailable')
							END,
		JMBkpStats.logArchGrpId,
		logArchGrpName = CASE
								WHEN JMBkpStats.logArchGrpId = 0 THEN ''
								ELSE ISNULL((SELECT name FROM archGroup WHERE id = JMBkpStats.logArchGrpId),'Unavailable')
							END,
		JMBkpStats.diffArchGrpId,
		diffArchGrpName = CASE
								WHEN JMBkpStats.diffArchGrpId = 0 THEN ''
								ELSE ISNULL((SELECT name FROM archGroup WHERE id = JMBkpStats.diffArchGrpId),'Unavailable')
							END,
		bkpLevel,
		JMBkpStats.status,
		childJobId = CASE appType
				WHEN 84 THEN ISNULL((SELECT TOP 1 childJobID FROM JMJobDataLink WHERE JMJobDataLink.parentJobId = JMBkpStats.jobId AND JMJobDataLink.commcellId = JMBkpStats.commcellId),0)
				ELSE 0
				END,
		childJobStatus = CASE appType
				WHEN 84 THEN ISNULL((SELECT TOP 1 childJobStatus FROM JMJobDataLink WHERE JMJobDataLink.parentJobId = JMBkpStats.jobId AND JMJobDataLink.commcellId = JMBkpStats.commcellId),0)
				ELSE 0
				END,
		duration,
		servStartDate,
		servEndDate,
		uncompBytes = totalUncompBytes,
		compBytes = totalCompBytes,
		numObjects = totalNumOfFiles,
		numFolders = totalNumOfFolders,
		initFrom,
		failureReason,
		bkpOptions,
		scanFileFailures,
		scanFolderFailures,
		backupFileFailures,
		backupFolderFailures,
		oraSubLevel,
		totalWriteTime,
		cloudId,
		username,
		bkpattributes,
		JMBkpStats.dataStatus,
		filesToXfer,
		ISNULL(#TmpAFCIInfo.AFCIFlags,0) AS AFCIFlags,
	 	ISNULL(#TmpAFCIInfo.AFCICloudId,0) AS AFCICloudId,
		ISNULL(#TmpAFCIInfo.AFCITime,0) AS AFCITime,
		failureErrorCode,
		scanType,
		scanTypeChangeReason,
		cloudName = CASE
			WHEN cloudId = 0 THEN ''
			ELSE ISNULL((SELECT stringVal from app_componentProp WITH (READUNCOMMITTED) where id = cloudId and componentId=2 AND propertyTypeId=1 AND modified=0),'')
			END,
		AFCICloudName = CASE
			WHEN ISNULL(#TmpAFCIInfo.AFCICloudId,0) = 0 THEN ''
			ELSE ISNULL((SELECT stringVal from app_componentProp WITH (READUNCOMMITTED) where id = ISNULL(#TmpAFCIInfo.AFCICloudId,0) and componentId=2 AND propertyTypeId=1 AND modified=0),'')
			END,
		dbo.JMGetKBArticlesForFailures(failureReason, 0) AS [failureKBArticle]
	FROM JMBkpStats
	INNER JOIN APP_Application
		ON JMBkpStats.appId = APP_Application.id AND JMBkpStats.appId IN
			(SELECT id FROM APP_Application  WHERE backupSet = @i_BackupSetId )
	INNER JOIN JMJobStats
		ON JMBkpStats.jobId = JMJobStats.jobId AND JMBkpStats.commCellId = JMJobStats.commCellId AND JMBkpStats.dataStatus IN (0, 1, 3)
	LEFT JOIN #TmpAFCIInfo
		ON JMBkpStats.jobId = #TmpAFCIInfo.AFCIJobId  AND JMBkpStats.commcellId = #TmpAFCIInfo.AFCICommCellId
	WHERE (@userId = 0 OR @i_UserName = username OR dbo.isBkpJobVisible(@userId, JMBkpStats.commCellId, clientId,appType, instance, backupSet, appID) = 1)
	ORDER BY servStartDate DESC
	DROP TABLE #TmpAFCIInfo
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'JMGetBackupHistory')
	delete from GxQscripts where name = 'JMGetBackupHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetBackupHistory')
	delete from GXDBVersions where aliasname = 'JMGetBackupHistory'
GO

insert into GXDBVersions values(2, 'JMGetBackupHistory',  '00010004029600030000', 'JMGetBackupHistory', '00010004029600030000')
GO

