

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetAuxCopyJobsHistory.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetAuxCopyJobsHistory.sp,v $ $Id: JMGetAuxCopyJobsHistory.sp,v 1.1.2.2 2019/09/07 01:40:15 snandhini Exp $";
---- =============================================
---- Description:	Get the aux copy history data
---- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetAuxCopyJobsHistory')
BEGIN
	print '>>> Drop Stored Procedure: JMGetAuxCopyJobsHistory <<<'
	drop procedure JMGetAuxCopyJobsHistory
END
IF EXISTS (select * from GxQscripts where name='JMGetAuxCopyJobsHistory')
	delete from GxQscripts where name = 'JMGetAuxCopyJobsHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetAuxCopyJobsHistory')
	delete from GXDBVersions where aliasname = 'JMGetAuxCopyJobsHistory'
GO
print '... Creating Procedure: JMGetAuxCopyJobsHistory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetAuxCopyJobsHistory
  @archGroupID INTEGER,
  @archGroupCopyId INTEGER
AS
  DECLARE @jobRunTime INTEGER
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @configurableFromDateTimestamp INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name='FromTimeForAnomalyAlert' and modified=0),0)
DECLARE @TempTable TABLE(JobID INTEGER, duration INTEGER, startTime INTEGER, commcellId INTEGER)
SELECT TOP 200  endTime - startTime
FROM HistoryDB.dbo.AuxCopyJobHistory WITH(NOLOCK)
WHERE archGrpId = @archGroupId AND archGrpCopyId = @archGroupCopyId AND startTime > @configurableFromDateTimestamp
ORDER BY  startTime DESC
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetAuxCopyJobsHistory')
	delete from GxQscripts where name = 'JMGetAuxCopyJobsHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetAuxCopyJobsHistory')
	delete from GXDBVersions where aliasname = 'JMGetAuxCopyJobsHistory'
GO

insert into GXDBVersions values(2, 'JMGetAuxCopyJobsHistory',  '00010001000200020000', 'JMGetAuxCopyJobsHistory', '00010001000200020000')
GO

