

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetAuxCopyAttemptWriteTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--			Author: Gokul Pattabiraman
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetAuxCopyAttemptWriteTime <<<'

IF EXISTS (select * from sysobjects where name='JMGetAuxCopyAttemptWriteTime')
	drop procedure JMGetAuxCopyAttemptWriteTime
IF EXISTS (select * from GxQscripts where name='JMGetAuxCopyAttemptWriteTime')
	delete from GxQscripts where name = 'JMGetAuxCopyAttemptWriteTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetAuxCopyAttemptWriteTime')
	delete from GXDBVersions where aliasname = 'JMGetAuxCopyAttemptWriteTime'
GO
print '... Creating Procedure: JMGetAuxCopyAttemptWriteTime'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetAuxCopyAttemptWriteTime
  @inJobID INTEGER,
  @inPhaseNum INTEGER,
  @inAttemptNum INTEGER
AS
  DECLARE @outWriteTime INT
SET NOCOUNT ON
DECLARE @curWriteTime INT = 0
DECLARE @curReservationtime INT = 0
DECLARE @curReleasetime INT = 0
DECLARE @maxReleasetime INT = 0
DECLARE @now INTEGER = dbo.GetUnixTime(GetUTCDate())
SET @outWriteTime = 0
DECLARE GetResourceInfo CURSOR
FOR SELECT ReservationTime, ReleaseTime FROM JMJobResourceHistory WITH(NOLOCK)
		WHERE jobId = @inJobID
		AND phaseNum = @inPhaseNum
		AND attemptNum = @inAttemptNum
		AND totalUncompBytes <> 0
		AND ReservationType = 2 -- Need to consider only destination reservation type.
		ORDER BY ReservationTime ASC
OPEN GetResourceInfo
FETCH GetResourceInfo INTO @curReservationtime, @curReleasetime
WHILE @@FETCH_STATUS = 0
BEGIN
		SET @curWriteTime = 0
		IF @curReleasetime = 0
			SET @curReleasetime = @now --The reservation is not released yet, then set the release time as current time
		-- This means it is a serial resrevation as reservation happened after previous releaseTime.
		IF @curReservationtime >= @maxReleasetime
		BEGIN
			SET @curWriteTime = (@curReleasetime - @curReservationtime)
			SET @maxReleasetime = @curReleasetime
		END
		ELSE
		BEGIN
			-- This means reservation happened in parallel to our previously accounted reservation
			IF @curReleasetime < @maxReleasetime
					-- This means reservation happened after our previously accounted reservationTime and ended before our previously accounted releaseTime.
					-- So no need to account for it.
					SET @curWriteTime = 0
			ELSE
			BEGIN
					-- This means reservation was held after our previously accounted releaseTime. So take the difference into account
					SET @curWriteTime = (@curReleasetime - @maxReleasetime) -- Note the use of maxReleaseTime here
					SET @maxReleasetime = @curReleasetime
			END
		END
		SET @outWriteTime = @outWriteTime + @curWriteTime
		FETCH GetResourceInfo INTO @curReservationtime, @curReleasetime
END
CLOSE GetResourceInfo
DEALLOCATE GetResourceInfo
SELECT @outWriteTime
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetAuxCopyAttemptWriteTime')
	delete from GxQscripts where name = 'JMGetAuxCopyAttemptWriteTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetAuxCopyAttemptWriteTime')
	delete from GXDBVersions where aliasname = 'JMGetAuxCopyAttemptWriteTime'
GO

insert into GXDBVersions values(2, 'JMGetAuxCopyAttemptWriteTime',  '00000000000000000000', 'JMGetAuxCopyAttemptWriteTime', '00000000000000000000')
GO

