

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetAutoSynthFullSubTasks.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--
--
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetAutoSynthFullSubTasks.sp,v $ $Id: JMGetAutoSynthFullSubTasks.sp,v 1.3.2.10 2020/09/13 05:06:20 sbonilla Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetAutoSynthFullSubTasks')
BEGIN
	print '>>> Drop Stored Procedure: JMGetAutoSynthFullSubTasks <<<'
	drop procedure JMGetAutoSynthFullSubTasks
END
IF EXISTS (select * from GxQscripts where name='JMGetAutoSynthFullSubTasks')
	delete from GxQscripts where name = 'JMGetAutoSynthFullSubTasks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetAutoSynthFullSubTasks')
	delete from GXDBVersions where aliasname = 'JMGetAutoSynthFullSubTasks'
GO
print '... Creating Procedure: JMGetAutoSynthFullSubTasks'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetAutoSynthFullSubTasks
  @firstTime INTEGER,
  @highWaterMark INTEGER
AS
  DECLARE @lastCounterId INTEGER
  DECLARE @taskId INTEGER
  DECLARE @subTaskId INTEGER
  DECLARE @subClientId INTEGER
  DECLARE @bkpSetId INTEGER
  DECLARE @instanceId INTEGER
  DECLARE @appTypeId INTEGER
  DECLARE @clientId INTEGER
  DECLARE @status INTEGER
BEGIN TRY
	BEGIN TRAN
		--Step 1: Find the number of allowable request for given Task.
		DECLARE @allowedSFs INTEGER = 0
		DECLARE @curSFs INTEGER = 0
		DECLARE @maxAllowedForTask INTEGER = ISNULL((SELECT CAST (value AS INT) FROM GXGlobalParam WHERE name = 'MaxSyntheticFullJobsForSPolicy' AND modified =0), 0)
		-- If max. sF jobs per task is not configured then allow max. SF high water mark jobs.
		IF @maxAllowedForTask <= 0
			SET @maxAllowedForTask = @highWaterMark
		DECLARE @TaskInfoTbl TABLE
		(
			jobTaskId	int,
            jobSubTaskId int,
			allowable int
		)
		if object_id('tempdb.dbo.#tempSynthReq') is not null
    		DROP TABLE #tempSynthReq
		CREATE TABLE #tempSynthReq
		(
			isyntheticRequestId      integer ,
			itaskId                  integer ,
			isubTaskId               integer ,
			isubclientId             integer ,
			ibackupsetId             integer ,
			iinstanceId              integer ,
			iappTypeId               integer ,
			iclientId                integer ,
			iuserId                  integer ,
			icreated                 integer ,
			imodified                integer ,
			ilastSynthetic           integer ,
			ilastFull                integer ,
			ilastIncremental         integer ,
			istatus                  integer ,
			iflags                   integer
		);
		CREATE CLUSTERED INDEX #tempSynthReq_isubclientId_isubTaskId_iclientId_Index1 ON #tempSynthReq ([isubclientId],[isubTaskId],[iclientId])
		CREATE INDEX [#tempSynthReq_isubTaskId_Index2] ON #tempSynthReq ([isubTaskId]) INCLUDE ([isubclientId], [iclientId], [ilastSynthetic], [ilastFull], [ilastIncremental])
		CREATE INDEX [#tempSynthReq_istatus_Index3] ON #tempSynthReq ([istatus]) INCLUDE ([itaskId], [isubTaskId], [isubclientId], [iclientId], [ilastSynthetic], [ilastFull], [ilastIncremental])
		SELECT @curSFs = count(*) From JmJobInfo(NOLOCK) Where opType in(14/*SYNTHFULL*/)
		IF (@highWaterMark > @curSFs)
		BEGIN
			SET @allowedSFs = @highWaterMark - @curSFs
		Insert into @TaskInfoTbl
			Select distinct [taskId], [subTaskId], 0 From TM_JobSyntheticRequest Where [status] = 0
		update @TaskInfoTbl
			Set allowable = @maxAllowedForTask - ISNULL((select count(*) From JmBkpJobInfo(NOLOCK) Where backupTaskId = jobSubTaskId), 0)
		IF @firstTime = 0
		BEGIN
			UPDATE TM_JobSyntheticRequest SET STATUS = 2 WHERE STATUS & 1 = 1
		END
		-- Step2: Filter the subclients based on
		--- i) MAOnline Check
		--- ii) Committed jobs in the current cycle.
		--- iii) if there are no pending snap backup jobs to be backup copied
		--- iv) Max. allowed SF jobs for a given schedule.
		--- v) if job is already running.
		;WITH MAOnlineCTE AS
		(
			SELECT [syntheticRequestId],[taskId],[subTaskId],[subclientId],[backupsetId],[instanceId],[appTypeId],[clientId],[userId],[created],[modified],[lastSynthetic],[lastFull],[lastIncremental],[status],[flags]
			FROM
		--MR:219866 - START SF EVEN IF NO NEW INCREMENTAL JOB RAN
			TM_JobSyntheticRequest Where [status] = 0 And --lastIncremental > lastFull And
			exists
			(
				Select 1
				From  App_Application APP WITH (NOLOCK), ArchGroup AG WITH(NOLOCK),
					   MMDataPath DPath WITH (NOLOCK), MMDrivePool DPool WITH (NOLOCK), MMHost MH WITH (NOLOCK), APP_Client CL WITH (NOLOCK)
				Where
					APP.id = [subclientId]
					And APP.dataArchGrpId = AG.id
					And AG.defaultCopy = DPath.copyId
					And DPath.DrivePoolId = DPool.DrivePoolId
					And DPool.ClientId = MH.ClientId
					And MH.clientId = CL.id
					And MH.MmHostEnabled = 1 And MH.MmHostSoftState = 1 And (MH.Attribute & 16 /*MMS2_MA_MARKED_FOR_MAINTENANCE*/) = 0
					And (DPath.Flag & 16 /*MMS2_REPLICATION_DATAPATH*/) = 0
					And (DPath.Flag & 4 /*MMS2_ENABLED_FAILOVER*/) > 0
			)
		),
		skipSubclientsWithJobRunningCTE AS
		(
			SELECT [syntheticRequestId],[taskId],[subTaskId],[subclientId],[backupsetId],[instanceId],[appTypeId],[clientId],[userId],[created],[modified],[lastSynthetic],[lastFull],[lastIncremental],[status],[flags]
			FROM MAOnlineCTE
			WHERE NOT EXISTS
			(
				SELECT 1 FROM JMBkpJobInfo(NOLOCK) JBI
				JOIN JMJobInfo (NOLOCK) JI ON JI.jobId = JBI.jobId
				WHERE JBI.applicationId = [subclientId]
				--MR:219866 - IGNORE JOBS FROM CLOUD LAPTOP
				AND JI.opType <> 116	--STATELESS_BACKUP
			)
		)
		--code from archHasJobsPendingMaterialize.sp to check if there are no pending snap backup jobs to be backup copied
		INSERT INTO #tempSynthReq
		SELECT DISTINCT
			CTE.syntheticRequestId,	CTE.taskId,	CTE.subTaskId, CTE.subclientId,	CTE.backupsetId, CTE.instanceId, CTE.appTypeId,	CTE.clientId, CTE.userId, CTE.created, CTE.modified, CTE.lastSynthetic, CTE.lastFull, CTE.lastIncremental, CTE.status, CTE.flags
			FROM skipSubclientsWithJobRunningCTE CTE
			INNER JOIN APP_Application APP WITH(NOLOCK) ON APP.id = CTE.subclientId
			LEFT JOIN JMJobSnapshotStats JSS WITH (NOLOCK) ON JSS.appId = CTE.subclientId
					AND JSS.archGrpId = APP.dataArchGrpID
                    AND JSS.materializationStatus IN (101, 102, 103) /*NODATACOPIED, NODATAVALID, PARTIALDATA */
					AND (JSS.disabled & 1) = 0
			WHERE JSS.jobId IS NULL
		;WITH maxAllowedSFJobsCTE AS
		(
			SELECT [isyntheticRequestId],[itaskId],[isubTaskId],[isubclientId],[ibackupsetId],[iinstanceId],[iappTypeId],[iclientId],[iuserId],[icreated],[imodified],[ilastSynthetic],[ilastFull],[ilastIncremental],[istatus],[iflags],
				ROW_NUMBER() over (PARTITION by [itaskId] order by ilastSynthetic) As rowNum
			FROM #tempSynthReq
		),
		synthFullCTE AS
		(
				Select top(@allowedSFs) * From
			maxAllowedSFJobsCTE
			Where rowNum <= (Select allowable From @TaskInfoTbl Where jobSubTaskId = [isubTaskId])
			Order by ilastSynthetic
		)
		Update synthFullCTE
		SET istatus = istatus | 4096 | 1
		UPDATE SR
		SET SR.STATUS = TSR.istatus
		FROM TM_JobSyntheticRequest SR
		INNER JOIN #tempSynthReq TSR ON TSR.isyntheticRequestId = SR.syntheticRequestId WHERE (TSR.istatus & 4097) = 4097
		-- Step3: Select the jobs to be processed
		--This procedure is wrapper on top of TM_JobSyntheticRequest and this table gets updated in a transaction inside this procedure. We should not use no lock here to avoid inconsistency.
		SELECT [syntheticRequestId], [taskId], [subTaskId], [subclientId], [backupsetId], [instanceId], [appTypeId], [clientId], [status]
		FROM TM_JobSyntheticRequest
		WHERE STATUS & 4096 = 4096
		-- Step4: Update the @status of previous selected jobs
		UPDATE TM_JobSyntheticRequest SET STATUS = STATUS ^ 4096 WHERE STATUS & 4096 = 4096
		END
		ELSE
		BEGIN
			SELECT [syntheticRequestId], [taskId], [subTaskId], [subclientId], [backupsetId], [instanceId], [appTypeId], [clientId], [status]
			FROM TM_JobSyntheticRequest(NOLOCK)
			WHERE 1 != 1
		END
	COMMIT TRAN
	if object_id('tempdb.dbo.#tempSynthReq') is not null
    		DROP TABLE #tempSynthReq
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRAN
END CATCH
GO


IF EXISTS (select * from GxQscripts where name = 'JMGetAutoSynthFullSubTasks')
	delete from GxQscripts where name = 'JMGetAutoSynthFullSubTasks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetAutoSynthFullSubTasks')
	delete from GXDBVersions where aliasname = 'JMGetAutoSynthFullSubTasks'
GO

insert into GXDBVersions values(2, 'JMGetAutoSynthFullSubTasks',  '00010003000200100000', 'JMGetAutoSynthFullSubTasks', '00010003000200100000')
GO

