

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetAnalyticsJobInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetAnalyticsJobInfo')
BEGIN
	print '>>> Drop Stored Procedure: JMGetAnalyticsJobInfo <<<'
	drop procedure JMGetAnalyticsJobInfo
END
IF EXISTS (select * from GxQscripts where name='JMGetAnalyticsJobInfo')
	delete from GxQscripts where name = 'JMGetAnalyticsJobInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetAnalyticsJobInfo')
	delete from GXDBVersions where aliasname = 'JMGetAnalyticsJobInfo'
GO
print '... Creating Procedure: JMGetAnalyticsJobInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetAnalyticsJobInfo
  @i_subclientId INT = 0,
  @i_clientId INT = 0,
  @i_datasourceId INT = 0,
  @i_datasourceIds VARCHAR(2048) = '',
  @i_rowsCount INT = 1,
  @i_jobListCategory INT = 0,
  @i_jobId INT = 0,
  @i_selectOutput INT = 1
AS
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	/*
		Stored Procedure to return job information for Live Scan jobs, associated to datasourceId
 - i_jobListCategory
                        JobListCategory.ALL : 0
                        JobListCategory.ACTIVE : 1
                        JobListCategory.FINISHED : 2
	*/
	IF( @i_selectOutput = 1)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#tmpOutputStatsTable') IS NOT NULL
			DROP TABLE dbo.#tmpOutputStatsTable
		CREATE TABLE #tmpOutputStatsTable
		(
			DataSourceId	INT,
			jobID			INT,
			status			VARCHAR(100),
			jobStartTime	BIGINT,
			jobEndTime		BIGINT,
			totalNumOfFiles	BIGINT,
			totalFailedFiles	BIGINT,
			pendingReasonErrorCode	VARCHAR(MAX),
			pendingReason           NVARCHAR(MAX)
		)
	END
	if OBJECT_ID('tempdb.dbo.#tmpAppIdTbl') IS NOT NULL
		DROP TABLE dbo.#tmpAppIdTbl
	CREATE TABLE #tmpAppIdTbl
	(
		DataSourceId INT,
		appId INT
	)
	--fetch from SubclientProp table for 'Indexing datasource id' property
	--
	IF ( @i_subclientId > 0)
	BEGIN
		INSERT INTO #tmpAppIdTbl
		SELECT CONVERT(INT, cp.attrVal), @i_subclientId FROM APP_SubClientProp CP WITH (NOLOCK)
		WHERE	CP.componentNameId = @i_subclientId AND CP.attrName = 'Indexing datasource id' AND CP.modified = 0
	END
	--fetch all the subclient for current client and datasourceId from clientProp table for 'Indexing datasource id' property
	--
	IF( @i_clientId > 0)
	BEGIN
		--fetch all subclient, when clientid is passed
		--
		INSERT INTO #tmpAppIdTbl
		SELECT CONVERT(INT, CP.attrVal), AP.id FROM APP_ClientProp CP  WITH (NOLOCK)
		INNER JOIN APP_Application AP WITH (NOLOCK) ON
				CP.componentNameId = AP.clientId AND
				CP.attrName = 'Indexing datasource id' AND
				AP.ClientId = @i_clientId  AND
				CP.modified = 0
	END
	--case when one or more datasources are passed
	--
	IF(@i_datasourceId > 0 OR ISNULL(@i_datasourceIds,'') != '')
	BEGIN
		DECLARE @dataSourceTbl TABLE( DataSourceID INT)
		INSERT INTO @dataSourceTbl
		SELECT @i_datasourceId WHERE @i_datasourceId > 0
			UNION
		SELECT T._ID FROM dbo.SplitIDs(@i_datasourceIds) as T WHERE ISNULL(@i_datasourceIds,'') != ''
		-- figure out clientid and subclient mapped to the datasource
		-- if subclient is populated, we will honor that, else honor all Subclient of the Client
		--
		;WITH CTE AS (
			SELECT DataSourceId AS DataSourceId, [pseudoclientid] 'ClientId' , [subclientid] 'SubClientId'
			FROM
			(	SELECT DSP.DataSourceId, CONVERT(INT, DSP.PropertyValue) 'Value', p.PropertyName
				FROM @dataSourceTbl AS DT INNER JOIN
					SEDataSourceProperty DSP	WITH (NOLOCK) ON DT.DataSourceID = DSP.DataSourceId INNER JOIN
					SEProperty P ON DSP.PropertyId = P.PropertyId
				 WHERE P.PropertyName IN ('pseudoclientid', 'subclientid')
			) AS SourceTable
			PIVOT
			( MIN(Value) FOR PropertyName IN ([pseudoclientid], [subclientid]) ) AS PivotTable
		)
		INSERT INTO #tmpAppIdTbl
		SELECT DataSourceId, SubClientId
		FROM CTE WHERE SubClientId IS NOT NULL
			UNION
		SELECT DataSourceId, AP.id
		FROM CTE INNER JOIN APP_Application AP WITH (NOLOCK) ON CTE.ClientId = AP.clientId WHERE CTE.SubClientId IS NULL
	END
	--get data from running jobs table
	--
      IF( @i_jobListCategory IN (0, 1))
      BEGIN
	INSERT INTO #tmpOutputStatsTable
		(DataSourceId, jobID, status,
			jobStartTime, jobEndTime, totalNumOfFiles,
			totalFailedFiles, pendingReasonErrorCode)
	SELECT	T.DataSourceId, T.jobId, T.status,
			T.servStart, T.servEnd, T.ObjectsDone,
			T.ObjectsFailed , T.failureReason
	FROM
		(
			SELECT DataSourceId, jobid,  status,
				servStart, servEnd, ObjectsDone,
				ObjectsFailed, failureReason,
				ROW_NUM = ROW_NUMBER() OVER (PARTITION BY DataSourceId ORDER BY servEnd desc)
            FROM
			    (
			        SELECT
				        APP.DataSourceId, JM.jobid, (SELECT stateName FROM JMJobStateNames WHERE stateType = JI.displayState) status,
				        JM.servStart, JM.servEnd, JM.ObjectsDone,
				        JM.ObjectsFailed, JI.failureReason
			        FROM JMAdminJobInfoTable JM
			        INNER JOIN JMJobStats JS ON JM.jobId = JS.jobId AND JM.commCellId = JS.commCellId
			        INNER JOIN JMJobInfo JI ON JM.jobId = JI.jobId AND JM.commCellId = JI.commCellId
			        INNER JOIN #tmpAppIdTbl APP ON JM.appID = APP.appId
                                WHERE JS.subOpType = 130  AND (@i_jobId = 0 OR JM.jobId = @i_jobId)
                    UNION
                    SELECT
				        DS.DataSourceId, JM.jobid,  (SELECT stateName FROM JMJobStatusNames WHERE stateType = JM.status) status,
				        JM.servStart, JM.servEnd, JM.ObjectsDone,
				        JM.ObjectsFailed, JI.failureReason
			        FROM JMAdminJobInfoTable JM
			        INNER JOIN @dataSourceTbl DS ON JM.LibraryID = DS.DataSourceID
                    INNER JOIN JMJobInfo JI ON JM.jobId = JI.jobId AND JM.commCellId = JI.commCellId
                                WHERE JM.opType = 124 AND (@i_jobId = 0 OR JM.jobId = @i_jobId)
                ) AS U
		) AS T
	WHERE T.ROW_NUM <= @i_rowsCount
      END
      IF( @i_jobListCategory IN (0, 2))
      BEGIN
	--get data from finished jobs table
	--
	INSERT INTO #tmpOutputStatsTable
		(DataSourceId, jobID, status,
			jobStartTime, jobEndTime, totalNumOfFiles,
			totalFailedFiles, pendingReasonErrorCode)
	SELECT	T.DataSourceId, T.jobId, T.status,
			T.servStart, T.servEnd, T.EX_TotalSuccess,
			T.EX_TotalFailures , T.failureReason
	FROM
		(
			SELECT DataSourceId, jobid,  status,
				servStart, servEnd, EX_TotalSuccess,
				EX_TotalFailures, failureReason,
				ROW_NUM = ROW_NUMBER() OVER (PARTITION BY DataSourceId ORDER BY servEnd desc)
            FROM
			    (
                    SELECT
				        APP.DataSourceId, JM.jobid ,  (SELECT stateName FROM JMJobStatusNames WHERE stateType = JM.status) status,
				        JM.servStart , JM.servEnd , JM.EX_TotalSuccess ,
				        JM.EX_TotalFailures , JM.failureReason
			        FROM JMAdminJobStatsTable JM
			        INNER JOIN JMJobStats JS ON JM.jobId = JS.jobId AND JM.commCellId = JS.commCellId
			        INNER JOIN #tmpAppIdTbl APP ON JM.appID = APP.appId
                                WHERE JS.subOpType = 130 AND (@i_jobId = 0 OR JM.jobId = @i_jobId)
                    UNION
                    SELECT
				        DS.DataSourceId, JM.jobid,  (SELECT stateName FROM JMJobStatusNames WHERE stateType = JM.status) status,
				        JM.servStart, JM.servEnd, JM.EX_TotalSuccess,
				        JM.EX_TotalFailures, JM.failureReason
			        FROM JMAdminJobStatsTable JM
			        INNER JOIN @dataSourceTbl DS ON JM.LibraryID = DS.DataSourceID
                                WHERE JM.opType = 124 AND (@i_jobId = 0 OR JM.jobId = @i_jobId)
                ) AS U
		) AS T
	WHERE T.ROW_NUM <= @i_rowsCount
      END
	--Populate ErrorCode and ErrorMessage.
	--
	 UPDATE #tmpOutputStatsTable
		SET pendingReasonErrorCode = SUBSTRING(pendingReasonErrorCode, 0, CHARINDEX(',', pendingReasonErrorCode, 0)),
			pendingReason = dbo.JMGetLocalizedMessageFunc(0, pendingReasonErrorCode)
		WHERE pendingReasonErrorCode <> '' AND pendingReasonErrorCode IS NOT NULL
	;WITH DuplicateRecord(DataSourceId, RowsCnt)
	AS
	(
		SELECT DataSourceId ,ROW_NUMBER() OVER(PARTITION by DataSourceId ORDER BY jobStartTime desc) AS RowsCnt
		FROM #tmpOutputStatsTable
	)
	DELETE FROM DuplicateRecord WHERE RowsCnt > @i_rowsCount
	--print output, if select is enabled
	--
	IF(@i_selectOutput = 1)
		SELECT * FROM #tmpOutputStatsTable order by datasourceid, jobStartTime desc
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetAnalyticsJobInfo')
	delete from GxQscripts where name = 'JMGetAnalyticsJobInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetAnalyticsJobInfo')
	delete from GXDBVersions where aliasname = 'JMGetAnalyticsJobInfo'
GO

insert into GXDBVersions values(2, 'JMGetAnalyticsJobInfo',  '00000000000000000000', 'JMGetAnalyticsJobInfo', '00000000000000000000')
GO

