

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetAnalyticsDataCrawlDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetAnalyticsDataCrawlDetails.sp,v $ $Id: JMGetAnalyticsDataCrawlDetails.sp,v 1.1.2.2 2019/05/16 19:07:52 canand Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetAnalyticsDataCrawlDetails')
BEGIN
	print '>>> Drop Stored Procedure: JMGetAnalyticsDataCrawlDetails <<<'
	drop procedure JMGetAnalyticsDataCrawlDetails
END
IF EXISTS (select * from GxQscripts where name='JMGetAnalyticsDataCrawlDetails')
	delete from GxQscripts where name = 'JMGetAnalyticsDataCrawlDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetAnalyticsDataCrawlDetails')
	delete from GXDBVersions where aliasname = 'JMGetAnalyticsDataCrawlDetails'
GO
print '... Creating Procedure: JMGetAnalyticsDataCrawlDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetAnalyticsDataCrawlDetails
  @input XML
AS
  DECLARE @output XML
BEGIN
	SET NOCOUNT ON
    DECLARE @dsID INT = 0
	DECLARE @l_cloudID INT
	DECLARE @l_collectionName VARCHAR(256)
	DECLARE @l_datasourcetype INT = 0
	DECLARE @l_portNo INT = 0, @l_serverType INT = 0
	DECLARE @l_baseUrl VARCHAR(256)
	DECLARE @l_relativeUrl VARCHAR(128)
	DECLARE @l_datasourceName VARCHAR(256)
    IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL
		DROP TABLE #getIndexServers
	CREATE TABLE #getIndexServers
	(
		serverURL NVARCHAR(512),
		clientId INT,
		clientName NVARCHAR(256),
		cloudId INT,
		hostName NVARCHAR(256),
		basePort INT,
		engineName  NVARCHAR(256),
		serverType INT,
		indexServerClientId INT,
		internalCloudName NVARCHAR(256)
	)
	SELECT @dsID = ISNULL(T.c.value('@datasourceId', 'int'), 0)
		FROM   @input.nodes('/DM2ContentIndexing_AnalyticsToolkitCrawlDetailsReq') T(c)
	IF EXISTS(SELECT 1 FROM SEDataSource WITH (NOLOCK) WHERE DataSourceId = @dsID)
	BEGIN
		SELECT @l_cloudID = CI.CloudID, @l_collectionName = CI.ActualCoreName, @l_datasourcetype = DS.datasourcetype, @l_datasourceName = DS.DataSourceName
		FROM SEDataSource AS DS WITH (NOLOCK) INNER JOIN SECollectionInfo AS CI WITH (NOLOCK)
		ON DS.coreId = CI.coreId AND DS.DataSourceId = @dsID
		-- use this SP to get the index server URL
		EXEC DM2GetIndexServers @i_cloudId= @l_cloudID
		SELECT TOP 1 @l_portNo = ( SELECT TOP 1 basePort from #getIndexServers )
		SELECT TOP 1 @l_serverType = ( SELECT TOP 1 serverType from #getIndexServers )
		SELECT TOP 1 @l_baseUrl = (SELECT TOP 1 serverURL from #getIndexServers)
		SET @l_relativeUrl = '/solr'
		SET @output = ( SELECT @dsID AS '@datasourceId',
							@l_datasourcetype AS '@datasourceType',
							@l_portNo AS '@portNumber',
							@l_collectionName AS '@collectionName',
							@l_serverType AS '@serverType',
							@l_baseUrl AS '@baseUrl',
							@l_relativeUrl AS '@relativeUrl',
							@l_datasourceName AS '@datasourceName',
							( SELECT TOP 1
								clientId AS '@clientId',
								clientName AS '@clientName',
								hostName AS '@hostName'
								FROM #getIndexServers
							FOR XML PATH('endPointClient'), TYPE),
							( SELECT
								( SELECT SP.PropertyName AS '@name', DSP.PropertyValue AS '@value'
									FROM SEDataSourceProperty AS DSP WITH (NOLOCK)
									INNER JOIN SEProperty AS SP WITH (NOLOCK)
									ON DSP.PropertyId = SP.PropertyId AND DSP.DataSourceId = @dsID
								FOR XML PATH('nameValues'), TYPE)
							FOR XML PATH('datasourceProperties'), TYPE)
						FOR XML PATH('DM2ContentIndexing_AnalyticsToolkitCrawlDetails'))
	END
	IF @output IS NULL
		SET @output = '<DM2ContentIndexing_AnalyticsToolkitCrawlDetails/>'
    SELECT @output AS [ouput]
	SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetAnalyticsDataCrawlDetails')
	delete from GxQscripts where name = 'JMGetAnalyticsDataCrawlDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetAnalyticsDataCrawlDetails')
	delete from GXDBVersions where aliasname = 'JMGetAnalyticsDataCrawlDetails'
GO

insert into GXDBVersions values(2, 'JMGetAnalyticsDataCrawlDetails',  '00010001000200020000', 'JMGetAnalyticsDataCrawlDetails', '00010001000200020000')
GO

