

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetActiveStream.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetActiveStream.sp,v $ $Id: JMGetActiveStream.sp,v 1.1.2.7 2020/06/25 20:46:34 sbonilla Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 				Cursor: "JMGetActiveStreams"							|
--	|	Select from ActiveStreams.view to return information about		|
--	|	running backups for Job Controller window.							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMGetActiveStream')
BEGIN
	print '>>> Drop Stored Procedure: JMGetActiveStream <<<'
	drop procedure JMGetActiveStream
END
IF EXISTS (select * from GxQscripts where name='JMGetActiveStream')
	delete from GxQscripts where name = 'JMGetActiveStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetActiveStream')
	delete from GXDBVersions where aliasname = 'JMGetActiveStream'
GO
print '... Creating Procedure: JMGetActiveStream'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMGetActiveStream
  @injobID BIGINT,
  @inCommCellID INTEGER,
  @inPhaseNumber INTEGER = 0,
  @inAttemptNum INTEGER = 0,
  @inGetDestinationStream INTEGER = 0
AS
  DECLARE @jobID integer
  DECLARE @commCellId integer
  DECLARE @destRcId integer
  DECLARE @destReservationId integer
  DECLARE @srcRcId integer
  DECLARE @srcReservationId integer
  DECLARE @archGrpId integer
  DECLARE @destCopyId integer
  DECLARE @srcCopyId integer
  DECLARE @status integer
  DECLARE @streamNum integer
  DECLARE @destStreamNum integer
  DECLARE @isPrimary integer
  DECLARE @guiAlertColorLevel integer
  DECLARE @unCompBytes bigint
  DECLARE @compBytes bigint
  DECLARE @nwTransBytes bigint
  DECLARE @writeTime integer
  DECLARE @committedUncompBytes bigint
  DECLARE @committedCompBytes bigint
  DECLARE @committedWriteTime integer
  DECLARE @numFiles bigint
  DECLARE @numFolders bigint
  DECLARE @numFailures bigint
  DECLARE @numSkipped bigint
  DECLARE @phaseNumber integer
  DECLARE @attemptNumber integer
  DECLARE @throughput float
  DECLARE @totalToCopy bigint
  DECLARE @embeddedObjects bigint
  DECLARE @readBytes bigint
  DECLARE @readTime bigint
  DECLARE @physicalWriteBytes bigint
  DECLARE @physicalWriteTime bigint
  DECLARE @nwTransTime bigint
  DECLARE @sidbLookups bigint
  DECLARE @sidbLookupTime bigint
  DECLARE @readThroughput float
  DECLARE @writeThroughput float
  DECLARE @networkThroughput float
  DECLARE @calcSidbLookups float
  DECLARE @compScheme char(25)
  DECLARE @destDriveName NVARCHAR(1024) 
  DECLARE @srcDriveName NVARCHAR(1024) 
  DECLARE @archGrpName NVARCHAR(144)
  DECLARE @destCopyName NVARCHAR(64)
  DECLARE @srcCopyName NVARCHAR(64)
  DECLARE @bkpJobIDs VARCHAR(MAX)
  DECLARE @destMedAgent VARCHAR(MAX)
  DECLARE @srcClient VARCHAR(MAX)
  DECLARE @restartString VARCHAR(MAX)
  DECLARE @activeFile NVARCHAR(max)
  DECLARE @failureReason VARCHAR(MAX)
  DECLARE @srcBarCode VARCHAR(MAX)
  DECLARE @destBarCode VARCHAR(MAX)
  DECLARE @DelayReason NVARCHAR(MAX)
  DECLARE @failureKBArticle NVARCHAR(MAX)
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
	SET NOCOUNT ON
	SELECT
	jobID
	,commCellId
	,destRcId
	,destReservationId
	,srcRcId
	,srcReservationId
	,archGrpId
	,destCopyId
	,srcCopyId
	,status
	,streamNum
	,destStreamNum
	,isPrimary
	,guiAlertColorLevel
	,unCompBytes
	,compBytes
	,nwTransBytes
	,writeTime
	,committedUncompBytes
	,committedCompBytes
	,committedWriteTime
	,numFiles
	,numFolders
	,numFailures
	,numSkipped
	,phaseNumber
	,attemptNumber
	,throughput
	,totalToCopy
	,embeddedObjects
	,readBytes
	,readTime
	,physicalWriteBytes
	,physicalWriteTime
	,nwTransTime
	,sidbLookups
	,sidbLookupTime
	,readThroughput
	,writeThroughput
	,networkThroughput
	,calcSidbLookups
	,compScheme
	,destDriveName
	,srcDriveName
	,archGrpName
	,destCopyName
	,srcCopyName
	,BackupJobId
	,destMedAgent
	,srcClient
	,restartString
	,activeFile
	,failureReason
	,srcBarCode
	,destBarCode
	,DelayReason
	,failureKBArticle
	FROM
	(
		SELECT A.jobID, A.commCellId, A.destRcId, A.destReservationId, A.srcRcId, A.srcReservationId, A.archGrpId, A.destCopyId, A.srcCopyId, A.status, A.streamNum, A.destStreamNum, A.isPrimary,
			A.guiAlertColorLevel, A.unCompBytes, A.compBytes, A.nwTransBytes, A.writeTime, A.committedUncompBytes, A.committedCompBytes, A.committedWriteTime, A.numFiles, A.numFolders, A.numFailures,
			A.numSkipped, A.phaseNumber, A.attemptNumber, A.throughput, A.totalToCopy, A.embeddedObjects, A.readBytes, A.readTime, A.physicalWriteBytes, A.physicalWriteTime, A.nwTransTime, A.sidbLookups,
			A.sidbLookupTime, A.readThroughput, A.writeThroughput, A.networkThroughput, A.calcSidbLookups, A.compScheme, A.destDriveName, A.srcDriveName, A.archGrpName, A.destCopyName, A.srcCopyName,
			A.BackupJobId, A.destMedAgent, A.srcClient, A.restartString, A.activeFile, A.failureReason, A.srcBarCode, A.destBarCode, A.DelayReason, A.failureKBArticle
		FROM ActiveStreams A
        JOIN JMJobInfo I ON I.jobId = A.jobID
                        AND I.subOpType NOT IN (144, 145, 146, 147)     --BACKUP_ADMIN, SNAP_BACKUP_ADMIN, BACKUP_COPY_ADMIN, SYNTH_FULL_ADMIN
                        AND I.commCellId = @inCommCellID
						AND A.jobID = @injobID
		UNION ALL
		SELECT A.jobID, A.commCellId, A.destRcId, A.destReservationId, A.srcRcId, A.srcReservationId, A.archGrpId, A.destCopyId, A.srcCopyId, A.status, ROW_NUMBER() OVER(PARTITION BY LN.parentJobId ORDER BY LN.childJobId) streamNum, A.destStreamNum, A.isPrimary,
			A.guiAlertColorLevel, A.unCompBytes, A.compBytes, A.nwTransBytes, A.writeTime, A.committedUncompBytes, A.committedCompBytes, A.committedWriteTime, A.numFiles, A.numFolders, A.numFailures,
			A.numSkipped, A.phaseNumber, A.attemptNumber, A.throughput, A.totalToCopy, A.embeddedObjects, A.readBytes, A.readTime, A.physicalWriteBytes, A.physicalWriteTime, A.nwTransTime, A.sidbLookups,
			A.sidbLookupTime, A.readThroughput, A.writeThroughput, A.networkThroughput, A.calcSidbLookups, A.compScheme, A.destDriveName, A.srcDriveName, A.archGrpName, A.destCopyName, A.srcCopyName,
			A.BackupJobId, A.destMedAgent, A.srcClient, A.restartString, A.activeFile, A.failureReason, A.srcBarCode, A.destBarCode, A.DelayReason, A.failureKBArticle
		FROM ActiveStreams A
		JOIN JMJobDataLink LN ON LN.childJobId = A.jobID
			AND LN.parentJobId = @injobID
AND LN.linkType = 7
		JOIN JMJobInfo I ON I.jobId = LN.parentJobId
			AND I.subOpType IN (144, 145, 146, 147)	--BACKUP_ADMIN, SNAP_BACKUP_ADMIN, BACKUP_COPY_ADMIN, SYNTH_FULL_ADMIN
			AND I.commCellId = @inCommCellID
	)
	T
	WHERE  (@inPhaseNumber = 0 OR phaseNumber = @inPhaseNumber)
			AND (@inAttemptNum = 0 OR attemptNumber = @inAttemptNum)
			AND (@inGetDestinationStream = 0 OR destRcId <> 0)
	SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetActiveStream')
	delete from GxQscripts where name = 'JMGetActiveStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetActiveStream')
	delete from GXDBVersions where aliasname = 'JMGetActiveStream'
GO

insert into GXDBVersions values(2, 'JMGetActiveStream',  '00010001000200070000', 'JMGetActiveStream', '00010001000200070000')
GO

