

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGetActiveMachinesInCluster.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Amey Karandikar
--	Date:   10/03/2005
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMGetActiveMachinesInCluster.sp,v $ $Id: JMGetActiveMachinesInCluster.sp,v 1.2.278.2 2018/03/22 03:06:28 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMGetActiveMachinesInCluster <<<'

IF EXISTS (select * from sysobjects where name='JMGetActiveMachinesInCluster')
	drop procedure JMGetActiveMachinesInCluster
IF EXISTS (select * from GxQscripts where name='JMGetActiveMachinesInCluster')
	delete from GxQscripts where name = 'JMGetActiveMachinesInCluster'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetActiveMachinesInCluster')
	delete from GXDBVersions where aliasname = 'JMGetActiveMachinesInCluster'
GO
print '... Creating Procedure: JMGetActiveMachinesInCluster'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMGetActiveMachinesInCluster
  @clientId INTEGER
AS
  DECLARE @r_clientId INTEGER
	SET NOCOUNT ON
	DECLARE @physicalid INT
	-- get the active physical node. the client could be a physical itself
	SET @physicalid = (SELECT TOP 1 attrVal FROM APP_ClientProp WHERE componentnameid = @clientid
						AND attrname LIKE 'Active Physical Node' AND modified = 0)
	IF @physicalid IS NULL
		SET @physicalid = @clientid
	-- get all the vm's that are currently active on this pm
	SELECT DISTINCT VMClientId FROM APP_VMToPMMap, APP_ClientProp
	WHERE PMClientId = @physicalid AND APP_VMToPMMap.VMClientId = APP_ClientProp.componentnameid AND
	modified = 0 AND attrname LIKE 'Active Physical Node' AND attrVal = CONVERT(NVARCHAR(1024),@physicalid)
	UNION ALL
	SELECT @physicalid
GO

IF EXISTS (select * from GxQscripts where name = 'JMGetActiveMachinesInCluster')
	delete from GxQscripts where name = 'JMGetActiveMachinesInCluster'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGetActiveMachinesInCluster')
	delete from GXDBVersions where aliasname = 'JMGetActiveMachinesInCluster'
GO

insert into GXDBVersions values(2, 'JMGetActiveMachinesInCluster',  '00010002027800020000', 'JMGetActiveMachinesInCluster', '00010002027800020000')
GO

