

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMGet3DFSForeverShareClientIdListForAuxCopy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +=============================================================================+
--  |   Procedure:  JMGet3DFSForeverShareClientIdListForAuxCopy()
--  |
--  | Description:  Select 3DFS forever share client IDs for a given aux copy job
--  |				and also set the state for the same
--  |
--  |       Input:  commCellId, jobId
--  |
--  |      Output:  3DFS forever share client IDs
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------------------	        --------------------------------
--  |   1.1        Jawahar Ragunathan           Initial Edit
--  |   1.2        Sagar M D                    Adding status to output
--  +============================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMGet3DFSForeverShareClientIdListForAuxCopy')
BEGIN
	print '>>> Drop Stored Procedure: JMGet3DFSForeverShareClientIdListForAuxCopy <<<'
	drop procedure JMGet3DFSForeverShareClientIdListForAuxCopy
END
IF EXISTS (select * from GxQscripts where name='JMGet3DFSForeverShareClientIdListForAuxCopy')
	delete from GxQscripts where name = 'JMGet3DFSForeverShareClientIdListForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGet3DFSForeverShareClientIdListForAuxCopy')
	delete from GXDBVersions where aliasname = 'JMGet3DFSForeverShareClientIdListForAuxCopy'
GO
print '... Creating Procedure: JMGet3DFSForeverShareClientIdListForAuxCopy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMGet3DFSForeverShareClientIdListForAuxCopy
  @i_commcellId INT,
  @i_jobId INT
AS
  DECLARE @forEverShareClientId INTEGER
  DECLARE @shareId INTEGER
  DECLARE @status INTEGER
SET NOCOUNT ON
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @archGrpId INT;
	SELECT @archGrpId=archGrpID FROM JMAdminJobStatsTable WHERE jobid = @i_jobId AND commCellId = @i_commcellId
	UPDATE EP SET status = (status | 4)
	OUTPUT inserted.tdfsServerId, inserted.id, inserted.status
	FROM APP_3DFSExportProps EP
	INNER JOIN APP_Application APP ON (EP.subclientId = APP.id OR EP.backupsetId = APP.backupset)
	WHERE (APP.dataArchGrpID = @archGrpId OR APP.logArchGrpID = @archGrpId)	AND EP.foreverShare = 1
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMGet3DFSForeverShareClientIdListForAuxCopy')
	delete from GxQscripts where name = 'JMGet3DFSForeverShareClientIdListForAuxCopy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMGet3DFSForeverShareClientIdListForAuxCopy')
	delete from GXDBVersions where aliasname = 'JMGet3DFSForeverShareClientIdListForAuxCopy'
GO

insert into GXDBVersions values(2, 'JMGet3DFSForeverShareClientIdListForAuxCopy',  '00000000000000000000', 'JMGet3DFSForeverShareClientIdListForAuxCopy', '00000000000000000000')
GO

