

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMFillCompPolicyQualifiedJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMFillCompPolicyQualifiedJobs.sp,v $ $Id: JMFillCompPolicyQualifiedJobs.sp,v 1.24.60.4 2018/03/20 19:49:40 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMFillCompPolicyQualifiedJobs
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMFillCompPolicyQualifiedJobs <<<'

IF EXISTS (select * from sysobjects where name='JMFillCompPolicyQualifiedJobs')
	drop procedure JMFillCompPolicyQualifiedJobs
IF EXISTS (select * from GxQscripts where name='JMFillCompPolicyQualifiedJobs')
	delete from GxQscripts where name = 'JMFillCompPolicyQualifiedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMFillCompPolicyQualifiedJobs')
	delete from GXDBVersions where aliasname = 'JMFillCompPolicyQualifiedJobs'
GO
print '... Creating Procedure: JMFillCompPolicyQualifiedJobs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMFillCompPolicyQualifiedJobs
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @compliancePolicyId INTEGER
AS
  DECLARE @errorCode INTEGER
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN TRY
BEGIN TRAN
	DECLARE @i_UserGUID		NVARCHAR(36)
	DECLARE @i_refTime		INTEGER
	DECLARE @i_capability	INTEGER
	DECLARE @i_UserName		NVARCHAR(255)
	DECLARE @i_domainName	NVARCHAR(255)
	DECLARE @i_xmlValueCompliance		XML
	DECLARE @i_xmlValueSearch			XML
	DECLARE @i_xmlComplianceOptions		XML
	DECLARE @bClientList	INTEGER
	DECLARE @bAppTypeList	INTEGER
	DECLARE @complianceId	INTEGER
	DECLARE @CONTENTINDEXED	INTEGER
SET @CONTENTINDEXED = (16 + 32 + 64 + 128)
	SET @bClientList    = 0
	SET @bAppTypeList	= 0
	-- List of Clients on which this compliance policy will run
	if object_id('tempdb.dbo.#ClientList') is not null DROP TABLE #ClientList
	CREATE TABLE #ClientList(id INTEGER)
	-- List of AppTypes on which this compliance policy will run
	if object_id('tempdb.dbo.#AppList') is not null	DROP TABLE #AppList
	CREATE TABLE #AppList(id INTEGER)
	-- List of Subclients on which this compliance policy will run
	if object_id('tempdb.dbo.#SCList') is not null	DROP TABLE #SCList
	CREATE TABLE #SCList(id INTEGER)
	-- List of Subclients on which this compliance policy will run
	if object_id('tempdb.dbo.#SCListUser') is not null	DROP TABLE #SCListUser
	CREATE TABLE #SCListUser(id INTEGER)
	-- None of these temp tables should ever exist when this procedure is called!
	if object_id('tempdb.dbo.#dm2UserObjectsTbl') is not null DROP TABLE #dm2UserObjectsTbl
	CREATE TABLE #dm2UserObjectsTbl (	commCellId	integer, clientId	integer, appTypeId	integer,
				instanceId	integer, backupsetId	integer, subClientId	integer, archGroupId	integer )
	IF object_id('tempdb.dbo.#tmpextGroupListTbl') is not null DROP TABLE #tmpextGroupListTbl
	CREATE TABLE #tmpextGroupListTbl (  t_groupName	varchar(1024) )
	if object_id('tempdb.dbo.#ComplianceList') is not null	DROP TABLE #ComplianceList
	CREATE TABLE #ComplianceList(id INTEGER)
	SET @errorCode = 0
	-- Set the capability as complianceserach
SET @i_capability = 25
	IF @compliancePolicyId = 0
	BEGIN
		INSERT INTO #ComplianceList SELECT distinct complianceID FROM SchedAdminComplianceXMLOptions
	END
	ELSE
		Insert into #ComplianceList values(@compliancePolicyId)
	-- Deletion of disable/deleted compliance policies
	DELETE FROM #ComplianceList where id in(select complianceID FROM SchedAdminComplianceXMLOptions where status !=0)
	DECLARE c1 CURSOR FOR SELECT id FROM #ComplianceList
	OPEN c1
	FETCH NEXT FROM c1 INTO @complianceId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DELETE FROM #ClientList
		DELETE FROM #AppList
		DELETE FROM #SCList
		DELETE FROM #SCListUser
		DELETE FROM #tmpextGroupListTbl
		DELETE FROM #dm2UserObjectsTbl
		SET @bClientList = 0
		SET @bAppTypeList = 0
		-- Find the compliance director definiton for the given complianceID
		select @i_xmlValueCompliance= xmlValue from schedAdminComplianceOptions where complianceID=@complianceId and dataType = 0
		select @i_xmlComplianceOptions= xmlValue from SchedAdminComplianceXMLOptions where complianceId=@complianceId
		if @i_xmlValueCompliance is NOT NULL
		BEGIN
			-- Get the reference time
			SET @i_UserGUID = ISNULL (( SELECT ref.value('@userId', 'NVARCHAR(36)') FROM @i_xmlValueCompliance.nodes ('DM2ContentIndexing_ComplianceDirector') R(ref)), '')
			IF LEN(@i_UserGUID) <> 0
			BEGIN
				-- Get the user name
				SET @i_UserName = (SELECT login FROM UMUsers WHERE userGuid = @i_UserGUID AND enabled=1)
				-- Get the user capability
				EXEC sec_getUserCapabilitiesForDM2 @i_capability, @i_UserName, '', #tmpextGroupListTbl, #dm2UserObjectsTbl
				-- Get the list of subclient on which the user has capability
				-- Commcell level
				IF EXISTS (SELECT * FROM #dm2UserObjectsTbl where commCellId > 0 and clientId = 0)
				BEGIN
					insert into #SCListUser select id from App_Application
					delete from #dm2UserObjectsTbl where commCellId > 0 and clientId = 0
				END
				-- Client level
				IF EXISTS (SELECT * FROM #dm2UserObjectsTbl where clientId > 0 and appTypeId = 0)
				BEGIN
					insert into #SCListUser select id from App_Application where clientId in(SELECT clientId FROM #dm2UserObjectsTbl where clientId > 0 and appTypeId = 0)
					delete from #dm2UserObjectsTbl where clientId > 0 and appTypeId = 0
				END
				-- AppType Level
				IF EXISTS (SELECT * FROM #dm2UserObjectsTbl where appTypeId > 0 and instanceId = 0 and backupsetId = 0)
				BEGIN
					insert into #SCListUser select t2.id from #dm2UserObjectsTbl t1, App_Application t2 where t1.clientId = t2.clientId and t1.appTypeId = t2.appTypeId and t1.instanceId = 0 and t1.backupsetId = 0
					delete from #dm2UserObjectsTbl where appTypeId > 0 and instanceId = 0 and backupsetId = 0
				END
				-- Instance Level
				IF EXISTS (SELECT * FROM #dm2UserObjectsTbl where instanceId > 0 and backupsetId = 0)
				BEGIN
					insert into #SCListUser select t2.id from #dm2UserObjectsTbl t1, App_Application t2 where t1.clientId = t2.clientId and t1.appTypeId = t2.appTypeId and t1.instanceId = t2.instance and t1.backupsetId = 0
					delete from #dm2UserObjectsTbl where instanceId > 0 and backupsetId = 0
				END
				-- Backupset level
				IF EXISTS (SELECT * FROM #dm2UserObjectsTbl where backupsetId > 0 and subClientId = 0)
				BEGIN
					insert into #SCListUser select t2.id from #dm2UserObjectsTbl t1, App_Application t2 where t1.clientId = t2.clientId and t1.appTypeId = t2.appTypeId and t1.instanceId = t2.instance and t1.backupsetId = t2.backupset and t1.subClientId = 0
					delete from #dm2UserObjectsTbl where backupsetId > 0 and subClientId = 0
				END
				-- Subclient level
				IF EXISTS (SELECT * FROM #dm2UserObjectsTbl where subClientId > 0)
				BEGIN
					insert into #SCListUser select subClientId from #dm2UserObjectsTbl where subClientId > 0
					delete from #dm2UserObjectsTbl where subClientId > 0
				END
				-- Get the reference time
				SET @i_refTime = ISNULL (( SELECT ref.value('@refTime', 'INTEGER')FROM @i_xmlValueCompliance.nodes('DM2ContentIndexing_ComplianceDirector') R(ref)), -1)
				-- Get the Search xml definiton for the given complianceID
				select @i_xmlValueSearch= xmlValue from schedAdminComplianceOptions where complianceID=@complianceId and dataType = 1
				if @i_xmlValueSearch is NOT NULL
				BEGIN
					-- Get the clientID and AppTypeList. If they are empty consider all else consider only those that are selected
					INSERT INTO #ClientList
					SELECT	ref.value('@val', 'INTEGER')
					FROM	@i_xmlValueSearch.nodes('/DM2ContentIndexing_SearchRequestOption/searchRequest/cFieldsAllUsers/client') R ( ref )
					-- Delete those clients that have CI flag disabled
					DELETE FROM #ClientList where id Not In(select componentNameId from App_ClientProp where attrName = N'Content Indexing Enabled' AND attrVal = N'1' AND modified = 0)
					IF EXISTS (SELECT * FROM #ClientList) SET @bClientList = 1
					INSERT INTO #AppList
					SELECT	ref.value('@val', 'INTEGER')
					FROM	@i_xmlValueSearch.nodes('/DM2ContentIndexing_SearchRequestOption/searchRequest/cFieldsAllUsers/iDAs') R ( ref )
					IF EXISTS (SELECT * FROM #AppList) SET @bAppTypeList = 1
				END
				-- Here we have the subclients that have CI Enabled at their clientLevel
				IF @bClientList = 1 AND @bAppTypeList = 1
					insert into #SCList SELECT id FROM App_Application where clientId in (select id from #ClientList) and appTypeId in (select id from #AppList)
				ELSE IF @bClientList = 1
					insert into #SCList SELECT id FROM App_Application where clientId in (select id from #ClientList)
				ELSE IF @bAppTypeList = 1
					insert into #SCList SELECT id FROM App_Application where appTypeId in (select id from #AppList) and clientId IN(select componentNameId from App_ClientProp where attrName = N'Content Indexing Enabled' AND attrVal = N'1' AND modified = 0)
				ELSE
					insert into #SCList SELECT id FROM App_Application where clientId IN(select componentNameId from App_ClientProp where attrName = N'Content Indexing Enabled' AND attrVal = N'1' AND modified = 0)
				-- Filter the subclient with the user for ComplianceSearch capability
				delete from #SCList where id not in(select id from #SCListUser)
				delete from #SCList where id not in(
select sc.id from #SCList sc ,App_Application app,archContentIndexingRules acir where sc.id = app.id and app.dataArchGrpID = acir.archGroupId and acir.enabled>0 AND acir.operationType = 1
				union
				-- Consider those deconfigured clients that have CI license consumed
				select id from App_Application where clientId in(select id FROM  APP_client WHERE (status & 2) > 0 AND id IN (SELECT cid FROM licUsage WHERE licType = 80 AND optype = 'Install' AND (eval = 0 OR expiryDateUTC > GetUTCdate()))))
				-- delete the SILO enabled subclients MR 23797
				-- CV_PROP_SINGLE_INSTANCE_SILO_COPYID
				DELETE FROM #SCList WHERE id IN (SELECT DISTINCT siloAppId from archGroupCopy WITH (NOLOCK) WHERE siloAppId > 0)
				-- delete the non-qualified jobs
				delete from JMCompliancePolicyQualifiedJobs where applicationId not in(select id from #SCList) and complianceId = @complianceId and status = 1
--				-- delete the subclients which are not content indexed in archFile tables
--				delete from #SCList where id not in(select distinct af.appId from archFile af where af.appId in(select id from #SCList) and
--				af.flags & @CONTENTINDEXED <> 0)
				-- Store the resultant job info into compliancePolicy Qualifed jobs table
				-- dataStatus = 0 ==> DATA_STATUS_VALID
				-- status = {1,3} ==> JMSUCCESS, PARTIALSUCCESS
				insert into JMCompliancePolicyQualifiedJobs
				select commCellId, @complianceId, appId, jobId, 1, N'' from jmbkpstats where dataStatus = 0 and appId in (select id from #SCList) and status IN (1,3) and servEndDate >= @i_refTime and jobId not in (select jobId from
				JMCompliancePolicyQualifiedJobs where complianceId = @complianceId)
				-- We should check InfoMgmt jobs which are valid legal hold backup jobs
				-- Infomgmt optype 64
				insert into JMCompliancePolicyQualifiedJobs
				select commCellId, @complianceId, appId, jobId, 1, N'' from JMAdminJobStatsTable where dataStatus = 0 and appId in (select id from #SCList) and status IN (1,3) and servEnd >= @i_refTime and jobId not in (select jobId from
				JMCompliancePolicyQualifiedJobs where complianceId = @complianceId)	and uncompBytes > 0 and opType = 64
				-- delete the jobs which are not content indexed in archFile tables
				delete from JMCompliancePolicyQualifiedJobs where complianceId = @complianceId and jobId not in(select jobid from archFile where
				jobId in (select jobId from JMCompliancePolicyQualifiedJobs where complianceId = @complianceId) and (flags & @CONTENTINDEXED <> 0))
				-- Update the ref. time with the currentTime
				SET @i_refTime = dbo.getunixtime(getutcdate())
				-- Update the ref. time in the complianceDirector definition
				SET @i_xmlValueCompliance.modify('replace value of (/DM2ContentIndexing_ComplianceDirector/@refTime)[1] with sql:variable("@i_refTime")')
				UPDATE SchedAdminComplianceOptions set xmlValue = @i_xmlValueCompliance where dataType = 0 and complianceId = @complianceId
				if @i_xmlComplianceOptions is NOT null
				BEGIN
				-- Update the ref. time in schedAdminComplianceXmlOptions table
				SET @i_xmlComplianceOptions.modify('replace value of (/director/@refTime)[1] with sql:variable("@i_refTime")')
				UPDATE SchedAdminComplianceXMLOptions set xmlValue = @i_xmlComplianceOptions where complianceId = @complianceId
				END
			END
		END
		FETCH NEXT FROM c1 INTO @complianceId
	END
	CLOSE c1
	DEALLOCATE c1
	COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = 1
	ROLLBACK TRANSACTION
END CATCH;
	select @errorCode
	RETURN @errorCode
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO


IF EXISTS (select * from GxQscripts where name = 'JMFillCompPolicyQualifiedJobs')
	delete from GxQscripts where name = 'JMFillCompPolicyQualifiedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMFillCompPolicyQualifiedJobs')
	delete from GXDBVersions where aliasname = 'JMFillCompPolicyQualifiedJobs'
GO

insert into GXDBVersions values(2, 'JMFillCompPolicyQualifiedJobs',  '00010024006000040000', 'JMFillCompPolicyQualifiedJobs', '00010024006000040000')
GO

