

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMDeleteOldFailureReasons.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   09/21/2006
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMDeleteOldFailureReasons.sp,v $ $Id: JMDeleteOldFailureReasons.sp,v 1.1.2.4 2020/03/19 23:28:10 sbonilla Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMDeleteOldFailureReasons')
BEGIN
	print '>>> Drop Stored Procedure: JMDeleteOldFailureReasons <<<'
	drop procedure JMDeleteOldFailureReasons
END
IF EXISTS (select * from GxQscripts where name='JMDeleteOldFailureReasons')
	delete from GxQscripts where name = 'JMDeleteOldFailureReasons'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMDeleteOldFailureReasons')
	delete from GXDBVersions where aliasname = 'JMDeleteOldFailureReasons'
GO
print '... Creating Procedure: JMDeleteOldFailureReasons'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMDeleteOldFailureReasons
  @i_failureReason VARCHAR(256)
AS
	DECLARE @nowUtcTime DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix INT = datediff(second, '01/01/1970', @nowUtcTime)
	IF object_id('tempdb.dbo.#failureReasonString_InfoTable') is not null
		DROP TABLE #failureReasonString_InfoTable
	CREATE TABLE #failureReasonString_InfoTable (failureId INT)
	INSERT INTO #failureReasonString_InfoTable
	(failureId)
	SELECT DISTINCT _ID
	FROM dbo.SplitIDString(@i_failureReason)
	-- delete JMFailureReasonMsgParamTmp first to avoid deadlock with JMAddJobPendingParam
	DELETE JMFailureReasonMsgParamTmp
	FROM JMFailureReasonMsgParamTmp FMT
	JOIN #failureReasonString_InfoTable FR ON FR.failureId = FMT.msgId
	DELETE JMFailureReasonMsg
	FROM JMFailureReasonMsg FM
	JOIN #failureReasonString_InfoTable FR ON FR.failureId = FM.id
	IF object_id('tempdb.dbo.#failureReasonString_InfoTable') is not null
		DROP TABLE #failureReasonString_InfoTable
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'JMDeleteOldFailureReasons')
	delete from GxQscripts where name = 'JMDeleteOldFailureReasons'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMDeleteOldFailureReasons')
	delete from GXDBVersions where aliasname = 'JMDeleteOldFailureReasons'
GO

insert into GXDBVersions values(2, 'JMDeleteOldFailureReasons',  '00010001000200040000', 'JMDeleteOldFailureReasons', '00010001000200040000')
GO

