

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMDeleteJobOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMDeleteJobOptions.sp,v $ $Id: JMDeleteJobOptions.sp,v 1.2.80.1 2020/03/17 20:36:15 gstoops Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMDeleteJobOptions')
BEGIN
	print '>>> Drop Stored Procedure: JMDeleteJobOptions <<<'
	drop procedure JMDeleteJobOptions
END
IF EXISTS (select * from GxQscripts where name='JMDeleteJobOptions')
	delete from GxQscripts where name = 'JMDeleteJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMDeleteJobOptions')
	delete from GXDBVersions where aliasname = 'JMDeleteJobOptions'
GO
print '... Creating Procedure: JMDeleteJobOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMDeleteJobOptions
  @i_jobId INT
AS
  DECLARE @o_jobOptionsRowsDeleted INT = 0
  DECLARE @o_jobXMLOptionsRowsDeleted INT = 0
  DECLARE @o_errorCode INT = 0
  DECLARE @o_errorCodeStr NVARCHAR(1024) = ''
BEGIN
	SET NOCOUNT ON
	IF (@i_jobId <= 0)
	BEGIN
		GOTO END_OF_PROC
	END
	-- Determine initiation source
	DECLARE @isCommandLine BIT = 'false'
	DECLARE @isThirdParty BIT = 'false'
	DECLARE @comInitFromId INT = 0
	DECLARE @initFrom INT = 0
	DECLARE @jobCategory INT = 0
	-- Get info on if it is command line
	SELECT @comInitFromId = [CommServ].[dbo].[GetJobOption](@i_jobId, 140030 /*COM_INIT_FROM_ID*/)
	IF @comInitFromId = 2 -- enum InitFromType InitFromType_COMMANDLINE in TMMsgEnumBase.h
	   SET @isCommandLine = 'true'
	-- Get info on if it is third party
	SELECT @jobCategory = jobCategory
		   FROM JMJobStats (NOLOCK)
		   WHERE jobid = @i_jobId
		   AND commcellId = 2 -- Default commcell id
	IF @jobCategory = 1 -- enum CVJobCategory BACKUPCATEGORY in CvConstDefCommon.h
	BEGIN
		   SELECT @initFrom = initFrom
		   FROM JMBkpStats (NOLOCK)
		   WHERE jobId = @i_jobId
		   AND commcellId = 2 -- Default commcell id
	END
	ELSE IF @jobCategory = 2 -- enum CVJobCategory RESTORECATEGORY in CvConstDefCommon.h
	BEGIN
		   SELECT @initFrom = initFrom
		   FROM JMRestoreStats (NOLOCK)
		   WHERE jobId = @i_jobId
		   AND commcellId = 2 -- Default commcell id
	END
	ELSE IF @jobCategory = 3 -- enum CVJobCategory ADMINCATEGORY in CvConstDefCommon.h
	BEGIN
		   SELECT @initFrom = initFrom
		   FROM JMAdminJobStatsTable (NOLOCK)
		   WHERE jobId = @i_jobId
		   AND commcellId = 2 -- Default commcell id
	END
	IF @initFrom = 1 -- enum CVInitiatedFrom THIRDPARTY in cvjob.h
		   SET @isThirdParty = 'true'
	-- Gathered enough information, time to start deleting
	BEGIN TRY
		BEGIN TRAN DeleteJobOptionsTrans
		IF (@isCommandLine = 'true' OR @isThirdParty = 'true')
		BEGIN -- Delete all the options that are not used for re-submit jobs
			DELETE TM_JobOptions
			FROM TM_JobOptions TJ
			WHERE jobId = @i_jobId
			SET @o_jobOptionsRowsDeleted = @@ROWCOUNT
			DELETE TM_JobXMLOptions
			FROM TM_JobXMLOptions TJ
			WHERE jobId = @i_jobId
			SET @o_jobXMLOptionsRowsDeleted = @@ROWCOUNT
			COMMIT TRANSACTION DeleteJobOptionsTrans
		END
		ELSE
		BEGIN -- Delete select options that are not used for re-submit jobs
			DELETE TM_JobOptions
			FROM TM_JobOptions TJ
			WHERE jobId = @i_jobId
			AND optionId IN(
			140001,		-- COM_SEQUENCE_NUMBER
			140016,		-- COM_TASK_TYPE
			120008,		-- RST_INIT_USER
			140019,		-- COM_USER_ID
			140021,		-- COM_OWNER_ID
			140026,		-- COM_TASK_ID
			140028,		-- COM_SUB_TASK_ID
			140017,		-- COM_SUB_TASK_TYPE
			140030,		-- COM_INIT_FROM_ID
			140018,		-- COM_OPERATION_TYPE
			100001,		-- BKP_APPID
			458405394,	-- options[1]/backupOpts[1]/@backupLevel
			140031,		-- COM_TASK_FLAGS_ID
			140002)		-- COM_CLIENT_GROUP_ID
			SET @o_jobOptionsRowsDeleted = @@ROWCOUNT
			COMMIT TRANSACTION DeleteJobOptionsTrans
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_errorCode = 1
		SET @o_errorCodeStr = 'DeleteJobOptionsTrans failed'
		ROLLBACK TRANSACTION DeleteJobOptionsTrans
	END CATCH
END_OF_PROC:
	SELECT @o_jobOptionsRowsDeleted o_jobOptionsRowsDeleted, @o_jobXMLOptionsRowsDeleted o_jobXMLOptionsRowsDeleted, @o_errorCode o_errorCode, @o_errorCodeStr o_errorCodeStr
END
GO

IF EXISTS (select * from GxQscripts where name = 'JMDeleteJobOptions')
	delete from GxQscripts where name = 'JMDeleteJobOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMDeleteJobOptions')
	delete from GXDBVersions where aliasname = 'JMDeleteJobOptions'
GO

insert into GXDBVersions values(2, 'JMDeleteJobOptions',  '00010002008000010000', 'JMDeleteJobOptions', '00010002008000010000')
GO

