

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMDataLinkUpgrade.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMDataLinkUpgrade.sp,v $ $Id: JMDataLinkUpgrade.sp,v 1.15.276.2 2018/08/17 08:41:59 pkrishnan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "JMDataLinkUpgrade"				|
--	|									|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMDataLinkUpgrade <<<'

IF EXISTS (select * from sysobjects where name='JMDataLinkUpgrade')
	drop procedure JMDataLinkUpgrade
IF EXISTS (select * from GxQscripts where name='JMDataLinkUpgrade')
	delete from GxQscripts where name = 'JMDataLinkUpgrade'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMDataLinkUpgrade')
	delete from GXDBVersions where aliasname = 'JMDataLinkUpgrade'
GO
print '... Creating Procedure: JMDataLinkUpgrade'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMDataLinkUpgrade
AS
  DECLARE @outErrorReturn integer
  DECLARE @outOpenedChain integer
  DECLARE @outDataLinkEntries integer
SET NOCOUNT ON
	DECLARE @errorReturn	integer
	DECLARE @openedChain	integer
	DECLARE @dataLinkCount	integer
	SET @errorReturn = 0
	SET @openedChain = 0
	SET @dataLinkCount = 0
	-- first initialize everything in new JM columns
	UPDATE JMBkpStats SET dataBackedUp = 0, logsBackedUp = 0, openChain = 0
	-- update data for apptypes which use archFileOracle
	UPDATE JMBkpStats SET dataBackedUp = 1 where JMBkpStats.appType in (22)
		AND (EXISTS(select * from archFileOracle, archFile where
			archFileOracle.commCellId = JMBkpStats.commcellId
			AND archFileOracle.archFileId =  archFile.id
			AND archFile.jobId = JMBkpStats.jobId
			AND archFile.isValid <> 0
			AND archFileOracle.commCellId = archFile.commCellId
			AND archFile.filetype = 1
			AND archFileOracle.instanceId = (select instance from app_application where id = JMBkpStats.appId) ) )
	-- update logs for apptypes which use archFileOracle
	UPDATE JMBkpStats SET logsBackedUp = 1 where JMBkpStats.appType in (22)
		AND (EXISTS(select * from archFileOracle, archFile where
			archFileOracle.commCellId = JMBkpStats.commcellId
			AND archFileOracle.archFileId =  archFile.id
			AND archFile.jobId = JMBkpStats.jobId
			AND archFile.isValid <> 0
			AND archFileOracle.commCellId = archFile.commCellId
			AND archFile.filetype = 4
			AND archFileOracle.instanceId = (select instance from app_application where id = JMBkpStats.appId) ) )
	-- update data for apptypes which don't use archFileOracle
	UPDATE JMBkpStats SET dataBackedUp = 1 where JMBkpStats.appType NOT in (22)
		AND (EXISTS(select * from archFile where
			archFile.commcellId = JMBkpStats.commcellId
			AND archFile.jobId = JMBkpStats.jobId
			AND archFile.isValid <> 0
			AND archFile.filetype = 1
			AND archFile.appId = JMBkpStats.appId))
	-- update data for apptypes which don't use archFileOracle
	UPDATE JMBkpStats SET logsBackedUp = 1 where JMBkpStats.appType NOT in (22)
		AND (EXISTS(select * from archFile where
			archFile.commcellId = JMBkpStats.commcellId
			AND archFile.jobId = JMBkpStats.jobId
			AND archFile.isValid <> 0
			AND archFile.filetype = 4
			AND archFile.appId = JMBkpStats.appId))
	-- one entry per job instance (oracle might have multipe instances)
	-- logjob is the log that completes the instance
	IF object_id('tempdb.dbo.#tempDataJobs') IS NOT NULL DROP TABLE #tempDataJobs
	create table #tempDataJobs
	(
		jobid			integer,
		commcellid		integer,
		servstartdate	integer,
		servenddate		integer,
		appid			integer,
		subclientstatus	integer,
		instanceid		integer,
		backupsetid		integer,
		apptype			integer,
		bkplevel		integer,
		status			integer,
		bkpattributes	bigint,
		logjobid		integer,
		logjobenddate	integer,
		configjobid		integer
	)
	IF object_id('tempdb.dbo.#tempLogJobs') IS NOT NULL DROP TABLE #tempLogJobs
	create table #tempLogJobs
	(
		jobid			integer,
		commcellid		integer,
		servstartdate	integer,
		servenddate		integer,
		appid			integer,
		subclientstatus	integer,
		instanceid		integer,
		backupsetid		integer,
		apptype			integer,
		status			integer,
		bkpattributes	bigint
	)
	IF object_id('tempdb.dbo.#tempAppId') IS NOT NULL DROP TABLE #tempAppId
	CREATE TABLE #tempAppId (
		baseappid		integer,   -- main appid that others will join to
		commcellid		integer,
		appid			integer,
		instanceid		integer,
		apptype			integer
	)
	IF object_id('tempdb.dbo.#tempLinkTable') IS NOT NULL DROP TABLE #tempLinkTable
	CREATE TABLE #tempLinkTable (
		commcellid	integer,
		parentjobid	integer,
		childjobid	integer,
		parentappid	integer,
		childappid	integer,
		childjobstatus	integer
	)
	-- populate above tables
	-- all jobs but oracle are single instance, mysql allows multiple backup levels to start chains
	-- oracle non apptype 22 are also single instance
	insert #tempDataJobs
		select JBS.jobId, JBS.commcellId, JBS.servStartDate, JBS.servEndDate, JBS.appId, AA.subclientStatus, AA.instance, AA.backupSet, JBS.appType, JBS.bkpLevel, JBS.status, JBS.bkpattributes, 0, 0, 0
			from jmbkpstats JBS, app_application AA
			where JBS.dataBackedUp <> 0
			AND	JBS.appType in (81, 3, 5, 6, 59, 77, 104, 37, 62, 103, 61, 2, 23, 80)
			AND JBS.status in (1, 3)
			AND ((JBS.bkpLevel = 1 AND JBS.appType <> 104) OR (JBS.bkpLevel in (1, 4) AND JBS.apptype = 104))
			AND JBS.appid = AA.id
	-- oracle apptype 22 jobs get instances from data backed up (might be multiple) -- note we don't care about subclientstatus or backupsetid so make same as instance
	-- also oracle can link on bkplevel offline full jobs
	insert #tempDataJobs
		select distinct JBS.jobId, JBS.commcellId, JBS.servStartDate, JBS.servEndDate, JBS.appId, 0, AFO.instanceId, AFO.instanceId, JBS.appType, JBS.bkpLevel, JBS.status, JBS.bkpattributes, 0, 0, 0
			from jmbkpstats JBS, archFile AF, archFileOracle AFO
			where JBS.dataBackedUp <> 0
			AND	JBS.appType in (22)
			AND JBS.status in (1, 3)
			AND JBS.bkpLevel in (1, 1024)
			AND JBS.jobId = AF.jobId
			AND JBS.commcellId = AF.commcellId
			AND AF.isValid <> 0
			AND AF.id = AFO.archFileId
			AND AF.filetype = 1
	-- create index on TDJ
	create index index1 on #tempDataJobs (jobid, commcellid)
	create index index2 on #tempDataJobs (instanceid, servstartdate, appid)
	create index index3 on #tempDataJobs (instanceid, servenddate, appid)
	-- get appId's involved
	-- create index now to make usage faster and prevent dups
	create UNIQUE index index1 on #tempAppId (commcellid, baseappid, appid) WITH IGNORE_DUP_KEY
	-- fill in the appId's to match
	-- apptypes which operate at subclient level
	-- mssql (81), sybase (5)
	insert into #tempAppId
		select TDJ.appid, TDJ.commcellId, TDJ.appid, TDJ.instanceid, TDJ.apptype
			from #tempDataJobs TDJ
			where TDJ.apptype in (81, 5)
	-- apptypes which can have log subclients also so need to get those 2 appId's
	-- lotus notes db (6, 59, 77) mysql (104)
	insert into #tempAppId
		select TDJ.appid, TDJ.commcellId, AA.id, TDJ.instanceid, TDJ.apptype
			from #tempDataJobs TDJ, app_application AA
			where TDJ.instanceid = AA.instance
			AND TDJ.apptype in (6, 59, 77, 104)
			AND ((TDJ.appId = AA.id) OR (TDJ.appId in (select id from app_application AA2 where TDJ.instanceid = AA2.instance AND ((AA2.subclientStatus & 0x80) = 0x80) )))
	-- apptypes which operate at backupset level
	-- db2 (37, 62, 103)
	insert into #tempAppId
		select TDJ.appid, TDJ.commcellId, AA.id, TDJ.instanceid, TDJ.apptype
			from #tempDataJobs TDJ, app_application AA
			where TDJ.instanceid = AA.instance
			AND TDJ.backupsetid = AA.backupSet
			AND TDJ.apptype in (37, 62, 103)
	-- apptypes which operate at instance level
	-- oracle (2, 22, 23, 80) or sap oracle (61) or informix (3)
	insert into #tempAppId
		select TDJ.appid, TDJ.commcellId, AA.id, TDJ.instanceid, TDJ.apptype
			from #tempDataJobs TDJ, app_application AA
				where TDJ.instanceid = AA.instance
				AND TDJ.apptype in (2, 22, 23, 80, 61, 3)
	-- now get the log jobs
	-- non oracle apptype 22 which don't have archFileOracle also do this way
	insert #tempLogJobs
		select JBS.jobId, JBS.commcellId, JBS.servStartDate, JBS.servEndDate, JBS.appId, AA.subclientStatus, AA.instance, AA.backupSet, JBS.appType, JBS.status, JBS.bkpattributes
			from jmbkpstats JBS, app_application AA
			where JBS.logsBackedUp <> 0
			AND	JBS.appType in (81, 3, 6, 59, 77, 5, 104, 37, 62, 103, 61, 2, 23, 80)
			AND JBS.status in (1, 3)
			AND JBS.appid = AA.id
	-- oracle jobs get instances from logs backed up (might be multiple)--again ignore backupSet
	insert #tempLogJobs
		select distinct JBS.jobId, JBS.commcellId, JBS.servStartDate, JBS.servEndDate, JBS.appId, 0, AFO.instanceId, AFO.instanceId, JBS.appType, JBS.status, JBS.bkpattributes
			from jmbkpstats JBS, archFile AF, archFileOracle AFO
			where JBS.logsBackedUp <> 0
			AND	JBS.appType in (22)
			AND JBS.status in (1, 3)
			AND JBS.jobId = AF.jobId
			AND JBS.commcellId = AF.commcellId
			AND AF.isValid <> 0
			AND AF.id = AFO.archFileId
			AND AF.filetype = 4
	-- create index on log job table
	create index index1 on #tempLogJobs (jobid, commcellid)
	create index index2 on #tempLogJobs (instanceid, servstartdate, appid)
	create index index3 on #tempLogJobs (instanceid, servenddate, appid)
	-- first find overlapping log jobs with the data ones, can simply join the 2 tables via instance
	-- and insert into the link table (will be generic across apptypes)
	insert #tempLinkTable
		select TDJ.commcellid, TDJ.jobid, TLJ.jobid, TDJ.appid, TLJ.appid, TLJ.status
			from #tempDataJobs TDJ, #tempLogJobs TLJ
			where TDJ.instanceid = TLJ.instanceid
				AND TDJ.commcellid = TLJ.commcellid
				AND TLJ.appid in (select appId from #tempAppId TA where TDJ.commcellid = TA.commcellid AND TA.baseappid = TDJ.appid AND TDJ.instanceid = TA.instanceid)
				AND ((TDJ.servstartdate <= TLJ.servstartdate AND TLJ.servstartdate <= TDJ.servenddate) OR
				 (TDJ.servstartdate <= TLJ.servenddate AND TLJ.servenddate <= TDJ.servenddate) OR
				 (TLJ.servstartdate <= TDJ.servstartdate AND TDJ.servenddate <= TLJ.servenddate))
				AND TDJ.jobid <> TLJ.jobid
				-- sap data jobs need qualifier
				AND (((TDJ.bkpattributes & 0x1000) = 0x1000 AND TDJ.apptype = 61) OR TDJ.apptype <> 61)
				-- but not for selective offline full -- they ONLY will self link to themselves
				AND TDJ.bkplevel <> 1024
	-- requirements change that we won't link another log job to this one if this one also
	-- did logs as it single fills its own requirement.  check if it did logs and link it to itself
	update #tempDataJobs set logjobid = TLJ.jobid
		from #tempDataJobs TDJ, #tempLogJobs TLJ
		where TDJ.jobid = TLJ.jobId
		AND TDJ.commcellid = TLJ.commcellid
		AND TDJ.instanceid = TLJ.instanceid
	-- now get the next log on the subclient & save it with the data job table
	-- this way we can see where links have been completed per instance
	-- only do this if we haven't already linked job to itself above
	update #tempDataJobs set logjobid =
		ISNULL((select TOP 1 TLJ.jobid
			from #tempDataJobs TDJ2, #tempLogJobs TLJ
			where TDJ2.instanceid = TLJ.instanceid
				AND TDJ2.commcellid = TLJ.commcellid
				AND TLJ.appid in (select appid from #tempAppId TA where TDJ2.commcellid = TA.commcellid AND TA.baseappid = TDJ2.appid AND TDJ2.instanceid = TA.instanceid)
				AND TDJ.servenddate <= TLJ.servstartdate
				AND TLJ.status = 1
				AND TDJ.jobid = TDJ2.jobid
				AND TDJ.commcellid = TDJ2.commcellid
				AND TDJ.instanceid = TDJ2.instanceid
				order by TLJ.servstartdate), 0)
		from #tempDataJobs TDJ
			-- sap data jobs need qualifier
			where (((TDJ.bkpattributes & 0x1000) = 0x1000 AND TDJ.apptype = 61) OR TDJ.apptype <> 61)
			AND TDJ.logjobid = 0
			-- don't do this for SQL (only do overlapping)
			AND TDJ.apptype <> 81
			-- don't do this for selective offline full
			AND TDJ.bkplevel <> 1024
	-- now any record in #tempDataJobs that has a logjobid in it will be a complete
	-- chain for the instance and should be linked.
	insert #tempLinkTable
		select TDJ.commcellid, TDJ.jobid, TLJ.jobid, TDJ.appid, TLJ.appid, TLJ.status
			from #tempDataJobs TDJ, #tempLogJobs TLJ
			where TDJ.logjobid <> 0
			AND TDJ.instanceid = TLJ.instanceid
			AND TDJ.commcellid = TLJ.commcellid
			AND TDJ.logjobid = TLJ.jobid
			-- sap data jobs need qualifier
			AND (((TDJ.bkpattributes & 0x1000) = 0x1000 AND TDJ.apptype = 61) OR TDJ.apptype <> 61)
	-- and data aging wants data jobs to be child of itself if also did logs so do this
	-- this might cause dups but they'll be filtered out when we move to final table
	insert #tempLinkTable
		select TDJ.commcellid, TDJ.jobid, TDJ.jobid, TDJ.appid, TDJ.appid, TDJ.status
			from #tempDataJobs TDJ, #tempLogJobs TLJ
			where TDJ.jobid = TLJ.jobid
			AND TDJ.commcellid = TLJ.commcellid
			-- sap data jobs need qualifier
			AND (((TDJ.bkpattributes & 0x1000) = 0x1000 AND TDJ.apptype = 61) OR TDJ.apptype <> 61)
	-- sap for oracle (61) wants to link to next config job started after log job
	-- first get the enddate of the log job
	update #tempDataJobs set logjobenddate = TLJ.servenddate
		from #tempDataJobs TDJ, #tempLogJobs TLJ
		where TDJ.logjobid = TLJ.jobId
		AND TDJ.commcellid = TLJ.commcellid
		AND TDJ.instanceid = TLJ.instanceid
		AND TDJ.logjobid <> 0
		AND TDJ.apptype = 61
		-- note that logjobid being set is sufficient that this isn't config
	-- now get the next successful config job after this for sap (note this config job will be a "log" job)
	update #tempDataJobs set configjobid =
		ISNULL((select TOP 1 TLJ.jobid
			from #tempLogJobs TLJ
			where TLJ.instanceid = TDJ.instanceid
				AND TLJ.commcellid = TDJ.commcellid
				AND TLJ.appid in (select appid from #tempAppId TA where TLJ.commcellid = TA.commcellid AND TA.baseappid = TLJ.appid AND TLJ.instanceid = TA.instanceid)
				AND TDJ.logjobenddate <= TLJ.servstartdate
				AND TLJ.status = 1
				AND TDJ.commcellid = TLJ.commcellid
				AND TDJ.instanceid = TLJ.instanceid
				AND (TLJ.bkpattributes & 0x4000) = 0x4000
				order by TLJ.servstartdate), 0)
		from #tempDataJobs TDJ
			where TDJ.apptype = 61
			AND TDJ.logjobid <> 0
			AND TDJ.logjobenddate <> 0
	-- and any job with a config job in it will now need to be linked to the parent (again the linked config job will be a log job)
	insert #tempLinkTable
		select DISTINCT TDJ.commcellid, TDJ.jobid, TLJ.jobid, TDJ.appid, TLJ.appid, TLJ.status
			from #tempDataJobs TDJ, #tempLogJobs TLJ
			where TDJ.configjobid <> 0
			AND TDJ.instanceid = TLJ.instanceid
			AND TDJ.commcellid = TLJ.commcellid
			AND TDJ.configjobid = TLJ.jobid
			AND TDJ.apptype = 61
	create index index1 on #tempLinkTable (parentjobid, commcellid, childjobid)
	-- elminate any dups in this table from actual datalink
	delete from #tempLinkTable from #tempLinkTable, JMJobDataLink
		where #tempLinkTable.parentjobid = JMJobDataLink.parentJobId
		AND #tempLinkTable.commcellid = JMJobDataLink.commcellId
		AND #tempLinkTable.childjobid = JMJobDataLink.childJobId
	-- now update jmjobtasklink with data from here (need to eliminate dups)
	insert JMJobDataLink
		-- LINK_TYPE_DATA_LOG_UNIT			=	5
		select DISTINCT commcellid, parentjobid, childjobid, parentappid, childappid, 5, childjobstatus
			from #tempLinkTable
	SET @dataLinkCount = @@ROWCOUNT
	-- finally, update jmbkpstats openChain with anything in parent table that doesn't have logjob set
	-- these are open chains.  Note that one intance might be complete so technically the count here might
	-- be inflated if you have a chain say with 3 instances and 2 didn't complete
	update JMBkpStats set openChain = 1
		from JMBkpStats JBS, #tempDataJobs TDJ
		where JBS.jobid = TDJ.jobid
			AND JBS.commcellid = TDJ.commcellid
			AND TDJ.logjobid = 0
			-- don't do this for SQL (only do overlapping so no open chains)
			AND TDJ.apptype <> 81
			-- but don't do this for selective offline full as they can't start a chain
			AND TDJ.bkplevel <> 1024
	SET @openedChain = @@ROWCOUNT
	-- for sap, if the log was found but not config, make openChain = 2
	update JMBkpStats set openChain = 2
		from JMBkpStats JBS, #tempDataJobs TDJ
		where JBS.jobid = TDJ.jobid
			AND JBS.commcellid = TDJ.commcellid
			AND TDJ.configjobid = 0
			AND JBS.openChain = 1
			AND TDJ.apptype = 61
	DROP TABLE #tempDataJobs
	DROP TABLE #tempAppId
	DROP TABLE #tempLogJobs
	DROP TABLE #tempLinkTable
	select @errorReturn, @openedChain, @dataLinkCount
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMDataLinkUpgrade')
	delete from GxQscripts where name = 'JMDataLinkUpgrade'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMDataLinkUpgrade')
	delete from GXDBVersions where aliasname = 'JMDataLinkUpgrade'
GO

insert into GXDBVersions values(2, 'JMDataLinkUpgrade',  '00010015027600020000', 'JMDataLinkUpgrade', '00010015027600020000')
GO

