

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMDataLinkRelatedJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMDataLinkRelatedJobs.sp,v $ $Id: JMDataLinkRelatedJobs.sp,v 1.33.2.29.12.1 2021/03/22 19:45:40 gpattabiraman Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "JMDataLinkRelatedJobs"				|
--	|									|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='JMDataLinkRelatedJobs')
BEGIN
	print '>>> Drop Stored Procedure: JMDataLinkRelatedJobs <<<'
	drop procedure JMDataLinkRelatedJobs
END
IF EXISTS (select * from GxQscripts where name='JMDataLinkRelatedJobs')
	delete from GxQscripts where name = 'JMDataLinkRelatedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMDataLinkRelatedJobs')
	delete from GXDBVersions where aliasname = 'JMDataLinkRelatedJobs'
GO
print '... Creating Procedure: JMDataLinkRelatedJobs'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure JMDataLinkRelatedJobs
  @inJobId integer,
  @inCommcellId integer
AS
  DECLARE @outErrorReturn integer
  DECLARE @outOpenedChain integer
  DECLARE @outClosedChain integer
  DECLARE @outUpdatedChain integer
  DECLARE @outDataLinkEntries integer
  DECLARE @outDataBackedUp integer
  DECLARE @outLogsBackedUp integer
  DECLARE @outInstanceCount integer
  DECLARE @outBkpLevel integer
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	--DECLARE	@inJobId	integer
	--DECLARE @inCommcellId	integer
	DECLARE @errorReturn	integer
	DECLARE @appId			integer
	DECLARE @appType		integer
	DECLARE @bkpLevel		integer
	DECLARE @status		integer
	DECLARE @servStartDate	integer
	DECLARE @servEndDate	integer
	DECLARE @minArchFileCTime integer
	DECLARE @bkpOptions		integer
	DECLARE @bkpattributes	bigint
	DECLARE @bkpattributesEx bigint
	DECLARE @initFrom		integer
	DECLARE @clientId		integer
	DECLARE @backupSetId	integer
	DECLARE @instanceId		integer
	DECLARE @subclientStatus	integer
	DECLARE @dataBackedUp	integer
	DECLARE @logsBackedUp	integer
	DECLARE @opType			integer
	DECLARE @openedChain	integer
	DECLARE @closedChain	integer
	DECLARE @updatedChain	integer
	DECLARE @dataLinkCount	integer
	--cursor loop holders
	DECLARE	@iid			integer
	DECLARE	@data			integer
	DECLARE	@logs			integer
	DECLARE	@loopCount		integer
	DECLARE @additionBkpLevelForChainStart	integer
	DECLARE @additionBkpLevelForSelfLink	integer
	DECLARE @additionBkpLevelForSelfLink1	integer
	DECLARE @docBkpType						integer
	DECLARE @inOpenChain					integer
	DECLARE @isBlockLevelSynthFull			INT = 0
	DECLARE @fullCycleNumber				INT = 0
	DECLARE @sybaseConcurentLogBackupsEnabled	INT = 0
	DECLARE @isTrueUpJob INT = 0
	DECLARE @synthFullJobIdInCurrentCycle INT = 0
	SET @errorReturn = 0
	SET @docBkpType = 0
	SET	@inOpenChain = 0
	SET @appId = 0
	SET @appType = 0
	SET @bkpLevel = 0
	SET @status = 0
	SET @servStartDate = 0
	SET @servEndDate = 0
	SET @bkpOptions = 0
	SET @bkpattributes = 0
	SET @bkpattributesEx = 0
	SET @initFrom = 0
	SET @clientId = 0
	SET @backupSetId = 0
	SET @instanceId = 0
	SET @subclientStatus = 0
	SET @dataBackedUp = 0
	SET @logsBackedUp = 0
	SET @opType = 0
	SET @openedChain = 0
	SET @closedChain = 0
	SET @updatedChain = 0
	SET @dataLinkCount = 0
	SET @iid = 0
	SET @data = 0
	SET @logs = 0
	SET @loopCount = 0
	-- used for mysql where differential can allow chain start (otherwise leave at full)
	SET @additionBkpLevelForChainStart = 1
	SET @additionBkpLevelForSelfLink = 0
	SET @additionBkpLevelForSelfLink1 = 0
	--DISABLE LINKING INTRODUCED WITH THIS CHANGE
	--SELECT @sybaseConcurentLogBackupsEnabled = value
	--FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'JMSybaseConcurrentLogBackupsEnabled'
	--get the bkpLevel, endTime, appId, appType, etc for this job
	select @appId = JBS.appId, @appType = JBS.appType, @bkpLevel = JBS.bkpLevel, @status = JBS.status, @servStartDate = JBS.servStartDate,
		@servEndDate = JBS.servEndDate, @bkpOptions = JBS.bkpOptions, @bkpattributes = JBS.bkpattributes, @bkpattributesEx = JBS.bkpAttributesEx, @initFrom = JBS.initFrom,
		@clientId = AA1.clientId, @backupSetId = AA1.backupSet, @instanceId = AA1.instance, @subclientStatus = AA1.subclientStatus,
		@dataBackedUp = JBS.dataBackedUp, @logsBackedUp = JBS.logsBackedUp, @opType = JBS.opType, @fullCycleNumber = JBS.fullCycleNum
		from JMBkpStats JBS, App_Application AA1
		where JBS.jobId = @inJobId AND JBS.commCellId = @inCommcellId AND
			JBS.appId = AA1.id
	IF @@ROWCOUNT <> 0
	BEGIN
		--JMBKP_EX_LOG_PROXY_DUMP_SWEEP = 0x4000000000000 and appType != CV_APPTYPE_MSSQL
		--we need to do job linking by choosing from time to be minimum of archfile ctime
		IF (@bkpattributesEx & 0x4000000000000) = 0x4000000000000
				AND	@appType <> 81
		BEGIN
			SELECT @minArchFileCTime = MIN(cTime)
					FROM archFile
					WHERE jobId = @inJobId AND commCellId = @inCommcellId
					AND isValid = 1
			IF @minArchFileCTime < @servStartDate
						SET @servStartDate = @minArchFileCTime
		END
		-- Special linking rules for Block level Synthetic full
		IF @opType = 14 AND @appType IN (37, 104, 22, 125, 135, 5, 62)
		-- optype = Synthetic Full and apptype in (DB2, MySQL, Oracle, PostGreSql, SAP HANA, Sybase, Unix DB2)
		BEGIN
			DECLARE @blockLevelProp NVARCHAR(50) = 'Use block level backup'
			SELECT @isBlockLevelSynthFull = ISNULL(CAST(attrVal AS INT), 0)
			FROM APP_SubClientProp SP WITH (READUNCOMMITTED)
			WHERE attrName = @blockLevelProp AND cs_attrName = CHECKSUM(@blockLevelProp) AND modified = 0
			AND componentNameId = @appId
		END
		IF @appType = 64 AND (@bkpattributesEx & 0x100000000000/*JMBKP_EX_TRANSACTION_LOG_BACKUP*/) = 0x100000000000/*JMBKP_EX_TRANSACTION_LOG_BACKUP*/ AND (@logsBackedUp <> 0 OR @dataBackedUp <> 0)
		BEGIN
			--For cassandra link the Log backup with previous databackup.
			DECLARE @previousDataJob BIGINT = 0
			DECLARE @previousDataJobStatus INTEGER = 1
			SELECT TOP 1 @previousDataJob = jobId , @previousDataJobStatus = status
			FROM JMBkpStats WITH(READUNCOMMITTED) WHERE appId = @appId
				AND fullCycleNum = @fullCycleNumber
				AND status IN (1, 3, 14)
				AND (bkpLevel = 1 OR bkpLevel = 2 OR bkpLevel = 256) --Full, Incremental and Incr No Trunc
				AND dataBackedUp = 1 -- Must have Data
				AND optype = 4
				AND (bkpAttributesEx & 0x100000000000/*JMBKP_EX_TRANSACTION_LOG_BACKUP*/) = 0
				ORDER BY cycleSequence DESC
			IF @previousDataJob > 0
			BEGIN
				INSERT INTO JMJobDataLink
				SELECT @inCommcellId, @previousDataJob, @inJobId,@appId, @appId, 5/*LINK_TYPE_DATA_LOG_UNIT*/, @previousDataJobStatus
			END
		END
		IF @isBlockLevelSynthFull = 1
		BEGIN
			IF (@dataBackedUp <> 0 OR @logsBackedUp <> 0)
			BEGIN
				DECLARE @previousDataIncrementalStartTime	INT = 0
				DECLARE @linkCount INT = 0
				SET @previousDataIncrementalStartTime = (SELECT TOP 1 servStartDate
														 FROM JMBkpStats WITH(READUNCOMMITTED)
														 WHERE appId = @appId
														 AND fullCycleNum = @fullCycleNumber - 1
														 AND status IN (1, 3, 14)
														 AND (bkpLevel = 2 OR bkpLevel = 256) --Incremental and Incr No Trunc
														 AND dataBackedUp = 1 -- Must have Data
														 AND optype != 60 -- Exclude Backup copy
														 ORDER BY cycleSequence DESC)
				IF @previousDataIncrementalStartTime > 0
				BEGIN
						INSERT INTO JMJobDataLink
						SELECT @inCommcellId, @inJobId, JM.jobId, @appId, JM.appId, 5/*LINK_TYPE_DATA_LOG_UNIT*/, JM.status
						FROM JMBkpStats JM WITH(READUNCOMMITTED)
						WHERE JM.appId IN(SELECT id FROM APP_Application WHERE backupSet = @backupSetId) -- In current backupset
						AND JM.status IN (1, 3, 14) -- Successful
						AND JM.logsBackedUp = 1 -- Log backups
						AND optype != 60 -- Exclude Backup copy
						AND JM.servStartDate > @previousDataIncrementalStartTime -- Started after previous incremental start time
						SET @dataLinkCount = @@ROWCOUNT
				END
			END
			IF @dataLinkCount = 0
			BEGIN
				-- if no new links, report that (this is still a good condition if starting a new chain)
				SET @errorReturn = 4
			END
		END
		ELSE IF @opType = 60 -- Backup copy
		BEGIN
				IF @appType IN (SELECT DISTINCT appTypeId
								 FROM GetAppTypesForAppGroup(136,0) --APPGRP_TRUE_UP_SUPPORTED
								 )
					AND @status IN (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
					AND @opType = 60 -- BACKUP
					AND @bkpLevel <> 1
				BEGIN
					--True Up is supported for Block level backup where Snap and backup copy run in separate jobs.
					-- Hence we need to link the snap job if Backup copy job was marked as true up.
					DECLARE @materializeJobID INTEGER
					SELECT @materializeJobID = processedJobId FROM JMJobWF  WITH(NOLOCK)
					WHERE childJobId = @inJobId AND commcellId = @inCommcellId
					-- change to read flag 44 (JM_FS_LINK_TRUEUP_JOB) from snap job
					SELECT @isTrueUpJob = intData FROM JMMisc(NOLOCK)
					WHERE jobid = @materializeJobID AND commCellId = @inCommcellId
AND itemType = 44
					IF @isTrueUpJob <> 0 AND @materializeJobID <> 0
					BEGIN
						-- If cycle started with synthetic full and this is first true-up job, then link it
						SELECT @synthFullJobIdInCurrentCycle = BS.jobId
						FROM JMBkpStats BS(NOLOCK)
						WHERE appId = @appId
						AND fullCycleNum = @fullCycleNumber
						AND opType = 14 --SYNTHFULL
						AND status IN (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
						IF @synthFullJobIdInCurrentCycle <> 0
						   AND NOT EXISTS (SELECT 1 FROM JMJobDataLink DL (NOLOCK)
										   WHERE parentJobId = @synthFullJobIdInCurrentCycle AND parentAppid = @appId
										   AND childAppid = @appId
										   AND linkType = 6 -- LINK_TYPE_FOR_SELCOPY_OR_EXT_RETENTION
										   )
						BEGIN
							-- This means it is first true up job let us link it
							INSERT INTO JMJobDataLink(commCellId, parentJobId, childJobId, parentAppid, childAppid, linkType , childJobStatus)
							SELECT @inCommcellId, @synthFullJobIdInCurrentCycle,@materializeJobID, @appId, @appId, 6/*LINK_TYPE_FOR_SELCOPY_OR_EXT_RETENTION*/, @status
							SET @dataLinkCount = @@ROWCOUNT
						END
						--Update true up attribute for Snap job
						UPDATE JMBkpStats
						SET bkpAttributesEx = (bkpAttributesEx | 0x8000000000) --JMBKP_EX_FS_TRUE_UP_JOB
						WHERE jobId = @materializeJobID AND commCellId = @inCommcellId
					END
				END
				ELSE
				BEGIN
					--not an optype we are dealing with
					SET @errorReturn = 2
				END
		END
		-- only do more if we have a db apptype
		ELSE IF @appType = 81 OR @appType = 3 OR @appType = 125 OR (@appType = 6 OR @appType = 59 OR @appType = 77)
		--     MSSQL          INFORMIX                        LOTUSNOTESDB
		-- removed exchangedb as logs go as data files
		--	OR (@appType = 9 OR @appType = 15 OR @appType = 53)
		--                  EXCHANGE DB
			OR @appType = 104 OR (@appType = 37 OR @appType = 62 OR @appType = 103)
		--        MYSQL			                 DB2
			OR @appType = 61 OR (@appType = 5 AND @sybaseConcurentLogBackupsEnabled = 1)
		--    SAP ORACLE		SYBASE
			OR (@appType = 2 OR @appType = 22 OR @appType = 23 OR @appType = 80  OR @appType = 128 OR @appType = 135)
		--                            ORACLE						ORACLE RAC		DOCUMENTUM		SAP HANA
		BEGIN
			IF (@dataBackedUp <> 0 OR @logsBackedUp <> 0)
			BEGIN
				--stores all appid's to search for (especially important for sql multi instance)
				IF object_id('tempdb.dbo.#tempAppId') IS NOT NULL DROP TABLE #tempAppId
				CREATE TABLE #tempAppId (
					ttappId			integer,
					ttsubclientstatus	integer,
					ttinstanceId	integer,
					ttdata			integer,
					ttlogs			integer
				)
				IF object_id('tempdb.dbo.#tempLinkTable') IS NOT NULL DROP TABLE #tempLinkTable
				CREATE TABLE #tempLinkTable (
					ttparentjobId	integer,
					ttparentappId	integer,
					ttchildjobId	integer,
					ttchildappId	integer,
					ttchildstatus	integer
				)
				-- these 2 used for oracle (and probably should have been for everything but too risky to change now
				-- but oracle has a problem with getting the right instanceId so have to do it this way)
				IF object_id('tempdb.dbo.#tempCandidateDataJobs') IS NOT NULL DROP TABLE #tempCandidateDataJobs
				create table #tempCandidateDataJobs
				(
					jobId			integer,
					commCellId		integer,
					servStartDate	integer,
					servEndDate		integer,
					appId			integer,
					instanceId		integer,
					appType			integer,
					status			integer,
					opType			integer,
					openChain		integer,
					changedOpenChain	integer
				)
				IF object_id('tempdb.dbo.#tempCandidateLogJobs') IS NOT NULL DROP TABLE #tempCandidateLogJobs
				create table #tempCandidateLogJobs
				(
					jobId			integer,
					commCellId		integer,
					servStartDate	integer,
					servEndDate		integer,
					appId			integer,
					instanceId		integer,
					appType			integer,
					status			integer,
					opType			integer
				)
				-- Get List of SA enabled subclients for documentum. Store in temporary table
				IF object_id('tempdb.dbo.#tempSAAppId') IS NOT NULL DROP TABLE #tempSAAppId
				CREATE TABLE #tempSAAppId (
					ttappId			integer
				)
				IF object_id('tempdb.dbo.#tempOpenChainJobs') IS NOT NULL DROP TABLE #tempOpenChainJobs
				CREATE TABLE #tempOpenChainJobs (
					jobId			integer
				)
				IF @appType = 81
				BEGIN
					-- MSSQL
					insert into #tempAppId
						select @appId, @subclientStatus, @instanceId, @dataBackedUp, @logsBackedUp
				END
				ELSE IF @appType = 3
				BEGIN
					-- INFORMIX
					insert into #tempAppId
						-- change as get all appid's on instance (like oracle where everything under instance also shares backupset)
						select id, subclientStatus, instance, @dataBackedUp, @logsBackedUp from App_Application where clientId = @clientId AND appTypeId = @appType AND instance = @instanceId AND backupSet = @backupSetId
				END
				ELSE IF (@appType = 6 OR @appType = 59 OR @appType = 77)
				BEGIN
					-- lotus notes db
					-- lotus notes db has separate log subclient and ALWAYS runs logs on that subclient for all other subclients
					-- if the current appId is the log subclient, then it can link with any subclient
					-- if it's not a log subclient, then it stands alone
					--	#define CV_STATUS_TRAN_LOG			0x0080 -- transaction logs subclient
					IF (@subclientStatus & 0x80) = 0x80
					BEGIN
						-- ignore these subclients however
						-- per Hetal, don't filter out deleted & uninstalled subclients as data still goes through aging
						-- #define CV_STATUS_UNINSTALLED		0x0002
						-- #define CV_STATUS_DELETED			0x0004
						-- #define CV_STATUS_HIDDEN				0x0020
						insert into #tempAppId
							select id, subclientStatus, instance, @dataBackedUp, @logsBackedUp from App_Application where clientId = @clientId AND appTypeId = @appType AND instance = @instanceId AND backupSet = @backupSetId AND (subClientStatus & 0x20) = 0
					END
					ELSE
					BEGIN
						-- need this subclient and potentially any log subclient
						insert into #tempAppId
							select id, subclientStatus, instance, @dataBackedUp, @logsBackedUp from App_Application
								where ((clientId = @clientId AND appTypeId = @appType AND instance = @instanceId AND backupSet = @backupSetId AND (subClientStatus & 0x80) = 0x80) OR (id = @appId))
					END
				END
				ELSE IF (@appType = 9 OR @appType = 15 OR @appType = 53)
				BEGIN
					-- exchange db (this code won't get executed as commented out above)
					-- exchange db has separate log subclient and ALWAYS runs logs on that subclient for all other subclients
					-- if the current appId is the log subclient, then it can link with any subclient
					-- if it's not a log subclient, then it stands alone
					--	#define CV_STATUS_TRAN_LOG			0x0080 -- transaction logs subclient
					IF (@subclientStatus & 0x80) = 0x80
					BEGIN
						-- ignore these subclients however
						-- #define CV_STATUS_HIDDEN				0x0020
						insert into #tempAppId
							select id, subclientStatus, instance, @dataBackedUp, @logsBackedUp from App_Application where clientId = @clientId AND appTypeId = @appType AND instance = @instanceId AND backupSet = @backupSetId AND (subClientStatus & 0x20) = 0
					END
					ELSE
					BEGIN
						-- need this subclient and potentially any log subclient
						insert into #tempAppId
							select id, subclientStatus, instance, @dataBackedUp, @logsBackedUp from App_Application
								where ((clientId = @clientId AND appTypeId = @appType AND instance = @instanceId AND backupSet = @backupSetId AND (subClientStatus & 0x80) = 0x80) OR (id = @appId))
					END
				END
				ELSE IF @appType = 5
				BEGIN
					-- sybase
					insert into #tempAppId
						select @appId, @subclientStatus, @instanceId, @dataBackedUp, @logsBackedUp
					-- Overlapping jobs will be linked below.
					-- Take start time as minimum of cTime and startTime to handle Sybase Log backup to disk case
					SELECT @minArchFileCTime = MIN(cTime)
					FROM archFile
					WHERE jobId = @inJobId AND commCellId = @inCommcellId
					AND isValid = 1
					IF @minArchFileCTime < @servStartDate
						SET @servStartDate = @minArchFileCTime
				END
				ELSE IF @appType = 104
				BEGIN
					-- mysql
					-- mysql can have a log subclient (like notes db) or can run log on same subclient
					-- differential jobs can also start a chain
					--	DIFFERENTIAL = 0x4,
					SET @additionBkpLevelForChainStart = 4
					--	#define CV_STATUS_TRAN_LOG			0x0080 -- transaction logs subclient
					--	#define CV_STATUS_HIDDEN			0x0020
					IF (@subclientStatus & 0x80) = 0x80
					BEGIN
						insert into #tempAppId
							select id, subclientStatus, instance, @dataBackedUp, @logsBackedUp from App_Application where clientId = @clientId AND appTypeId = @appType AND instance = @instanceId AND backupSet = @backupSetId AND (subClientStatus & 0x20) = 0
					END
					ELSE
					BEGIN
						insert into #tempAppId
							select @appId, @subclientStatus, @instanceId, @dataBackedUp, @logsBackedUp
					END
				END
				ELSE IF @appType = 37 OR @appType = 62 OR @appType = 103 OR @appType = 135
				BEGIN
					-- db2 and SAP Hana
					-- db2 and SAP Hana are at the backupset level.  link everything with same backupsetid (which means it will also have the same instance as this job)
					BEGIN
						insert into #tempAppId
							select id, subclientStatus, instance, @dataBackedUp, @logsBackedUp
							from App_Application
							where clientId = @clientId AND appTypeId = @appType AND instance = @instanceId AND backupSet = @backupSetId
							AND (((subClientStatus & 0x40) = 0 AND @appType = 135) OR @appType <> 135)	--Ignore command line subclients for SPA Hana
					END
				END
				ELSE IF @appType = 2 OR @appType = 23 OR @appType = 128
				BEGIN
					-- oracle like (non 22 which doesn't use ArchFileOracle)
					-- here everything is on an instance
					insert into #tempAppId
						select id, subclientStatus, instance, @dataBackedUp, @logsBackedUp from App_Application where clientId = @clientId AND appTypeId = @appType AND instance = @instanceId AND backupSet = @backupSetId
					-- also use selective online full for linking
					SET @additionBkpLevelForChainStart = 32768
				END
				ELSE IF @appType IN(22, 80, 61) -- Oracle, RAC and SAP to have same logic. MR:223761
				BEGIN
					-- oracle apptype 22 uses ArchFileOracle and has all kinds of weird cases
					-- because of multiinstance, best to find all appId's for the current job
					-- then get their instance and all other appId's on each instance
					-- also use selective offline full as self link but it can't be chained too..weird special case
					-- Update : 16/05/2016 - We can get the instance Id from App_Application table and ArchFileOracle is no longer reliable from V11. MR : 158077
					SET @additionBkpLevelForSelfLink = 1024
					SET @additionBkpLevelForChainStart = 32768
					-- SnapBackup online FULL backup. For traditional backup linking is done in job object creation itself
					IF @opType = 59 OR @opType = 65
					BEGIN
						SET @additionBkpLevelForSelfLink1 = 32768
					END
					insert into #tempAppId
						select id, subclientStatus, instance, 0, 0 from App_Application where clientId = @clientId AND appTypeId = @appType
							AND instance in (
												SELECT APP.instance
												FROM archFile AF
												INNER JOIN APP_Application APP ON AF.appId = APP.id
												WHERE AF.jobId = @inJobId AND AF.commCellId = @inCommcellId
												AND AF.isValid <> 0
											)
							--AND backupSet = @backupSetId
							--per Hetal, don't filter out deleted & uninstalled as data still goes through aging
							--AND (subClientStatus & 0x6) = 0
					-- now update the data & logs column on a per instance basis
					update #tempAppId set ttdata = 1
						where (EXISTS(
										SELECT 1
										FROM archFile AF
										INNER JOIN APP_Application APP ON AF.appId = APP.id
										WHERE AF.jobId = @inJobId AND AF.commCellId = @inCommcellId
										AND AF.isValid <> 0 AND APP.instance = #tempAppId.ttinstanceId
										AND AF.fileType = 1 -- CVA_DATATYPE_DATA
										)
								)
					update #tempAppId set ttlogs = 1
						where (EXISTS(
										SELECT 1
										FROM archFile AF
										INNER JOIN APP_Application APP ON AF.appId = APP.id
										WHERE AF.jobId = @inJobId AND AF.commCellId = @inCommcellId
										AND AF.isValid <> 0 AND APP.instance = #tempAppId.ttinstanceId
										AND AF.fileType = 4 -- CVA_DATATYPE_LOGS
										)
								)
					-- now things get a bit messy because we can't use the instance in jmbkpstats later since that could be an ondemand job
					-- where archive files go to a different instance.  So really have to make a list of all jobs on the instances we
					-- just put in #tempAppId above.  Those become our candidate jobIds
					-- Update : 16/05/2016 - We can get the instance Id from App_Application table and ArchFileOracle is no longer reliable from V11. MR : 158077
					insert #tempCandidateDataJobs
						select distinct JBS.jobId, JBS.commCellId, JBS.servStartDate, JBS.servEndDate, JBS.appId, APP.instance, JBS.appType, JBS.status, JBS.opType, JBS.openChain, 0
							from jmbkpstats JBS, archFile AF, APP_Application APP
							where JBS.dataBackedUp <> 0
							AND JBS.status in (1, 3, 14) -- Success, partial success and success with warnings
							AND (
									JBS.bkpLevel = 1 -- selective offline full not here as nothing links to it except itself
										  OR
								    (JBS.bkpLevel IN(2, 256) AND JBS.opType = 59) -- Consider Snap Incrementals with data also
										  OR
								    (JBS.bkpLevel  = 32768 AND (@bkpattributesEx & 0x4000000000000) = 0x4000000000000)
									-- we will consider SOF jobs for linking only for Log backup to disk feature
									--JMBKP_EX_LOG_PROXY_DUMP_SWEEP = 0x4000000000000 this is
									-- because during the log phase of SOF jobs, we backup the logs to disk which is later swept.
								)
							AND JBS.jobId = AF.jobId
							AND JBS.commCellId = AF.commCellId
							AND AF.isValid <> 0
							AND AF.appId = APP.id
							AND AF.filetype = 1
							AND APP.instance in (select ttinstanceId from #tempAppId)
					insert #tempCandidateLogJobs
						select distinct JBS.jobId, JBS.commCellId, JBS.servStartDate, JBS.servEndDate, JBS.appId, APP.instance, JBS.appType, JBS.status, JBS.opType
							from jmbkpstats JBS, archFile AF, APP_Application APP
							where JBS.logsBackedUp <> 0
							AND JBS.status in (1, 3, 14) -- Success, partial success and success with warnings
							AND JBS.jobId = AF.jobId
							AND JBS.commCellId = AF.commCellId
							AND AF.isValid <> 0
							AND AF.appId = APP.id
							AND AF.filetype = 4
							AND APP.instance in (select ttinstanceId from #tempAppId)
					-- create index on TDJ
					create index index1 on #tempCandidateDataJobs (jobId, commCellId)
					create index index2 on #tempCandidateDataJobs (instanceid, servStartDate, appId)
					create index index3 on #tempCandidateDataJobs (instanceid, servEndDate, appId)
				END
				ELSE IF @appType = 125
				BEGIN
					-- Postgres Sql.
					-- In case of PG FS Backup we need link data with logs
					-- For dump backup there is no need of linking the jobs
					insert into #tempAppId
						select @appId, @subclientStatus, @instanceId, @dataBackedUp, @logsBackedUp
				END
				IF @appType = 128
				BEGIN
					-- Documentum SA
					IF(@bkpattributes & 0x400000000000 = 0x400000000000)
					BEGIN
						SET @docBkpType |= 0x2
					END
					-- Documentum FTI
					IF (@bkpattributes & 0x800000000000 = 0x800000000000)
					BEGIN
						SET @docBkpType |= 0x4
					END
					-- Documentum LOG
					IF (@bkpattributes & 0x4000000000000 = 0x4000000000000)
					BEGIN
						SET @docBkpType |= 0x8
					END
					-- Get list of appIds which are enabled for SA.
					INSERT INTO #tempSAAppId
					SELECT DISTINCT componentnameid FROM APP_SubClientProp WHERE attrName = 'Documentum Skip SA Backup' AND componentNameId in (select id FROM APP_Application WHERE instance = @instanceId AND ((subclientStatus & (2 | 4 | 16 | 32)) = 0)) AND attrVal = '1' AND modified =0
					IF ((@bkpattributes & 0x1000) <> 0x1000)
					BEGIN
						IF (@status = 1 AND @bkpLevel = 1)
						BEGIN
							-- So documentum FTI, SA and Log jobs
					insert into #tempLinkTable
						select top 1 JBS.jobId, JBS.appId, @inJobId, @appId, @status
						from JMBkpStats JBS where
						JBS.dataBackedUp <> 0
						AND JBS.commCellId = @inCommcellId
						AND JBS.jobId <> @inJobId
						AND JBS.appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @instanceId)
						AND (JBS.bkpattributes & 0x1000 = 0x1000)
								AND ( openChain & 0x10 <> 0x10 AND -- Job belongs to current cycle
								(openChain & @docBkpType & 0x2 <> 0 OR openChain & @docBkpType & 0x4 <> 0
									OR openChain & @docBkpType & 0x8 <> 0))
						ORDER By JBS.servEndDate DESC
								SELECT @inOpenChain = openChain FROM JMBkpStats where jobid =
								(select ttparentjobId from #tempLinkTable) and commCellId = @inCommcellId
								-- Delete those subclients which are already linked
								delete from #tempSAAppId WHERE ttappId in(
								SELECT DISTINCT childAppid  FROM JMJobDataLink WHERE parentJobId in
								(SELECT ttparentjobId FROM #tempLinkTable) AND commCellId = @inCommcellId)
								-- Delete the current entry APPId
								delete from #tempSAAppId WHERE ttappId = @appId
								-- SA
								IF NOT EXISTS(SELECT *FROM #tempSAAppId) AND (@inOpenChain & @docBkpType & 0x2 <> 0)
									SET @inOpenChain ^= 0x2
								-- FTI
								IF @inOpenChain & @docBkpType & 0x4 <> 0
									SET @inOpenChain ^= 0x4
								-- LOG
								IF @inOpenChain & @docBkpType & 0x8 <> 0
									SET @inOpenChain ^= 0x8
								IF @inOpenChain = 0x1
									SET @inOpenChain = 0
								-- Here we have to close the open chain
								UPDATE JMBkpStats
								set openChain = @inOpenChain
								where commCellId = @inCommcellId
								AND jobId in (select ttparentjobId from #tempLinkTable)
						  END
					END
					ELSE
					BEGIN
						-- DB Backup
					IF @dataBackedUp <> 0
					BEGIN
						-- if the data job was success/partial, it's a candidate to link other jobs to
						-- bkpLevel 1024 means offline database
						IF (@status = 1 AND (@bkpLevel = 1 or @bkpLevel = 1024))
						BEGIN
							-- handle data job
							-- Self linking if the job contains Log or SA or FTI
							IF @logsBackedUp <> 0 OR (@bkpattributes & 0x400000000000 = 0x400000000000) OR (@bkpattributes & 0x800000000000 = 0x800000000000)
							BEGIN
								insert into #tempLinkTable
									select @inJobId, @appId, @inJobId, @appId, @status
							END
							-- Find any overlapping LOG,FTI and SA jobs and select them as children of this job
							insert into #tempLinkTable
								select @inJobId, @appId, JBS.jobId, JBS.appId, JBS.status
									from JMBkpStats JBS where
									 -- target job start time is after this one's start and before this one's end time
									((@servStartDate <= JBS.servStartDate AND JBS.servStartDate <= @servEndDate) OR
									 -- target job's end time is after this one's start time and before this one's end time
									 (@servStartDate <= JBS.servEndDate AND JBS.servEndDate <= @servEndDate) OR
									 -- target jobs start time is before this one and it ended after this one (should not happen)
									 (JBS.servStartDate <= @servStartDate AND @servEndDate <= JBS.servEndDate))
									 AND (JBS.logsBackedUp <> 0 OR (((JBS.bkpattributes & 0x400000000000) = 0x400000000000) AND bkpLevel = 1)
									 OR (((JBS.bkpattributes & 0x800000000000) = 0x800000000000) AND bkpLevel =1) )
									 AND JBS.commCellId = @inCommcellId
									 AND JBS.jobId <> @inJobId
									 AND JBS.appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @instanceId)
									-- For documentum Agent we have to close the existing chain if DB backup is followed
									UPDATE JMBkpStats
									set openChain |= 0x10
									where
									dataBackedUp <> 0
									AND commCellId = @inCommcellId
									AND jobId <> @inJobId
									AND appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @instanceId)
									AND (bkpattributes & 0x1000 = 0x1000)
									AND openChain <> 0
									-- Delete those subclients which are selected for child jobs
                                    -- because they are going to be linked
									delete from #tempSAAppId WHERE ttappId in(
									SELECT DISTINCT ttchildappId  FROM #tempLinkTable)
									-- Delete the parent AppId as it will be part of this link
									delete from #tempSAAppId WHERE ttappId = @appId
									SET @inOpenChain = 0
									-- SA
									IF EXISTS(SELECT *FROM #tempSAAppId)
										SET @inOpenChain |= 0x2
									-- FTI
									IF (@docBkpType & 0x4 <> 0x4) AND NOT EXISTS(select * from jmbkpstats where jobid in(select ttchildjobId from #tempLinkTable) and bkpattributes & 0x800000000000 = 0x800000000000)
										IF EXISTS(SELECT * FROM APP_InstanceProp WHERE componentNameId = @instanceId and attrName = 'DOCUMENTUM FTIEnabled' and modified = 0)
											SET @inOpenChain |= 0x4
									-- LOG
									-- Only for online database we need to link log jobs
									IF @bkpLevel = 1 AND (@docBkpType & 0x8 <> 0x8) AND NOT EXISTS(select * from jmbkpstats where jobid in(select ttchildjobId from #tempLinkTable) and bkpattributes & 0x4000000000000 = 0x4000000000000)
										SET @inOpenChain |= 0x8
									IF @inOpenChain > 0
										set @inOpenChain |= 1
									update JMBkpStats set
										openChain = @inOpenChain
										where jobId = @inJobId
										AND commCellId = @inCommcellId
									-- don't "add" @@ROWCOUNT like we'll do later on closed as this is in a loop and can only be 1 even if this
									-- job starts a chain on multiple instances
									IF @@ROWCOUNT <> 0
									BEGIN
										-- record that we opened a new chain for debug
										SET @openedChain = 1
									END
								END
							END
						END
				END
				ELSE
				BEGIN
					-- at this point we have all apptypes we care about
					-- there might be multiple instances (because of oracle) so have to handle each
					-- separately since a log from one instance shouldn't link to another instance
					DECLARE CursorForInstance CURSOR FOR
						SELECT DISTINCT ttinstanceId, ttdata, ttlogs from #tempAppId
					OPEN CursorForInstance
					FETCH NEXT FROM CursorForInstance INTO @iid, @data, @logs
					WHILE @@FETCH_STATUS = 0
					BEGIN
						SET @loopCount = @loopCount + 1
						-- notice the use of the data on an instance variable value since a log
						-- on a different instance shouldn't chain to this one
						IF @data <> 0
						BEGIN
							-- if the data job was success/partial, it's a candidate to link other jobs to
							IF (@status = 1 OR @status = 3 OR @status = 14)
								AND (
											@bkpLevel = 1
												OR
											@bkpLevel = @additionBkpLevelForChainStart
												OR
											(@appType = 104 AND @logs<>0) --MySql can run dataphases as part of Incremental job
												OR
											(@opType = 59 AND @appType IN (37, 104, 22, 125, 135, 5, 62) AND @bkpLevel IN(2, 256)) --For DB agents, incremental/Incr. No Trunc data snap backup should open chain and link with logs.
											-- optype = Snap Backup and apptype in (DB2, MySQL, Oracle, PostGreSql, SAP HANA, Sybase, Unix DB2) and bkpLevel in(INCR, INCR_NOTRUNC)
									 )
							BEGIN
								-- handle data job
								-- data aging wants job to be child of itself if it also had logs so do that first
								IF @logs <> 0
								BEGIN
									insert into #tempLinkTable
										select @inJobId, @appId, @inJobId, @appId, @status
								END
								IF (@appType NOT IN(22, 80, 61)) -- Oracle, RAC and SAP.
								BEGIN
									IF (@appType IN (3)) -- Informix
									BEGIN
										-- Find any overlapping LOG jobs and select them as children of this job
										-- consider only sweep jobs for Informix
										insert into #tempLinkTable
											select @inJobId, @appId, JBS.jobId, JBS.appId, JBS.status
												from JMBkpStats JBS where
												 -- target job start time is after this one's start and before this one's end time
												((@servStartDate <= JBS.servStartDate AND JBS.servStartDate <= @servEndDate) OR
												 -- target job's end time is after this one's start time and before this one's end time
												 (@servStartDate <= JBS.servEndDate AND JBS.servEndDate <= @servEndDate) OR
												 -- target jobs start time is before this one and it ended after this one (should not happen)
												 (JBS.servStartDate <= @servStartDate AND @servEndDate <= JBS.servEndDate))
												 AND JBS.logsBackedUp <> 0
												 AND JBS.commCellId = @inCommcellId
												 AND JBS.jobId <> @inJobId
												 AND JBS.appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @iid)
												 AND ( (JBS.bkpattributesEx & 0x4000000000000) = 0x4000000000000) -- JMBKP_EX_LOG_PROXY_DUMP_SWEEP
									END
									IF (@appType <> 135 AND @appType <> 3)
									BEGIN
									-- Find any overlapping LOG jobs and select them as children of this job
									insert into #tempLinkTable
										select @inJobId, @appId, JBS.jobId, JBS.appId, JBS.status
											from JMBkpStats JBS where
											 -- target job start time is after this one's start and before this one's end time
											((@servStartDate <= JBS.servStartDate AND JBS.servStartDate <= @servEndDate) OR
											 -- target job's end time is after this one's start time and before this one's end time
											 (@servStartDate <= JBS.servEndDate AND JBS.servEndDate <= @servEndDate) OR
											 -- target jobs start time is before this one and it ended after this one (should not happen)
											 (JBS.servStartDate <= @servStartDate AND @servEndDate <= JBS.servEndDate))
											 AND JBS.logsBackedUp <> 0
											 AND JBS.commCellId = @inCommcellId
											 AND JBS.jobId <> @inJobId
											 AND JBS.appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @iid)
											 AND JBS.optype <> 60 -- Exclude Backup copy jobs
									END
									ELSE IF @initFrom IN (2,3)	--GUIINITIATED, SCHEDINITIATED
									BEGIN
									-- Find any overlapping LOG jobs and select them as children of this job
									insert into #tempLinkTable
										select @inJobId, @appId, JBS.jobId, JBS.appId, JBS.status
											from JMBkpStats JBS where
											 -- target jobs start time is before this one and it ended after this one
											 (JBS.servStartDate <= @servStartDate AND @servStartDate <= JBS.servEndDate)
											 AND JBS.logsBackedUp <> 0
											 AND JBS.commCellId = @inCommcellId
											 AND JBS.jobId <> @inJobId
											 AND JBS.appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @iid)
											 AND JBS.optype <> 60 -- Exclude Backup copy jobs
											 -- sap jobs need qualifier as only link this job if it's really data
											--AND (((@bkpattributes & 0x1000) = 0x1000 AND @appType = 61) OR @appType <> 61)
									END
								END
								ELSE
								BEGIN
									-- oracle, RAC and SAP are similiar but now use our candidate log table
									insert into #tempLinkTable
										select @inJobId, @appId, JBS.jobId, JBS.appId, JBS.status
											from #tempCandidateLogJobs JBS where
											 -- target job start time is after this one's start and before this one's end time
											((@servStartDate <= JBS.servStartDate AND JBS.servStartDate <= @servEndDate) OR
											 -- target job's end time is after this one's start time and before this one's end time
											 (@servStartDate <= JBS.servEndDate AND JBS.servEndDate <= @servEndDate) OR
											 -- target jobs start time is before this one and it ended after this one (should not happen)
											 (JBS.servStartDate <= @servStartDate AND @servEndDate <= JBS.servEndDate))
											 --we know these are all logs when we created it
											 --AND JBS.logsBackedUp <> 0
											 AND JBS.commCellId = @inCommcellId
											 AND JBS.jobId <> @inJobId
											 -- and now we can just use instance instead of app since we have that
											 --AND JBS.appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @iid)
											 AND JBS.instanceId = @iid
											 AND JBS.optype <> 60 -- Exclude Backup copy jobs
											  -- sap jobs need qualifier as only link this job if it's really data
											AND (((@bkpattributes & 0x1000) = 0x1000 AND @appType = 61) OR @appType <> 61)
								END
								-- we are no longer making SQL/SYBASE jobs have an open chain (only simultanously run jobs will chain)
								IF @appType NOT IN (81, 5, 135, 3) -- SQL SERVER, SYBASE, SAP HANA, INFORMIX
								BEGIN
									-- #define JMBKP_OPEN_DATA_CHAIN				0x4000000000LL
									update JMBkpStats set
										--bkpattributes = bkpattributes | cast(0x4000000000 as bigint),
										openChain = 1
										where jobId = @inJobId
										AND commCellId = @inCommcellId
										-- sap jobs need qualifier
										AND (((@bkpattributes & 0x1000) = 0x1000 AND @appType = 61) OR @appType <> 61)
									-- don't "add" @@ROWCOUNT like we'll do later on closed as this is in a loop and can only be 1 even if this
									-- job starts a chain on multiple instances
									IF @@ROWCOUNT <> 0
									BEGIN
										-- record that we opened a new chain for debug
										SET @openedChain = 1
									END
								END
							END
							-- for oracle selective offline full, handle the self link case
							-- For Incremental DB2, Oracle backups with both data and log needs self linking
							ELSE IF ( (@status = 1 OR @status = 3 OR @status = 14) AND
									  ((@bkpLevel = @additionBkpLevelForSelfLink) OR (@bkpLevel = @additionBkpLevelForSelfLink1) OR
									   -- JMIsOracle(2, 22, 23, 80)
									   (@bkpLevel = 2/*Incr*/ AND @appType in(2,22,23,80)) OR -- Do we need to include SAP Data jobs here?
									    -- JMIsDB2(37,62,103)
									   (@bkpLevel IN (2/*Incr*/, 4/*Differential*/) AND @appType in(37,62,103))
									  ))
							BEGIN
								-- data aging wants job to be child of itself if it also had logs so do that first
								IF @logs <> 0
								BEGIN
									insert into #tempLinkTable
										select @inJobId, @appId, @inJobId, @appId, @status
								END
							END
						END
						-- again notice the use of the logs on an instance variable value since a log
						-- on one instance can't close a chain on another
						IF @logs <> 0
						BEGIN
							-- handle log job
							-- Find any overlapping DATA jobs and select this job as children of them
							IF (@appType NOT IN(22, 80, 61)) -- Oracle, RAC and SAP
							BEGIN
								IF (@appType <> 135 AND @appType <> 3) OR
								-- For sweep jobs servStartDate has been set to oldest afile cTime.
								-- This will corresspond to the cTime of the first log that was backed up using this sweep job.
								--
								-- Informix and HANA Sweep jobs should be linked with all data jobs that ran in the interval servStartDate and servEndDate
								-- JMBKP_EX_LOG_PROXY_DUMP_SWEEP = 0x4000000000000
								(@appType IN (135,3) AND (@bkpattributesEx & 0x4000000000000) = 0x4000000000000)
								BEGIN
								insert into #tempLinkTable
									select JBS.jobId, JBS.appId, @inJobId, @appId, @status
										from JMBkpStats JBS where
										-- target job start time is after this one's start and before this one's end time
										((@servStartDate <= JBS.servStartDate AND JBS.servStartDate <= @servEndDate) OR
										-- target job's end time is after this one's start time and before this one's end time
										(@servStartDate <= JBS.servEndDate AND JBS.servEndDate <= @servEndDate) OR
										-- target jobs start time is before this one and it ended after this one (should not happen)
										(JBS.servStartDate <= @servStartDate AND @servEndDate <= JBS.servEndDate))
										AND JBS.dataBackedUp <> 0
										AND JBS.commCellId = @inCommcellId
										AND JBS.jobId <> @inJobId
										AND JBS.appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @iid)
										AND JBS.optype <> 60 -- Exclude Backup copy jobs
										-- #define JMBKP_OPEN_DATA_CHAIN				0x4000000000LL
										--AND (bkpattributes & cast(0x4000000000 as bigint)) = (cast(0x4000000000 as bigint))
										-- for SQL we need to catch any overlapping jobs and we don't set the openChain on the data jobs
										-- so for them it's all time based
										AND ((openChain = 1) OR (@appType IN (81, 5, 37, 62, 103, 3, 135))) -- SQL, Sybase, DB2, UnixDB2, DB2DPF, Informix and HANA. We want to link all overlapping jobs irrespective of open chain. MR:223761
								END
								ELSE
								BEGIN
								insert into #tempLinkTable
									select JBS.jobId, JBS.appId, @inJobId, @appId, @status
										from JMBkpStats JBS where
										-- target job start time is after this one's start and before this one's end time
										(@servStartDate <= JBS.servStartDate AND JBS.servStartDate <= @servEndDate)
										AND JBS.dataBackedUp <> 0
										AND JBS.commCellId = @inCommcellId
										AND JBS.jobId <> @inJobId
										AND JBS.appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @iid)
										AND JBS.optype <> 60 -- Exclude Backup copy jobs
										-- #define JMBKP_OPEN_DATA_CHAIN				0x4000000000LL
										--AND (bkpattributes & cast(0x4000000000 as bigint)) = (cast(0x4000000000 as bigint))
										-- for SAP Hana only parent jobs started by GUI or schedule
										AND initFrom IN (2, 3)	--GUIINITIATED, SCHEDINITIATED
										AND bkpLevel = 1		--FULL
								END
							END
							ELSE
							BEGIN
								insert into #tempLinkTable
									select JBS.jobId, JBS.appId, @inJobId, @appId, @status
										from #tempCandidateDataJobs JBS where
										-- target job start time is after this one's start and before this one's end time
										((@servStartDate <= JBS.servStartDate AND JBS.servStartDate <= @servEndDate) OR
										-- target job's end time is after this one's start time and before this one's end time
										(@servStartDate <= JBS.servEndDate AND JBS.servEndDate <= @servEndDate) OR
										-- target jobs start time is before this one and it ended after this one (should not happen)
										(JBS.servStartDate <= @servStartDate AND @servEndDate <= JBS.servEndDate))
										-- we know everything here is data
										--AND JBS.dataBackedUp <> 0
										AND JBS.commCellId = @inCommcellId
										AND JBS.jobId <> @inJobId
										AND JBS.optype <> 60 -- Exclude Backup copy jobs
										--AND JBS.appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @iid)
										-- and can use instance directly
										AND JBS.instanceId = @iid
										-- #define JMBKP_OPEN_DATA_CHAIN				0x4000000000LL
										--AND (bkpattributes & cast(0x4000000000 as bigint)) = (cast(0x4000000000 as bigint))
										-- need not qualify sap jobs here as only data will have openChain set
										--AND openChain <> 0 -- We want to link all overlapping jobs irrespective of open chain for Oracle, RAC, SAP. MR:223761
							END
							-- now if this job did both data & logs, then it will close it's own chain
							-- (new requirement), otherwise we have to find the next log after it ended
							-- note also that this job still could close OTHER jobs's chains as well
							-- sap must have data, config & log to self close
							IF @data <> 0 AND (@status IN(1, 3, 14)) AND ((@appType NOT IN (81, 61, 5)) OR (@appType = 61 AND (@bkpattributes & 0x7000) = 0x7000))
							BEGIN
								-- note that we don't have to stick a datalink entry here since we are
								-- self chaining and we did that in the data part earlier, but we do have
								-- to close the chain
								update JMBkpStats set
									--bkpattributes = bkpattributes & ~cast(0x4000000000 as bigint),
									openChain = 0
									where commCellId = @inCommcellId
										AND jobId = @inJobId
										AND openChain <> 0
									--record how many chains we closed for debug, note this one job could close multiple old jobs
									SET @closedChain = @closedChain + @@ROWCOUNT
							END
							-- now look for open data jobs with end time before this job
							-- we will chain to those jobs and reset their open chain
							-- again not needed for SQL/SYBASE
							IF @appType NOT IN(81, 5)
							BEGIN
								IF @appType NOT IN (22, 80) -- Oracle and RAC - Dont include SAP here as we dont want to change open chain behavior!
								BEGIN
									insert into #tempLinkTable
										select JBS.jobId, JBS.appId, @inJobId, @appId, @status
											from JMBkpStats JBS where
											-- target job end time is before this one's start
											JBS.servEndDate <= @servStartDate
											AND JBS.dataBackedUp <> 0
											AND JBS.commCellId = @inCommcellId
											AND JBS.jobId <> @inJobId
											AND JBS.appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @iid)
											-- #define JMBKP_OPEN_DATA_CHAIN				0x4000000000LL
											-- AND (bkpattributes & cast(0x4000000000 as bigint)) = (cast(0x4000000000 as bigint))
											AND JBS.openChain = 1
											AND JBS.optype <> 60 -- Exclude Backup copy jobs
											 -- sap jobs don't need qualifier since only data jobs will have openChain set
									-- and reset the chain flag on such jobs IF the current job was success
									-- or set it to 2 for SAP if it only did log or 0 if it did config also
									IF (@status IN(1, 3, 14))
									BEGIN
										IF @appType <> 61
										BEGIN
                                            TRUNCATE TABLE #tempOpenChainJobs
                                            INSERT INTO #tempOpenChainJobs
                                            SELECT jobId
                                            FROM JMBkpStats
											where
												servEndDate <= @servStartDate
												AND dataBackedUp <> 0
												AND commCellId = @inCommcellId
												AND jobId <> @inJobId
												AND appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @iid)
												-- #define JMBKP_OPEN_DATA_CHAIN				0x4000000000LL
												-- AND (bkpattributes & cast(0x4000000000 as bigint)) = (cast(0x4000000000 as bigint))
												AND openChain <> 0
											update JMBkpStats set
											openChain = 0
                                            WHERE jobId IN (SELECT jobId FROM #tempOpenChainJobs)
											AND commCellId = @inCommcellId
											-- record how many chains we closed for debug, note this one job could close multiple old jobs
											SET @closedChain = @closedChain + @@ROWCOUNT
										END
										ELSE
										BEGIN
											-- if this SAP job did LOG AND CONFIG, it closes earlier ones, otherwise it just sets it needing CONFIG still
											if (@bkpattributes & 0x6000) = 0x6000
											BEGIN
                                                TRUNCATE TABLE #tempOpenChainJobs
                                                INSERT INTO #tempOpenChainJobs
                                                SELECT jobId
                                                FROM JMBkpStats
												where
													servEndDate <= @servStartDate
													AND dataBackedUp <> 0
													AND commCellId = @inCommcellId
													AND jobId <> @inJobId
													AND appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @iid)
													-- #define JMBKP_OPEN_DATA_CHAIN				0x4000000000LL
													-- AND (bkpattributes & cast(0x4000000000 as bigint)) = (cast(0x4000000000 as bigint))
													AND openChain = 1
											    update JMBkpStats set
											    openChain = 0
                                                WHERE jobId IN (SELECT jobId FROM #tempOpenChainJobs)
												AND commCellId = @inCommcellId
												-- don't have to qualify SAP here as only data jobs will have openChain = 1
												-- record how many chains we closed for debug, note this one job could close multiple old jobs
												SET @closedChain = @closedChain + @@ROWCOUNT
											END
											ELSE
											BEGIN
                                                TRUNCATE TABLE #tempOpenChainJobs
                                                INSERT INTO #tempOpenChainJobs
                                                SELECT jobId
                                                FROM JMBkpStats
												where
													servEndDate <= @servStartDate
													AND dataBackedUp <> 0
													AND commCellId = @inCommcellId
													AND jobId <> @inJobId
													AND appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @iid)
													-- #define JMBKP_OPEN_DATA_CHAIN				0x4000000000LL
													-- AND (bkpattributes & cast(0x4000000000 as bigint)) = (cast(0x4000000000 as bigint))
													AND openChain = 1
											    update JMBkpStats set
											    openChain = 2
                                                WHERE jobId IN (SELECT jobId FROM #tempOpenChainJobs)
												AND commCellId = @inCommcellId
												-- don't have to qualify SAP here as only data jobs will have openChain = 1
												-- record how many chains we updted for debug, note this one job could close multiple old jobs
												SET @updatedChain = @updatedChain + @@ROWCOUNT
											END
										END
									END
									-- now if it's SAP and this is a CONFIG LOG job, then look for
									-- earlier job to complete the chain, they will have openChain = 2
									IF @appType = 61 AND ((@bkpattributes & 0x4000) = 0x4000) AND (@status IN(1, 3, 14))
									BEGIN
										insert into #tempLinkTable
											select JBS.jobId, JBS.appId, @inJobId, @appId, @status
												from JMBkpStats JBS where
												-- target job end time is before this one's start
												JBS.servEndDate <= @servStartDate
												AND JBS.dataBackedUp <> 0
												AND JBS.commCellId = @inCommcellId
												AND JBS.jobId <> @inJobId
												AND JBS.appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @iid)
												-- #define JMBKP_OPEN_DATA_CHAIN				0x4000000000LL
												-- AND (bkpattributes & cast(0x4000000000 as bigint)) = (cast(0x4000000000 as bigint))
												AND JBS.openChain = 2
												AND JBS.optype <> 60 -- Exclude Backup copy jobs
                                            TRUNCATE TABLE #tempOpenChainJobs
                                            INSERT INTO #tempOpenChainJobs
                                            SELECT jobId
                                            FROM JMBkpStats
											where
												servEndDate <= @servStartDate
												AND dataBackedUp <> 0
												AND commCellId = @inCommcellId
												AND jobId <> @inJobId
												AND appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @iid)
												-- #define JMBKP_OPEN_DATA_CHAIN				0x4000000000LL
												-- AND (bkpattributes & cast(0x4000000000 as bigint)) = (cast(0x4000000000 as bigint))
												AND openChain = 2
											update JMBkpStats set
											--bkpattributes = bkpattributes & ~cast(0x4000000000 as bigint),
											openChain = 0
                                            WHERE jobId IN (SELECT jobId FROM #tempOpenChainJobs)
											AND commCellId = @inCommcellId
											-- record how many chains we closed for debug, note this one job could close multiple old jobs
											SET @closedChain = @closedChain + @@ROWCOUNT
									END
								END
								ELSE
								BEGIN
									insert into #tempLinkTable
										select JBS.jobId, JBS.appId, @inJobId, @appId, @status
											from #tempCandidateDataJobs JBS where
											-- target job end time is before this one's start
											JBS.servEndDate <= @servStartDate
											-- we know this is true for all these
											--AND JBS.dataBackedUp <> 0
											AND JBS.commCellId = @inCommcellId
											AND JBS.jobId <> @inJobId
											-- and can use instance directly
											AND JBS.instanceId = @iid
											--AND JBS.appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @iid)
											-- #define JMBKP_OPEN_DATA_CHAIN				0x4000000000LL
											-- AND (bkpattributes & cast(0x4000000000 as bigint)) = (cast(0x4000000000 as bigint))
											AND JBS.openChain <> 0
											AND JBS.optype <> 60 -- Exclude Backup copy jobs
									-- and reset the chain flag on such jobs IF the current job was success
									IF (@status IN(1, 3, 14))
									BEGIN
										update #tempCandidateDataJobs set
										--bkpattributes = bkpattributes & ~cast(0x4000000000 as bigint),
										openChain = 0, changedOpenChain = 1
										where
											servEndDate <= @servStartDate
											--true for all these
											--AND dataBackedUp <> 0
											AND commCellId = @inCommcellId
											AND jobId <> @inJobId
											-- and can use instance directly
											AND instanceId = @iid
											--AND appId in (select DISTINCT ttappId from #tempAppId where ttinstanceId = @iid)
											-- #define JMBKP_OPEN_DATA_CHAIN				0x4000000000LL
											-- AND (bkpattributes & cast(0x4000000000 as bigint)) = (cast(0x4000000000 as bigint))
											AND openChain <> 0
										--record how many chains we closed for debug, note this one job could close multiple old jobs
										SET @closedChain = @closedChain + @@ROWCOUNT
										-- use this table to update jmbkpstats with ones with newOpenChainSet
										update JMBkpStats set
											openChain = 0
											from JMBkpStats JBS, #tempCandidateDataJobs TT
											where TT.changedOpenChain = 1
											AND TT.jobId = JBS.jobId
											AND TT.commCellId = JBS.commCellId
									END
								END
							END
						END
						FETCH NEXT FROM CursorForInstance INTO @iid, @data, @logs
					END
					CLOSE CursorForInstance
					DEALLOCATE CursorForInstance
					-- now we have lots of stuff potentially in our temp table that we want to move to JMJobTaskLink
					-- first delete out any links that already exist for one reason or other to avoid insert error
					delete from #tempLinkTable from #tempLinkTable, JMJobDataLink
						where #tempLinkTable.ttparentjobId = JMJobDataLink.parentJobId
						AND #tempLinkTable.ttchildJobId = JMJobDataLink.childJobId
						AND JMJobDataLink.commCellId = @inCommcellId
				END
				-- For DB2 fetch the job option.
				IF @appType = 37 OR @appType = 62 OR @appType = 103
AND EXISTS(SELECT 1 FROM JMMisc Where JobId = @inJobId and commCellId = @inCommcellId and itemType = 30)
				BEGIN
					DECLARE	@jobXml	XML
SET @jobXml = ISNULL((SELECT data FROM JMMisc Where JobId = @inJobId and commCellId = @inCommcellId and itemType = 30), '<JobManager_JobLinking/>')
					-- Merge the entries.
					Merge #tempLinkTable jm
					USING
					(
						SELECT
						ISNULL(Tbl.Col.value('@jobID','INT'),0) parentJobId,
						ISNULL(Tbl.Col.value('@subClientID','INT'),0) parentAppId,
						ISNULL(Tbl1.Col1.value('@jobID','INT'),0) childJobId,
						ISNULL(Tbl1.Col1.value('@subClientID','INT'),0) childAppId,
						ISNULL((select status From jmbkpstats where jobid = ISNULL(Tbl1.Col1.value('@jobID','INT'),0) and commCellId = @inCommcellId), 0) status
						FROM @jobXml.nodes('JobManager_JobLinking/link/parentJobId') as Tbl(Col)
						CROSS APPLY Tbl.Col.nodes('../childJobId') as Tbl1(Col1)
					) cli
					ON jm.ttparentjobId = cli.parentJobId And jm.ttchildjobId = cli.childJobId
					WHEN NOT MATCHED THEN
					INSERT VALUES
					(cli.parentJobId, cli.parentAppId, cli.childJobId, cli.childAppId, cli.status);
				END
				insert JMJobDataLink
					-- LINK_TYPE_DATA_LOG_UNIT			=	5
					select DISTINCT @inCommcellId, ttparentjobId, ttchildjobId, ttparentappId, ttchildappId, 5, ttchildstatus
					from #tempLinkTable
				-- record how many new links we created for debug
				SET @dataLinkCount = @@ROWCOUNT
				IF @dataLinkCount = 0
				BEGIN
					-- if no new links, report that (this is still a good condition if starting a new chain)
					SET @errorReturn = 4
				END
				-- finally drop our temp tables
				DROP TABLE #tempLinkTable
				DROP TABLE #tempAppId
				DROP TABLE #tempCandidateDataJobs
				DROP TABLE #tempCandidateLogJobs
			END
			ELSE
			BEGIN
				-- no data or logs, nothing to do
				SET @errorReturn = 3
			END
		END
ELSE IF @appType = 53 AND @opType = 4 AND (@bkpattributesEx & 0x400000 = 0x400000) AND (@status = 1 OR @status = 3 OR @status = 14)
		BEGIN
			-- For Exchange DB
			-- Full backup with parital success status populate the failed db info.
			-- i. Mark the open chain as 1.
			-- Incremental backup with partial success status
			-- i) Reset the failedDb if it is backed successfully.
			-- ii) Link this with the first full job.
			-- iii) If all the failed dbs are backed up, reset the openChain to 0.
			IF ( @bkpLevel = 1/*FULL*/ AND @status = 3/*PARTIALSUCCESS*/) OR
			   ( @bkpLevel IN(2/*INCR*/, 4/*DIFFERENTIAL*/) AND
			      EXISTS(SELECT 1 FROM App_SubClientProp(NOLOCK) WHERE componentNameId = @appId and modified = 0 and attrName = 'is any failed full DB' and attrVal = '1') )
			BEGIN
				DECLARE @scFailedDBs        XML
				DECLARE @jobDBStatus        XML
				DECLARE @fullJobID          INT = 0
				DECLARE @isAnyFailedDBSuccessful BIT = 0
				DECLARE @isAnyFailedDBExists BIT = 0
SET @jobDBStatus =  ISNULL((SELECT data From JMMisc(NOLOCK) Where jobid = @inJobId and commcellId = @inCommcellId and itemType = 28), '<JobManager_ExchDbJobInfo/>')
				IF @bkpLevel = 1/*FULL*/
					SET @scFailedDBs =  '<JobManager_ExchDbJobInfo/>'
				ELSE
					SET @scFailedDBs =  ISNULL((SELECT attrVal From App_SubclientProp(NOLOCK) Where componentNameId = @appId and attrName = 'Failed full DBs' and modified = 0), '<JobManager_ExchDbJobInfo/>')
				-- None of these temp tables should ever exist when this procedure is called!
				IF object_id('tempdb.dbo.#scFailedDBsTbl') IS NOT NULL
				   DROP TABLE #scFailedDBsTbl
				IF object_id('tempdb.dbo.#jobDBStatusTbl') IS NOT NULL
				   DROP TABLE #jobDBStatusTbl
				CREATE TABLE #scFailedDBsTbl
				(
					DatabaseName        varchar(2048),
					status              int
				)
				CREATE TABLE #jobDBStatusTbl
				(
					DatabaseName        varchar(2048),
					status              int
				)
				INSERT INTO #jobDBStatusTbl
				SELECT
				ISNULL(Tbl.Col.value('@dbName', 'varchar(2048)'), ''),
				ISNULL(Tbl.Col.value('@status', 'int'), '')
				FROM @jobDBStatus.nodes('/JobManager_ExchDbJobInfo/SourceDatabaseStats') as Tbl(Col)
				INSERT INTO #scFailedDBsTbl
				SELECT
				ISNULL(Tbl.Col.value('@dbName', 'varchar(2048)'), ''),
				ISNULL(Tbl.Col.value('@status', 'int'), '')
				FROM @scFailedDBs.nodes('/JobManager_ExchDbJobInfo/SourceDatabaseStats') as Tbl(Col)
				IF @bkpLevel = 1/*FULL*/
				BEGIN
					INSERT INTO #scFailedDBsTbl
					SELECT * FROM #jobDBStatusTbl WHERE status = 3/*Failed*/
					SET @fullJobID = @inJobId
				END
				ELSE
				BEGIN
					SET @fullJobID = ISNULL((Select Tbl.Col.value('@jobId', 'bigint') From @scFailedDBs.nodes('JobManager_ExchDbJobInfo') Tbl(Col)), 0)
					IF EXISTS(SELECT 1 FROM #scFailedDBsTbl WHERE DatabaseName IN (SELECT DatabaseName FROM #jobDBStatusTbl WHERE status = 5/*Successful*/))
						SET @isAnyFailedDBSuccessful = 1
					DELETE FROM #scFailedDBsTbl
					WHERE DatabaseName In(SELECT DatabaseName FROM #jobDBStatusTbl WHERE status = 5/*Successful*/)
				END
				SET @scFailedDBs = (
								SELECT
								@fullJobID '@jobId',
								@inCommcellId '@commcellId',
								(
									SELECT
									DatabaseName    '@dbName',
									status          '@status'
									FROM #scFailedDBsTbl
									FOR XML PATH('SourceDatabaseStats'), TYPE
								)
								For XML PATH('JobManager_ExchDbJobInfo')
							  )
				IF EXISTS(SELECT 1 FROM #scFailedDBsTbl WHERE status = 3/*Failed*/)
					SET @isAnyFailedDBExists = 1
				DELETE FROM App_SubclientProp WHERE componentNameId = @appId AND attrName = 'Failed full DBs' AND modified = 0
				DELETE FROM App_SubclientProp WHERE componentNameId = @appId AND attrName = 'is any failed full DB' AND modified = 0
				-- Insert the subclient property for failed dbs.
				INSERT INTO App_subclientprop (componentnameid, attrname, attrtype, attrval, created, modified) VALUES (@appId, 'Failed full DBs', 2, cast(@scFailedDBs as nvarchar(max)), dbo.getunixtime(getutcdate()), 0)
				INSERT INTO App_subclientprop (componentnameid, attrname, attrtype, attrval, created, modified) VALUES (@appId, 'is any failed full DB', 8, @isAnyFailedDBExists, dbo.getunixtime(getutcdate()), 0)
				-- Link the incremental to Full
				IF @bkpLevel IN(2/*INCR*/, 4/*DIFFERENTIAL*/) AND @isAnyFailedDBSuccessful = 1 AND NOT EXISTS(SELECT 1 FROM JMJobDataLink(NOLOCK) WHERE parentJobId = @fullJobID AND childJobId = @inJobId) AND @fullJobID > 0
				BEGIN
					INSERT INTO JMJobDataLink
					SELECT @inCommcellId, @fullJobID, @inJobId, @appId, @appId, 5/*LINK_TYPE_DATA_LOG_UNIT*/, @status
					SET @dataLinkCount = @@ROWCOUNT
					-- When incremental/differential backups up all the dbs, the openChain should be closed.
					IF @isAnyFailedDBExists = 0
						UPDATE JMBkpStats SET openChain = 0 WHERE jobId = @fullJobID AND commCellId = @inCommcellId
				END
				--For Full backups with Partial successful job, mark the openChain as 1.
				ELSE IF @bkpLevel = 1/*FULL*/
					UPDATE JMBkpStats SET openChain = 1 WHERE jobId = @fullJobID AND commCellId = @inCommcellId
				DROP TABLE #scFailedDBsTbl
				DROP TABLE #jobDBStatusTbl
			END
			-- Resetting the failedDB info.
			ELSE IF @appType = 53/*TITANIUM_DB*/ AND @opType = 4/*Backup*/ AND @bkpLevel = 1/*FULL*/
			BEGIN
				IF EXISTS(SELECT 1 FROM App_SubclientProp WHERE componentNameId = @appId AND attrName = 'Failed full DBs' AND modified = 0)
					DELETE FROM App_SubclientProp WHERE componentNameId = @appId AND attrName = 'Failed full DBs' AND modified = 0
				IF EXISTS(SELECT 1 FROM App_SubclientProp WHERE componentNameId = @appId AND attrName = 'is any failed full DB' AND modified = 0)
					DELETE FROM App_SubclientProp WHERE componentNameId = @appId AND attrName = 'is any failed full DB' AND modified = 0
			END
		END
		ELSE IF @appType IN (SELECT DISTINCT appTypeId
							 FROM GetAppTypesForAppGroup(22,0) --APPGRP_W2KFileSystem
							 UNION
							 SELECT DISTINCT appTypeId
							 FROM GetAppTypesForAppGroup(34,0) --APPGRP_UnixFileSystem
							 )
				AND @status IN (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
				AND @opType = 4 -- BACKUP
				AND @bkpLevel <> 1
        BEGIN
            SELECT @isTrueUpJob = intData FROM JMMisc(NOLOCK)
            WHERE jobid = @inJobId AND commCellId = @inCommcellId
AND itemType = 44
            IF @isTrueUpJob <> 0
            BEGIN
                -- If cycle started with synthetic full and this is first true-up job, then link it
				SELECT @synthFullJobIdInCurrentCycle = BS.jobId
				FROM JMBkpStats BS(NOLOCK)
				WHERE appId = @appId
				AND fullCycleNum = @fullCycleNumber
				AND opType = 14 --SYNTHFULL
				AND status IN (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
				IF @synthFullJobIdInCurrentCycle <> 0
				   AND NOT EXISTS (SELECT 1 FROM JMJobDataLink DL (NOLOCK)
								   WHERE parentJobId = @synthFullJobIdInCurrentCycle AND parentAppid = @appId
								   AND childAppid = @appId
								   AND linkType = 6 -- LINK_TYPE_FOR_SELCOPY_OR_EXT_RETENTION
								   )
				BEGIN
					-- This means it is first true up job let us link it
					INSERT INTO JMJobDataLink(commCellId, parentJobId, childJobId, parentAppid, childAppid, linkType , childJobStatus)
					SELECT @inCommcellId, @synthFullJobIdInCurrentCycle, @inJobId, @appId, @appId, 6/*LINK_TYPE_FOR_SELCOPY_OR_EXT_RETENTION*/, @status
					SET @dataLinkCount = @@ROWCOUNT
				END
            END
        END
		ELSE
		BEGIN
			--not an apptype we are dealing with
			SET @errorReturn = 2
		END
	END
	ELSE
	BEGIN
		--could not get details of passed in job
		SET @errorReturn = 1
	END
	select @errorReturn, @openedChain, @closedChain, @updatedChain, @dataLinkCount, @dataBackedUp, @logsBackedUp, @loopCount, @bkpLevel
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'JMDataLinkRelatedJobs')
	delete from GxQscripts where name = 'JMDataLinkRelatedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMDataLinkRelatedJobs')
	delete from GXDBVersions where aliasname = 'JMDataLinkRelatedJobs'
GO

insert into GXDBVersions values(2, 'JMDataLinkRelatedJobs',  'v1.33.2.29.12.1', 'JMDataLinkRelatedJobs', 'v1.33.2.29.12.1')
GO

