

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMCreatePrepartionJobForBCDIndex.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMCreatePrepartionJobForBCDIndex.sp,v $ $Id: JMCreatePrepartionJobForBCDIndex.sp,v 1.28.60.5 2019/03/22 10:06:04 chandru Exp $";
--
--  +========================================================================+
--  |   Procedure:  JMCreatePrepartionJobForBCDIndex
--  |
--  |       Scope:  -PUBLIC-
--  |
--  | Description:
--  |
--  |       Input:  xxxx
--  |      Output:  xxxx
--  |      Return:  xxxx
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='JMCreatePrepartionJobForBCDIndex')
BEGIN
	print '>>> Drop Stored Procedure: JMCreatePrepartionJobForBCDIndex <<<'
	drop procedure JMCreatePrepartionJobForBCDIndex
END
IF EXISTS (select * from GxQscripts where name='JMCreatePrepartionJobForBCDIndex')
	delete from GxQscripts where name = 'JMCreatePrepartionJobForBCDIndex'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCreatePrepartionJobForBCDIndex')
	delete from GXDBVersions where aliasname = 'JMCreatePrepartionJobForBCDIndex'
GO
print '... Creating Procedure: JMCreatePrepartionJobForBCDIndex'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure JMCreatePrepartionJobForBCDIndex
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inXMl XML
AS
  DECLARE @dummyXml XML
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN TRY
BEGIN TRAN
DECLARE @inMiningJobId int
DECLARE @inMiningAppId int
DECLARE @inMiningCCId int
DECLARE @t_JobId		TABLE( jobId int )	--Temp table
DECLARE @t_minableJobId TABLE(jobId int, ccId int, status int)
DECLARE @t_minableCommcellInfo TABLE(ccId int, ccType int)
DECLARE	@preparationJobId int
DECLARE	@preparationCCId int
DECLARE	@minableJobId int
DECLARE	@minableCCId int
DECLARE @minableCommCellType int
DECLARE @minableClientId int
DECLARE @minableAppId int
DECLARE @minableAppType int
DECLARE @minableArchGrpId int
DECLARE @minableArchGrpCopyId int
DECLARE @errCode int
DECLARE @errorString varchar(2000)
DECLARE @isAlreadyPrepared int
DECLARE @runningJobOpType int
DECLARE @preparedJobStatus int
DECLARE @spName nvarchar(512)
SET @errCode = 0
--	PREPARATION_STATUSUNKNOWN = 0,
--	PREPARATION_STARTED,
--	PREPARATION_FAILED,
--	PREPARATION_COMPLETED
SET @isAlreadyPrepared = 0
-- Get the running job details
SET @inMiningJobId = ISNULL (( SELECT ref.value('@miningJobId', 'INTEGER')FROM @inXMl.nodes('JobManager_PreparedJobsReq') R(ref)), 0)
SET @inMiningAppId = ISNULL (( SELECT ref.value('@miningSubclientId', 'INTEGER')FROM @inXMl.nodes('JobManager_PreparedJobsReq') R(ref)), 0)
SET @inMiningCCId = ISNULL (( SELECT ref.value('@miningCommCellId', 'INTEGER')FROM @inXMl.nodes('JobManager_PreparedJobsReq') R(ref)), 0)
SET @runningJobOpType = ISNULL (( SELECT ref.value('@miningOpType', 'INTEGER')FROM @inXMl.nodes('JobManager_PreparedJobsReq') R(ref)), 0)
-- Prepared job commcellId will be the running job commcellId
SET @preparationCCId = @inMiningCCId
SET @preparationJobId = 0
-- Get the running job opType
--SELECT @runningJobOpType = opType FROM JMJOBINFO WHERE jobId = @inMiningJobId
IF NOT EXISTS (SELECT * FROM JMJobMiningStats WITH (NOLOCK) WHERE miningJobId = @inMiningJobId AND miningCommCellId = @inMiningCCId)
BEGIN
	IF @runningJobOpType = 4 -- BACKUP
	BEGIN
		-- This is a mining backup job
		INSERT INTO @t_minableJobId EXEC archGetMinableJobs @inMiningAppId, @inMiningJobId, @inMiningCCId
		SELECT @errCode = @@error
		IF @errCode <> 0
		BEGIN
		   SET @errorString = 'archGetMinableJobs stored proc returned' + 'ErrorCode is ' + ltrim(str(@errCode)) + '.'
		   GOTO JM_ERROR_EXIT
		END
		IF EXISTS (SELECT * FROM @t_minableJobId WHERE JobID = -1)
		BEGIN
			SET @errCode = 1
			SET @errorString = 'Unable to get lock on archGetMinableJobs procedure'
		END
		IF NOT EXISTS (SELECT * FROM JMJobMiningStats WITH (NOLOCK) WHERE miningJobId = @inMiningJobId AND miningCommCellId = @inMiningCCId)
		BEGIN
			SET @errCode = 1
			SET @errorString = 'There are no mining jobs to be mined'
		END
	END
END
-- Get the minable subclient details
IF @runningJobOpType = 4 -- BACKUP
BEGIN
	SELECT @minableJobId = jobId, @minableCCId = commCellId, @minableAppId = appId FROM JMJobMiningStats WITH (NOLOCK)
		WHERE miningJobId = @inMiningJobId AND miningCommCellId = @inMiningCCId
END
ELSE IF @runningJobOpType = 60 -- SNAPTOTAPE
BEGIN
	-- Get minable jobInfo from JMJobWF table
	SELECT @minableJobId = processedJobId, @minableCCId = processedCommcellId, @minableAppId = applicationId FROM JMJobWF  WHERE childJobId = @inMiningJobId AND commcellId = @inMiningCCId
END
ELSE
BEGIN
   SET @errCode = 1
   SET @errorString = 'OpertionType:' + @runningJobOpType + ' Is not supported for this job.'
   GOTO JM_ERROR_EXIT
END
-- Get the other minable subclient details
SELECT @minableAppType = appType, @minableArchGrpId = dataArchGrpId FROM JMBkpStats
	WHERE jobId = @minableJobId AND commCellId = @minableCCId
SELECT @minableCommCellType = type FROM APP_CommCell WHERE id = @minableCCId
--  2   -- CV_STATUS_UNINSTALLED
--  4   -- CV_STATUS_DELETED
-- 16   -- CV_STATUS_DUMMY
-- 32   -- CV_STATUS_HIDDEN
IF @minableCommCellType < 100 AND @runningJobOpType = 60 -- SNAPTOTAPE	and local jobs mining
BEGIN
	-- Dont reset minableArchGrpId from AppID for SnapToTape as the old policy of the snap job should be used here.
	SELECT @minableClientId = clientId FROM App_Application WHERE id = @minableAppId AND ((subclientStatus & (2 | 4 | 16 | 32)) = 0)
END
ELSE
BEGIN
	SELECT @minableClientId = clientId, @minableArchGrpId = dataArchGrpID FROM App_Application WHERE id = @minableAppId AND ((subclientStatus & (2 | 4 | 16 | 32)) = 0)
END
IF @minableArchGrpId = 1 -- Means storage policy on the minable subclient is not configured
BEGIN
   SET @errCode = 1
   SET @errorString = 'Storage Policy on the minable subclient is not configured.'
   GOTO JM_ERROR_EXIT
END
SELECT @spName = name, @minableArchGrpCopyId = defaultSnapCopy FROM archGroup WHERE id = @minableArchGrpId
IF @minableArchGrpCopyId = 0 -- Means snap copy is not configured for this storage policy
BEGIN
   SET @errCode = 1
   SET @errorString = 'SnapCopy is not configured for ' + @spName + ' storage policy.'
   GOTO JM_ERROR_EXIT
END
--Only foreign commcell needs preparation
IF @minableCommCellType > = 100
BEGIN
	-- The minable commcellType is a foreign commcell
	IF NOT EXISTS (SELECT * FROM JMPreparedJob WHERE jobId = @minableJobId AND commCellId = @minableCCId)
	BEGIN
		-- Got the prepartion JobId
		INSERT INTO @t_JobId EXEC @preparationJobId = TM_GetNextJobId
		SELECT @errCode = @@error
		IF @errCode <> 0
		BEGIN
		   SET @errorString = 'Failed to jobId from TM_GetNextJobId' + 'ErrorCode is ' + ltrim(str(@errCode)) + '.'
		   GOTO JM_ERROR_EXIT
		END
		-- Insert into jmjobstats
		INSERT	INTO JMJobStats
		SELECT	DISTINCT @preparationJobId,
		b.status,
		b.opType,
		@preparationCCId,
		b.jobCategory,
		b.jobDescription,
		b.xmlJobInfo,
		b.subOpType,
		b.foreignToken
		FROM JMJobStats b
		WHERE b.jobId = @minableJobId AND b.commCellId = @minableCCId
		-- Insert entry in jmbkpstats table
		INSERT	INTO JMBkpStats
		SELECT	DISTINCT @preparationJobId, @preparationCCId, b.appId, b.appType,
			b.numAttempts, @minableArchGrpId, b.copyId, b.bkpLevel, b.indexOverride,
			b.status, b.duration, b.numStreams, b.servStartDate, b.servEndDate,
			b.opType, b.fullCycleNum, b.initFrom, b.failureReason, b.bkpOptions,
			b.scanFileFailures, b.scanFolderFailures, b.backupFileFailures,
			b.backupFolderFailures, b.oraSubLevel, b.username, b.totalWriteTime,
			b.priority, b.totalCompBytes, b.totalUncompBytes, b.totalNumOfFiles,
			b.bkpattributes, @minableArchGrpId, b.totalNumOfFolders,
			b.failureErrorCode, b.lastIncrJobTime, b.scanType,
			b.scanTypeChangeReason, b.numStreamsRequested,
			b.dataStatus, b.agedTime, b.mediaDeletedTime, dbo.GetUnixTime(CURRENT_TIMESTAMP),
			b.version, b.idaVersion, b.cIndexTime, b.cycleSequence, b.filesToXfer, 0, b.diffArchGrpId,
			b.totalBackupSize, b.percentageChange, b.targetClientId,
			b.totalUncompBytesToXfer, b.displayStatus, b.dataBackedUp, b.logsBackedUp, b.openChain,
			b.secondaryBkpLevel, b.jobIdPrepared, b.jobIdActedOn, b.fromTime, b.toTime, 0,  -- The schedule (subTaskId) isn't migrated
			b.nwTransBytes, b.totSkippedObjects, b.bkpAttributesEx, b.jobReferenceTime
			FROM JMBkpStats b, APP_Application a
			WHERE b.jobId = @minableJobId AND b.commCellId = @minableCCId AND b.appId = a.id
		-- Insert entry in JmJobDatatStats table
		INSERT	INTO JMJobDataStats
		SELECT  DISTINCT
			@preparationJobId, @minableArchGrpId, @minableArchGrpCopyId, b.dataType ,
			b.opType, b.auxCopyJobId, b.status, b.disabled, b.appId, @preparationCCId,
			b.archCheckEndTime, b.archCheckStatus, b.retentionFlags, b.manualRetentionEndTime, b.copiedTime, b.agedTime,
			b.mediaDeletedTime, b.modifiedTime, b.sizeOnMedia, b.agedBy, b.flags, b.modifiedTime, b.auxCopyStatus, b.unCompSize
			FROM JMJobDataStats b
			WHERE b.jobId = @minableJobId and b.commCellId = @minableCCId
		-- Execute the archive Manager Stored proceduer
		EXEC archFileForPreparedJobCreate @minableJobId, @minableCCId, @preparationJobId, @preparationCCId, @minableArchGrpId, @minableArchGrpCopyId
		SELECT @errCode = @@error
		IF @errCode <> 0
		BEGIN
		   SET @errorString = 'archFileForPreparedJobCreate Failed to populate entries into archivemanager tables' + 'ErrorCode is ' + ltrim(str(@errCode)) + '.'
		   GOTO JM_ERROR_EXIT
		END
		-- Insert the newly prepared job
		INSERT INTO JMPreparedJob VALUES(@minableJobId, @minableCCId, @preparationJobId, @preparationCCId, @minableAppId, 1, @inMiningJobId)
	END
	ELSE
	BEGIN
		-- The prepartion job is already created but may not be prepared(The previous job is failed)
		IF EXISTS (SELECT * FROM JMPreparedJob WHERE jobId = @minableJobId AND commCellId = @minableCCId AND status = 2)
		BEGIN
			UPDATE JMPreparedJob SET status = 1, miningJobId = @inMiningJobId WHERE jobId = @minableJobId AND commCellId = @minableCCId
		END
	-- END of IF-ELSE JMPreparedJob check
	END
	-- IF there are minable jobs to be prepared
	IF EXISTS (SELECT * FROM JMPreparedJob WHERE jobId = @minableJobId AND commCellId = @minableCCId AND status = 3)
	BEGIN
		SET @isAlreadyPrepared  = 1
	END
	SELECT @preparationJobId=preparedJobId, @preparationCCId=preparedJobCCId FROM JMPreparedJob WHERE
	jobId = @minableJobId AND commCellId = @minableCCId
	if not exists(select *From JMJobOptions where jobId = @preparationJobId and commCellId = @preparationCCId and attributeId = 20)
		if exists (select *From APP_SubClientProp where componentNameId = @minableAppId and attrName = 'Use RMAN for Tape Movement' and modified = 0) or
		   exists (select *from APP_InstanceProp where componentNameId = (select distinct instance from app_application where id = @minableAppId) and attrName = 'Use RMAN for Tape Movement' and modified = 0)
		insert into jmjoboptions values(@preparationJobId, @preparationCCId, 20, 'Use RMAN for Tape Movemen', '1','1')
-- END of IF CommcellType check
END
ELSE
BEGIN
	IF EXISTS (SELECT * FROM JMPreparedJob WHERE preparedJobId = @minableJobId AND preparedJobCCId = @minableCCId)
	BEGIN
		-- This is a prepared phase. Check the status and rerun the preparation phases if needed
		SELECT @preparedJobStatus=status FROM JMPreparedJob WHERE preparedJobId = @minableJobId AND preparedJobCCId = @minableCCId
		IF @preparedJobStatus = 2
		BEGIN
			-- Previous prepared job is not successful. So set the status as 0 and rerun it
			UPDATE JMPreparedJob SET status = 1, miningJobId = @inMiningJobId WHERE preparedJobId = @minableJobId AND preparedJobCCId = @minableCCId
		END
		ELSE IF @preparedJobStatus = 3
		BEGIN
			-- Previous prepared job is successful
			SET @isAlreadyPrepared  = 1
		END
		SELECT @preparationJobId=preparedJobId, @preparationCCId=preparedJobCCId FROM JMPreparedJob
		WHERE preparedJobId = @minableJobId AND preparedJobCCId = @minableCCId
	END
	ELSE
	BEGIN
		-- No need of preparation
		SET @isAlreadyPrepared  = 1
	END
END
-- Insert entry into jmjobsnapshotstats table for the prepared job
IF @preparationJobId > 0
BEGIN
	IF NOT EXISTS (SELECT * FROM JMJobSnapshotStats WHERE jobId = @preparationJobId and commcellId = @preparationCCId)
	BEGIN
		INSERT INTO JMJobSnapshotStats
		SELECT	@preparationJobId, @preparationCCId, materializationStatus, disabled, materializationJobId, appId, archGrpId, 0, 0 FROM JMJobSnapshotStats --@TODO need to integrate with mining job operations once JM changes for 'latest cycle only backup copy' is completed
		Where jobId = @minableJobId and commcellId = @minableCCId
	END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @errCode = @@error
	IF @errorString IS NULL
	BEGIN
		if @errCode = 0
			set @errCode = 1
		SET @errorString = 'DataBase exception occurred' + 'ErrorCode is ' + ltrim(str(@errCode)) + '.'
	END
END CATCH;
JM_ERROR_EXIT:
IF @errCode > 0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
set @inXMl = (select @errCode "errorCode",
					 @errorString "errorMsg",
					 @isAlreadyPrepared "alreadyPrepared",
					 @minableCCId "minableCommCellId",
					 @minableCommCellType "minableCommCellType",
					 @minableClientId "minableClientId",
					 @minableAppId "minableAppId",
					 @minableAppType "minableAppType",
					 @minableArchGrpId "minableArchGrpId",
					 @preparationJobId "preparedJobId",
					 @preparationCCId "preparedCommCellId"
			 FOR XML PATH('JobManager_PreparedJobResp'))
select @inXMl
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'JMCreatePrepartionJobForBCDIndex')
	delete from GxQscripts where name = 'JMCreatePrepartionJobForBCDIndex'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCreatePrepartionJobForBCDIndex')
	delete from GXDBVersions where aliasname = 'JMCreatePrepartionJobForBCDIndex'
GO

insert into GXDBVersions values(2, 'JMCreatePrepartionJobForBCDIndex',  '00010028006000050000', 'JMCreatePrepartionJobForBCDIndex', '00010028006000050000')
GO

