

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/JMCreateInfoMgmtStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: JayaRam
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/JMCreateInfoMgmtStats.sp,v $ $Id: JMCreateInfoMgmtStats.sp,v 1.3.60.2 2018/03/22 03:01:45 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: JMCreateInfoMgmtStats <<<'

IF EXISTS (select * from sysobjects where name='JMCreateInfoMgmtStats')
	drop procedure JMCreateInfoMgmtStats
IF EXISTS (select * from GxQscripts where name='JMCreateInfoMgmtStats')
	delete from GxQscripts where name = 'JMCreateInfoMgmtStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCreateInfoMgmtStats')
	delete from GXDBVersions where aliasname = 'JMCreateInfoMgmtStats'
GO
print '... Creating Procedure: JMCreateInfoMgmtStats'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure JMCreateInfoMgmtStats
  @inStatus INTEGER,
  @inJobId INTEGER,
  @inComplianceId INTEGER
AS
  DECLARE @retCode INTEGER
  DECLARE @bkpJobsList XML
DECLARE    @bkpJobs			XML
DECLARE    @commcellId		INTEGER
SET NOCOUNT ON
BEGIN TRY
BEGIN TRAN
	SET @retCode = 0
	-- @inStatus =4 => Killed, 2=> Fail
	if @inStatus = 4 or @inStatus = 2
		UPDATE JMCompliancePolicyQualifiedJobs set status = 1 where complianceId = @inComplianceId and status = 4
	else
	BEGIN
		SET @bkpJobs = (select jobid '@val' from JMCompliancePolicyQualifiedJobs WHERE complianceId = @inComplianceId and status = 4
						for xml path('bkpjobIds'), root('JobManager_InfoMgmtJobStats'))
		SET @bkpJobsList = @bkpJobs
		SET @commcellId = (select top 1 commcellId from JMCompliancePolicyQualifiedJobs WHERE complianceId = @inComplianceId and status = 4)
		IF @bkpJobs is NOT null
			BEGIN
				INSERT INTO JMAdminInfoMgmtStats
				SELECT @inJobId, @commCellId, @inComplianceId, 4, @bkpJobs
				DELETE From JMCompliancePolicyQualifiedJobs where complianceId = @inComplianceId and status = 4
			END
	END
	COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	set @retCode = 1
	ROLLBACK TRAN
END CATCH
	select @retCode, @bkpJobsList
GO


IF EXISTS (select * from GxQscripts where name = 'JMCreateInfoMgmtStats')
	delete from GxQscripts where name = 'JMCreateInfoMgmtStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='JMCreateInfoMgmtStats')
	delete from GXDBVersions where aliasname = 'JMCreateInfoMgmtStats'
GO

insert into GXDBVersions values(2, 'JMCreateInfoMgmtStats',  '00010003006000020000', 'JMCreateInfoMgmtStats', '00010003006000020000')
GO

